/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.interfaces.ModelStructureListener;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrFraction;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.enumerations.SpectralAverage;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ObservatoryGoalTargetParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import javax.swing.table.AbstractTableModel;

public class MultiResolutionElementTableModel
extends AbstractTableModel {
    private static final int REP_FREQ_COL = ColumnDescriptor.SETREPFREQ.getColumnIndex();
    private final ScienceSpectralWindow[] empty = new ScienceSpectralWindow[0];
    private int groupIndex = -1;
    private int targetIndex = 0;
    private SpectralSetupParameters ssp;
    private boolean isReadOnlyTable = false;
    private boolean isImageSpectralWindowMode = false;
    private final PropertyChangeListener representativeWindowListener = propertyChangeEvent -> {
        Object object = propertyChangeEvent.getSource();
        if (object instanceof ScienceSpectralWindow && propertyChangeEvent.getPropertyName().endsWith(".representativeWindow")) {
            ScienceSpectralWindow scienceSpectralWindow = (ScienceSpectralWindow)object;
            int n = scienceSpectralWindow.getIndex();
            this.fireTableCellUpdated(n, REP_FREQ_COL);
        }
    };
    private final ModelStructureListener structureListener = new ModelStructureListener(){

        public void businessObjectAddedTo(IBusinessObject iBusinessObject, IBusinessObject iBusinessObject2, Referring.By by, int n) {
            ScienceSpectralWindow scienceSpectralWindow;
            if (iBusinessObject2 == MultiResolutionElementTableModel.this.ssp && iBusinessObject instanceof ScienceSpectralWindow && (scienceSpectralWindow = (ScienceSpectralWindow)iBusinessObject).getGroupIndex() == MultiResolutionElementTableModel.this.groupIndex) {
                scienceSpectralWindow.addPropertyChangeListener(MultiResolutionElementTableModel.this.representativeWindowListener);
                MultiResolutionElementTableModel.this.fireTableRowsInserted(n, n);
            }
        }

        public void businessObjectRemovedFrom(IBusinessObject iBusinessObject, IBusinessObject iBusinessObject2, Referring.By by) {
            if (iBusinessObject2 == MultiResolutionElementTableModel.this.ssp && iBusinessObject instanceof ScienceSpectralWindow) {
                ScienceSpectralWindow scienceSpectralWindow = (ScienceSpectralWindow)iBusinessObject;
                scienceSpectralWindow.removePropertyChangeListener(MultiResolutionElementTableModel.this.representativeWindowListener);
                if (scienceSpectralWindow.getGroupIndex() == MultiResolutionElementTableModel.this.groupIndex) {
                    int n = scienceSpectralWindow.getIndex();
                    MultiResolutionElementTableModel.this.fireTableRowsDeleted(n, n);
                }
            }
        }
    };

    public MultiResolutionElementTableModel() {
    }

    public MultiResolutionElementTableModel(SpectralSetupParameters spectralSetupParameters) {
        this.setDocument(spectralSetupParameters, -1);
    }

    public void setDocument(SpectralSetupParameters spectralSetupParameters) {
        this.setDocument(spectralSetupParameters, -1);
    }

    public void setDocument(SpectralSetupParameters spectralSetupParameters, int n) {
        ObsProject obsProject;
        this.groupIndex = n;
        if (this.ssp != null) {
            obsProject = this.ssp.findProject();
            if (obsProject != null) {
                obsProject.removeModelStructureListener(this.structureListener);
            }
            for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
                scienceSpectralWindow.removePropertyChangeListener(this.representativeWindowListener);
            }
        }
        this.ssp = spectralSetupParameters;
        if (spectralSetupParameters == null) {
            return;
        }
        obsProject = this.ssp.findProject();
        if (obsProject != null) {
            obsProject.addModelStructureListener(this.structureListener);
        }
        for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
            if (scienceSpectralWindow.getGroupIndex() != n) continue;
            scienceSpectralWindow.addPropertyChangeListener(this.representativeWindowListener);
        }
        this.fireTableDataChanged();
    }

    public void setTargetIndex(int n) {
        int n2 = this.targetIndex;
        this.targetIndex = n;
        if (n2 != this.targetIndex) {
            this.fireTableDataChanged();
        }
    }

    private Velocity getTargetVelocity(int n) {
        try {
            boolean bl;
            Velocity velocity = Velocity.createVelocity();
            BusinessObject businessObject = this.ssp.getParent();
            boolean bl2 = bl = this.ssp.getSpectralType() == SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM;
            if (businessObject instanceof ObservatoryGoal) {
                ObservatoryGoalTargetParameters observatoryGoalTargetParameters = ((ObservatoryGoal)businessObject).getObservatoryGoalTargetParameters(n);
                velocity = bl ? observatoryGoalTargetParameters.getSourceVelocity() : observatoryGoalTargetParameters.getSourceVelocityInDefaultReferenceFrame(Optional.empty());
            } else if (businessObject instanceof ScienceGoal) {
                ScienceGoal scienceGoal = (ScienceGoal)businessObject;
                TargetParameters targetParameters = scienceGoal.getTargetParameters(n);
                velocity = bl ? targetParameters.getSourceVelocity() : targetParameters.getSourceVelocityInDefaultReferenceFrame(Optional.of(scienceGoal));
            }
            return velocity;
        }
        catch (IndexOutOfBoundsException | NullPointerException runtimeException) {
            return Velocity.createVelocity();
        }
    }

    public Velocity getTargetVelocity() {
        return this.getTargetVelocity(this.getTargetIndex());
    }

    public ScienceSpectralWindow[] getSpectralWindow() {
        if (this.ssp == null) {
            return this.empty;
        }
        return this.ssp.getScienceSpectralWindowGroup(this.groupIndex);
    }

    public ScienceSpectralWindow getSpectralWindow(int n) {
        return this.getSpectralWindow()[n];
    }

    public ScienceSpectralWindow[] getDocument() {
        return this.getSpectralWindow();
    }

    public ScienceSpectralWindow getRow(int n) {
        return this.getSpectralWindow()[n];
    }

    public CorrPolarization getPolarization() {
        return this.ssp.getCorrPolarization();
    }

    @Override
    public int getColumnCount() {
        return ColumnDescriptor.values().length;
    }

    @Override
    public int getRowCount() {
        if (this.ssp == null) {
            return 0;
        }
        return this.getSpectralWindow().length;
    }

    @Override
    public String getColumnName(int n) {
        return ColumnDescriptor.getColumnDescriptor(n).getColumnName();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return ColumnDescriptor.getColumnDescriptor(n).getColumnClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        boolean bl;
        if (n >= this.getRowCount() || this.isImageSpectralWindowMode) {
            return false;
        }
        if (this.ssp == null) {
            return false;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl2 = ObsProposal.isProposalVLBI();
            bl3 = ObsProposal.isVLBIRelated();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(MultiResolutionElementTableModel.class).warning("Unable to determine if the project is VLBI");
        }
        if (bl2 && this.ssp.isSpectralLine() && this.groupIndex == 0 && VLBIExpert.IS_VLBI_SPECTRALLINE_ENABLED) {
            return false;
        }
        ScienceGoal scienceGoal = this.ssp.getScienceGoal();
        if (scienceGoal != null && scienceGoal.isPhase2ScienceGoal() && !RoleDirectoryServiceHelper.isUserP2G()) {
            UserEditRestrictionController userEditRestrictionController;
            return this.ssp.isSpectralLine() && !(userEditRestrictionController = UserEditRestrictionController.getInstance()).isPreExistingP2GMajorEditsInPlace(scienceGoal) && EnumSet.of(ColumnDescriptor.CENTERFREQREST, ColumnDescriptor.CENTERFREQSKY).contains((Object)ColumnDescriptor.getColumnDescriptor(n2));
        }
        if (this.isReadOnlyTable) {
            if (!bl3 && ColumnDescriptor.getColumnDescriptor(n2).equals((Object)ColumnDescriptor.SPECTRALAVG) && this.isSpectralAverageColumnEditable(n, n2)) {
                return true;
            }
            if (ColumnDescriptor.getColumnDescriptor(n2) != ColumnDescriptor.SETREPFREQ) {
                return false;
            }
        }
        boolean bl4 = bl = bl2 && this.ssp.isSpectralLine();
        if (bl && ColumnDescriptor.getColumnDescriptor(n2) == ColumnDescriptor.SETREPFREQ) {
            return false;
        }
        return !ColumnDescriptor.getColumnDescriptor(n2).equals((Object)ColumnDescriptor.SPECTRALAVG) || this.isSpectralAverageColumnEditable(n, n2);
    }

    private boolean isSpectralAverageColumnEditable(int n, int n2) {
        assert (ColumnDescriptor.getColumnDescriptor(n2).equals((Object)ColumnDescriptor.SPECTRALAVG));
        ScienceSpectralWindow scienceSpectralWindow = this.getSpectralWindow(n);
        return !scienceSpectralWindow.getCorrConfigMode().getFilter().equals((Object)CorrFilter.TDM);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.getRowCount()) {
            return null;
        }
        ScienceSpectralWindow scienceSpectralWindow = this.getSpectralWindow(n);
        switch (ColumnDescriptor.getColumnDescriptor(n2)) {
            case FRACTION: {
                return scienceSpectralWindow.getFraction().getLabel();
            }
            case CENTERFREQREST: {
                if (this.isImageSpectralWindowMode) {
                    return this.getTargetVelocity(this.getTargetIndex()).reverseShift(scienceSpectralWindow.getImageSPWSkyCenterFrequency(this.ssp.getLO1Frequency()));
                }
                if (scienceSpectralWindow.getIsSkyFrequency()) {
                    return this.getTargetVelocity(this.getTargetIndex()).reverseShift(scienceSpectralWindow.getCenterFrequency());
                }
                return scienceSpectralWindow.getCenterFrequency();
            }
            case CENTERFREQSKY: {
                if (this.isImageSpectralWindowMode) {
                    return scienceSpectralWindow.getImageSPWSkyCenterFrequency(this.ssp.getLO1Frequency());
                }
                if (scienceSpectralWindow.getIsSkyFrequency()) {
                    return scienceSpectralWindow.getCenterFrequency();
                }
                return scienceSpectralWindow.getCenterFrequency().dopplerShifted(this.getTargetVelocity());
            }
            case TRANSITION: {
                return scienceSpectralWindow.getTransitionName();
            }
            case MODEDESCRIPTION: {
                return scienceSpectralWindow.formatWindowDescription(this.getTargetVelocity(), this.isImageSpectralWindowMode);
            }
            case SPECTRALAVG: {
                return SpectralAverage.getValue(scienceSpectralWindow.getAdvancedWindowSetup().getSmoothingFactor());
            }
            case SETREPFREQ: {
                return scienceSpectralWindow.getRepresentativeWindow();
            }
            case WALSHSWITCH: {
                return scienceSpectralWindow.getAdvancedWindowSetup().getUseImage();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ScienceSpectralWindow scienceSpectralWindow = this.getRow(n);
        switch (ColumnDescriptor.getColumnDescriptor(n2)) {
            case FRACTION: {
                CorrFraction corrFraction = (CorrFraction)((Object)object);
                scienceSpectralWindow.setGroupResourceUse(corrFraction.getResourceUse());
                this.fireTableRowsUpdated(n, n);
                return;
            }
            case CENTERFREQREST: {
                if (!(object instanceof Frequency)) break;
                Frequency frequency = (Frequency)((Object)object);
                ScienceGoal scienceGoal = this.ssp.getScienceGoal();
                if (VLBIExpert.isScienceGoalLegalVLBISpectralLine(scienceGoal)) {
                    Velocity velocity = this.getTargetVelocity();
                    Frequency frequency2 = velocity.dopplerShift(frequency);
                    scienceSpectralWindow.getCenterFrequency().setContentAndUnit((ValueUnitPair)frequency2);
                } else {
                    scienceSpectralWindow.getCenterFrequency().setContentAndUnit((ValueUnitPair)frequency);
                }
                this.fireTableRowsUpdated(n, n);
                break;
            }
            case CENTERFREQSKY: {
                if (!(object instanceof Frequency)) break;
                Frequency frequency = (Frequency)((Object)object);
                ScienceGoal scienceGoal = this.ssp.getScienceGoal();
                if (VLBIExpert.isScienceGoalLegalVLBISpectralLine(scienceGoal)) {
                    scienceSpectralWindow.getCenterFrequency().setContentAndUnit((ValueUnitPair)frequency);
                } else {
                    Velocity velocity = this.getTargetVelocity();
                    Frequency frequency3 = velocity.reverseShift(frequency);
                    scienceSpectralWindow.getCenterFrequency().setContentAndUnit((ValueUnitPair)frequency3);
                }
                this.fireTableRowsUpdated(n, n);
                break;
            }
            case TRANSITION: {
                String string = (String)object;
                scienceSpectralWindow.setTransitionName(string);
                this.fireTableCellUpdated(n, n2);
                return;
            }
            case MODEDESCRIPTION: {
                if (!(object instanceof CorrConfigMode)) {
                    return;
                }
                CorrConfigMode corrConfigMode = (CorrConfigMode)object;
                boolean bl = false;
                if (corrConfigMode.getFilter().equals((Object)CorrFilter.TDM)) {
                    this.setValueAt((Object)SpectralAverage.SPEC_AVERAGE_FACTOR_1, n, ColumnDescriptor.SPECTRALAVG.getColumnIndex());
                } else {
                    CorrConfigMode corrConfigMode2 = scienceSpectralWindow.getCorrConfigMode();
                    if (corrConfigMode2.getMode() == -1 || corrConfigMode2.getFilter().equals((Object)CorrFilter.TDM)) {
                        bl = true;
                    }
                }
                scienceSpectralWindow.setCorrConfigMode(corrConfigMode);
                this.fireTableCellUpdated(n, n2);
                if (bl) {
                    this.setValueAt((Object)SpectralAverage.SPEC_AVERAGE_FACTOR_2, n, ColumnDescriptor.SPECTRALAVG.getColumnIndex());
                }
                return;
            }
            case SPECTRALAVG: {
                if (!(object instanceof SpectralAverage)) {
                    return;
                }
                SpectralAverage spectralAverage = (SpectralAverage)((Object)object);
                scienceSpectralWindow.getAdvancedWindowSetup().setSmoothingFactor(spectralAverage.getSpectralAveragingFactor());
                this.fireTableCellUpdated(n, n2);
                return;
            }
            case SETREPFREQ: {
                this.ssp.setRepresentativeSpectralWindow(scienceSpectralWindow);
                return;
            }
            case WALSHSWITCH: {
                boolean bl = (Boolean)object;
                scienceSpectralWindow.getAdvancedWindowSetup().setUseImage(bl);
                if (this.ssp.isSpectralLine() && bl) {
                    CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(CorrelatorType.BL);
                    scienceSpectralWindow.setCorrConfigMode(correlatorExpert.getSpectralLineWalshSwitchMode(this.ssp.getCorrPolarization()));
                }
                this.fireTableRowsUpdated(n, n);
                break;
            }
            default: {
                return;
            }
        }
    }

    public Object[] getLongValues() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ColumnDescriptor columnDescriptor : ColumnDescriptor.values()) {
            arrayList.add(columnDescriptor.longValue);
        }
        Object[] objectArray = new Object[arrayList.size()];
        return arrayList.toArray(objectArray);
    }

    public SpectralSetupParameters getSSP() {
        return this.ssp;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    public void setReadOnlyTable(boolean bl) {
        this.isReadOnlyTable = bl;
    }

    public boolean isReadOnlyTable() {
        return this.isReadOnlyTable;
    }

    public void setImageSpectralWindowMode(boolean bl) {
        this.isImageSpectralWindowMode = bl;
    }

    public boolean isImageSpectralWindowMode() {
        return this.isImageSpectralWindowMode;
    }

    public static enum ColumnDescriptor {
        FRACTION("<html>Fraction<br>&nbsp;</html>", String.class, "1(full)"),
        CENTERFREQREST("<html><center>Center Freq<br>(Rest)</center></html>", Frequency.class, (Object)((Object)Frequency.createFrequencyGHZ(999.999999))),
        CENTERFREQSKY("<html><center>Center Freq<br>(Sky)</center></html>", Frequency.class, (Object)((Object)Frequency.createFrequencyGHZ(999.999999))),
        TRANSITION("Transition", String.class, "CH3OH(2,1-1,1A)"),
        MODEDESCRIPTION("Bandwidth, Resolution (smoothed)", String.class, "2000.000MHz(000.000 km/s), 488.281 kHz(  0.000 km/s).........................."),
        SPECTRALAVG("<html><center>Spec. <br>Avg.</center></html>", SpectralAverage.class, (Object)((Object)SpectralAverage.SPEC_AVERAGE_FACTOR_1)),
        WALSHSWITCH("<html>Store<br>Image</html>", Boolean.class, false),
        SETREPFREQ("<html><center>Representative<br>Window</center></html>", Boolean.class, false);

        public final String columnName;
        public final Class<?> columnClass;
        public final Object longValue;

        public static ColumnDescriptor getColumnDescriptor(int n) {
            return ColumnDescriptor.values()[n];
        }

        public int getColumnIndex() {
            int n = 0;
            for (ColumnDescriptor columnDescriptor : ColumnDescriptor.values()) {
                if (this == columnDescriptor) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        private ColumnDescriptor(String string2, Class<?> clazz, Object object) {
            this.columnName = string2;
            this.columnClass = clazz;
            this.longValue = object;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }
}

