/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock.observingparameters;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.models.schedblock.observingparameters.CalibratorParameterModel;
import alma.valuetypes.Time;

public class PhaseCalParameterModel
extends CalibratorParameterModel {
    private static final double SLEWING_OVERHEAD_SECS = 7.0;

    public PhaseCalParameterModel(PhaseCalParameters phaseCalParameters) {
        super((CalibratorParameters)((Object)phaseCalParameters));
        this.setDocument((Object)phaseCalParameters);
    }

    public PhaseCalParameters getPhaseCalParameters() {
        return (PhaseCalParameters)((Object)this.getDocument());
    }

    @Override
    Time getRepeatInterval() {
        Object object;
        Time time = Time.createTime();
        CalibratorParameters calibratorParameters = this.getCalibratorParameters();
        assert (this.context != null && calibratorParameters != null);
        BusinessObject businessObject = calibratorParameters.getParent();
        Target target = null;
        if (businessObject != null && businessObject instanceof SchedBlock) {
            object = (SchedBlock)businessObject;
            block0: for (ObservingGroup observingGroup : object.getObservingGroup()) {
                for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                    Target target2 = orderedTarget.getTarget();
                    if (!target2.hasPhaseCalParameters() || target2.getPhaseCalParametersList()[0] != calibratorParameters) continue;
                    target = observingGroup.getMainTarget();
                    break block0;
                }
            }
        }
        if (target == null) {
            return time;
        }
        object = target.getScienceParametersList();
        if (object == null || ((ScienceParameters[])object).length == 0) {
            return time;
        }
        double d = object[0].getSubScanDuration().getContentInUnits(Time.UNIT_S);
        double d2 = calibratorParameters.getCycleTime().getContentInUnits(Time.UNIT_S);
        double d3 = calibratorParameters.getSubScanDuration().getContentInUnits(Time.UNIT_S);
        double d4 = calibratorParameters.getDefaultIntegrationTime().getContentInUnits(Time.UNIT_S);
        double d5 = Math.ceil(d2 / d) * d + Math.ceil(d4 / d3) * d3 + 7.0;
        time = Time.createTimeSec(d5);
        return time;
    }
}

