/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.Target;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import javax.swing.table.AbstractTableModel;

public class ObservingGroupSelectTargetsTableModel
extends AbstractTableModel {
    public static final int COLUMN_INDEX = 0;
    public static final int COLUMN_SOURCE_NAME = 1;
    public static final int COLUMN_RA = 2;
    public static final int COLUMN_DEC = 3;
    public static final int COLUMN_SPECTRAL_SPEC = 4;
    public static final int COLUMN_REST_FREQUENCY = 5;
    public static final int COLUMN_PURPOSE = 6;
    public static final int COLUMN_DOPPLER_TARGET = 7;
    public static final int LAST_COLUMN = 7;
    private ObservingGroup observingGroup;

    public ObservingGroupSelectTargetsTableModel(ObservingGroup observingGroup) {
        this.observingGroup = observingGroup;
    }

    private int getOrderedTargetCount() {
        return this.getObservingGroup() == null ? 0 : this.getObservingGroup().getOrderedTargetCount();
    }

    public OrderedTarget getOrderedTargetAtRow(int n) {
        if (this.getObservingGroup() == null) {
            return null;
        }
        return this.getObservingGroup().getOrderedTarget(n);
    }

    private String getPurposeString(Target target) {
        String string;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (target.hasScienceParameters()) {
            stringBuilder.append("Science,");
        }
        if (target.hasPhaseCalParameters()) {
            stringBuilder.append("PhsCal,");
        }
        if (target.hasAmplitudeCalParameters()) {
            stringBuilder.append("AmpCal,");
        }
        if (target.hasPolarizationCalParameters()) {
            stringBuilder.append("PolCal,");
        }
        if (target.hasPointingCalParameters()) {
            stringBuilder.append("PntCal,");
        }
        if (target.hasAtmosphericCalParameters()) {
            stringBuilder.append("AtmCal,");
        }
        if (target.hasDelayCalParameters()) {
            stringBuilder.append("DlyCal,");
        }
        if (target.hasDGCReferenceCalParameters()) {
            stringBuilder.append("DGCRefCal,");
        }
        if (target.hasDGCScienceCalParameters()) {
            stringBuilder.append("DGCScienceCal,");
        }
        if (target.hasCheckSourceCalParameters()) {
            stringBuilder.append("ChkCal,");
        }
        if (target.hasBandpassCalParameters()) {
            stringBuilder.append("BndCal,");
        }
        if (target.hasFocusCalParameters()) {
            stringBuilder.append("FocCal,");
        }
        if (target.hasOpticalPointingParameters()) {
            stringBuilder.append("OptPtg,");
        }
        if (target.hasRadiometricPointingParameters()) {
            stringBuilder.append("RadPtg,");
        }
        if ((n = (string = stringBuilder.toString()).lastIndexOf(",")) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.getObservingGroup() == null) {
            return false;
        }
        switch (n2) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case 6: {
                return false;
            }
            case 7: {
                return this.getOrderedTargetAtRow(n).getTarget().hasScienceParameters();
            }
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Longitude.class;
            }
            case 3: {
                return Latitude.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return Frequency.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return Boolean.class;
            }
        }
        throw new RuntimeException("Invalid number of columns");
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "<html><div align=center>Index</div></html>";
            }
            case 1: {
                return "<html><div align=center>Source Name</div></html>";
            }
            case 2: {
                return "<html><div align=center>RA</div></html>";
            }
            case 3: {
                return "<html><div align=center>DEC</div></html>";
            }
            case 4: {
                return "<html><div align=center>Spectral Spec</div></html>";
            }
            case 5: {
                return "<html><div align=center>Rest Freq</div></html>";
            }
            case 6: {
                return "<html><div align=center>Purpose</div></html>";
            }
            case 7: {
                return "<html>Doppler Target</html>";
            }
        }
        return "<html><div align=center><font color=red>**ERROR**</font></div></html>";
    }

    @Override
    public int getRowCount() {
        return this.getOrderedTargetCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        OrderedTarget orderedTarget = this.getOrderedTargetAtRow(n);
        Target target = orderedTarget.getTarget();
        try {
            switch (n2) {
                case 0: {
                    return orderedTarget.getIndex();
                }
                case 1: {
                    return target.getFieldSource().getSourceName();
                }
                case 2: {
                    return target.getFieldSource().getSourceCoordinates().getJ2000SkyCoordinates().getLongitude();
                }
                case 3: {
                    return target.getFieldSource().getSourceCoordinates().getJ2000SkyCoordinates().getLatitude();
                }
                case 4: {
                    return target.getSpectralSpec().getName();
                }
                case 5: {
                    return target.getSpectralSpec().getRestFrequency();
                }
                case 6: {
                    return this.getPurposeString(target);
                }
                case 7: {
                    Target target2 = this.observingGroup.getMainTarget();
                    if (target2 == null) {
                        return false;
                    }
                    return this.observingGroup.getMainTarget().equals(target);
                }
            }
            return "<html><font color=\"red\">Error!</font></html>";
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        OrderedTarget orderedTarget = this.getOrderedTargetAtRow(n);
        Target target = orderedTarget.getTarget();
        switch (n2) {
            case 7: {
                this.observingGroup.setMainTarget(target);
                break;
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public Object[] getLongValues() {
        return new Object[]{"123", "Source Name", "+00:00:00", "+00:00:00", "Spectral Spec Name", "123.4 GHz", "Phs,Amp,Plr", false};
    }

    public ObservingGroup getObservingGroup() {
        return this.observingGroup;
    }

    public void setObservingGroup(ObservingGroup observingGroup) {
        this.observingGroup = observingGroup;
    }
}

