/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import javax.swing.table.AbstractTableModel;

public class BaseBandConfigTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -2993454306993606198L;
    private Boolean hardwareSetupMode = false;
    private SpectralSpec spectralSpec = null;

    public BaseBandConfigTableModel(SpectralSpec spectralSpec) {
        this.setSpectralSpec(spectralSpec);
    }

    public void setHardwareSetupMode(boolean bl) {
        if (this.hardwareSetupMode != bl) {
            this.hardwareSetupMode = bl;
            this.fireTableDataChanged();
        }
    }

    public boolean getSideBandSeparationMode() {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        if (spectralSpec == null) {
            return false;
        }
        if (spectralSpec.getCorrelatorConfiguration() == null) {
            return false;
        }
        return spectralSpec.getCorrelatorConfiguration().isSideBandSeprationMode();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (ColumnDescriptor.getColumnDescriptor(n2)) {
            case CENTER_FREQUENCY: {
                return this.hardwareSetupMode == false;
            }
            case IMAGE_FREQUENCY: {
                return this.hardwareSetupMode != false ? false : this.getSideBandSeparationMode();
            }
            case DATA_PRODUCT: {
                return this.getSpectralSpec() != null && this.getSpectralSpec().hasCorrelatorConfiguration();
            }
            case LO2FREQUENCY: {
                return this.hardwareSetupMode != false;
            }
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return ColumnDescriptor.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return ColumnDescriptor.getColumnDescriptor(n).getColumnName();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return ColumnDescriptor.getColumnDescriptor(n).getColumnClass();
    }

    @Override
    public int getRowCount() {
        return this.getSpectralSpec() == null ? 0 : this.getSpectralSpec().getBaseBandCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        BaseBand baseBand = this.getSpectralSpec().getBaseBand(n);
        BaseBandSpecification baseBandSpecification = baseBand.getBaseBandSpecification();
        if (baseBandSpecification == null) {
            return null;
        }
        AbstractBaseBandConfig abstractBaseBandConfig = baseBand.getBaseBandConfig();
        switch (ColumnDescriptor.getColumnDescriptor(n2)) {
            case BASEBAND_NAME: {
                return baseBandSpecification.getBaseBandName();
            }
            case CENTER_FREQUENCY: {
                return baseBandSpecification.getCenterFrequency();
            }
            case IMAGE_FREQUENCY: {
                return baseBandSpecification.getImageCenterFrequency();
            }
            case DATA_PRODUCT: {
                return abstractBaseBandConfig == null ? null : abstractBaseBandConfig.getDataProducts();
            }
            case LO2FREQUENCY: {
                return baseBandSpecification.getLO2Frequency();
            }
            case DATARATE: {
                return baseBandSpecification.getInstantaneousDataRate();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        BaseBand baseBand = this.getSpectralSpec().getBaseBand(n);
        BaseBandSpecification baseBandSpecification = baseBand.getBaseBandSpecification();
        if (baseBandSpecification == null) {
            return;
        }
        AbstractBaseBandConfig abstractBaseBandConfig = baseBand.getBaseBandConfig();
        switch (ColumnDescriptor.getColumnDescriptor(n2)) {
            case CENTER_FREQUENCY: {
                Frequency frequency = (Frequency)((Object)object);
                baseBandSpecification.getCenterFrequency().setContent(frequency.getContent());
                baseBandSpecification.getCenterFrequency().setUnit(frequency.getUnit());
                break;
            }
            case IMAGE_FREQUENCY: {
                Frequency frequency = (Frequency)((Object)object);
                baseBandSpecification.getImageCenterFrequency().setContent(frequency.getContent());
                baseBandSpecification.getImageCenterFrequency().setUnit(frequency.getUnit());
                break;
            }
            case DATA_PRODUCT: {
                if (object == null) break;
                String string = (String)object;
                if (abstractBaseBandConfig == null) break;
                abstractBaseBandConfig.setDataProducts(TextUtils.stripHtmlTags(string));
                break;
            }
            case LO2FREQUENCY: {
                Frequency frequency = (Frequency)((Object)object);
                baseBandSpecification.getLO2Frequency().setContent(frequency.getContent());
                baseBandSpecification.getLO2Frequency().setUnit(frequency.getUnit());
                break;
            }
            default: {
                return;
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public Object[] getLongValues() {
        return new Object[]{"BB_1", "123.123456 GHz", "123.123456 GHz", "CROSS_AND_AUTO", "10.980 GHz", "123.456 MB/s"};
    }

    public void dataRateChanged() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.fireTableCellUpdated(i, ColumnDescriptor.DATARATE.ordinal());
        }
    }

    public Boolean getHardwareSetupMode() {
        return this.hardwareSetupMode;
    }

    public SpectralSpec getSpectralSpec() {
        return this.spectralSpec;
    }

    public void setSpectralSpec(SpectralSpec spectralSpec) {
        this.spectralSpec = spectralSpec;
    }

    public static enum ColumnDescriptor {
        BASEBAND_NAME("Name", String.class),
        CENTER_FREQUENCY("Desired Center Freq", Frequency.class),
        IMAGE_FREQUENCY("Image Freq (optional)", Frequency.class),
        DATA_PRODUCT("Data Product", String.class),
        LO2FREQUENCY("LO2 Frequency", Frequency.class),
        DATARATE("Output Data Rate", DataRate.class);

        public final String columnName;
        public final Class<?> columnClass;

        protected static int getColumnCount() {
            return ColumnDescriptor.values().length;
        }

        protected static ColumnDescriptor getColumnDescriptor(int n) {
            return ColumnDescriptor.values()[n];
        }

        private ColumnDescriptor(String string2, Class<?> clazz) {
            this.columnName = string2;
            this.columnClass = clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }
}

