/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.MiscUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.TreePath;

public class Overview
extends Editor
implements MouseListener,
HyperlinkListener {
    public static final FieldID FID_STATUS = new FieldID("Overview.status");
    public static final FieldID FID_VALID_BUTTON = new FieldID("Overview.validBtn");
    public static final Color HELP_COLOUR = new Color(237, 212, 0);
    public ObservingToolGui _gui;
    private JPanel _phase1Panel;
    private JPanel _phase2Panel;
    private JLabel _phase1Label;
    private JLabel _phase1HelpLabel;
    private JLabel _phase1ClickLabel;
    private JEditorPane _phase1HelpTipPane;
    private OverviewStep _phase1NewPropStep;
    private OverviewStep _phase1CreateGoalStep;
    private OverviewStep _phase1ValidPropStep;
    private OverviewStep _phase1SubPropStep;
    private OverviewStep _phase1ImportExportStep;
    private OverviewStep _phase1TemplateLibraryStep;
    private OverviewStep _phase1MoreHelpStep;
    private OverviewPhase _phase1ViewPhase2;
    private JLabel _phase2Label;
    private JLabel _phase2HelpLabel;
    private JLabel _phase2ClickLabel;
    private JEditorPane _phase2HelpTipPane;
    private OverviewStep _phase2RetrievePropStep;
    private OverviewStep _phase2SysSetupStep;
    private OverviewStep _phase2ValidProgStep;
    private OverviewStep _phase2SubProgStep;
    private OverviewStep _phase2ImportExportStep;
    private OverviewStep _phase2TemplateLibraryStep;
    private OverviewStep _phase2MoreHelpStep;
    private OverviewPhase _phase2ViewPhase1;
    public static final DialogId browserErrorDialog = new DialogId("Editor.UnexpectedError");
    private static final URL _newPropImg = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/phase1_inv_16x16.png");
    private static final URL _newGoalImg = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/ScienceGoal.gif");
    private static final URL _validateImg = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/translate.gif");
    private static final URL _genBlockImg = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/newGenerateSB2.png");
    private static final URL _importImg = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/open.gif");
    private static final URL _exportImg = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/save.gif");
    private static final URL _obsProgImg = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/obs-program.gif");
    private static final URL _libraryImg = MiscUtils.findResource(null, "obj16/library_obj.gif");
    private static String _bodyWidth = "400";
    private static final String _htmlHeader = "<html><head><style type=\"text/css\">ol { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }ul { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }</style></head>";
    private static final String _newProposalHelpMsg = "<html><head><style type=\"text/css\">ol { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }ul { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }</style></head><body width=\"" + _bodyWidth + "\"><ol><li>Please ensure you and your co-Is are registered with the <a href=\"http://almascience.org/\">ALMA Science Portal</a></li><li>Create a new proposal by either:<ul><li>Selecting <em>File > New Proposal</em></li><li>Clicking on the <img src=\"" + _newPropImg + "\" align=\"bottom\"/> icon in the toolbar</li><li>Or clicking on this <a href=\"#NewProposal\">link</a></li></ul></li><li>Click on the <img src=\"" + _obsProgImg + "\" align=\"bottom\"/> <a href=\"#ViewProposal\">proposal</a> tree node and complete the relevant fields.</li></ol></body></html>";
    private static final String _createScienceGoalHelpMsg = "<html><head><style type=\"text/css\">ol { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }ul { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }</style></head><body width=\"" + _bodyWidth + "\"><ol><li>Create your science goals by either:<ul><li>Selecting <em>Edit > New Phase-I Science Goal</em></li><li>Clicking on the <img src=\"" + _newGoalImg + "\" align=\"bottom\"/> icon in the toolbar</li><li>Or clicking on this <a href=\"#NewScienceGoal\">link</a></li></ul></li><li>Complete the field set-up and spectral set-up, etc. More than one science goal may be added.</li></ol></body></html>";
    private static final String _validateProposalHelpMsg = "<html><head><style type=\"text/css\">ol { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }ul { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }</style></head><body width=\"" + _bodyWidth + "\"><ol><li>Validate your science proposal by either:<ul><li>Selecting <em>File > Validate</em></li><li>Clicking on the <img src=\"" + _validateImg + "\" align=\"bottom\"/> icon in the toolbar</li><li>Or clicking on this <a href=\"#ValidateProposal\">link</a></li></ul></li><li>Look at the <em>Feedback</em> panel and view the list of reported problems. Please fix the reported problems before attempting to submit your science proposal.</li></ol></body></html>";
    private static final String _submitProposalHelpMsg = "<html><head><style type=\"text/css\">ol { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }ul { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }</style></head><body width=\"" + _bodyWidth + "\">Submit your science proposal to the ALMA server by either:<ul><li>Selecting <em>File > Submit Project</em></li><li>Or clicking on this <a href=\"#SubmitProposal\">link</a></li></ul></body></html>";
    private static final String _retrieveProposalHelpMsg = "<html><head><style type=\"text/css\">ol { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }ul { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }</style></head><body width=\"" + _bodyWidth + "\">Retrieve your science proposal from the ALMA server by either:<ul><li>Selecting <em>File > Open Project > From ALMA Archive</em></li><li>Or clicking on this <a href=\"#RetrieveProposal\">link</a></li></ul></body></html>";
    private static final String _systemSetupHelpMsg = "<html><head><style type=\"text/css\">ol { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }ul { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }</style></head><body width=\"" + _bodyWidth + "\"><ol><li>Generate the scheduling blocks from your science goals by either:<ul><li>Selecting <em>Tool > Generate SBs from the Selected Goal</em></li><li>Clicking on the <img src=\"" + _genBlockImg + "\" align=\"bottom\"/> toolbar icon</li><li>Or clicking on this <a href=\"#GenerateBlocks\">link</a></li></ul></li><li>Although you are free to generate your own scheduling blocks and change their values this step is only really available for <strong><font color=red>expert</font></strong> users. So be careful!</font></strong></li></ol></body></html>";
    private static final String _validateProgramHelpMsg = "<html><head><style type=\"text/css\">ol { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }ul { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }</style></head><body width=\"" + _bodyWidth + "\"><ol><li>Validate your observing program by either:<ul><li>Selecting <em>File > Validate</em></li><li>Clicking on the <img src=\"" + _validateImg + "\" align=\"bottom\"/>  icon in the toolbar</li><li>Or clicking on this <a href=\"#ValidateProgram\">link</a></li></ul></li><li>Look at the <em>Feedback</em> panel and view the list of reported problems. Please fix the reported problems before attempting to submit your observing program.</li></ol></body></html>";
    private static final String _submitProgramHelpMsg = "<html><head><style type=\"text/css\">ol { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }ul { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }</style></head><body width=\"" + _bodyWidth + "\">Submit your observing program to the ALMA server by either:<ul><li>Selecting <em>File > Submit Project</em></li><li>Or clicking on this <a href=\"#SubmitProgram\">link</a></li></ul></body></html>";
    private static final String _importExportHelpMsg = "<html><head><style type=\"text/css\">ol { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }ul { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }</style></head><body width=\"" + _bodyWidth + "\">Share your proposals/programs with collaborators by importing and exporting via a local disk<ol><li>You may import a proposal/program by either:</li><ul><li>Selecting <em>File > Open Project > From File</em></li><li>Clicking on the <img src=\"" + _importImg + "\" align=\"bottom\"/> icon in the toolbar</li><li>Or clicking on this <a href=\"#ImportProposal\">link</a></li></ul><li>You may export a proposal/program by either:</li><ul><li>Selecting <em>File > Save Project > to File</em></li><li>Clicking on the <img src=\"" + _exportImg + "\" align=\"bottom\"/> icon in the toolbar</li><li>Or clicking on this <a href=\"#ExportProposal\">link</a></li></ul></ol></body></html>";
    private static final String _templateLibraryMsg = "<html><head><style type=\"text/css\">ol { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }ul { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }</style></head><body width=\"" + _bodyWidth + "\">The ALMA template library provides a set of predefined science goals for users to copy and paste into their proposals. These science goals represent common scenarios that users can modify to meet their own requirements. You can open the library by either:<ul><li>Selecting <em>View > Show ALMA Template Library</em></li><li>Clicking on the <img src=\"" + _libraryImg + "\" align=\"bottom\"/> icon in the toolbar</li><li>Or clicking on this <a href=\"#TemplateLibrary\">link</a></li></ul>The template library will appear at the bottom of the <em>Project Structure</em> panel. <strong>Note:</strong>You may have to scroll down the panel to see the library.</body></html>";
    private static final String _needMoreHelpMsg = "<html><head><style type=\"text/css\">ol { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }ul { margin-left:15px; margin-right:0px; margin-top:0px; margin-bottom:0px; }</style></head><body width=\"" + _bodyWidth + "\">Need More Help?<ul><li>View the <a href=\"#Help\">observing tool help</a> which can be found at <em>File > Help</em></li><li>Or download a pdf version from the <a href=\"#UserManual\">Science Portal</a></li></ul></body></html>";

    public Overview(Model model, ObservingToolGui observingToolGui) {
        this._gui = observingToolGui;
        this.setModel(model);
        this.build();
    }

    @Override
    protected void build() {
        this._phase1Panel = this.assemblePhase1();
        this._phase2Panel = this.assemblePhase2();
        this.setLayout(new BoxLayout(this, 0));
        this.add(this._phase1Panel);
        this.add(this._phase2Panel);
        this._phase1Panel.setVisible(true);
        this._phase2Panel.setVisible(false);
        this.selectStep(this._phase1NewPropStep);
        this.selectStep(this._phase2RetrievePropStep);
    }

    private JPanel assemblePhase1() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 3;
        this._phase1HelpLabel = new JLabel("Contextual Help", 0);
        this._phase1HelpLabel.setBackground(Color.WHITE);
        this._phase1HelpLabel.setOpaque(true);
        this._phase1HelpLabel.setFont(this._phase1HelpLabel.getFont().deriveFont(this._phase1HelpLabel.getFont().getStyle() ^ 1));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        jPanel.add((Component)this._phase1HelpLabel, gridBagConstraints);
        this._phase1HelpTipPane = new JEditorPane();
        this._phase1HelpTipPane.setEditable(false);
        this._phase1HelpTipPane.setContentType("text/html");
        this._phase1HelpTipPane.setOpaque(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel.add((Component)this._phase1HelpTipPane, gridBagConstraints);
        this._phase1HelpTipPane.addHyperlinkListener(this);
        this._phase1Label = new JLabel("Phase I: Science Proposal", 0);
        this._phase1Label.setBackground(this._gui.getPalette().getPhase1Color());
        this._phase1Label.setOpaque(true);
        this._phase1Label.setFont(this._phase1Label.getFont().deriveFont(this._phase1Label.getFont().getStyle() ^ 1));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)this._phase1Label, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 1;
        this._phase1NewPropStep = new OverviewStep("New\nScience\nProposal", ObsProject.STATUS_NEWPHASE1, _newProposalHelpMsg, 20);
        this._phase1NewPropStep.setItemColor(this._gui.getPalette().getPhase1Color());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this._phase1NewPropStep, gridBagConstraints);
        this._phase1NewPropStep.addMouseListener(this);
        this.initEvents(this._phase1NewPropStep, FID_STATUS);
        this._phase1CreateGoalStep = new OverviewStep("Create\nScience\nGoals", ObsProject.STATUS_NEWPHASE1, _createScienceGoalHelpMsg, 20);
        this._phase1CreateGoalStep.setItemColor(this._gui.getPalette().getPhase1Color());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this._phase1CreateGoalStep, gridBagConstraints);
        this._phase1CreateGoalStep.addMouseListener(this);
        this.initEvents(this._phase1CreateGoalStep, FID_STATUS);
        this._phase1ValidPropStep = new OverviewStep("Validate\nScience\nProposal", ObsProject.STATUS_NEWPHASE1, _validateProposalHelpMsg, 20);
        this._phase1ValidPropStep.setItemColor(this._gui.getPalette().getPhase1Color());
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this._phase1ValidPropStep, gridBagConstraints);
        this._phase1ValidPropStep.addMouseListener(this);
        this.initEvents(this._phase1ValidPropStep, FID_STATUS);
        this._phase1SubPropStep = new OverviewStep("Submit\nScience\nProposal", ObsProject.STATUS_NEWPHASE1, _submitProposalHelpMsg, 0);
        this._phase1SubPropStep.setItemColor(this._gui.getPalette().getPhase1Color());
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this._phase1SubPropStep, gridBagConstraints);
        this._phase1SubPropStep.addMouseListener(this);
        this.initEvents(this._phase1SubPropStep, FID_STATUS);
        this._phase1ClickLabel = new JLabel("Click on the overview steps to view the contextual help", 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        jPanel.add((Component)this._phase1ClickLabel, gridBagConstraints);
        this._phase1ImportExportStep = new OverviewStep("Importing\nAnd\nExporting", ObsProject.STATUS_NEWPHASE1, _importExportHelpMsg, 0);
        this._phase1ImportExportStep.setItemColor(HELP_COLOUR);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this._phase1ImportExportStep, gridBagConstraints);
        this._phase1ImportExportStep.addMouseListener(this);
        this.initEvents(this._phase1ImportExportStep, FID_STATUS);
        this._phase1TemplateLibraryStep = new OverviewStep("Template\nLibrary", ObsProject.STATUS_NEWPHASE1, _templateLibraryMsg, 0);
        this._phase1TemplateLibraryStep.setItemColor(HELP_COLOUR);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this._phase1TemplateLibraryStep, gridBagConstraints);
        this._phase1TemplateLibraryStep.addMouseListener(this);
        this.initEvents(this._phase1TemplateLibraryStep, FID_STATUS);
        this._phase1MoreHelpStep = new OverviewStep("Need\nMore\nHelp?", ObsProject.STATUS_NEWPHASE1, _needMoreHelpMsg, 0);
        this._phase1MoreHelpStep.setItemColor(HELP_COLOUR);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this._phase1MoreHelpStep, gridBagConstraints);
        this._phase1MoreHelpStep.addMouseListener(this);
        this.initEvents(this._phase1MoreHelpStep, FID_STATUS);
        this._phase1ViewPhase2 = new OverviewPhase("View\nPhase 2\nSteps", ObsProject.STATUS_NEWPHASE1, Direction.RIGHT, 10);
        this._phase1ViewPhase2.setItemColor(this._gui.getPalette().getPhase2Color());
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this._phase1ViewPhase2, gridBagConstraints);
        this._phase1ViewPhase2.addMouseListener(this);
        this.initEvents(this._phase1ViewPhase2, FID_STATUS);
        return jPanel;
    }

    private JPanel assemblePhase2() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 3;
        this._phase2HelpLabel = new JLabel("Contextual Help", 0);
        this._phase2HelpLabel.setBackground(Color.WHITE);
        this._phase2HelpLabel.setOpaque(true);
        this._phase2HelpLabel.setFont(this._phase2HelpLabel.getFont().deriveFont(this._phase2HelpLabel.getFont().getStyle() ^ 1));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        jPanel.add((Component)this._phase2HelpLabel, gridBagConstraints);
        this._phase2HelpTipPane = new JEditorPane();
        this._phase2HelpTipPane.setEditable(false);
        this._phase2HelpTipPane.setContentType("text/html");
        this._phase2HelpTipPane.setOpaque(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel.add((Component)this._phase2HelpTipPane, gridBagConstraints);
        this._phase2HelpTipPane.addHyperlinkListener(this);
        this._phase2Label = new JLabel("Phase II: Observing Program", 0);
        this._phase2Label.setBackground(this._gui.getPalette().getPhase2Color());
        this._phase2Label.setOpaque(true);
        this._phase2Label.setFont(this._phase2Label.getFont().deriveFont(this._phase2Label.getFont().getStyle() ^ 1));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)this._phase2Label, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 1;
        this._phase2RetrievePropStep = new OverviewStep("Retrieve\nScience\nProposal", ObsProject.STATUS_NEWPHASE2, _retrieveProposalHelpMsg, 20);
        this._phase2RetrievePropStep.setItemColor(this._gui.getPalette().getPhase2Color());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this._phase2RetrievePropStep, gridBagConstraints);
        this._phase2RetrievePropStep.addMouseListener(this);
        this.initEvents(this._phase2RetrievePropStep, FID_STATUS);
        this._phase2SysSetupStep = new OverviewStep("Configure\nSystem\nSetup", ObsProject.STATUS_NEWPHASE2, _systemSetupHelpMsg, 20);
        this._phase2SysSetupStep.setItemColor(this._gui.getPalette().getPhase2Color());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this._phase2SysSetupStep, gridBagConstraints);
        this._phase2SysSetupStep.addMouseListener(this);
        this.initEvents(this._phase2SysSetupStep, FID_STATUS);
        this._phase2ValidProgStep = new OverviewStep("Validate\nObserving\nProgram", ObsProject.STATUS_NEWPHASE2, _validateProgramHelpMsg, 20);
        this._phase2ValidProgStep.setItemColor(this._gui.getPalette().getPhase2Color());
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this._phase2ValidProgStep, gridBagConstraints);
        this._phase2ValidProgStep.addMouseListener(this);
        this.initEvents(this._phase2ValidProgStep, FID_STATUS);
        this._phase2SubProgStep = new OverviewStep("Submit\nObserving\nProgram", ObsProject.STATUS_NEWPHASE2, _submitProgramHelpMsg, 0);
        this._phase2SubProgStep.setItemColor(this._gui.getPalette().getPhase2Color());
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this._phase2SubProgStep, gridBagConstraints);
        this._phase2SubProgStep.addMouseListener(this);
        this.initEvents(this._phase2SubProgStep, FID_STATUS);
        this._phase2ClickLabel = new JLabel("Click on the overview steps to view the contextual help", 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        jPanel.add((Component)this._phase2ClickLabel, gridBagConstraints);
        this._phase2ImportExportStep = new OverviewStep("Importing\nAnd\nExporting", ObsProject.STATUS_NEWPHASE2, _importExportHelpMsg, 0);
        this._phase2ImportExportStep.setItemColor(HELP_COLOUR);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this._phase2ImportExportStep, gridBagConstraints);
        this._phase2ImportExportStep.addMouseListener(this);
        this.initEvents(this._phase2ImportExportStep, FID_STATUS);
        this._phase2TemplateLibraryStep = new OverviewStep("Template\nLibrary", ObsProject.STATUS_NEWPHASE2, _templateLibraryMsg, 0);
        this._phase2TemplateLibraryStep.setItemColor(HELP_COLOUR);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this._phase2TemplateLibraryStep, gridBagConstraints);
        this._phase2TemplateLibraryStep.addMouseListener(this);
        this.initEvents(this._phase2TemplateLibraryStep, FID_STATUS);
        this._phase2MoreHelpStep = new OverviewStep("Need\nMore\nHelp?", ObsProject.STATUS_NEWPHASE2, _needMoreHelpMsg, 0);
        this._phase2MoreHelpStep.setItemColor(HELP_COLOUR);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this._phase2MoreHelpStep, gridBagConstraints);
        this._phase2MoreHelpStep.addMouseListener(this);
        this.initEvents(this._phase2MoreHelpStep, FID_STATUS);
        this._phase2ViewPhase1 = new OverviewPhase("View\nPhase 1\nSteps", ObsProject.STATUS_NEWPHASE2, Direction.LEFT, 10);
        this._phase2ViewPhase1.setItemColor(this._gui.getPalette().getPhase1Color());
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this._phase2ViewPhase1, gridBagConstraints);
        this._phase2ViewPhase1.addMouseListener(this);
        this.initEvents(this._phase2ViewPhase1, FID_STATUS);
        return jPanel;
    }

    @Override
    public void set(JComponent jComponent, Object object) {
        if (jComponent == null) {
            return;
        }
        if (jComponent instanceof OverviewStep) {
            return;
        }
        super.set(jComponent, object);
    }

    private void _launchBrowser(String string) {
        Desktop desktop = null;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            URI uRI = null;
            try {
                uRI = new URI(string);
                desktop.browse(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                Log.logger((Object)this).warning("Got a bad URI " + string + "(" + uRISyntaxException.getMessage() + ")");
                String string2 = "Unable to load URL " + string + " in desktop browser.\nPlease check your desktop browser configuration.";
                GUIUtilities.warning(browserErrorDialog, string2);
            }
            catch (IOException iOException) {
                Log.logger((Object)this).warning("Failed to launch desktop web browser for URI " + uRI.toString() + "(" + iOException.getMessage() + ")");
                String string3 = "Unable to load URL " + string + " in desktop browser.\nPlease check your desktop browser configuration.";
                GUIUtilities.warning(browserErrorDialog, string3);
            }
        }
    }

    public void refreshColors() {
        Color color = this._gui.getPalette().getPhase1Color();
        Color color2 = this._gui.getPalette().getPhase2Color();
        this._phase1Label.setBackground(color);
        this._phase1NewPropStep.setItemColor(color);
        this._phase1CreateGoalStep.setItemColor(color);
        this._phase1ValidPropStep.setItemColor(color);
        this._phase1SubPropStep.setItemColor(color);
        this._phase1ViewPhase2.setItemColor(color2);
        this._phase2Label.setBackground(color2);
        this._phase2RetrievePropStep.setItemColor(color2);
        this._phase2SysSetupStep.setItemColor(color2);
        this._phase2ValidProgStep.setItemColor(color2);
        this._phase2SubProgStep.setItemColor(color2);
        this._phase2ViewPhase1.setItemColor(color);
    }

    private void _deselectPhase1Steps() {
        this._phase1NewPropStep.setSelected(false);
        this._phase1CreateGoalStep.setSelected(false);
        this._phase1ValidPropStep.setSelected(false);
        this._phase1SubPropStep.setSelected(false);
        this._phase1ImportExportStep.setSelected(false);
        this._phase1TemplateLibraryStep.setSelected(false);
        this._phase1MoreHelpStep.setSelected(false);
        this._phase1Label.repaint();
        this._phase1HelpLabel.repaint();
        this._phase1ClickLabel.repaint();
        this._phase1NewPropStep.repaint();
        this._phase1CreateGoalStep.repaint();
        this._phase1ValidPropStep.repaint();
        this._phase1SubPropStep.repaint();
        this._phase1ImportExportStep.repaint();
        this._phase1TemplateLibraryStep.repaint();
        this._phase1MoreHelpStep.repaint();
    }

    private void _deselectPhase2Steps() {
        this._phase2RetrievePropStep.setSelected(false);
        this._phase2SysSetupStep.setSelected(false);
        this._phase2ValidProgStep.setSelected(false);
        this._phase2SubProgStep.setSelected(false);
        this._phase2ImportExportStep.setSelected(false);
        this._phase2TemplateLibraryStep.setSelected(false);
        this._phase2MoreHelpStep.setSelected(false);
        this._phase2Label.repaint();
        this._phase2HelpLabel.repaint();
        this._phase2ClickLabel.repaint();
        this._phase2RetrievePropStep.repaint();
        this._phase2SysSetupStep.repaint();
        this._phase2ValidProgStep.repaint();
        this._phase2SubProgStep.repaint();
        this._phase2ImportExportStep.repaint();
        this._phase2TemplateLibraryStep.repaint();
        this._phase2MoreHelpStep.repaint();
    }

    private void selectStep(OverviewStep overviewStep) {
        if (overviewStep.getKey() == ObsProject.STATUS_NEWPHASE1) {
            this._deselectPhase1Steps();
        } else if (overviewStep.getKey() == ObsProject.STATUS_NEWPHASE2) {
            this._deselectPhase2Steps();
        }
        overviewStep.setClicked(false);
        overviewStep.setSelected(true);
        overviewStep.writeHelpTip();
        overviewStep.repaint();
        this.setCursor(null);
    }

    public void setProjectPhase(String string) {
        if (string.equals(ObsProject.STATUS_NEWPHASE1) || string.equals(ObsProject.STATUS_PHASE1SUBMITTED) || string.equals(ObsProject.STATUS_REJECTED)) {
            this._phase2Panel.setVisible(false);
            this._phase1Panel.setVisible(true);
        } else {
            this._phase1Panel.setVisible(false);
            this._phase2Panel.setVisible(true);
        }
    }

    public void setProjectPhase(Phase phase) {
        if (phase == Phase.PHASE1) {
            this._phase2Panel.setVisible(false);
            this._phase1Panel.setVisible(true);
        } else {
            this._phase1Panel.setVisible(false);
            this._phase2Panel.setVisible(true);
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(FID_STATUS)) {
            this.set((JComponent)this._phase1NewPropStep, object);
            this.set((JComponent)this._phase1CreateGoalStep, object);
            this.set((JComponent)this._phase1ValidPropStep, object);
            this.set((JComponent)this._phase1SubPropStep, object);
            this.set((JComponent)this._phase1ImportExportStep, object);
            this.set((JComponent)this._phase1TemplateLibraryStep, object);
            this.set((JComponent)this._phase1MoreHelpStep, object);
            this.set((JComponent)this._phase2RetrievePropStep, object);
            this.set((JComponent)this._phase2SysSetupStep, object);
            this.set((JComponent)this._phase2ValidProgStep, object);
            this.set((JComponent)this._phase2SubProgStep, object);
            this.set((JComponent)this._phase2ImportExportStep, object);
            this.set((JComponent)this._phase2TemplateLibraryStep, object);
            this.set((JComponent)this._phase2MoreHelpStep, object);
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        JLabel jLabel;
        if (mouseEvent.getSource() instanceof OverviewPhase) {
            jLabel = (OverviewPhase)mouseEvent.getSource();
            if (jLabel == this._phase2ViewPhase1) {
                this._phase2Panel.setVisible(false);
                this._phase1Panel.setVisible(true);
            } else if (jLabel == this._phase1ViewPhase2) {
                this._phase1Panel.setVisible(false);
                this._phase2Panel.setVisible(true);
            }
        }
        if (mouseEvent.getSource() instanceof OverviewStep) {
            jLabel = (OverviewStep)mouseEvent.getSource();
            ((OverviewStep)jLabel).setClicked(true);
            jLabel.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof OverviewStep) {
            OverviewStep overviewStep = (OverviewStep)mouseEvent.getSource();
            this.selectStep(overviewStep);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String string = hyperlinkEvent.getURL() != null ? hyperlinkEvent.getURL().toString() : hyperlinkEvent.getDescription();
            if (string.contains("http://")) {
                this._launchBrowser(string);
            } else if (string.equals("#NewProposal")) {
                this.performAction(this._gui.primaryProjectCompartment().getProjectTiedActions().newProposal);
            } else if (string.equals("#NewDDTProposal")) {
                this.performAction(this._gui.primaryProjectCompartment().getProjectTiedActions().newDDTProposal);
            } else if (string.equals("#NewScienceGoal")) {
                ProjectTree projectTree = this._gui.primaryProjectCompartment().getPhase1Tree();
                ProjectTreeNode projectTreeNode = projectTree.findNodeBelow(projectTree.getTop(), ObsProposal.class);
                projectTree.select(new TreePath(projectTreeNode.getPath()));
                this.performAction(this._gui.primaryProjectCompartment().getProjectTiedActions().addPhaseIScienceGoal);
                this._gui.showNode(projectTree, projectTreeNode);
            } else if (string.equals("#ViewProject")) {
                ProjectTree projectTree = this._gui.primaryProjectCompartment().getPhase1Tree();
                ProjectTreeNode projectTreeNode = projectTree.getTop();
                this._gui.showNode(projectTree, projectTreeNode);
            } else if (string.equals("#ViewProposal")) {
                ProjectTree projectTree = this._gui.primaryProjectCompartment().getPhase1Tree();
                ProjectTreeNode projectTreeNode = projectTree.findNodeBelow(projectTree.getTop(), ObsProposal.class);
                this._gui.showNode(projectTree, projectTreeNode);
            } else if (string.equals("#ValidateProposal") || string.equals("#ValidateProgram")) {
                this.performAction(this._gui.primaryProjectCompartment().getProjectTiedActions().validate);
            } else if (string.equals("#SubmitProposal") || string.equals("#SubmitProgram")) {
                this.performAction(this._gui.primaryProjectCompartment().getProjectTiedActions().submit);
            } else if (string.equals("#RetrieveProposal")) {
                this.performAction(this._gui.primaryProjectCompartment().getProjectTiedActions().retrieve);
            } else if (string.equals("#NewProgram")) {
                this.performAction(this._gui.primaryProjectCompartment().getProjectTiedActions().newProject);
            } else if (string.equals("#GenerateBlocks")) {
                this.performAction(this._gui.primaryProjectCompartment().getProjectTiedActions().generateSBs);
            } else if (string.equals("#ImportProposal")) {
                this.performAction(this._gui.primaryProjectCompartment().getProjectTiedActions().open);
            } else if (string.equals("#ExportProposal")) {
                this.performAction(this._gui.primaryProjectCompartment().getProjectTiedActions().saveAs);
            } else if (string.equals("#TemplateLibrary")) {
                this.performAction(this._gui.getApplicationWideActions().importStdLibrary);
            } else if (string.equals("#Help")) {
                this.performAction(this._gui.getApplicationWideActions().helpUserManual);
            } else if (string.equals("#UserManual")) {
                this._launchBrowser("http://almascience.org/");
            }
        }
    }

    private void performAction(Action action) {
        if (!action.isEnabled()) {
            return;
        }
        Overview overview = this;
        int n = 1001;
        String string = (String)action.getValue("Name");
        action.actionPerformed(new ActionEvent(overview, n, string));
    }

    public static void main(String[] stringArray) {
    }

    public class OverviewPhase
    extends JLabel {
        private String _text;
        private String _key;
        private String[] _label;
        private int _numTextLines;
        private int _textWidth;
        private int _textHeight;
        private int _itemWidth;
        private int _itemHeight;
        private int _arrowLength;
        private Direction _direction = Direction.RIGHT;
        private Color _stepColor = Color.WHITE;
        private Color _borderColor = Color.BLACK;

        public OverviewPhase(String string, String string2, Direction direction, int n) {
            this._text = string;
            this._key = string2;
            this._direction = direction;
            this._arrowLength = n;
        }

        public void setKey(String string) {
            this._key = string;
        }

        public String getKey() {
            return this._key;
        }

        public void setItemColor(Color color) {
            this._stepColor = color;
        }

        public Color getItemColor() {
            return this._stepColor;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this._textHeight = fontMetrics.getAscent();
            this._label = this._text.split("\n");
            int n = 0;
            for (int i = 0; i < this._label.length; ++i) {
                int n2 = fontMetrics.stringWidth(this._label[i]);
                if (n2 <= n) continue;
                n = n2;
            }
            this._textWidth = n;
            this._itemWidth = n + 2 * this._textHeight;
            this._itemHeight = (this._label.length + 2) * this._textHeight;
            return new Dimension(this._itemWidth + 1 + 2 * this._arrowLength, this._itemHeight + 1);
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle2D.Float float_ = new Rectangle2D.Float(this._arrowLength, 0.0f, this._itemWidth, this._itemHeight);
            this.paint(graphics, float_);
            graphics2D.setFont(this.getFont());
            int n2 = this._textHeight + this._arrowLength;
            int n3 = this._textHeight * 11 / 6;
            for (n = 0; n < this._label.length; ++n) {
                graphics2D.drawString(this._label[n], n2, n3 + n * this._textHeight);
            }
            if (this._arrowLength != 0) {
                int n4;
                int[] nArray;
                int[] nArray2;
                int[] nArray3;
                int[] nArray4;
                n = 0;
                int n5 = this._arrowLength + 1;
                int n6 = this._itemWidth + this._arrowLength;
                int n7 = this._itemWidth + this._arrowLength * 2;
                int n8 = 0;
                int n9 = this._itemHeight / 2;
                int n10 = this._itemHeight;
                if (this._direction == Direction.RIGHT) {
                    nArray4 = new int[]{n5, n, n5, n, n5};
                    nArray3 = new int[]{n8, n8, n9, n10, n10};
                    nArray2 = new int[]{n6, n7, n6};
                    nArray = new int[]{n8, n9, n10};
                } else {
                    nArray4 = new int[]{n6, n7, n6, n7, n6};
                    nArray3 = new int[]{n8, n8, n9, n10, n10};
                    nArray2 = new int[]{n5, n, n5};
                    nArray = new int[]{n8, n9, n10};
                }
                GeneralPath generalPath = new GeneralPath(0, nArray4.length + nArray2.length);
                generalPath.moveTo(nArray4[0], nArray3[0]);
                for (n4 = 1; n4 < nArray4.length; ++n4) {
                    generalPath.lineTo(nArray4[n4], nArray3[n4]);
                }
                generalPath.moveTo(nArray2[0], nArray[0]);
                for (n4 = 1; n4 < nArray2.length; ++n4) {
                    generalPath.lineTo(nArray2[n4], nArray[n4]);
                }
                this.paint(graphics, generalPath);
            }
        }

        private void paint(Graphics graphics, Shape shape) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(this._stepColor);
            graphics2D.fill(shape);
            graphics2D.setPaint(this._borderColor);
            graphics2D.draw(shape);
        }
    }

    public class OverviewStep
    extends JLabel {
        private String _text;
        private String _key;
        private boolean _selected = false;
        private boolean _clicked = false;
        private String _helpMsg;
        private String[] _label;
        private int _numTextLines;
        private int _textWidth;
        private int _textHeight;
        private int _itemWidth;
        private int _itemHeight;
        private int _arrowLength;
        private Color _stepColor = Color.WHITE;
        private Color _borderColor = Color.BLACK;

        public OverviewStep(String string, String string2, String string3, int n) {
            this._text = string;
            this._key = string2;
            this._helpMsg = string3;
            this._arrowLength = n;
        }

        public void setKey(String string) {
            this._key = string;
        }

        public String getKey() {
            return this._key;
        }

        public void setHelpMsg(String string) {
            this._helpMsg = string;
        }

        public String getHelpMsg() {
            return this._helpMsg;
        }

        public void setSelected(boolean bl) {
            this._selected = bl;
        }

        public boolean getSelected() {
            return this._selected;
        }

        public void setClicked(boolean bl) {
            this._clicked = bl;
        }

        public boolean getClicked() {
            return this._clicked;
        }

        public void setItemColor(Color color) {
            this._stepColor = color;
        }

        public Color getItemColor() {
            return this._stepColor;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this._textHeight = fontMetrics.getAscent();
            this._label = this._text.split("\n");
            int n = 0;
            for (int i = 0; i < this._label.length; ++i) {
                int n2 = fontMetrics.stringWidth(this._label[i]);
                if (n2 <= n) continue;
                n = n2;
            }
            this._textWidth = n;
            this._itemWidth = n + 2 * this._textHeight;
            this._itemHeight = (this._label.length + 2) * this._textHeight;
            return new Dimension(this._itemWidth + 1 + this._arrowLength, this._itemHeight + 1);
        }

        public void writeHelpTip() {
            if (this.getKey() == ObsProject.STATUS_NEWPHASE1) {
                Overview.this._phase1HelpTipPane.setText(this._helpMsg);
            } else {
                Overview.this._phase2HelpTipPane.setText(this._helpMsg);
            }
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(0.0f, 0.0f, this._itemWidth, this._itemHeight, 25.0f, 25.0f);
            this.paint(graphics, float_);
            if (this._selected) {
                graphics2D.setFont(this.getFont().deriveFont(1));
            } else {
                graphics2D.setFont(this.getFont());
            }
            int n2 = this._textHeight;
            int n3 = this._textHeight * 11 / 6;
            for (n = 0; n < this._label.length; ++n) {
                graphics2D.drawString(this._label[n], n2, n3 + n * this._textHeight);
            }
            if (this._arrowLength != 0) {
                n = this._itemWidth;
                int n4 = n + this._arrowLength / 2;
                int n5 = n + this._arrowLength;
                int n6 = this._itemHeight / 3;
                int n7 = this._itemHeight / 5;
                int n8 = this._itemHeight / 2;
                int n9 = this._itemHeight - n7;
                int n10 = this._itemHeight - n6;
                int[] nArray = new int[]{n, n4, n4, n5, n4, n4, n};
                int[] nArray2 = new int[]{n6, n6, n7, n8, n9, n10, n10};
                GeneralPath generalPath = new GeneralPath(0, nArray.length);
                generalPath.moveTo(nArray[0], nArray2[0]);
                for (int i = 1; i < nArray.length; ++i) {
                    generalPath.lineTo(nArray[i], nArray2[i]);
                }
                this.paint(graphics, generalPath);
            }
        }

        private void paint(Graphics graphics, Shape shape) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = this._stepColor;
            if (this._clicked) {
                color = color.darker();
            } else if (this._selected) {
                color = color.brighter();
            }
            graphics2D.setPaint(color);
            graphics2D.fill(shape);
            graphics2D.setPaint(this._borderColor);
            graphics2D.draw(shape);
        }
    }

    public static enum Direction {
        LEFT,
        RIGHT;

    }

    public static enum Phase {
        PHASE1,
        PHASE2;

    }
}

