/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.gui.toplevel.ReadonlyHandler;
import alma.obsprep.util.job.JobUtility;
import com.google.common.collect.ImmutableList;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;

public class EditorDisablerController {
    public static final String READONLY_HANDLER = "readonly-handler";
    private static final List<Class<? extends Container>> alwaysEnabledContainers = ImmutableList.of(JPanel.class, Box.class, JScrollPane.class, JViewport.class, JScrollBar.class, JTabbedPane.class);
    public static ReadonlyHandler keepEnabledStateOnReadonly = new ReadonlyHandler(){};
    private List<Component> componentsToReenable;
    private Container m_topLevel;
    private final Map<Component, ReadonlyHandler> m_underlyingComponents;

    public EditorDisablerController(Container container) {
        this.m_topLevel = container;
        this.m_underlyingComponents = new LinkedHashMap<Component, ReadonlyHandler>(1200);
    }

    public void setReadonly(boolean bl) {
        if (bl) {
            ArrayList<Component> arrayList = new ArrayList<Component>(1200);
            this.harvestComponents(this.m_topLevel, arrayList);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Component component = (Component)arrayList.get(i);
                ReadonlyHandler readonlyHandler = this.m_underlyingComponents.get(component);
                if (readonlyHandler == null) {
                    this.checkHandler(component);
                    readonlyHandler = this.m_underlyingComponents.get(component);
                }
                readonlyHandler.handleReadOnly(component);
            }
        } else {
            ArrayList<Component> arrayList = new ArrayList<Component>(this.m_underlyingComponents.keySet());
            this.componentsToReenable = new ArrayList<Component>(1200);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Component component = (Component)arrayList.get(i);
                ReadonlyHandler readonlyHandler = this.m_underlyingComponents.get(component);
                if (readonlyHandler == null) {
                    this.checkHandler(component);
                    readonlyHandler = this.m_underlyingComponents.get(component);
                }
                readonlyHandler.handleNotReadOnly(component);
                if (i != 0) continue;
                readonlyHandler.actionHandleNotReadOnly();
            }
        }
    }

    private void checkHandler(Component component) {
        if (this.m_underlyingComponents.get(component) == null) {
            if (component instanceof JComponent) {
                Object object = ((JComponent)component).getClientProperty(READONLY_HANDLER);
                if (object != null && object instanceof ReadonlyHandler) {
                    this.m_underlyingComponents.put(component, (ReadonlyHandler)object);
                } else if (this.excluded(component)) {
                    this.m_underlyingComponents.put(component, keepEnabledStateOnReadonly);
                } else {
                    this.m_underlyingComponents.put(component, new DisableOnReadonlyHandler());
                }
            } else {
                this.m_underlyingComponents.put(component, new DisableOnReadonlyHandler());
            }
        }
    }

    private boolean excluded(Component component) {
        for (Class<? extends Container> clazz : alwaysEnabledContainers) {
            if (!clazz.isAssignableFrom(component.getClass())) continue;
            return true;
        }
        return false;
    }

    private void harvestComponents(Container container, List<Component> list) {
        for (Component component : container.getComponents()) {
            if (component == null) continue;
            list.add(component);
            if (!(component instanceof Container)) continue;
            this.harvestComponents((Container)component, list);
        }
    }

    public void disableAutoDisable(Component component) {
        ReadonlyHandler readonlyHandler = this.m_underlyingComponents.get(component);
        if (readonlyHandler != null) {
            readonlyHandler.disableAutoStateReset(component);
        }
    }

    private class DisableOnReadonlyHandler
    implements ReadonlyHandler {
        private boolean isPrevStateEnabled;
        private boolean isReadonlyState = false;
        private PropertyChangeListener m_propListener;

        @Override
        public void disableAutoStateReset(Component component) {
            component.removePropertyChangeListener("enabled", this.m_propListener);
        }

        @Override
        public void handleReadOnly(final Component component) {
            UserEditRestrictionController userEditRestrictionController = UserEditRestrictionController.getInstance();
            boolean bl = userEditRestrictionController.isComponentP2EditRestrictionControlled(component);
            if (this.isReadonlyState && !bl) {
                return;
            }
            if (userEditRestrictionController.isComponentColourControlled(component) && component.getBackground() == UserEditRestrictionController.PI_CAN_EDIT_COLOUR) {
                component.setBackground(UserEditRestrictionController.EDITABLE_BY_ALL_COLOUR);
            }
            this.m_propListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (DisableOnReadonlyHandler.this.isReadonlyState && propertyChangeEvent.getNewValue().equals(true) && propertyChangeEvent.getSource().equals(component)) {
                        try {
                            JobUtility.swing.execute(() -> component.setEnabled(false));
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                }
            };
            if (!bl) {
                component.addPropertyChangeListener("enabled", this.m_propListener);
            }
            this.isPrevStateEnabled = component.isEnabled();
            this.isReadonlyState = true;
            component.setEnabled(false);
        }

        @Override
        public void handleNotReadOnly(Component component) {
            boolean bl = UserEditRestrictionController.getInstance().isComponentP2EditRestrictionControlled(component);
            if (!this.isReadonlyState && !bl) {
                return;
            }
            try {
                this.isReadonlyState = false;
                component.removePropertyChangeListener("enabled", this.m_propListener);
                if (this.isPrevStateEnabled || bl) {
                    EditorDisablerController.this.componentsToReenable.add(component);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        @Override
        public void actionHandleNotReadOnly() {
            EditorDisablerController.this.componentsToReenable.stream().forEach(component -> component.setEnabled(true));
        }
    }
}

