/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.feedback.ProblemTableModel;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.UserAuthenticator;
import alma.obsprep.ot.persistence.ProjectRepositoryHttp;
import alma.obsprep.ot.persistence.SslCertificateImporter;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.network.versioncheck.VersionChecker;
import alma.obsprep.services.network.versioncheck.VersionCheckerService;
import alma.obsprep.util.job.AbstractHeap;
import java.io.IOException;

public abstract class AbstractObservingToolController {
    protected Log.Logger logger;
    protected ModuleHeap heap;
    private ProblemTableModel problemTableModel;

    protected AbstractObservingToolController() {
    }

    protected void init() throws IOException {
        InitServices.init();
        this.logger = Log.logger(AbstractObservingToolController.class);
        UserAuthenticator userAuthenticator = new UserAuthenticator();
        this.heap().setUserAuthenticator(userAuthenticator);
        ProjectRepositoryHttp projectRepositoryHttp = new ProjectRepositoryHttp(userAuthenticator);
        this.heap().setProjectRepository(projectRepositoryHttp);
        RoleDirectoryService roleDirectoryService = new RoleDirectoryService(userAuthenticator);
        this.heap().setRoleDirectory(roleDirectoryService);
        VersionCheckerService versionCheckerService = new VersionCheckerService();
        this.heap().setVersionChecker(versionCheckerService);
        String string = System.getProperty("ot.submission.host");
        SslCertificateImporter.configureSSL(string);
    }

    public ModuleHeap heap() {
        if (this.heap == null) {
            this.heap = new ModuleHeap();
        }
        return this.heap;
    }

    public ProblemTableModel getSystemProblemModel() {
        if (this.problemTableModel == null) {
            this.problemTableModel = new ProblemTableModel();
        }
        return this.problemTableModel;
    }

    public class ModuleHeap
    extends AbstractHeap {
        private UserAuthenticator userAuthenticator;
        private ProjectRepositoryHttp projectRepository;
        private RoleDirectoryService roleDirectory;
        private VersionChecker versionChecker;

        public UserAuthenticator getUserAuthenticator() {
            return this.userAuthenticator;
        }

        public void setUserAuthenticator(UserAuthenticator userAuthenticator) {
            this.userAuthenticator = userAuthenticator;
            this.firePropertyChange("userAuthenticator", this.userAuthenticator);
        }

        public ProjectRepositoryHttp getProjectRepository() {
            return this.projectRepository;
        }

        protected void setProjectRepository(ProjectRepositoryHttp projectRepositoryHttp) {
            this.projectRepository = projectRepositoryHttp;
            this.firePropertyChange("projectRepository", this.projectRepository);
        }

        public RoleDirectoryService getRoleDirectory() {
            return this.roleDirectory;
        }

        public void setRoleDirectory(RoleDirectoryService roleDirectoryService) {
            this.roleDirectory = roleDirectoryService;
            this.firePropertyChange("roleDirectory", this.roleDirectory);
        }

        public VersionChecker getVersionChecker() {
            return this.versionChecker;
        }

        protected void setVersionChecker(VersionChecker versionChecker) {
            this.versionChecker = versionChecker;
            this.firePropertyChange("versionChecker", this.versionChecker);
        }
    }
}

