/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.bott;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.BOInfo;
import alma.obsprep.bo.BOIntrospector;
import alma.obsprep.bo.BOPropertyDescriptor;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import javax.swing.tree.DefaultMutableTreeNode;

class BOTreeNode
extends DefaultMutableTreeNode {
    private String[] boFields = null;
    private BOInfo boInfo = null;

    public BOTreeNode(BusinessObject businessObject) throws IntrospectionException {
        super(businessObject);
        this.boInfo = BOIntrospector.getBOInfo(businessObject.getClass());
        this.boFields = this.boInfo.getSimplePropertyNames();
    }

    public boolean equals(BOTreeNode bOTreeNode) {
        return this.getBusinessObject().equals(bOTreeNode.getBusinessObject());
    }

    public BusinessObject getBusinessObject() {
        return (BusinessObject)this.getUserObject();
    }

    public BOTreeNode getChild(int n) {
        BOTreeNode bOTreeNode = (BOTreeNode)this.getChildAt(n);
        return bOTreeNode;
    }

    public String getPropertyName(int n) {
        if (n >= this.boFields.length) {
            return null;
        }
        return this.boFields[n];
    }

    public int getFieldsCount() {
        return this.boFields.length;
    }

    public Object getFieldValue(int n) {
        return this.getFieldValue(this.getPropertyName(n));
    }

    public Object getFieldValue(String string) {
        BOPropertyDescriptor bOPropertyDescriptor = this.boInfo.getProperty(string);
        if (bOPropertyDescriptor == null) {
            return null;
        }
        Method method = bOPropertyDescriptor.getReadMethod();
        Object object = null;
        try {
            object = method.invoke((Object)this.getBusinessObject(), (Object[])null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    public void setFieldValue(String string, String string2) {
        BOPropertyDescriptor bOPropertyDescriptor = this.boInfo.getProperty(string);
        if (bOPropertyDescriptor == null) {
            return;
        }
        Class<?> clazz = bOPropertyDescriptor.getPropertyType();
        Object object = null;
        if (clazz == String.class) {
            object = string2;
        } else if (clazz == Integer.TYPE) {
            object = new Integer(Integer.parseInt(string2));
        } else if (clazz == Float.TYPE) {
            object = new Float(Float.parseFloat(string2));
        } else if (clazz == Double.TYPE) {
            object = new Double(Double.parseDouble(string2));
        } else {
            throw new RuntimeException("Unsupported setter arg: " + clazz);
        }
        try {
            BusinessObject businessObject = this.getBusinessObject();
            Object[] objectArray = new Object[]{object};
            Method method = bOPropertyDescriptor.getWriteMethod();
            method.invoke((Object)businessObject, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean hasProperty(String string) {
        BOPropertyDescriptor bOPropertyDescriptor = this.boInfo.getProperty(string);
        return bOPropertyDescriptor != null;
    }

    @Override
    public String toString() {
        String string = this.boInfo.getBOclassName();
        return string;
    }
}

