/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.bott;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.BOInfo;
import alma.obsprep.bo.BOIntrospector;
import alma.obsprep.bo.BOPropertyDescriptor;
import alma.obsprep.ot.gui.bott.AbstractTreeTableModel;
import alma.obsprep.ot.gui.bott.BOTreeNode;
import alma.obsprep.ot.gui.bott.TreeTableModel;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class BOLargeTTModel
extends AbstractTreeTableModel {
    private String[] columns;

    public BOLargeTTModel(BusinessObject businessObject) throws IntrospectionException {
        super(new BOTreeNode(businessObject));
        this.init((BOTreeNode)this.root);
    }

    private void addChildBO(BOTreeNode bOTreeNode, BusinessObject businessObject, Map<BusinessObject, BOTreeNode> map) throws IntrospectionException {
        BOTreeNode bOTreeNode2 = new BOTreeNode(businessObject);
        bOTreeNode.add(bOTreeNode2);
        this.computeChildren(bOTreeNode2, map);
    }

    private void collectFieldNames(Class<?> clazz, Map<String, Integer> map, Map<Class<?>, Class<?>> map2) throws IntrospectionException {
        if (map2.get(clazz) != null) {
            return;
        }
        map2.put(clazz, clazz);
        BOInfo bOInfo = BOIntrospector.getBOInfo(clazz);
        String[] stringArray = bOInfo.getSimplePropertyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Integer n = map.get(string);
            n = n == null ? new Integer(1) : new Integer(n + 1);
            map.put(string, n);
        }
        Class<?>[] classArray = bOInfo.getChildClasses();
        for (int i = 0; i < classArray.length; ++i) {
            this.collectFieldNames(classArray[i], map, map2);
        }
    }

    protected void computeChildren(BOTreeNode bOTreeNode) throws IntrospectionException {
        this.computeChildren(bOTreeNode, new HashMap<BusinessObject, BOTreeNode>());
    }

    private void computeChildren(BOTreeNode bOTreeNode, Map<BusinessObject, BOTreeNode> map) throws IntrospectionException {
        if (bOTreeNode == null) {
            return;
        }
        map.put(bOTreeNode.getBusinessObject(), bOTreeNode);
        BusinessObject businessObject = bOTreeNode.getBusinessObject();
        BOInfo bOInfo = BOIntrospector.getBOInfo(businessObject.getClass());
        BOPropertyDescriptor[] bOPropertyDescriptorArray = bOInfo.getProperties();
        for (int i = 0; i < bOPropertyDescriptorArray.length; ++i) {
            BOPropertyDescriptor bOPropertyDescriptor = bOPropertyDescriptorArray[i];
            if (!bOPropertyDescriptor.isBusinessObject()) continue;
            try {
                BusinessObject businessObject2;
                Method method = bOPropertyDescriptor.getReadMethod();
                Object object = method.invoke((Object)businessObject, (Object[])null);
                if (object == null || map.get(object) != null) continue;
                if (object.getClass().isArray()) {
                    businessObject2 = (BusinessObject)object;
                    for (int j = 0; j < ((BusinessObject)businessObject2).length; ++j) {
                        BusinessObject businessObject3 = businessObject2[j];
                        this.addChildBO(bOTreeNode, businessObject3, map);
                    }
                    continue;
                }
                businessObject2 = (BusinessObject)object;
                this.addChildBO(bOTreeNode, businessObject2, map);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public Object getChild(Object object, int n) {
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        BOTreeNode bOTreeNode2 = (BOTreeNode)bOTreeNode.getChildAt(n);
        return bOTreeNode2;
    }

    @Override
    public int getChildCount(Object object) {
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        int n = bOTreeNode.getChildCount();
        return n;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return TreeTableModel.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length + 1;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return "";
        }
        return this.columns[n - 1];
    }

    public BOTreeNode[] computePathToRoot(BOTreeNode bOTreeNode) {
        Stack<BOTreeNode> stack = new Stack<BOTreeNode>();
        this.recurseToRoot(bOTreeNode, stack);
        BOTreeNode[] bOTreeNodeArray = stack.toArray(new BOTreeNode[stack.size()]);
        return bOTreeNodeArray;
    }

    private void recurseToRoot(BOTreeNode bOTreeNode, Stack<BOTreeNode> stack) {
        if (bOTreeNode == null) {
            return;
        }
        stack.add(0, bOTreeNode);
        this.recurseToRoot((BOTreeNode)bOTreeNode.getParent(), stack);
    }

    @Override
    public Object getValueAt(Object object, int n) {
        if (n == 0) {
            return null;
        }
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        String string = this.getColumnName(n);
        Object object2 = bOTreeNode.getFieldValue(string);
        return object2;
    }

    private void init(BOTreeNode bOTreeNode) throws IntrospectionException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap hashMap2 = new HashMap();
        this.collectFieldNames(bOTreeNode.getBusinessObject().getClass(), hashMap, hashMap2);
        this.columns = this.sort(hashMap);
        this.computeChildren(bOTreeNode);
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        if (n == 0) {
            return true;
        }
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        String string = this.getColumnName(n);
        return bOTreeNode.hasProperty(string);
    }

    @Override
    public boolean isLeaf(Object object) {
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        boolean bl = bOTreeNode.isLeaf();
        return bl;
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
    }

    private String[] sort(Map<String, Integer> map) {
        Object object;
        ColumnName[] columnNameArray = new ColumnName[map.size()];
        Iterator<String> iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            int n2 = map.get(object);
            columnNameArray[n++] = new ColumnName((String)object, n2);
        }
        object = (columnName, columnName2) -> {
            int n;
            ColumnName columnName3 = columnName;
            ColumnName columnName4 = columnName2;
            int n2 = columnName3.getFrequency();
            if (n2 != (n = columnName4.getFrequency())) {
                return n - n2;
            }
            return columnName3.getName().compareTo(columnName4.getName());
        };
        Arrays.sort(columnNameArray, object);
        String[] stringArray = new String[columnNameArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = columnNameArray[i].getName();
        }
        return stringArray;
    }

    private class ColumnName {
        private final int freq;
        private final String name;

        ColumnName(String string, int n) {
            this.name = string;
            this.freq = n;
        }

        int getFrequency() {
            return this.freq;
        }

        String getName() {
            return this.name;
        }
    }
}

