/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.valuetypes;

import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.guiutil.mvc.verifiers.Verifier;
import alma.obsprep.ot.boEditors.VelocityVerifier;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.models.valuetypes.VelocityModel;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class VelocityEditor
extends Editor
implements ActionListener {
    private DialogId dialogId = new DialogId("VelocityEditor.ReferenceSystem", "Display velocity reference system change message");
    private boolean isUpdatePending = false;
    private static final int FIELDWIDTH = 8;
    private NumberFormat redshiftFormatter = new DecimalFormat("0.000000000");
    private FieldID valueFID;
    private FieldID unitFID;
    private FieldID systemFID;
    private FieldID dopplerFID;
    private FieldID redshiftFID;
    private JTextField input;
    private JComboBox units;
    private JComboBox systems;
    private JComboBox doppler;
    private JTextField redshift;
    private JLabel zLabel;
    private JLabel dopplerLabel;

    public VelocityEditor(VelocityModel velocityModel) {
        this(velocityModel, null);
    }

    public VelocityEditor(VelocityModel velocityModel, VelocityVerifier velocityVerifier) {
        this.valueFID = velocityModel.getCenterVelocityValueFID();
        this.unitFID = velocityModel.getCenterVelocityUnitFID();
        this.systemFID = velocityModel.getReferenceSystemFID();
        this.dopplerFID = velocityModel.getDopplerCalcTypeFID();
        this.redshiftFID = velocityModel.getRedshiftFID();
        this.build(velocityVerifier);
        this.setModel(velocityModel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Verifier verifier = this.getVerifier(this.input, "FOCUSLOST_VERIFIER");
        if (verifier != null) {
            verifier.verify();
        }
    }

    @Override
    protected void build() {
        this.build(null);
    }

    protected void build(VelocityVerifier velocityVerifier) {
        this.input = new JTextField(8);
        this.units = new JComboBox();
        this.systems = new JComboBox();
        this.doppler = new JComboBox();
        this.redshift = new JTextField(8);
        this.input.setName("VelocityEditor.inputText");
        this.units.setName("VelocityEditor.unitsCombo");
        this.systems.setName("VelocityEditor.SystemsCombo");
        this.doppler.setName("VelocityEditor.DopplerTypeCombo");
        this.redshift.setName("VelocityEditor.RedShiftText");
        if (velocityVerifier != null) {
            this.initEvents(this.input, this.valueFID, "FOCUSLOST_VERIFIER", velocityVerifier);
        } else {
            this.initEvents(this.input, this.valueFID);
        }
        this.initEvents(this.units, this.unitFID);
        this.units.addActionListener(this);
        this.initEvents(this.systems, this.systemFID);
        this.systems.addActionListener(this);
        VelocityReferenceItemListener velocityReferenceItemListener = new VelocityReferenceItemListener();
        this.systems.addItemListener(velocityReferenceItemListener);
        this.initEvents(this.doppler, this.dopplerFID);
        this.doppler.addActionListener(this);
        DoubleVerifier doubleVerifier = new DoubleVerifier((Editor)this, this.redshift, -1.7976931348623157E308, (double)Double.MAX_VALUE);
        this.initEvents(this.redshift, this.redshiftFID, "FOCUSLOST_VERIFIER", doubleVerifier);
        this.redshift.addActionListener(this);
        FlowLayout flowLayout = (FlowLayout)this.getLayout();
        flowLayout.setAlignment(0);
        this.add(this.input);
        this.add(this.units);
        this.add(this.systems);
        this.zLabel = new JLabel(" z");
        this.add(this.zLabel);
        this.add(this.redshift);
        this.dopplerLabel = new JLabel("Doppler Type");
        this.add(this.dopplerLabel);
        this.add(this.doppler);
    }

    public void setVerifier(String string, Verifier verifier) {
        super.setVerifier(this.getInput(), string, verifier);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.setEnabled(this.input, bl);
        this.setEnabled(this.units, bl);
        this.setEnabled(this.systems, bl);
        this.setEnabled(this.doppler, bl);
        this.setEnabled(this.redshift, bl);
    }

    @Override
    public void setToolTipText(String string) {
        this.input.setToolTipText("Velocity value in your desired units");
        this.units.setToolTipText("Choose units from the list");
        this.systems.setToolTipText("Select a velocity reference frame from the list");
        this.doppler.setToolTipText("Velocity convention");
        this.redshift.setToolTipText("Astronomical redshift, calculated using the specified velocity convention");
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (fieldID.equals(this.redshiftFID)) {
            Double d = Double.NaN;
            try {
                d = Double.parseDouble(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                d = Double.NaN;
            }
            object = d.equals(Double.NaN) ? "" : this.redshiftFormatter.format(d);
        }
        super.modelChanged(model, fieldID, object);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(this.unitFID)) {
            JComboBox jComboBox = (JComboBox)this.retrieve(fieldID);
            VelocityModel velocityModel = (VelocityModel)this.getModel();
            Object[] objectArray = velocityModel.unitMap().getUnitsSorted();
            this.suspendEvents(jComboBox);
            jComboBox.removeAllItems();
            for (int i = 0; i < objectArray.length; ++i) {
                jComboBox.addItem(objectArray[i]);
            }
            this.resumeEvents(jComboBox);
            this.set(jComboBox, (String)object);
        } else if (fieldID.equals(this.systemFID)) {
            JComboBox jComboBox = (JComboBox)this.retrieve(fieldID);
            VelocityModel velocityModel = (VelocityModel)this.getModel();
            this.isUpdatePending = true;
            this.suspendEvents(jComboBox);
            jComboBox.removeAllItems();
            for (String string : velocityModel.getKnownReferenceSystemList()) {
                if (string.equals(Velocity.REFERENCESYSTEM_LSR)) continue;
                jComboBox.addItem(string);
            }
            this.resumeEvents(jComboBox);
            this.set(jComboBox, (String)object);
            this.isUpdatePending = false;
        } else if (fieldID.equals(this.dopplerFID)) {
            JComboBox jComboBox = (JComboBox)this.retrieve(fieldID);
            VelocityModel velocityModel = (VelocityModel)this.getModel();
            String[] stringArray = velocityModel.getKnownDopplerCalcTypeList();
            this.suspendEvents(jComboBox);
            jComboBox.removeAllItems();
            for (int i = 0; i < stringArray.length; ++i) {
                jComboBox.addItem(stringArray[i]);
            }
            this.resumeEvents(jComboBox);
            this.set(jComboBox, (String)object);
        } else {
            this.isUpdatePending = true;
            super.update(fieldID, object);
            this.isUpdatePending = false;
        }
    }

    @Override
    public Object widgetModified(FieldID fieldID, Object object) {
        if (fieldID.equals(this.unitFID)) {
            Velocity velocity = (Velocity)((Object)this.getModel().getDocument());
            Speed speed = velocity.getCenterVelocity();
            String string = (String)object;
            speed.convertToUnit(string);
            this.getModel().publish(this.valueFID, speed.getContent());
        }
        return object;
    }

    @Override
    public List<JComponent> getUserRestrictedEditableComponents() {
        return Arrays.asList(this.input, this.units, this.systems, this.doppler, this.redshift, this.zLabel, this.dopplerLabel);
    }

    public FieldID getValueFID() {
        return this.valueFID;
    }

    public FieldID getUnitFID() {
        return this.unitFID;
    }

    public FieldID getSystemFID() {
        return this.systemFID;
    }

    public FieldID getDopplerFID() {
        return this.dopplerFID;
    }

    public FieldID getRedshiftFID() {
        return this.redshiftFID;
    }

    public JTextField getInput() {
        return this.input;
    }

    public JComboBox getUnits() {
        return this.units;
    }

    public JComboBox getSystems() {
        return this.systems;
    }

    public JComboBox getDoppler() {
        return this.doppler;
    }

    public JTextField getRedshift() {
        return this.redshift;
    }

    class VelocityReferenceItemListener
    implements ItemListener {
        private String previousValue = null;

        VelocityReferenceItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            String string = itemEvent.getItem().toString();
            if (string.equals(this.previousValue)) {
                return;
            }
            if (this.previousValue == null) {
                this.previousValue = string;
                return;
            }
            String string2 = this.previousValue;
            this.previousValue = string;
            if (VelocityEditor.this.isUpdatePending) {
                return;
            }
            final String string3 = "Changed velocity reference system type from \"" + string2 + "\" to \"" + string + "\",\nbut no velocity conversion was performed";
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GUIUtilities.infoWithDoNotShowAgain(VelocityEditor.this.dialogId, string3);
                }
            });
        }
    }
}

