/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.valuetypes;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.guiutil.mvc.verifiers.Verifier;
import alma.obsprep.ot.boEditors.ValueUnitPairVerifier;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.ot.models.valuetypes.AbstractValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.util.TextUtils;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Optional;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.Timer;

public class ValueUnitPairEditor
extends Editor
implements ActionListener {
    private static final long serialVersionUID = -5338042615932901078L;
    private static final int FIELDWIDTH = 8;
    private Optional<Color> oldBackgroundColor = Optional.empty();
    Map<String, String> uiToBOUnitMapping = null;
    protected JTextField input;
    protected FieldID unitFID;
    protected JComboBox units;
    protected FieldID valueFID;
    protected String[] unitList;
    private boolean isUnitDropdownMenuEditable = true;
    ActionListener taskPerformer = actionEvent -> {
        this.input.setForeground(Color.BLACK);
        this.input.setBackground(this.oldBackgroundColor.orElse(Color.WHITE));
        ValueUnitPairModel valueUnitPairModel = (ValueUnitPairModel)this.getModel();
        double d = valueUnitPairModel.getVUP().getContentInUnits((String)this.units.getSelectedItem());
        this.input.setText(valueUnitPairModel.getNumberFormat().format(d));
        DoubleVerifier doubleVerifier = (DoubleVerifier)this.getVerifier(this.getInput(), "FOCUSLOST_VERIFIER");
        String string = Double.toString(valueUnitPairModel.getVUP().getContentInDefaultUnits());
        try {
            DoubleVerifier.parseDouble((Object)string, doubleVerifier.getMin(), doubleVerifier.getMax());
        }
        catch (Exception exception) {
            this.input.setForeground(Colors.OT_RED);
        }
    };

    public ValueUnitPairEditor(AbstractValueUnitPairModel abstractValueUnitPairModel) {
        this(abstractValueUnitPairModel, null, null);
    }

    public ValueUnitPairEditor(AbstractValueUnitPairModel abstractValueUnitPairModel, ValueUnitPairVerifier valueUnitPairVerifier) {
        this(abstractValueUnitPairModel, valueUnitPairVerifier, null);
    }

    public ValueUnitPairEditor(AbstractValueUnitPairModel abstractValueUnitPairModel, String[] stringArray) {
        this(abstractValueUnitPairModel, null, stringArray);
    }

    private ValueUnitPairEditor(AbstractValueUnitPairModel abstractValueUnitPairModel, ValueUnitPairVerifier valueUnitPairVerifier, String[] stringArray) {
        this.valueFID = abstractValueUnitPairModel.getValueFID();
        this.unitFID = abstractValueUnitPairModel.getUnitFID();
        this.unitList = stringArray;
        this.build(valueUnitPairVerifier);
        this.setModel(abstractValueUnitPairModel);
    }

    protected ValueUnitPairEditor() {
    }

    public ValueUnitPairEditor(AbstractValueUnitPairModel abstractValueUnitPairModel, Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: uiToBOUnitMapping");
        }
        this.uiToBOUnitMapping = map;
        this.valueFID = abstractValueUnitPairModel.getValueFID();
        this.unitFID = abstractValueUnitPairModel.getUnitFID();
        this.unitList = null;
        this.build(null);
        this.setModel(abstractValueUnitPairModel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Verifier verifier = this.getVerifier(this.getInput(), "FOCUSLOST_VERIFIER");
        if (verifier == null) {
            verifier = this.getVerifier(this.getInput(), "KEYSTROKE_VERIFIER");
        }
        if (verifier != null) {
            verifier.verify();
        }
    }

    @Override
    protected void build() {
        this.build(null);
    }

    protected void build(ValueUnitPairVerifier valueUnitPairVerifier) {
        this.input = new JTextField(8);
        this.units = this.unitList == null ? new JComboBox() : new JComboBox<String>(this.unitList);
        if (this.uiToBOUnitMapping != null) {
            for (String string : this.uiToBOUnitMapping.keySet()) {
                this.createUILabelMapping(this.units, this.uiToBOUnitMapping.get(string), string);
            }
        }
        if (valueUnitPairVerifier != null) {
            this.initEvents(this.input, this.valueFID, "FOCUSLOST_VERIFIER", valueUnitPairVerifier);
        } else {
            this.initEvents(this.input, this.valueFID);
        }
        this.initEvents(this.units, this.unitFID);
        this.units.addActionListener(this);
        FlowLayout flowLayout = (FlowLayout)this.getLayout();
        flowLayout.setAlignment(0);
        this.add(this.input);
        this.add(this.units);
        this.units.setEnabled(this.isUnitDropdownMenuEditable);
    }

    public JTextField getInput() {
        return this.input;
    }

    public JComboBox getUnits() {
        return this.units;
    }

    public String getSelectedUnit() {
        String string = (String)this.units.getSelectedItem();
        return this.getUILabelToBOMapping(this.units, string);
    }

    public FieldID getValueFID() {
        return this.valueFID;
    }

    public FieldID getUnitFID() {
        return this.unitFID;
    }

    public void setVerifier(String string, Verifier verifier) {
        super.setVerifier(this.getInput(), string, verifier);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.setEnabled(this.input, bl);
        this.setEnabled(this.units, bl);
    }

    @Override
    public boolean isEnabled() {
        return this.input.isEnabled();
    }

    public void setEditable(boolean bl) {
        this.input.setEditable(bl);
        this.units.setEnabled(bl);
    }

    public boolean isEditable() {
        return this.input.isEditable();
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.input.setToolTipText(string);
        this.units.setToolTipText(string);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>();
        if (fieldID.equals(this.unitFID)) {
            JComboBox jComboBox = (JComboBox)this.retrieve(fieldID);
            if (this.unitList == null) {
                AbstractValueUnitPairModel abstractValueUnitPairModel = (AbstractValueUnitPairModel)this.getModel();
                Object[] objectArray = abstractValueUnitPairModel.unitMap().getUnitsSorted();
                this.suspendEvents(jComboBox);
                for (int i = 0; i < objectArray.length; ++i) {
                    defaultComboBoxModel.addElement(objectArray[i]);
                }
                jComboBox.setModel(defaultComboBoxModel);
                this.resumeEvents(jComboBox);
            }
            this.set(jComboBox, (String)object);
        } else {
            super.update(fieldID, object);
        }
    }

    @Override
    public Object widgetModified(FieldID fieldID, Object object) {
        if (fieldID.equals(this.unitFID)) {
            ValueUnitPair valueUnitPair = (ValueUnitPair)this.getModel().getDocument();
            String string = (String)object;
            valueUnitPair.convertToUnit(string);
            this.getModel().publish(this.valueFID, TextUtils.format(valueUnitPair.getContent(), 0, 10));
        }
        return object;
    }

    public void flashBackground() {
        if (!this.input.getBackground().equals(Colors.OT_RED)) {
            this.oldBackgroundColor = Optional.of(this.input.getBackground());
        }
        this.input.setForeground(Color.BLACK);
        this.input.setBackground(Colors.OT_RED);
        Timer timer = new Timer(1000, this.taskPerformer);
        timer.setRepeats(false);
        timer.start();
    }

    public boolean isUnitDropdownMenuEditable() {
        return this.isUnitDropdownMenuEditable;
    }

    public void setUnitDropdownMenuEditable(boolean bl) {
        this.isUnitDropdownMenuEditable = bl;
        this.units.setEnabled(bl);
    }
}

