/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spectralvisual;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.AbstractTargetParameters;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.PanelUtilities;
import alma.obsprep.ot.boEditors.PanelUtilitiesClient;
import alma.obsprep.ot.editors.spectralvisual.TimerLogger;
import alma.obsprep.ot.editors.spectralvisual.ZoomObservable;
import alma.obsprep.ot.editors.spectralvisual.ZoomObserver;
import alma.obsprep.ot.gui.dnd.DNDAdapter;
import alma.obsprep.ot.gui.dnd.DNDClient;
import alma.obsprep.ot.gui.resources.ColorPalette;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.services.etc.AtmosphereTable;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;

public abstract class ObservedAndTargetPanel
extends JPanel
implements PanelUtilitiesClient,
ZoomObservable,
DNDClient,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final double MIN_ZOOM_FREQ_WIDTH_GHZ = 0.001;
    private static final BasicStroke THIN_LINE = new BasicStroke(1.0f);
    private static final BasicStroke THICK_LINE = new BasicStroke(2.0f);
    private static final URL ZOOM_CURSOR = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/zoom_cursor_16x16.png");
    private static final URL MOVE_CURSOR = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/pan_cursor_16x16.png");
    private static final URL HAND_CURSOR = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/hand.png");
    private static final URL NEW_FONT = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/vera.ttf");
    Cursor cursor = new Cursor(12);
    Cursor handCursor = new Cursor(12);
    Cursor moveCursor = new Cursor(13);
    Cursor zoomCursor = new Cursor(1);
    private final List<SpectralLine> linesToDisplay = new ArrayList<SpectralLine>();
    private Font hatchFont;
    private int waterVapourIndex = 0;
    protected int pressedX;
    protected boolean isDraggingLocally = false;
    protected double pressedMinOF;
    protected double pressedMaxOF;
    protected boolean isDrawDSBImageWindow;
    private boolean isShowFullSpectralScan = true;
    private boolean isDragging = false;
    protected static final Color COLOUR_BANDLABEL = Color.BLACK;
    protected static final Color COLOUR_BANDLINES = Color.lightGray;
    protected static final Color COLOUR_AXES = Color.black;
    private static final String observedLabel = "Observed Frequency (GHz)";
    private static final String restLabel = "Rest Frequency (GHz)";
    protected ColorPalette palette;
    protected PanelUtilities graphicsHelper;
    protected String[] names = ReceiverBand.getKnownReceiverBandNames();
    protected static final int initHeight = 250;
    protected static final int initWidth = 750;
    protected Model model;
    protected double absoluteMaxOF = -1.0;
    protected double absoluteMinOF;
    protected double maxOF;
    protected double maxTF;
    protected double minOF;
    protected double minTF;
    protected double tickSpacing;
    protected int textHeight;
    protected int ticksPerMajor;
    protected AtmosphereTable.DataTable xmission = null;
    private int[] xmission_x = null;
    private int[] xmission_y = null;
    private boolean drawOtherLines;
    private boolean isDrawTransmission;
    private final boolean[] displaySpectralScanTuning = new boolean[SpectralScan.MAXTUNINGS.intValue()];
    private final Velocity zeroVelocity;
    private Font axesFont;
    private Font spectralLineFont;
    protected TimerLogger logger = null;
    private final Collection<ZoomObserver> zoomObservers = new HashSet<ZoomObserver>();

    protected ObservedAndTargetPanel(double d, double d2) {
        super(true);
        this.setPreferredSize(new Dimension((int)(750.0 * d), (int)(250.0 * d2)));
        this.createZoomCursor();
        this.createMoveCursor();
        this.createHandCursor();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        Speed speed = Speed.createSpeed();
        speed.setContent(0.0);
        speed.setUnit(Speed.UNIT_KM_S);
        this.zeroVelocity = Velocity.createVelocity();
        this.zeroVelocity.setCenterVelocity(speed);
        this.logger = new TimerLogger(this, false);
        for (int i = 0; i < SpectralScan.MAXTUNINGS; ++i) {
            this.displaySpectralScanTuning[i] = Boolean.TRUE;
        }
        try {
            Font font = Font.createFont(0, NEW_FONT.openStream());
            this.hatchFont = font.deriveFont(1, 12.0f);
            this.axesFont = font.deriveFont(0, 12.0f);
            this.spectralLineFont = font.deriveFont(1, 12.0f);
        }
        catch (FontFormatException | IOException exception) {
            Log.logger(ObservedAndTargetPanel.class).warning("Unable to load create fonts " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    protected ObservedAndTargetPanel() {
        this(1.0, 1.0);
    }

    public void createZoomCursor() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(ZOOM_CURSOR);
        this.zoomCursor = toolkit.createCustomCursor(image, new Point(0, 0), "ZOOM_CURSOR");
    }

    public void createMoveCursor() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(MOVE_CURSOR);
        this.moveCursor = toolkit.createCustomCursor(image, new Point(0, 0), "MOVE_CURSOR");
    }

    public void createHandCursor() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(HAND_CURSOR);
        this.handCursor = toolkit.createCustomCursor(image, new Point(0, 0), "HAND_CURSOR");
    }

    @Override
    public double getAbsoluteMax() {
        return this.absoluteMaxOF;
    }

    @Override
    public double getAbsoluteMin() {
        return this.absoluteMinOF;
    }

    public void setDrawOtherLines(boolean bl) {
        this.drawOtherLines = bl;
    }

    public boolean getDrawOtherLines() {
        return this.drawOtherLines;
    }

    public void setFrequencyRange(double d, double d2) {
        this.setFrequencyRangeNoRound(d, d2);
        this.minOF /= this.tickSpacing;
        this.maxOF /= this.tickSpacing;
        this.setMinObservedFreq((Math.ceil(this.minOF) - 1.0) * this.tickSpacing);
        this.setMaxObservedFreq((Math.floor(this.maxOF) + 1.0) * this.tickSpacing);
        this.setRestFrequencyRange();
        this.notifyObservers();
    }

    public void setFrequencyRangeNoRound(double d, double d2) {
        if (Math.abs(d2 - d) < 0.001) {
            return;
        }
        if (d < this.absoluteMinOF) {
            this.setMaxObservedFreq(d2 + (this.absoluteMinOF - d));
            this.setMinObservedFreq(this.absoluteMinOF);
        } else if (d2 > this.absoluteMaxOF) {
            this.setMinObservedFreq(d - (d2 - this.absoluteMaxOF));
            this.setMaxObservedFreq(this.absoluteMaxOF);
        } else if (d >= d2) {
            this.setMinObservedFreq(this.absoluteMinOF);
            this.setMaxObservedFreq(this.absoluteMaxOF);
        } else {
            this.setMinObservedFreq(d);
            this.setMaxObservedFreq(d2);
        }
        this.graphicsHelper.calculateTickSpacing(this.minOF, this.maxOF);
        this.setRestFrequencyRange();
        this.notifyObservers();
    }

    public List<SpectralLine> getLinesToDisplay() {
        ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
        arrayList.addAll(this.linesToDisplay);
        return arrayList;
    }

    public void setLinesToDisplay(List<SpectralLine> list) {
        this.linesToDisplay.clear();
        this.linesToDisplay.addAll(list);
    }

    @Override
    public void setMaxObservedFreq(double d) {
        this.maxOF = d;
        this.xmission = null;
    }

    @Override
    public double getMaxObservedFreq() {
        return this.maxOF;
    }

    @Override
    public void setMinObservedFreq(double d) {
        this.minOF = d;
        this.xmission = null;
    }

    @Override
    public double getMinObservedFreq() {
        return this.minOF;
    }

    public void setModel(Model model) {
        this.model = model;
        this.resetFrequencyRange();
        this.repaint();
    }

    public Model getModel() {
        return this.model;
    }

    public void setPalette(ColorPalette colorPalette) {
        this.palette = colorPalette;
    }

    @Override
    public void setTickSpacing(double d) {
        this.tickSpacing = d;
    }

    @Override
    public void setTicksPerMajor(int n) {
        this.ticksPerMajor = n;
    }

    public void paintAtmosphericTransmission(Graphics graphics, double d, double d2) {
        int n;
        int n2;
        if (this.xmission == null) {
            this.xmission = AtmosphereTable.getInstance().lookup(d, d2, this.waterVapourIndex);
            this.xmission_x = new int[this.xmission.size()];
            this.xmission_y = new int[this.xmission.size()];
            this.textHeight = this.graphicsHelper.calculateTextHeight(graphics);
            n2 = this.yClearObserved();
            for (n = 0; n < this.xmission.size(); ++n) {
                this.xmission_x[n] = this.scaleOF(this.xmission.getF(n));
                this.xmission_y[n] = this.scaleTau(this.xmission.getTau(n)) + n2;
            }
        }
        graphics.setColor(this.palette.getTransmissionColor());
        if (this.xmission.size() >= 2) {
            n2 = this.xmission_x[0];
            n = this.xmission_y[0];
            for (int i = 1; i < this.xmission.size(); ++i) {
                int n3 = this.xmission_x[i];
                int n4 = this.xmission_y[i];
                graphics.drawLine(n2, n, n3, n4);
                n2 = n3;
                n = n4;
            }
        }
    }

    public void paintSkyAxis(Graphics graphics) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        graphics.setColor(COLOUR_AXES);
        graphics.setFont(this.axesFont);
        this.graphicsHelper.labelCentre(graphics, 0, this.getWidth(), this.yObservedBanner(), observedLabel);
        graphics.drawLine(this.scaleOF(this.minOF), this.yObservedAxis(), this.scaleOF(this.maxOF), this.yObservedAxis());
        long l = Math.round(Math.floor(this.minOF / this.tickSpacing));
        long l2 = l % (long)this.ticksPerMajor;
        for (double d = (double)l * this.tickSpacing; d <= this.maxOF; d += this.tickSpacing) {
            int n = this.scaleOF(d);
            if (l2++ % (long)this.ticksPerMajor == 0L) {
                graphics.drawLine(n, this.yObservedAxis(), n, this.yObservedAxis() - this.yBigTickHeight());
                this.graphicsHelper.labelTick(graphics, d, n, this.yObservedAxisLabels());
                continue;
            }
            graphics.drawLine(n, this.yObservedAxis(), n, this.yObservedAxis() - this.yMinorTickHeight());
        }
    }

    public void paintRestAxis(Graphics graphics) {
        int n;
        double d;
        double d2;
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        graphics.setFont(this.axesFont);
        graphics.setColor(COLOUR_AXES);
        this.setRestFrequencyRange();
        double d3 = this.maxTF - this.minTF;
        for (d2 = 1000000.0; d3 <= d2; d2 /= 10.0) {
            if (d3 != 0.0 || d2 != 0.0) continue;
            return;
        }
        if ((d3 /= d2) <= 2.0) {
            d = d2 / 20.0;
            n = 4;
        } else if (d3 <= 5.0) {
            d = d2 / 10.0;
            n = 5;
        } else {
            d = d2 / 2.0;
            n = 2;
        }
        this.graphicsHelper.labelCentre(graphics, 0, this.getWidth(), this.yTargetBanner() - 2, restLabel);
        graphics.drawLine(this.scaleRestFrequency(this.minTF), this.yTargetAxis(), this.scaleRestFrequency(this.maxTF), this.yTargetAxis());
        long l = Math.round(Math.floor(this.minTF / d));
        long l2 = l % (long)n;
        for (double d4 = (double)l * d; d4 <= this.maxTF; d4 += d) {
            int n2 = this.scaleRestFrequency(d4);
            if (l2++ % (long)n == 0L) {
                graphics.drawLine(n2, this.yTargetAxis(), n2, this.yTargetAxis() + this.yBigTickHeight());
                this.graphicsHelper.labelTick(graphics, d4, n2, this.yTargetAxisLabels() + 2);
                continue;
            }
            graphics.drawLine(n2, this.yTargetAxis(), n2, this.yTargetAxis() + this.yMinorTickHeight());
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Image image = this.createImage(this.getWidth(), this.getHeight());
        Graphics graphics2 = image.getGraphics();
        graphics2.setClip(graphics.getClip());
        super.paintComponent(graphics2);
        if (this.isDrawTransmission()) {
            this.paintAtmosphericTransmission(graphics2, this.absoluteMinOF, this.absoluteMaxOF);
        }
        if (!this.isDragging()) {
            this.paintZoomBox(graphics2);
        }
        this.corePaintComponent(graphics2);
        graphics.drawImage(image, 0, 0, this);
    }

    public abstract void corePaintComponent(Graphics var1);

    private void paintZoomBox(Graphics graphics) {
        Point point = this.getMousePosition();
        if (point != null) {
            double[] dArray = this.computeRange(this.unscaleObservedFrequency((int)point.getX()), 0.3333333333333333);
            graphics.setColor(this.palette.getZoomBoxColor());
            int n = this.scaleOF(dArray[0]);
            int n2 = this.scaleOF(dArray[1]);
            graphics.fillRect(n, this.yObservedAxis() - this.yBigTickHeight(), n2 - n, this.yBigTickHeight());
            graphics.fillRect(n, this.yTargetAxis(), n2 - n, this.yBigTickHeight());
        }
    }

    public boolean mouseOnAxes(MouseEvent mouseEvent) {
        int n = mouseEvent.getY();
        return n < this.yObservedAxis() || n > this.yTargetAxis();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.pressedX = mouseWheelEvent.getX();
        int n = mouseWheelEvent.getWheelRotation();
        if (n < 0) {
            this.zoomInAtCursor(3.0);
        } else {
            this.zoomOutAtCursor(3.0);
        }
        this.repaint();
    }

    public void panLeft(double d) {
        double d2 = (this.maxOF - this.minOF) * d;
        if (this.minOF - d2 < this.absoluteMinOF) {
            d2 = this.minOF - this.absoluteMinOF;
        }
        this.setFrequencyRangeNoRound(this.minOF - d2, this.maxOF - d2);
    }

    public void panRight(double d) {
        double d2 = (this.maxOF - this.minOF) * d;
        if (this.maxOF + d2 > this.absoluteMaxOF) {
            d2 = this.absoluteMaxOF - this.maxOF;
        }
        this.setFrequencyRangeNoRound(this.minOF + d2, this.maxOF + d2);
    }

    public void panTo(double d) {
        double d2 = (this.maxOF + this.minOF) / 2.0;
        double d3 = d - d2;
        if (this.minOF + d3 < this.absoluteMinOF) {
            d3 = this.absoluteMinOF - this.minOF;
        } else if (this.maxOF + d3 > this.absoluteMaxOF) {
            d3 = this.absoluteMaxOF - this.maxOF;
        }
        this.setFrequencyRangeNoRound(this.minOF + d3, this.maxOF + d3);
    }

    public void resetFrequencyRange() {
        this.setMinObservedFreq(this.absoluteMinOF);
        this.setMaxObservedFreq(this.absoluteMaxOF);
        this.setFrequencyRangeNoRound(this.minOF, this.maxOF);
    }

    public void zoomIn(double d) {
        double d2 = (this.minOF + this.maxOF) / 2.0;
        double d3 = d2 - this.minOF;
        this.setFrequencyRangeNoRound(d2 - d3 / d, d2 + d3 / d);
    }

    public void zoomOut(double d) {
        double d2 = (this.minOF + this.maxOF) / 2.0;
        double d3 = d2 - this.minOF;
        double d4 = d2 - d3 * d;
        double d5 = d2 + d3 * d;
        if (d4 < this.absoluteMinOF && d5 > this.absoluteMaxOF) {
            d4 = this.absoluteMinOF;
            d5 = this.absoluteMaxOF;
            this.tickSpacing = 50.0;
        } else if (d4 < this.absoluteMinOF) {
            d4 = this.absoluteMinOF;
            d5 = Math.min(d4 + d3 * d, this.absoluteMaxOF);
            this.tickSpacing *= d;
        } else if (d5 > this.absoluteMaxOF) {
            d5 = this.absoluteMaxOF;
            d4 = Math.max(d5 - d3 * d, this.absoluteMinOF);
            this.tickSpacing *= d;
        } else {
            this.tickSpacing *= d;
        }
        this.setFrequencyRangeNoRound(d4, d5);
    }

    protected void setInitialFrequencyRange() {
        this.minOF = 1.0E9;
        this.maxOF = -1.0;
        for (int i = 0; i < this.names.length; ++i) {
            ReceiverBand receiverBand = ReceiverBand.getReceiverBand(this.names[i]);
            this.minOF = Math.min(this.minOF, receiverBand.getRFMin());
            this.maxOF = Math.max(this.maxOF, receiverBand.getRFMax());
        }
        this.absoluteMinOF = this.minOF;
        this.absoluteMaxOF = this.maxOF;
        this.setFrequencyRange(this.minOF, this.maxOF);
        this.absoluteMinOF = this.minOF;
        this.absoluteMaxOF = this.maxOF;
    }

    protected void setRestFrequencyRange() {
        if (this.model != null) {
            this.minTF = this.convertRestFrameFreqToSkyFrame(this.minOF);
            this.maxTF = this.convertRestFrameFreqToSkyFrame(this.maxOF);
        }
    }

    protected void labelSpectralLine(Graphics graphics, int n, int n2, String string) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics);
        Rectangle rectangle = graphics.getClipBounds();
        int n3 = (int)float_.width;
        graphics.setFont(this.spectralLineFont);
        if (n + n3 <= rectangle.x + rectangle.width) {
            graphics.drawString(string, n, n2);
        } else if (rectangle.x <= n - n3) {
            graphics.drawString(string, n - n3, n2);
        } else {
            graphics.drawString(string, (n + n - n3) / 2, n2);
        }
    }

    protected void paintKnownSpectralLinesLines(Graphics graphics, double d, double d2) {
        int n = this.yHalfHeight() / this.textHeight;
        int n2 = 1;
        for (SpectralLine spectralLine : this.linesToDisplay) {
            this.paintTargetSpectralLine(graphics, spectralLine.getFrequencyInGHz(), spectralLine.getTitle(), this.palette.getCatalogLinesColor(), n2++);
            if (n2 <= n) continue;
            n2 = 1;
        }
    }

    protected void paintTargetSpectralLine(Graphics graphics, double d, String string, Color color, int n, boolean bl) {
        int n2 = this.scaleRestFrequency(d);
        graphics.setColor(color);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(THICK_LINE);
        if (bl) {
            graphics2D.drawLine(n2, this.yTargetAxis(), n2, this.yTargetAxis() - this.yClearHeight());
        } else {
            graphics2D.drawLine(n2, this.yTargetAxis(), n2, this.yTargetAxis() - this.yHalfHeight());
        }
        graphics2D.setStroke(THIN_LINE);
        if (string != null && !string.equals("")) {
            this.labelSpectralLine(graphics, n2 + 3, this.targetLabelHeight(n) - 2, string);
        }
    }

    protected void paintSpectralScanLine(Graphics graphics, double d, Color color, int n) {
        int n2 = this.scaleRestFrequency(d);
        graphics.setColor(color);
        graphics.drawLine(n2, this.yTargetAxis(), n2, this.yTargetAxis() - 60);
    }

    protected void paintTargetSpectralLine(Graphics graphics, double d, String string, Color color, int n) {
        this.paintTargetSpectralLine(graphics, d, string, color, n, false);
    }

    protected void paintRestSpectralWindow(Graphics graphics, double d, double d2, double d3, Color color, int n) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        graphics.setFont(this.axesFont);
        double d4 = this.textHeight;
        int n2 = this.clipXToVisible(this.scaleRestFrequency(d));
        int n3 = this.clipXToVisible(this.scaleRestFrequency(d + d2));
        int n4 = n3 - n2;
        int n5 = this.targetLabelHeight(n);
        int n6 = (int)(d4 * d3);
        if (n6 == 0) {
            n6 = 1;
        }
        graphics.setColor(color);
        graphics.drawRect(n2, n5, n4, n6);
        this.graphicsHelper.hatch(graphics, n2, n5, n4, n6, color, true);
    }

    protected void paintObservedSpectralWindow(Graphics graphics, double d, double d2, double d3, Color color, int n) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        graphics.setFont(this.axesFont);
        double d4 = this.textHeight;
        int n2 = this.clipXToVisible(this.scaleOF(d));
        int n3 = this.clipXToVisible(this.scaleOF(d + d2));
        int n4 = n3 - n2;
        n3 = this.targetLabelHeight(n);
        int n5 = (int)(d4 * d3);
        graphics.setColor(color);
        if (n5 == 0) {
            n5 = 1;
        }
        graphics.drawRect(n2, n3, n4, n5);
        this.graphicsHelper.hatch(graphics, n2, n3, n4, n5, color, true);
    }

    protected String transitionName(ScienceSpectralWindow scienceSpectralWindow) {
        if (scienceSpectralWindow.getSpectralSetupParameters().isSingleContinuum()) {
            return "Continuum";
        }
        return scienceSpectralWindow.getTransitionName();
    }

    protected void paint(Graphics graphics, AbstractScienceSpectralWindow abstractScienceSpectralWindow, AbstractTargetParameters abstractTargetParameters, Color color, int n) {
        if (abstractScienceSpectralWindow instanceof ScienceSpectralWindow) {
            this.paintSpectralWindow(graphics, (ScienceSpectralWindow)((Object)abstractScienceSpectralWindow), abstractTargetParameters, color, n);
        } else if (abstractScienceSpectralWindow instanceof SpectralScan) {
            this.paintSpectralScan(graphics, (SpectralScan)((Object)abstractScienceSpectralWindow));
        }
    }

    protected void paintSpectralWindow(Graphics graphics, ScienceSpectralWindow scienceSpectralWindow, AbstractTargetParameters abstractTargetParameters, Color color, int n) {
        Frequency frequency = scienceSpectralWindow.getCenterFrequency();
        double d = frequency.getContentInGHz();
        double d2 = 0.0;
        d2 = scienceSpectralWindow.getIsSkyFrequency() ? d : this.getSourceVelocity().dopplerShift(frequency).getContentInGHz();
        double d3 = scienceSpectralWindow.getCorrConfigMode().getEffectiveBandwidth().getContentInGHz();
        double d4 = scienceSpectralWindow.getSpectralResolution().getContentInGHz();
        String string = this.transitionName(scienceSpectralWindow);
        this.paintTargetSpectralLine(graphics, d, string, color, n + 1);
        this.paintObservedSpectralWindow(graphics, d2 - d3 / 2.0, d3, d4, color, n + 1);
    }

    protected void paintSpectralScan(Graphics graphics, SpectralScan spectralScan) {
        double d;
        double d2;
        SpectralScan.SpectralScanTunings spectralScanTunings;
        Color[] colorArray = new Color[]{Colors.OT_BLUE, new Color(144, 38, 158), Color.GRAY, new Color(33, 158, 57), Color.BLACK};
        Velocity velocity = this.getSourceVelocity();
        if (this.isShowFullSpectralScan) {
            Color color = new Color(47, 66, 145);
            double d3 = velocity.reverseShift(spectralScan.getStartFrequency()).getContentInGHz();
            double d4 = velocity.reverseShift(spectralScan.getEndFrequency()).getContentInGHz();
            this.paintSpectralScanLine(graphics, d3, color, 2);
            this.paintSpectralScanLine(graphics, d4, color, 2);
            this.paintRestSpectralWindow(graphics, d3, d4 - d3, 0.5, color, 2);
        }
        try {
            spectralScanTunings = spectralScan.getTunings();
        }
        catch (UnableToFindSolutionException unableToFindSolutionException) {
            return;
        }
        if (spectralScanTunings == null) {
            return;
        }
        double d5 = spectralScan.getEffectiveBandwidth().getContentInGHz();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            for (ArrayList<Frequency> arrayList : spectralScanTunings.getTunings()) {
                if (this.displaySpectralScanTuning[n2]) {
                    for (Frequency frequency : arrayList) {
                        d2 = velocity.reverseShift(Frequency.createFrequencyGHZ(frequency.getContentInGHz() - d5 / 2.0)).getContentInGHz();
                        d = velocity.reverseShift(Frequency.createFrequencyGHZ(frequency.getContentInGHz() + d5 / 2.0)).getContentInGHz();
                        this.paintRestSpectralWindow(graphics, d2, d - d2, 0.5, colorArray[n], 3 + n3);
                    }
                }
                ++n3;
                n3 %= 5;
                ++n2;
                ++n;
                n %= colorArray.length;
            }
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
            return;
        }
        if (this.isDrawDSBImageWindow) {
            n2 = 0;
            n3 = 0;
            n = 0;
            try {
                for (ArrayList<Frequency> arrayList : spectralScanTunings.getImageTunings()) {
                    if (this.displaySpectralScanTuning[n2]) {
                        for (Frequency frequency : arrayList) {
                            d2 = velocity.reverseShift(Frequency.createFrequencyGHZ(frequency.getContentInGHz() - d5 / 2.0)).getContentInGHz();
                            d = velocity.reverseShift(Frequency.createFrequencyGHZ(frequency.getContentInGHz() + d5 / 2.0)).getContentInGHz();
                            this.paintRestSpectralWindow(graphics, d2, d - d2, 0.5, colorArray[n], 3 + n3);
                        }
                    }
                    ++n3;
                    n3 %= 5;
                    ++n2;
                    ++n;
                    n %= colorArray.length;
                }
            }
            catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
                // empty catch block
            }
        }
    }

    protected int scaleOF(double d) {
        double d2 = (d - this.minOF) / (this.maxOF - this.minOF);
        return (int)(d2 * (double)this.getWidth());
    }

    protected int scaleRestFrequency(double d) {
        double d2 = (d - this.minTF) / (this.maxTF - this.minTF);
        return (int)(d2 * (double)this.getWidth());
    }

    protected double unscaleObservedFrequency(int n) {
        double d = 1.0 * (double)n / (double)this.getWidth();
        return d * (this.maxOF - this.minOF) + this.minOF;
    }

    protected double unscaleRestFrequency(int n) {
        double d = 1.0 * (double)n / (double)this.getWidth();
        return d * (this.maxTF - this.minTF) + this.minTF;
    }

    protected abstract int yClearObserved();

    protected abstract int yClearTarget();

    protected abstract int observedLabelHeight(int var1);

    private int scaleTau(double d) {
        double d2 = Math.exp(-d);
        d2 = 1.0 - d2;
        return (int)(d2 * (double)this.yClearHeight());
    }

    protected int yBigTickHeight() {
        return this.textHeight;
    }

    protected int yClearHeight() {
        return this.yClearTarget() - this.yClearObserved();
    }

    protected int yHalfHeight() {
        return this.yHalfHeight(true);
    }

    protected int yObservedAxis() {
        return this.textHeight * 2 + this.yMinorTickHeight();
    }

    protected int yObservedAxisLabels() {
        return this.yObservedAxis() - this.yMinorTickHeight();
    }

    protected int yObservedBanner() {
        return this.textHeight;
    }

    protected int yTargetAxis() {
        return this.getHeight() - this.textHeight * 2;
    }

    protected int yTargetAxisLabels() {
        return this.getHeight() - this.textHeight;
    }

    protected int yTargetBanner() {
        return this.getHeight();
    }

    protected int yMinorTickHeight() {
        return (this.textHeight + 1) / 2 - 3;
    }

    protected int yRxBandHeight() {
        return 3 * this.textHeight / 2;
    }

    protected int yLOBandHeight() {
        return 2 * this.textHeight - this.yRxBandHeight();
    }

    protected abstract SpectralSpecDocument getContext();

    protected abstract Velocity getSourceVelocity();

    private double convertRestFrameFreqToSkyFrame(double d) {
        double d2 = d;
        if (d > 0.0) {
            Velocity velocity = this.getSourceVelocity();
            Frequency frequency = velocity.reverseShift(Frequency.createFrequencyGHZ(d));
            d2 = frequency.getContentInGHz();
        }
        return d2;
    }

    private int targetLabelBase() {
        return this.yTargetAxis();
    }

    private int targetLabelHeight(int n) {
        return this.targetLabelBase() - n * this.textHeight;
    }

    private int yHalfHeight(boolean bl) {
        int n = (this.yTargetAxis() - this.yObservedAxis()) / 2;
        if (bl) {
            n += this.textHeight;
        }
        return n;
    }

    public double[] clipOFRange(double d, double d2) {
        if (d < this.absoluteMinOF) {
            if ((d2 += this.absoluteMinOF - d) > this.absoluteMaxOF) {
                d2 = this.absoluteMaxOF;
            }
            d = this.absoluteMinOF;
        } else if (d2 > this.absoluteMaxOF) {
            if ((d -= d2 - this.absoluteMaxOF) < this.absoluteMinOF) {
                d = this.absoluteMinOF;
            }
            d2 = this.absoluteMaxOF;
        }
        return new double[]{d, d2};
    }

    public double[] computeRange(double d, double d2) {
        double d3 = this.maxOF - this.minOF;
        double d4 = this.absoluteMaxOF - this.absoluteMinOF;
        double d5 = Math.min(d3 * d2, d4);
        if (d5 <= 0.0) {
            return new double[]{this.minOF, this.maxOF};
        }
        double d6 = d - (d - this.minOF) * d2;
        double d7 = d + (this.maxOF - d) * d2;
        return this.clipOFRange(d6, d7);
    }

    public void setFrequencyRangeAndRepaint(double[] dArray) {
        this.setMinObservedFreq(dArray[0]);
        this.setMaxObservedFreq(dArray[1]);
        this.graphicsHelper.calculateTickSpacing(this.minOF, this.maxOF);
        this.setRestFrequencyRange();
        this.notifyObservers();
        this.repaint();
    }

    @Override
    public boolean isZoomed() {
        return this.getMinObservedFreq() != this.absoluteMinOF || this.getMaxObservedFreq() != this.absoluteMaxOF;
    }

    @Override
    public void addObserver(ZoomObserver zoomObserver) {
        this.zoomObservers.add(zoomObserver);
    }

    @Override
    public void deleteObserver(ZoomObserver zoomObserver) {
        this.zoomObservers.remove(zoomObserver);
    }

    @Override
    public void notifyObservers() {
        boolean bl = this.isZoomed();
        for (ZoomObserver zoomObserver : this.zoomObservers) {
            zoomObserver.update(this, bl);
        }
    }

    public void resetTransmissionData() {
        this.xmission = null;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.pressedX = mouseEvent.getX();
        this.isDraggingLocally = this.mouseOnAxes(mouseEvent);
        this.pressedMinOF = this.minOF;
        this.pressedMaxOF = this.maxOF;
        if (this.isDraggingLocally) {
            this.setCursor(this.moveCursor);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isDraggingLocally) {
            if (mouseEvent.getButton() == 1) {
                this.zoomInAtCursor(3.0);
            } else if (mouseEvent.getButton() == 3) {
                this.zoomOutAtCursor(3.0);
            }
            this.repaint();
        }
        if (this.pressedX != mouseEvent.getX()) {
            return;
        }
        this.isDraggingLocally = false;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isDraggingLocally) {
            return;
        }
        if (this.pressedX == mouseEvent.getX()) {
            return;
        }
        double d = this.unscaleObservedFrequency(this.scaleOF(this.pressedMinOF) - (mouseEvent.getX() - this.pressedX));
        double d2 = this.unscaleObservedFrequency(this.scaleOF(this.pressedMaxOF) - (mouseEvent.getX() - this.pressedX));
        double[] dArray = this.clipOFRange(d, d2);
        this.setFrequencyRangeAndRepaint(dArray);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.mouseOnAxes(mouseEvent)) {
            this.setCursor(this.handCursor);
        } else {
            this.setCursor(this.zoomCursor);
        }
        this.repaint();
    }

    protected int clipXToVisible(int n) {
        if (n < -1) {
            n = -1;
        } else if (n > this.getWidth()) {
            n = this.getWidth();
        }
        return n;
    }

    protected void paintBand(Graphics graphics, ReceiverBand receiverBand, Color color, boolean bl) {
        int n = this.scaleOF(receiverBand.getRFMin());
        int n2 = this.scaleOF(receiverBand.getRFMax());
        if (n2 <= 0 || n >= this.getWidth()) {
            return;
        }
        int n3 = this.scaleOF(receiverBand.getLOMin());
        int n4 = this.scaleOF(receiverBand.getLOMax());
        int n5 = (n + n2) / 2;
        n = this.clipXToVisible(n);
        n3 = this.clipXToVisible(n3);
        n4 = this.clipXToVisible(n4);
        n2 = this.clipXToVisible(n2);
        graphics.setColor(color);
        graphics.drawRect(n, this.yObservedAxis(), n2 - n, this.yRxBandHeight());
        graphics.drawRect(n3, this.yObservedAxis() + this.yRxBandHeight(), n4 - n3, this.yLOBandHeight());
        String string = receiverBand.getName();
        int n6 = string.lastIndexOf(95);
        if (n6 >= 0) {
            string = string.substring(n6 + 1);
        }
        this.hatch(graphics, n, this.yObservedAxis(), n2 - n, this.yRxBandHeight(), string, n5, color, bl);
        this.hatch(graphics, n3, this.yObservedAxis() + this.yRxBandHeight(), n4 - n3, this.yLOBandHeight(), null, -1, color, bl);
    }

    protected void paintBand(Graphics graphics, ReceiverBand receiverBand, Color color) {
        this.paintBand(graphics, receiverBand, color, true);
        this.paintBand(graphics, receiverBand, color, false);
    }

    private void hatch(Graphics graphics, int n, int n2, int n3, int n4, String string, int n5, Color color, boolean bl) {
        this.graphicsHelper.hatch(graphics, n, n2, n3, n4, color, bl);
        if (string != null) {
            Font font = graphics.getFont();
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            graphics.setFont(this.hatchFont);
            graphics.setColor(COLOUR_BANDLABEL);
            Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics);
            n = (int)((float)n5 - float_.width / 2.0f);
            n2 = (int)((float)n2 + float_.height);
            graphics.drawString(string, n, n2);
            graphics.setFont(font);
        }
    }

    protected void paintSideBand(Graphics graphics, Range range, Color color, boolean bl) {
        graphics.setColor(color);
        int n = this.scaleOF(range.min());
        int n2 = this.scaleOF(range.max());
        graphics.setColor(color);
        if (bl) {
            this.graphicsHelper.hatch(graphics, n, this.yObservedAxis(), n2 - n, this.yTargetAxis() - this.yObservedAxis(), color, true);
        }
        graphics.fillRect(n, this.yObservedAxis(), n2 - n, this.yTargetAxis() - this.yObservedAxis());
    }

    protected void paintObservedSpectralLine(Graphics graphics, double d, String string, Color color, int n, boolean bl) {
        int n2 = this.scaleOF(d);
        graphics.setColor(color);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(THICK_LINE);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        if (bl) {
            graphics.drawLine(n2, this.yObservedAxis(), n2, this.yClearHeight());
        } else {
            graphics.drawLine(n2, this.yObservedAxis(), n2, this.yObservedAxis() + this.yHalfHeight());
        }
        if (string != null && !string.equals("")) {
            this.labelSpectralLine(graphics, n2 + 2, this.observedLabelHeight(n) - 2, string);
        }
        graphics2D.setStroke(THIN_LINE);
    }

    public void zoomInAtCursor(double d) {
        double[] dArray = this.computeRange(this.unscaleObservedFrequency(this.pressedX), 1.0 / d);
        if (Math.abs(dArray[1] - dArray[0]) < 0.001) {
            return;
        }
        this.setFrequencyRangeAndRepaint(dArray);
    }

    public void zoomOutAtCursor(double d) {
        double[] dArray = this.computeRange(this.unscaleObservedFrequency(this.pressedX), d);
        if (Math.abs(dArray[1] - dArray[0]) < 0.001) {
            return;
        }
        this.setFrequencyRangeAndRepaint(dArray);
    }

    public void setSpectralScanTuningVisibility(int n, Boolean bl) {
        this.displaySpectralScanTuning[n] = bl;
    }

    public int getWaterVapourIndex() {
        return this.waterVapourIndex;
    }

    public void setWaterVapourIndex(int n) {
        this.waterVapourIndex = n;
    }

    public boolean isDrawDSBImageWindow() {
        return this.isDrawDSBImageWindow;
    }

    public void setDrawDSBImageWindow(boolean bl) {
        this.isDrawDSBImageWindow = bl;
    }

    public boolean isShowFullSpectralScan() {
        return this.isShowFullSpectralScan;
    }

    public void setShowFullSpectralScan(boolean bl) {
        this.isShowFullSpectralScan = bl;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setDragging(boolean bl) {
        this.isDragging = bl;
    }

    public void setDrawTransmission(boolean bl) {
        this.isDrawTransmission = bl;
    }

    public boolean isDrawTransmission() {
        return this.isDrawTransmission;
    }

    protected class LocalDNDAdapter
    extends DNDAdapter {
        private boolean wasNotifying;

        public LocalDNDAdapter(DNDClient dNDClient) {
            super(dNDClient);
        }

        @Override
        protected void domainSpecificPickup() {
            this.wasNotifying = BusinessObject.enablePropertyChangeEvents((boolean)false);
        }

        @Override
        protected void domainSpecificDrop() {
            BusinessObject.enablePropertyChangeEvents((boolean)this.wasNotifying);
        }
    }
}

