/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.mapper;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.editors.spatialvisual.BaseSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.CenterMapper;
import alma.obsprep.ot.editors.spatialvisual.mapper.Mapper;
import alma.obsprep.ot.editors.spatialvisual.mapper.MapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.PatternFigure;
import alma.valuetypes.SkyCoordinates;
import java.awt.geom.Point2D;
import jsky.coords.CoordinateConverter;
import jsky.image.gui.MainImageDisplay;
import org.junit.Assert;

public class CenterMapperModel
extends MapperModel {
    public CenterMapperModel(BaseSpatialVisualModel baseSpatialVisualModel) {
        super(baseSpatialVisualModel);
        this.setSingleMode(true);
    }

    public CenterMapper getCenterMapper() {
        return (CenterMapper)this.mapper;
    }

    @Override
    public void publish() {
        for (SkyCoordinates skyCoordinates : this.getSpatialVisualModel().getVisualModelHelper().getTargetCenters()) {
            this.getCenterMapper().update(skyCoordinates);
        }
    }

    @Override
    public void updateBO(PatternFigure patternFigure) {
        double d = patternFigure.getBounds().getCenterX();
        double d2 = patternFigure.getBounds().getCenterY();
        this.setSourceCoordinates(new Point2D.Double(d, d2), 1);
    }

    public SkyCoordinates setSourceCoordinates(Point2D.Double double_, int n) {
        MainImageDisplay.CoordSystemType coordSystemType;
        CoordinateConverter coordinateConverter = this.getCenterMapper().getCoordinateConverter();
        switch (n) {
            case 3: {
                coordinateConverter.userToWorldCoords(double_, false);
                break;
            }
            case 1: {
                coordinateConverter.screenToWorldCoords(double_, false);
            }
        }
        SkyCoordinates skyCoordinates = this.getTargetCenter();
        String string = skyCoordinates.getSystem();
        try {
            coordSystemType = this.mapper.getImageCoordinateSystem();
        }
        catch (Mapper.NoImageWCSException noImageWCSException) {
            Log.logger(CenterMapperModel.class).warning("No WCS information is associated with the image - cannot update the source coordinates");
            return skyCoordinates;
        }
        Assert.assertNotNull((Object)coordSystemType);
        switch (coordSystemType) {
            case EQUATORIAL: {
                skyCoordinates.setAbsoluteCoordinatesInJ2000Deg(double_);
                break;
            }
            case GALACTIC: {
                skyCoordinates.setAbsoluteCoordinatesInGalacticDeg(double_);
                break;
            }
            default: {
                Log.logger(CenterMapperModel.class).warning("Unknown coordinate system seen in loaded image " + coordSystemType);
                return skyCoordinates;
            }
        }
        skyCoordinates.convertToSystem(string);
        this.updateFormEditor();
        return skyCoordinates;
    }

    public SkyCoordinates getTargetCenter() {
        return this.getSpatialVisualModel().getVisualModelHelper().getTargetCenter();
    }

    protected SkyCoordinates addTargetCenter() {
        if (this.singleMode) {
            this.initialize();
        }
        return this.getSpatialVisualModel().getVisualModelHelper().addTargetCenter();
    }

    public void createTargetCenter(SkyCoordinates skyCoordinates) {
        if (this.singleMode) {
            this.getCenterMapper().createTargetCenterFigure(skyCoordinates);
        }
    }
}

