/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.mapper;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplayPanel;
import alma.obsprep.ot.editors.spatialvisual.mapper.PatternFigure;
import java.util.HashMap;
import java.util.Map;

public class BOFigureListManager {
    private AlmaNavigatorImageDisplayPanel imagePanel;
    private Map<BusinessObject, PatternFigure> figureTable = new HashMap<BusinessObject, PatternFigure>();
    private Map<BusinessObject, Boolean> selectionTable = new HashMap<BusinessObject, Boolean>();

    public BOFigureListManager(AlmaNavigatorImageDisplayPanel almaNavigatorImageDisplayPanel) {
        this.imagePanel = almaNavigatorImageDisplayPanel;
    }

    protected void initialize() {
        this.figureTable = new HashMap<BusinessObject, PatternFigure>();
        this.selectionTable = new HashMap<BusinessObject, Boolean>();
    }

    protected void add(BusinessObject businessObject, PatternFigure patternFigure) {
        this.figureTable.put(businessObject, patternFigure);
        this.selectionTable.put(businessObject, new Boolean(false));
    }

    protected void remove(BusinessObject businessObject) {
        PatternFigure patternFigure = this.figureTable.get(businessObject);
        if (patternFigure != null) {
            this.figureTable.remove(businessObject);
            this.imagePanel.getAlmaCanvasDraw().deleteFigure(patternFigure);
            patternFigure.cleanupForRemoval();
        }
    }

    public void remove(PatternFigure patternFigure) {
        BusinessObject businessObject;
        if (patternFigure != null && (businessObject = patternFigure.getBusinessObject()) != null) {
            this.figureTable.remove(businessObject);
            this.selectionTable.remove(businessObject);
            this.imagePanel.getAlmaCanvasDraw().deleteFigure(patternFigure);
            patternFigure.cleanupForRemoval();
        }
    }

    protected void deleteAll() {
        BusinessObject[] businessObjectArray = new BusinessObject[this.figureTable.size()];
        this.figureTable.keySet().toArray(businessObjectArray);
        for (BusinessObject businessObject : businessObjectArray) {
            this.remove(businessObject);
        }
    }

    public PatternFigure getFigure(BusinessObject businessObject) {
        return this.figureTable.get(businessObject);
    }

    protected boolean figureTableContainsBO(BusinessObject businessObject) {
        return this.figureTable.containsKey(businessObject);
    }

    protected void selectAll(boolean bl) {
        for (BusinessObject businessObject : this.selectionTable.keySet()) {
            this.selectionTable.put(businessObject, new Boolean(bl));
        }
    }

    protected void selectAll() {
        this.selectAll(true);
    }

    public void deselectAll() {
        this.selectAll(false);
    }

    public void select(BusinessObject businessObject) {
        this.select(businessObject, true);
    }

    public void select(BusinessObject businessObject, boolean bl) {
        this.selectionTable.put(businessObject, new Boolean(bl));
    }

    public boolean isSelected(BusinessObject businessObject) {
        Boolean bl;
        boolean bl2 = false;
        if (businessObject != null && (bl = this.selectionTable.get(businessObject)) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    protected int getSelectedCount() {
        int n = 0;
        for (Boolean bl : this.selectionTable.values()) {
            if (!bl.booleanValue()) continue;
            ++n;
        }
        return n;
    }

    public void setVisible(boolean bl) {
        for (PatternFigure patternFigure : this.figureTable.values()) {
            patternFigure.setVisible(bl);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Class=" + this.getClass().getSimpleName() + "[" + this.hashCode() + "]");
        stringBuffer.append(", nSelected=" + this.getSelectedCount());
        stringBuffer.append(", figureTable.size()=" + this.figureTable.size());
        stringBuffer.append(", selectionTable.size()=" + this.selectionTable.size());
        return stringBuffer.toString();
    }
}

