/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.actions;

import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplay;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplayPanel;
import alma.obsprep.ot.editors.spatialvisual.actions.SpatialVisualAction;
import alma.obsprep.ot.gui.resources.Icons;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SpatialVisualActionImageOpen
extends SpatialVisualAction {
    public static final String actionName = "Open Image";
    private JFileChooser fileChooser = null;

    public SpatialVisualActionImageOpen(AlmaNavigatorImageDisplayPanel almaNavigatorImageDisplayPanel) {
        super(almaNavigatorImageDisplayPanel, actionName, Icons.getIcon("open24.png"), true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (this.fileChooser == null) {
            this.fileChooser = this.makeImageFileChooser();
        }
        if ((n = this.fileChooser.showOpenDialog(this.imagePanel)) == 0 && this.fileChooser.getSelectedFile() != null) {
            String string = this.fileChooser.getSelectedFile().toString();
            this.imagePanel.erase();
            AlmaNavigatorImageDisplay almaNavigatorImageDisplay = this.imagePanel.getImageDisplay();
            almaNavigatorImageDisplay.setFilename(string);
            almaNavigatorImageDisplay.getCanvasDraw().clear();
        }
    }

    private JFileChooser makeImageFileChooser() {
        JFileChooser jFileChooser = new JFileChooser(new File("."));
        FitsFileFilter fitsFileFilter = new FitsFileFilter();
        jFileChooser.addChoosableFileFilter(fitsFileFilter);
        jFileChooser.setFileFilter(fitsFileFilter);
        return jFileChooser;
    }

    private class FitsFileFilter
    extends FileFilter {
        String[] extensions = new String[]{"fits", "fits.gz", "fits.Z", "hfits"};
        String description = "FITS Image Files";

        private FitsFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file != null) {
                if (file.isDirectory()) {
                    return true;
                }
                for (String string : this.extensions) {
                    if (!file.getName().endsWith(string)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.description);
            stringBuffer.append("(");
            for (String string : this.extensions) {
                stringBuffer.append(string);
                stringBuffer.append(",");
            }
            String string = stringBuffer.toString();
            String string2 = string.substring(0, string.length() - 1) + ")";
            return string2;
        }
    }
}

