/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual;

import alma.obsprep.bo.annotations.PointingPatternI;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.guiutil.jsky.image.graphics.AlmaDivaImageGraphics;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.editors.obsproject.RectangleEditor;
import alma.obsprep.ot.editors.schedblock.PointingPatternEditor;
import alma.obsprep.ot.editors.sciencegoals.FieldSetupEditor;
import alma.obsprep.ot.editors.sciencegoals.TargetParametersEditor;
import alma.obsprep.ot.editors.spatialvisual.ScienceGoalSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualEditor;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.models.obsproject.RectangleModel;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.ot.models.sciencegoals.FieldSetupModel;
import alma.obsprep.services.experts.RectangleAreaExpert;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.SkyCoordinates;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import lombok.NonNull;

public class SpatialVisualEditorForSG
extends SpatialVisualEditor {
    private final Pattern p = Pattern.compile("(\\d+):(\\d+):(\\d+)");
    private ExportDialogue exportDialogue;

    public SpatialVisualEditorForSG(ScienceGoalSpatialVisualModel scienceGoalSpatialVisualModel) {
        super(scienceGoalSpatialVisualModel);
        FieldSetupModel fieldSetupModel = scienceGoalSpatialVisualModel.getFormModel();
        this.formEditor = new FieldSetupEditor(fieldSetupModel);
        this.formEditor.setName("SpatialVisualEditorForSG.FieldSetupEditor");
        this.registerSubView(this.formEditor);
        this.build();
        scienceGoalSpatialVisualModel.publish();
        this.configureSelectionListeners();
        RectangleModel rectangleModel = this.getModel().getFormModel().getTargetParametersModel().getFieldModel().getRectangleModel();
        rectangleModel.subscribe(this);
        rectangleModel.subscribe(this.fovParameterEditor.getAcaEnabledSubscriber());
        ((AlmaDivaImageGraphics)this.imageDisplay.getCanvasGraphics()).addSelectionDraggerListener(this);
    }

    private TargetParametersEditor getTargetParametersEditor() {
        return ((FieldSetupEditor)this.formEditor).getTargetParametersEditor();
    }

    @Override
    public ScienceGoalSpatialVisualModel getModel() {
        return (ScienceGoalSpatialVisualModel)super.getModel();
    }

    @Override
    protected PointingPatternI getPointingPattern() {
        return this.getModel().getFormModel().getTargetParametersModel().getFieldModel().getPointingPatternModel().getPointingPattern();
    }

    @Override
    protected JTable getPointingPatternTable() {
        PointingPatternEditor pointingPatternEditor = this.getTargetParametersEditor().fieldEditor.getPointsEditor();
        return pointingPatternEditor.getPointingPatternTable();
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        super.update(fieldID, object);
        if (fieldID == RectangleEditor.EXPORT_POINTINGS_FID) {
            this.exportPointings();
        }
    }

    private void exportPointings() {
        boolean bl;
        Rectangle rectangle = (Rectangle)this.getModel().getFormModel().getTargetParametersModel().getFieldModel().getRectangleModel().getDocument();
        RectangleAreaExpert rectangleAreaExpert = RectangleAreaExpert.of(rectangle);
        PointingPattern pointingPattern = rectangleAreaExpert.getPointingPattern(Array.ARRAY_12M);
        PointingPattern pointingPattern2 = rectangleAreaExpert.getPointingPattern(Array.ARRAY_7M);
        if (pointingPattern.getNumberOfPointings() == 0 && pointingPattern2.getNumberOfPointings() == 0) {
            GUIUtilities.info(null, "There are no pointings to export");
            return;
        }
        if (this.exportDialogue == null) {
            this.exportDialogue = new ExportDialogue();
        }
        try {
            bl = ((ScienceGoal)this.getModel().getSpatialDocument()).getPerformanceParameters().getUseACA();
        }
        catch (Exception exception) {
            bl = false;
        }
        this.exportDialogue.setInclude7m(bl);
        if (JOptionPane.showOptionDialog(this, this.exportDialogue, "Export Pointings to Files", 2, -1, null, null, null) != 0) {
            return;
        }
        SkyCoordinates skyCoordinates = (SkyCoordinates)this.getModel().getSourceCoordinatesModel().getDocument();
        String string = this.getModel().getFormModel().getTargetParametersModel().getTargetParameters().getSourceName();
        String[] stringArray = this.asSexaRaDec(skyCoordinates);
        String string2 = string + " (" + skyCoordinates.getSystem() + " " + stringArray[0] + " " + stringArray[1] + ")";
        File file = new File(this.exportDialogue.getReply12m());
        this.exportPointings("12m Pointings for Source " + string2, skyCoordinates, pointingPattern, file);
        if (bl) {
            File file2 = new File(this.exportDialogue.getReply7m());
            this.exportPointings("7m Pointings for Source " + string2, skyCoordinates, pointingPattern2, file2);
        }
    }

    private void exportPointings(String string, @NonNull SkyCoordinates skyCoordinates, @NonNull PointingPattern pointingPattern, @NonNull File file) {
        if (skyCoordinates == null) {
            throw new NullPointerException("centroid is marked non-null but is null");
        }
        if (pointingPattern == null) {
            throw new NullPointerException("pp is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        PointingPatternModel pointingPatternModel = new PointingPatternModel(pointingPattern);
        FieldSource fieldSource = FieldSource.createFieldSource();
        fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
        fieldSource.setSourceCoordinates(skyCoordinates);
        pointingPatternModel.exportAbsoluteCoordsToFile(file, PointingPatternEditor.AbsoluteCoordsFormat.SEXAGESIMAL);
    }

    private String[] asSexaRaDec(SkyCoordinates skyCoordinates) {
        String string = "<Conversion Error>";
        String string2 = "<Conversion Error>";
        try {
            string = skyCoordinates.getLongitude().toHHMMSS();
            string = this.p.matcher(string).replaceAll("$1h$2m$3");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string2 = skyCoordinates.getLatitude().toDDMMSS();
            string2 = this.p.matcher(string2).replaceAll("$1d$2m$3");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String[]{string, string2};
    }

    public static void main(String[] stringArray) {
        ExportDialogue exportDialogue = new ExportDialogue();
        exportDialogue.setInclude7m(true);
        int n = JOptionPane.showOptionDialog(null, exportDialogue, "Export Pointings to Disk", 2, -1, null, null, null);
        if (n != 0) {
            return;
        }
        System.out.println(new File(exportDialogue.getReply12m()));
        System.out.println(new File(exportDialogue.getReply7m()));
    }

    private static class ExportDialogue
    extends JPanel {
        static final String ext12m = "12m.pointings";
        static final String ext7m = "7m.pointings";
        JButton btnDirectory;
        JTextField txtName;
        JTextField txt7m;
        JFileChooser fc;
        boolean include7m;

        String getReply12m() {
            return this.btnDirectory.getText() + File.separator + this.txtName.getText().trim() + ext12m;
        }

        String getReply7m() {
            if (!this.include7m) {
                return "<No pointings to export since ACA not used>";
            }
            return this.btnDirectory.getText() + File.separator + this.txtName.getText().trim() + ext7m;
        }

        void setInclude7m(boolean bl) {
            this.include7m = bl;
            this.txt7m.setText(this.getReply7m());
        }

        ExportDialogue() {
            super(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            this.add((Component)new JLabel("Export 12m pointings to:"), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            Box box = Box.createHorizontalBox();
            this.add((Component)box, gridBagConstraints);
            this.btnDirectory = new JButton();
            box.add(this.btnDirectory);
            box.add(new JLabel(File.separator));
            this.txtName = new JTextField();
            box.add(this.txtName);
            JTextField jTextField = new JTextField(ext12m);
            box.add(jTextField);
            box.add(Box.createHorizontalGlue());
            gridBagConstraints.gridy = 2;
            this.add((Component)new JLabel("Export 7m pointings to:"), gridBagConstraints);
            gridBagConstraints.gridy = 3;
            this.txt7m = new JTextField();
            this.add((Component)this.txt7m, gridBagConstraints);
            jTextField.setEditable(false);
            jTextField.setBackground(this.txtName.getBackground());
            jTextField.setBorder(null);
            jTextField.setFocusable(false);
            jTextField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    txtName.selectAll();
                    txtName.requestFocusInWindow();
                }
            });
            box.setBorder(this.txtName.getBorder());
            this.txt7m.setEditable(false);
            this.btnDirectory.setFocusPainted(false);
            this.btnDirectory.setBorderPainted(false);
            this.btnDirectory.setMargin(new Insets(0, 0, 0, 0));
            this.txtName.setBorder(null);
            this.fc = GuiFactory.getFactory().giveFileChooser("pointings");
            this.fc.setFileSelectionMode(1);
            this.btnDirectory.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (fc.showDialog(this, "Choose Folder") == 0) {
                        btnDirectory.setText(fc.getSelectedFile().getAbsolutePath());
                        txt7m.setText(this.getReply7m());
                        SwingUtilities.getWindowAncestor(this).pack();
                    }
                }
            });
            this.txtName.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            txt7m.setText(this.getReply7m());
                            SwingUtilities.getWindowAncestor(this).pack();
                        }
                    });
                }
            });
            this.btnDirectory.setText(this.fc.getCurrentDirectory().getAbsolutePath());
            this.btnDirectory.setToolTipText(this.btnDirectory.getText());
            this.txtName.setText("Alma");
            this.txt7m.setText(this.getReply7m());
        }
    }
}

