/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.annotations.PointingPatternI;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.guiutil.jsky.image.graphics.gui.AlmaCanvasDraw;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplay;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplayPanel;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.editors.spatialvisual.AlmaImageDisplayToolBar;
import alma.obsprep.ot.editors.spatialvisual.BaseSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.SelectionDraggerListener;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualParametersModel;
import alma.obsprep.ot.editors.spatialvisual.VisualModelHelper;
import alma.obsprep.ot.editors.spatialvisual.mapper.BOFigureListManager;
import alma.obsprep.ot.editors.spatialvisual.mapper.FovFigure;
import alma.obsprep.ot.editors.spatialvisual.mapper.MapperManager;
import alma.obsprep.ot.editors.spatialvisual.mapper.PointingMapperModel;
import alma.obsprep.ot.editors.spatialvisual.subform.FovParameterEditor;
import alma.obsprep.ot.editors.spatialvisual.subform.ImageQueryEditor;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.EditorDisablerController;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.schedblock.FieldPatternChangeListener;
import alma.valuetypes.SkyCoordinates;
import diva.canvas.interactor.SelectionEvent;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.interactor.SelectionListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jsky.graphics.CanvasFigure;

public abstract class SpatialVisualEditor
extends Editor
implements SelectionDraggerListener,
FieldPatternChangeListener {
    protected AlmaCanvasDraw almaCanvasDraw;
    protected AlmaNavigatorImageDisplay imageDisplay;
    protected AlmaNavigatorImageDisplayPanel imagePanel;
    protected AlmaImageDisplayToolBar toolbar;
    protected ImageQueryEditor imageQueryEditor;
    protected Editor formEditor;
    protected FovParameterEditor fovParameterEditor;
    public static final FieldID FID_IMAGEFILENAME = new FieldID("SpatialVisualEditor.imageFilename");
    private TableModelEvent prevEvent;
    private ListSelectionListener lsl;

    public FovParameterEditor getFovParameterEditor() {
        return this.fovParameterEditor;
    }

    public SpatialVisualEditor(BaseSpatialVisualModel baseSpatialVisualModel) {
        this.setModel(baseSpatialVisualModel);
        this.imagePanel = new AlmaNavigatorImageDisplayPanel(baseSpatialVisualModel, true);
        this.register(this.imagePanel, FID_IMAGEFILENAME);
        this.imageDisplay = this.imagePanel.getImageDisplay();
        this.imageDisplay.setImageDisplayPanel(this.imagePanel);
        this.imageDisplay.addImageFileLoadedListener(changeEvent -> {
            SpatialVisualParametersModel spatialVisualParametersModel = this.getSpatialVisualParametersModel();
            spatialVisualParametersModel.getSpatialVisualParameters().setFilename(this.imageDisplay.getFilename());
        });
        SpatialVisualParametersModel spatialVisualParametersModel = this.getSpatialVisualParametersModel();
        this.imageQueryEditor = new ImageQueryEditor(spatialVisualParametersModel);
        this.fovParameterEditor = new FovParameterEditor(spatialVisualParametersModel);
        CSH.setHelpIDString((Component)((Object)this.imageDisplay), (String)"TOC-The Visual Editors-The Visual Spatial Editor-Tool Bar and Zooming Functions");
        CSH.setHelpIDString((Component)this.imageQueryEditor, (String)"TOC-The Visual Editors-The Visual Spatial Editor-Image Query");
        CSH.setHelpIDString((Component)this.fovParameterEditor, (String)"TOC-The Visual Editors-The Visual Spatial Editor-Fov Parameters");
        this.registerSubView(this.imageQueryEditor);
        this.registerSubView(this.fovParameterEditor);
        this.imageQueryEditor.setImagePanel(this.imagePanel);
        baseSpatialVisualModel.addFieldPatternChangeListener(this);
    }

    @Override
    public BaseSpatialVisualModel getModel() {
        return (BaseSpatialVisualModel)super.getModel();
    }

    protected SpatialVisualParametersModel getSpatialVisualParametersModel() {
        return this.getModel().getSpatialVisualParametersModel();
    }

    @Override
    public void build() {
        JPanel jPanel = this.buildLeftPanel();
        JPanel jPanel2 = this.buildRightPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
    }

    private JPanel buildLeftPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(this.createVisualEditorGroup("Spatial Image"));
        jPanel.add(this.fovParameterEditor);
        jPanel.add(this.imageQueryEditor);
        return jPanel;
    }

    protected JPanel createVisualEditorGroup(String string) {
        JPanel jPanel = new JPanel();
        this.toolbar = new AlmaImageDisplayToolBar(this.getModel(), this.imagePanel);
        JButton jButton = new JButton(Icons.question);
        jButton.setPreferredSize(new Dimension(Icons.question.getIconWidth(), Icons.question.getIconHeight()));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText("Display help from reference manual");
        jButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(jPanel2.getWidth(), 1)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        jPanel3.add(this.toolbar);
        jPanel3.add(this.imagePanel);
        jPanel.add(jPanel3);
        jPanel.add(Box.createRigidArea(new Dimension(jPanel3.getWidth(), 1)));
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        ObservingToolController observingToolController = ObservingToolController.getMyInstance();
        if (observingToolController != null) {
            jButton.addActionListener((ActionListener)new CSH.DisplayHelpFromFocus(observingToolController.getReferenceManualHS(), "javax.help.MainWindow", null));
        }
        return jPanel;
    }

    private JPanel buildRightPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.formEditor, gridBagConstraints);
        jPanel.add(this.formEditor);
        return jPanel;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(FID_IMAGEFILENAME)) {
            String string = (String)object;
            if (string == null) {
                this.imagePanel.erase();
                this.imagePanel.getImageDisplay().setWCS(null);
            } else {
                this.imagePanel.setImageFile(string);
            }
            MapperManager mapperManager = this.imagePanel.getMapperManager();
            mapperManager.setFieldPatternType(this.getModel().getVisualModelHelper().getFieldPatternType());
            this.imagePanel.clearGraphics();
            this.imagePanel.reloadPatterns();
            return;
        }
        super.update(fieldID, object);
    }

    public AlmaNavigatorImageDisplayPanel getImagePanel() {
        return this.imagePanel;
    }

    @Override
    public void selectionDraggerSelectFinished() {
        this.imagePanel.setFigureSelectionEventEnabled(true);
        this.figureSelectionSync();
    }

    protected void figureSelectionSync() {
        JTable jTable = this.getPointingPatternTable();
        List<CanvasFigure> list = this.imagePanel.getAlmaCanvasDraw().getSelectedFovList();
        BOFigureListManager bOFigureListManager = this.getPointingMapperModel().getBoFigureListManager();
        bOFigureListManager.deselectAll();
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI != null && pointingPatternI.isPointingPattern()) {
            int n = pointingPatternI.getPhaseCenterCoordinatesCount();
            if (n > 0) {
                jTable.removeRowSelectionInterval(0, n - 1);
            }
            for (CanvasFigure canvasFigure : list) {
                if (!(canvasFigure instanceof FovFigure)) continue;
                FovFigure fovFigure = (FovFigure)canvasFigure;
                SkyCoordinates skyCoordinates = (SkyCoordinates)fovFigure.getBusinessObject();
                bOFigureListManager.select((BusinessObject)skyCoordinates);
                int n2 = pointingPatternI.indexOf(skyCoordinates);
                jTable.addRowSelectionInterval(n2, n2);
            }
        }
    }

    protected void figureSelectionChanged(SelectionEvent selectionEvent) {
        if (this.imagePanel.isFigureSelectionEventEnabled()) {
            int n;
            FovFigure fovFigure;
            SkyCoordinates skyCoordinates;
            Object e;
            JTable jTable = this.getPointingPatternTable();
            PointingPatternI pointingPatternI = this.getPointingPattern();
            BOFigureListManager bOFigureListManager = this.getPointingMapperModel().getBoFigureListManager();
            Iterator iterator = selectionEvent.getSelectionAdditions();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof FovFigure) || bOFigureListManager.isSelected((BusinessObject)(skyCoordinates = (SkyCoordinates)(fovFigure = (FovFigure)e).getBusinessObject()))) continue;
                bOFigureListManager.select((BusinessObject)skyCoordinates);
                n = pointingPatternI.indexOf(skyCoordinates);
                jTable.addRowSelectionInterval(n, n);
            }
            iterator = selectionEvent.getSelectionRemovals();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof FovFigure) || !bOFigureListManager.isSelected((BusinessObject)(skyCoordinates = (SkyCoordinates)(fovFigure = (FovFigure)e).getBusinessObject())) || pointingPatternI == null) continue;
                bOFigureListManager.select((BusinessObject)skyCoordinates, false);
                n = pointingPatternI.indexOf(skyCoordinates);
                if (n == -1) continue;
                jTable.removeRowSelectionInterval(n, n);
            }
            return;
        }
    }

    protected void setupSelectionInteractorSelectionChangeListener() {
        SelectionInteractor selectionInteractor = this.imagePanel.getImageGraphics().getDraggableSelectionInteractor();
        selectionInteractor.getSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                SpatialVisualEditor.this.figureSelectionChanged(selectionEvent);
            }
        });
    }

    protected abstract JTable getPointingPatternTable();

    protected abstract PointingPatternI getPointingPattern();

    protected PointingMapperModel getPointingMapperModel() {
        return this.getModel().getVisualModelHelper().getPointingMapperModel();
    }

    private boolean processTableEvent(TableModelEvent tableModelEvent) {
        if (this.prevEvent == tableModelEvent) {
            return false;
        }
        this.prevEvent = tableModelEvent;
        return true;
    }

    protected void pointingPatternTableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getType();
        if (!this.processTableEvent(tableModelEvent)) {
            return;
        }
        PointingMapperModel pointingMapperModel = this.getPointingMapperModel();
        BOFigureListManager bOFigureListManager = pointingMapperModel.getBoFigureListManager();
        if (n == 1) {
            PointingPatternI pointingPatternI = this.getPointingPattern();
            for (int i = tableModelEvent.getFirstRow(); i <= tableModelEvent.getLastRow(); ++i) {
                SkyCoordinates skyCoordinates = pointingPatternI.getPhaseCenterCoordinates(i);
                if (!pointingMapperModel.getPointingMapper().isWcsSet(false)) continue;
                pointingMapperModel.publishPointing(skyCoordinates, true);
            }
        } else if (n == -1) {
            PointingPatternI pointingPatternI = this.getPointingPattern();
            for (int i = tableModelEvent.getFirstRow(); i <= tableModelEvent.getLastRow(); ++i) {
                SkyCoordinates skyCoordinates = pointingPatternI.getPhaseCenterCoordinates(i);
                FovFigure fovFigure = (FovFigure)bOFigureListManager.getFigure((BusinessObject)skyCoordinates);
                bOFigureListManager.remove(fovFigure);
            }
        } else if (n == 0 && tableModelEvent.getFirstRow() == -1 && tableModelEvent.getLastRow() == -1) {
            pointingMapperModel.importPattern();
        }
    }

    private void addListSelectionListener() {
        ListSelectionModel listSelectionModel = this.getPointingPatternTable().getSelectionModel();
        listSelectionModel.addListSelectionListener(this.lsl);
    }

    private void removeListSelectionListener() {
        ListSelectionModel listSelectionModel = this.getPointingPatternTable().getSelectionModel();
        listSelectionModel.removeListSelectionListener(this.lsl);
    }

    protected void setupPointingPatternTableListener() {
        this.lsl = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SpatialVisualEditor.this.pointingPatternTableSelectionChanged(listSelectionEvent);
            }
        };
        this.addListSelectionListener();
        TableModelListener tableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                SpatialVisualEditor.this.pointingPatternTableChanged(tableModelEvent);
            }
        };
        this.getPointingPatternTable().getModel().addTableModelListener(tableModelListener);
    }

    protected void pointingPatternTableSelectionChanged(ListSelectionEvent listSelectionEvent) {
        if (this.getPointingPatternTable().getRowCount() <= listSelectionEvent.getLastIndex()) {
            return;
        }
        PointingMapperModel pointingMapperModel = this.getPointingMapperModel();
        BOFigureListManager bOFigureListManager = pointingMapperModel.getBoFigureListManager();
        for (int i = listSelectionEvent.getFirstIndex(); i <= listSelectionEvent.getLastIndex(); ++i) {
            try {
                boolean bl;
                boolean bl2;
                SkyCoordinates skyCoordinates = this.getPointingPattern().getPhaseCenterCoordinates(i);
                if (skyCoordinates == null || (bl2 = bOFigureListManager.isSelected((BusinessObject)skyCoordinates)) == (bl = this.getPointingPatternTable().isRowSelected(i))) continue;
                bOFigureListManager.select((BusinessObject)skyCoordinates, bl);
                FovFigure fovFigure = (FovFigure)bOFigureListManager.getFigure((BusinessObject)skyCoordinates);
                if (fovFigure == null || !pointingMapperModel.isFovFigureSelectionEnabled()) continue;
                if (bl) {
                    this.imagePanel.getImageGraphics().select(fovFigure);
                    continue;
                }
                this.imagePanel.getImageGraphics().deselect(fovFigure);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    protected void configureSelectionListeners() {
        this.setupPointingPatternTableListener();
        this.setupSelectionInteractorSelectionChangeListener();
        VisualModelHelper visualModelHelper = this.getModel().getVisualModelHelper();
        visualModelHelper.getPointingMapperModel().setTableSelectionModel(this.getPointingPatternTable().getSelectionModel());
    }

    @Override
    public void fieldPatternChanged(FieldPattern.FieldPatternType fieldPatternType) {
        if (this.imagePanel == null) {
            return;
        }
        this.imagePanel.getMapperManager().setFieldPatternType(fieldPatternType);
    }
}

