/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTBasicTextArea;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.sciencegoals.TJEditorEnum;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationModel;
import alma.obsprep.util.LogLoggerProviderImpl;
import alma.obsprep.util.UnitMapConfigurator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class TechnicalJustificationEditor
extends EditorWithGridBagLayout {
    private static final long serialVersionUID = 6105832616755431952L;
    public static final JLabel wideBandwidthWarning = TechnicalJustificationEditor.decoratedWarningLabel("Note that the bandwidth used for sensitivity is larger than 1/3 of the linewidth.<br/>The S/N achieved for a resolution element that allows the line to be resolved will be lower than that reported.");
    public static final JLabel mayNotResolveWarning = TechnicalJustificationEditor.decoratedWarningLabel("Note that the spectral resolution is larger than 1/3 of the the spectral line width and that your line may not be resolved.");
    public static final JLabel snrLowWarning = TechnicalJustificationEditor.decoratedWarningLabel("Note that one or more of the S/N estimates are &lt; 3. Please double-check the RMS and/or line fluxes entered and/or address the issue below.");
    public static final JLabel dynamicRangeWarning = TechnicalJustificationEditor.decoratedWarningLabel("Note that the dynamic range is higher than that offered for the chosen band in this cycle. Please double-check your input and/or address the issue below.");
    public static final JLabel linewidthGreaterThanSPWWarning = TechnicalJustificationEditor.decoratedWarningLabel("Note that the line width is larger than the representative spectral window width. Please double-check your input and/or address the issue below.");
    private static final FieldID FID_LINE_WIDTH_AGAIN = new FieldID("TechnicalJustificationEditor.lineWidthAgain");
    private static final FieldID FID_LINE_WIDTH_CALC = new FieldID("TechnicalJustificationEditor.lineWidthCalc");
    public static final FieldID FID_LINE_ACHIEVED_SNR = new FieldID("TechnicalJustificationEditor.lineAchievedSNR");
    public static final FieldID FID_ACHIEVED_CONTINUUM_RMS = new FieldID("TechnicalJustification.achevedContinuumRms");
    public static final FieldID FID_AGGREGATE_BANDWIDTH_ALL_SPW = new FieldID("TechnicalJustificationEditor.desiredFrequencyWidth");
    public static final FieldID FID_ANGULAR_RES = new FieldID("TechnicalJustificationEditor.angularResolution");
    public static final FieldID FID_BANDWIDTH_FOR_SENSITIVITY = new FieldID("TechnicalJustificationEditor.bandwidthForSensitivity");
    public static final FieldID FID_BANDWIDTH_FOR_SENSITIVITY_CALC = new FieldID("TechnicalJustificationEditor.bandwidthForSensitivityCalc");
    public static final FieldID FID_BAND_CALC_RESULT = new FieldID("TechnicalJustificationEditor.PeakFluxSnr");
    public static final FieldID FID_CONT_PEAK_FLUX_DENSITY = new FieldID("TechnicalJustificationEditor.PeakFluxDensity");
    public static final FieldID FID_CONT_PEAK_FLUX_SNR = new FieldID("TechnicalJustificationEditor.contPeakFluxSnr");
    public static final FieldID FID_ANY_FLUX_SET = new FieldID("TechnicalJustificationEditor.contFluxSet");
    public static final FieldID FID_DESIRED_SENSITIVITY = new FieldID("TechnicalJustificationEditor.sensitivity");
    public static final FieldID FID_DYNAMIC_RANGE = new FieldID("TechnicalJustificationEditor.dynamicRange");
    public static final FieldID FID_LARGEST_ANGULAR_SCALE = new FieldID("TechnicalJustificationEditor.largestAngularScale");
    public static final FieldID FID_LINEWIDTH_SET = new FieldID("TechnicalJustificationEditor.lineWidthSet");
    public static final FieldID FID_LINE_FLUX_SET = new FieldID("TechnicalJustificationEditor.lineFluxSet");
    public static final FieldID FID_LINE_RESOLUTIONS = new FieldID("TechnicalJustificationEditor.lineResolutions");
    public static final FieldID FID_LINE_WIDTH = new FieldID("TechnicalJustificationEditor.lineWidth");
    public static final FieldID FID_MIN_ANGULAR_RES = new FieldID("TechnicalJustificationEditor.MinResolution");
    public static final FieldID FID_PEAK_FLUX_DENSITY = new FieldID("TechnicalJustificationEditor.peakFluxDensity");
    public static final FieldID FID_PEAK_FLUX_SNR = new FieldID("TechnicalJustificationEditor.linePeakFluxSnr");
    public static final FieldID FID_PEAK_LINE_FLUX = new FieldID("TechnicalJustificationEditor.PeakLineFlux");
    public static final FieldID FID_REPRESENTATIVE_SPEC_WIDTH = new FieldID("TechnicalJustificationEditor.representativeFrequency");
    public static final FieldID FID_RESOLUTION_VELOCITY = new FieldID("TechnicalJustificationEditor.ResolutionVelocity");
    public static final FieldID FID_SHOW_CONT_RMS_CALC = new FieldID("TechnicalJustificationEditor.showContRMSCalc");
    public static final FieldID FID_SHOW_DYNAMIC_RANGE = new FieldID("TechnicalJustificationEditor.displayDynamicRange");
    public static final FieldID FID_SHOW_MAX_DR_WARNING = new FieldID("TechnicalJustificationEditor.displayMaxDynamicRangeWarning");
    public static final FieldID FID_SHOW_MAY_NOT_RESOLVE_WARNING = new FieldID("TechnicalJustificationEditor.MayNotResolve");
    public static final FieldID FID_SHOW_SNR_LOW_WARNING = new FieldID("TechnicalJustificationEditor.FluxLowWarning");
    public static final FieldID FID_SHOW_WIDE_BANDWIDTH_WARNING = new FieldID("TechnicalJustificationEditor.WideBandwidthWarning");
    public static final FieldID FID_THIRD_OF_WIDTH = new FieldID("TechnicalJustificationEditor.ThirdOfWidth");
    public static final FieldID FID_LINEWIDTH_GREATER_THAN_SPW_WARNING = new FieldID("TechnicalJustificationEditor.LwGreaterThanSpw");
    public static final FieldID FID_IS_VLBI = new FieldID("TechnicalJustificationEditor.IsVLBI");
    public static final FieldID FID_IS_SOLAR = new FieldID("TechnicalJustificationEditor.IsSolar");
    public static final FieldID DISPLAY_NON_STD_SECTION = new FieldID("TechnicalJustificationEditor.DisplayNonStandardSection");
    static final Map<FieldID, String> tooltips = new HashMap<FieldID, String>();
    private JComponent lineWidthSensitivityCalc = null;
    private JComponent fluxComment = null;
    private JComponent spectralWindowComment = null;
    private JComponent spwWidthComment = null;
    private JComponent dynamicRangeComment = null;
    private JComponent aggregateRMSComment = null;
    private JComponent lineFluxComment = null;
    private JComponent contFluxComment = null;
    private JComponent nonStandardGroup = null;
    private JComponent sensitivityGroup = null;
    private JComponent imagingGroup = null;
    private JComponent correlatorGroup = null;
    private final String groupType = "Technical Justification";
    private JPanel correlatorFieldsSection;

    public TechnicalJustificationEditor(Model model, boolean bl) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    public TechnicalJustificationEditor(Model model) {
        this(model, true);
    }

    @Override
    protected void build() {
        super.build("Technical Justification");
    }

    @Override
    protected void addComponents(String string) {
        this.sensitivityGroup = this.createSensitivityJustificationSection();
        this.addNonCollapsingGroup(this.sensitivityGroup, "Sensitivity");
        this.imagingGroup = this.createImagingJustificationSection();
        this.addNonCollapsingGroup(this.imagingGroup, "Imaging");
        this.correlatorGroup = this.createCorrelatorJustificationSection();
        this.addNonCollapsingGroup(this.correlatorGroup, "Correlator configuration");
        this.nonStandardGroup = this.addNonCollapsingGroup(this.createNonStandardJustificationSection(), "Choices to be justified");
    }

    private JPanel createSensitivityFieldsSection() {
        JPanel jPanel = this.createNewGroup();
        GridBagConstraints gridBagConstraints = this.getGridBagConstraints(true);
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2));
        JPanel jPanel3 = this.createLineContainer();
        this.addComponentToContainer(jPanel3, FID_BANDWIDTH_FOR_SENSITIVITY, new JLabel("Requested RMS over "));
        this.addComponentToContainer(jPanel3, FID_DESIRED_SENSITIVITY, new JLabel(" is "));
        jPanel2.add(jPanel3);
        this.fluxComment = this.createLineContainer();
        this.addComponentToContainer(this.fluxComment, FID_PEAK_FLUX_DENSITY, new JLabel("For a peak flux density of "));
        this.addField(this.fluxComment, " , the S/N is ", FID_PEAK_FLUX_SNR);
        jPanel2.add(this.fluxComment);
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, jPanel2);
        JPanel jPanel4 = new JPanel(new GridLayout(0, 2));
        this.aggregateRMSComment = this.createLineContainer();
        this.addComponentToContainer(this.aggregateRMSComment, FID_AGGREGATE_BANDWIDTH_ALL_SPW, new JLabel("Achieved RMS over the total "));
        this.addComponentToContainer(this.aggregateRMSComment, FID_ACHIEVED_CONTINUUM_RMS, new JLabel("bandwidth is "));
        jPanel4.add(this.aggregateRMSComment);
        this.contFluxComment = this.createLineContainer();
        this.addComponentToContainer(this.contFluxComment, FID_CONT_PEAK_FLUX_DENSITY, new JLabel("For a continuum flux density of "));
        this.addField(this.contFluxComment, " , the achieved S/N is ", FID_CONT_PEAK_FLUX_SNR);
        jPanel4.add(this.contFluxComment);
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, jPanel4);
        this.lineFluxComment = this.createLineContainer();
        this.addComponentToContainer(this.lineFluxComment, FID_PEAK_LINE_FLUX, new JLabel("For a peak line flux of "));
        this.addComponentToContainer(this.lineFluxComment, FID_LINE_WIDTH, new JLabel(" , the achieved S/N over 1/3 of the source line width ( "));
        this.addComponentToContainer(this.lineFluxComment, FID_THIRD_OF_WIDTH, new JLabel(" / 3 = "));
        this.addComponentToContainer(this.lineFluxComment, FID_LINE_ACHIEVED_SNR, new JLabel(" ) is "));
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, this.lineFluxComment);
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, snrLowWarning);
        this.lineWidthSensitivityCalc = this.createLineContainer();
        this.addComponentToContainer(this.lineWidthSensitivityCalc, FID_LINE_WIDTH_AGAIN, new JLabel("Line width / bandwidth used for sensitivity ( "));
        this.addComponentToContainer(this.lineWidthSensitivityCalc, FID_BANDWIDTH_FOR_SENSITIVITY_CALC, new JLabel(" / "));
        this.addComponentToContainer(this.lineWidthSensitivityCalc, FID_BAND_CALC_RESULT, new JLabel(" ) = "));
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, this.lineWidthSensitivityCalc);
        this.lineWidthSensitivityCalc.setVisible(false);
        return jPanel;
    }

    private JPanel createSensitivityJustificationSection() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.getGridBagConstraints(false);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.createSensitivityFieldsSection());
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints, 5);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, wideBandwidthWarning);
        wideBandwidthWarning.setVisible(true);
        this.dynamicRangeComment = this.createLineContainer();
        this.addComponentToContainer(this.dynamicRangeComment, FID_DYNAMIC_RANGE, new JLabel("Spectral Dynamic Range (continuum flux / line rms): "));
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.dynamicRangeComment);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, dynamicRangeWarning);
        this.addLabel(jPanel, gridBagLayout, gridBagConstraints, "Justify your requested RMS and resulting S/N for the spectral line and/or continuum observations.");
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints, 2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_SENSITIVITY));
        return jPanel;
    }

    private JPanel createImagingFieldsSection() {
        GridLayout gridLayout = new GridLayout(0, 1);
        gridLayout.setHgap(20);
        JPanel jPanel = new JPanel(gridLayout);
        JPanel jPanel2 = this.createLineContainer();
        this.addComponentToContainer(jPanel2, FID_ANGULAR_RES, new JLabel("Requested angular resolution "));
        jPanel.add(jPanel2);
        JPanel jPanel3 = this.createLineContainer();
        this.addComponentToContainer(jPanel3, FID_LARGEST_ANGULAR_SCALE, new JLabel("Requested Largest Angular Scale "));
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel createImagingJustificationSection() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.createImagingFieldsSection());
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints, 10);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_ANGULAR_RESOLUTION));
        return jPanel;
    }

    private JPanel createCorrelatorFieldsSection() {
        GridLayout gridLayout = new GridLayout(0, 1);
        JPanel jPanel = new JPanel(gridLayout);
        this.spwWidthComment = this.createLineContainer();
        this.addComponentToContainer(this.spwWidthComment, FID_LINE_WIDTH_CALC, new JLabel("line width / representative spectral window resolution: "));
        this.addComponentToContainer(this.spwWidthComment, FID_RESOLUTION_VELOCITY, new JLabel(" / "));
        this.addComponentToContainer(this.spwWidthComment, FID_LINE_RESOLUTIONS, new JLabel(" = "));
        jPanel.add(this.spwWidthComment);
        jPanel.add(mayNotResolveWarning);
        this.spectralWindowComment = this.createLineContainer();
        this.addComponentToContainer(this.spectralWindowComment, FID_REPRESENTATIVE_SPEC_WIDTH, new JLabel("Representative spectral window width : "));
        jPanel.add(this.spectralWindowComment);
        jPanel.add(linewidthGreaterThanSPWWarning);
        return jPanel;
    }

    private JPanel createCorrelatorJustificationSection() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.correlatorFieldsSection = this.createCorrelatorFieldsSection();
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.correlatorFieldsSection);
        this.addLabel(jPanel, gridBagLayout, gridBagConstraints, "");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_CORRELATOR));
        return jPanel;
    }

    private JPanel createNonStandardJustificationSection() {
        JPanel jPanel = this.createNewGroup();
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_USER_DEFINED_CALIB));
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_ADDITIONAL_TIME));
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_NON_STD_CONT_FREQ));
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_SINGLE_POLARISATION));
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_TIME_CONSTRAINT));
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_LOW_MAX_ELEVATION));
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_VLBI));
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_SOLAR));
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_VLBI_PASSIVE_PHASING));
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_VLBI_PHASED_ARRAY));
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_ASTROMETRY));
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, this.createEditorBoxWithLabel(TJEditorEnum.ED_NON_NYQUIST));
        return jPanel;
    }

    private List<JComponent> addField(JComponent jComponent, String string, FieldID fieldID) {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        GridBagConstraints gridBagConstraints = this.getGridBagConstraints(true);
        JLabel jLabel = new JLabel(string);
        jComponent.add((Component)jLabel, gridBagConstraints);
        arrayList.add(jLabel);
        JTextField jTextField = new JTextField();
        jTextField.setHorizontalAlignment(11);
        if (tooltips.containsKey(fieldID)) {
            jTextField.setToolTipText(tooltips.get(fieldID));
        }
        jTextField.setEditable(false);
        gridBagConstraints = this.getGridBagConstraints(false);
        jComponent.add((Component)jTextField, gridBagConstraints);
        this.register(jTextField, fieldID);
        arrayList.add(jTextField);
        return arrayList;
    }

    private List<JComponent> addComponentToContainer(JComponent jComponent, FieldID fieldID, JLabel jLabel) {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        GridBagConstraints gridBagConstraints = this.getGridBagConstraints(true);
        JTextField jTextField = new JTextField();
        jTextField.setHorizontalAlignment(11);
        arrayList.add(jTextField);
        jTextField.setEditable(false);
        if (tooltips.containsKey(fieldID)) {
            jLabel.setToolTipText(tooltips.get(fieldID));
            jTextField.setToolTipText(tooltips.get(fieldID));
        }
        jComponent.add((Component)jLabel, gridBagConstraints);
        arrayList.add(jLabel);
        jComponent.add((Component)jTextField, gridBagConstraints);
        this.register(jTextField, fieldID);
        return arrayList;
    }

    private GridBagConstraints getGridBagConstraints(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weighty = 0.0;
        if (bl) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
        } else {
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
        }
        return gridBagConstraints;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(FID_LINEWIDTH_SET)) {
            boolean bl = Boolean.parseBoolean(object.toString());
            this.spwWidthComment.setVisible(bl);
            this.spectralWindowComment.setVisible(bl);
        } else if (fieldID.equals(FID_SHOW_MAY_NOT_RESOLVE_WARNING)) {
            boolean bl = Boolean.parseBoolean(object.toString());
            mayNotResolveWarning.setVisible(bl);
        } else if (fieldID.equals(FID_SHOW_DYNAMIC_RANGE)) {
            boolean bl = Boolean.parseBoolean(object.toString());
            this.dynamicRangeComment.setVisible(bl);
        } else if (fieldID.equals(FID_SHOW_WIDE_BANDWIDTH_WARNING)) {
            boolean bl = Boolean.parseBoolean(object.toString());
            wideBandwidthWarning.setVisible(bl);
        } else if (fieldID.equals(FID_SHOW_SNR_LOW_WARNING)) {
            boolean bl = Boolean.parseBoolean(object.toString());
            snrLowWarning.setVisible(bl);
        } else if (fieldID.equals(FID_SHOW_MAX_DR_WARNING)) {
            boolean bl = Boolean.parseBoolean(object.toString());
            dynamicRangeWarning.setVisible(bl);
        } else if (fieldID.equals(FID_SHOW_CONT_RMS_CALC)) {
            boolean bl = Boolean.parseBoolean(object.toString());
            this.aggregateRMSComment.setVisible(bl);
            this.contFluxComment.setVisible(bl);
        } else if (fieldID.equals(FID_LINE_FLUX_SET)) {
            boolean bl = Boolean.parseBoolean(object.toString());
            this.lineFluxComment.setVisible(bl);
            this.lineWidthSensitivityCalc.setVisible(bl);
        } else if (fieldID.equals(FID_ANY_FLUX_SET)) {
            boolean bl = Boolean.parseBoolean(object.toString());
            this.fluxComment.setVisible(bl);
        } else {
            if (fieldID.equals(FID_LINE_WIDTH)) {
                super.update(FID_LINE_WIDTH, object);
                super.update(FID_LINE_WIDTH_CALC, object);
                super.update(FID_LINE_WIDTH_AGAIN, object);
                boolean bl = object == null || object instanceof String && !StringUtils.contains((CharSequence)((String)object), (CharSequence)"0.00 nm/s");
                this.correlatorFieldsSection.setVisible(bl);
                return;
            }
            if (TJEditorEnum.isMember(fieldID)) {
                if (object == null) {
                    this.showJustificationEditor(false, TJEditorEnum.getEditor(fieldID));
                    return;
                }
                this.showJustificationEditor(true, TJEditorEnum.getEditor(fieldID));
                OTBasicTextArea oTBasicTextArea = (OTBasicTextArea)this.retrieve(fieldID);
                if (oTBasicTextArea != null) {
                    String string = (String)object;
                    oTBasicTextArea.setText(string);
                }
                return;
            }
            if (fieldID.equals(DISPLAY_NON_STD_SECTION)) {
                boolean bl = Boolean.parseBoolean(object.toString());
                this.nonStandardGroup.setEnabled(bl);
                this.nonStandardGroup.setVisible(bl);
                return;
            }
            if (fieldID.equals(FID_LINEWIDTH_GREATER_THAN_SPW_WARNING)) {
                boolean bl = Boolean.parseBoolean(object.toString());
                linewidthGreaterThanSPWWarning.setEnabled(bl);
                linewidthGreaterThanSPWWarning.setVisible(bl);
                return;
            }
            if (fieldID.equals(FID_IS_VLBI)) {
                boolean bl = Boolean.parseBoolean(object.toString());
                boolean bl2 = !bl;
                this.sensitivityGroup.setVisible(bl2);
                this.imagingGroup.setVisible(bl2);
                this.correlatorGroup.setVisible(bl2);
                return;
            }
            if (fieldID.equals(FID_IS_SOLAR)) {
                boolean bl = Boolean.parseBoolean(object.toString());
                boolean bl3 = !bl;
                this.sensitivityGroup.setVisible(bl3);
                this.imagingGroup.setVisible(bl3);
                this.correlatorGroup.setVisible(bl3);
                return;
            }
        }
        super.update(fieldID, object);
    }

    private void showJustificationEditor(boolean bl, @NonNull TJEditorEnum tJEditorEnum) {
        if (tJEditorEnum == null) {
            throw new NullPointerException("ed is marked non-null but is null");
        }
        JComponent jComponent = this.getComponent(tJEditorEnum.id);
        JComponent jComponent2 = this.getComponent(tJEditorEnum.labelId);
        if (jComponent != null) {
            jComponent.setVisible(bl);
            jComponent2.setVisible(bl);
        }
    }

    private JComponent createEditorBoxWithLabel(TJEditorEnum tJEditorEnum) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel = new JLabel(tJEditorEnum.label);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jLabel);
        this.register(jLabel, tJEditorEnum.labelId);
        OTBasicTextArea oTBasicTextArea = this.makeOTBasicTextArea(tJEditorEnum.id, tJEditorEnum.label, 800, 150, true);
        Font font = oTBasicTextArea.getFont();
        oTBasicTextArea.setFont(font.deriveFont(font.getSize2D() + 1.0f));
        this.addComponent(4, jPanel, gridBagLayout, gridBagConstraints, oTBasicTextArea);
        this.register(oTBasicTextArea, tJEditorEnum.id);
        return jPanel;
    }

    private static JLabel decoratedWarningLabel(String string) {
        StringBuilder stringBuilder = new StringBuilder("<html>").append(string).append("</html>");
        JLabel jLabel = new JLabel(stringBuilder.toString());
        jLabel.setForeground(Colors.OT_BLUE);
        Rectangle rectangle = jLabel.getBounds();
        rectangle.setSize((int)((double)rectangle.width * 1.5), (int)((double)rectangle.height * 1.5));
        jLabel.setBounds(rectangle);
        jLabel.setMinimumSize(new Dimension(rectangle.width, rectangle.height));
        return jLabel;
    }

    public static void main(String[] stringArray) {
        Log.setRuntimeImplementation((Log.LoggerProvider)new LogLoggerProviderImpl());
        UnitMapConfigurator.configureUnitMaps();
        TechnicalJustificationModel technicalJustificationModel = new TechnicalJustificationModel(null);
        TechnicalJustificationEditor technicalJustificationEditor = new TechnicalJustificationEditor(technicalJustificationModel);
        TechnicalJustificationEditor.runTestApp(technicalJustificationEditor);
    }
}

