/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.DataRate;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringEscapeUtils;

public class ProjectTimeEstimateSummary {
    protected final Map<ScienceGoal, Map<TimeTableColTypes, Time>> estimatedTotalTimeData = new HashMap<ScienceGoal, Map<TimeTableColTypes, Time>>();
    protected final Map<ScienceGoal, String> scienceGoalNameMap = new LinkedHashMap<ScienceGoal, String>();
    protected final Map<ScienceGoal, Map<TimeTableColTypes, Time>> estimatedCalibrationTimeData = new HashMap<ScienceGoal, Map<TimeTableColTypes, Time>>();
    protected final Map<ScienceGoal, Map<DataTableColTypes, DataRate>> estimatedDataRates = new HashMap<ScienceGoal, Map<DataTableColTypes, DataRate>>();
    protected final Map<ScienceGoal, Map<DataTableColTypes, StorageVolume>> estimatedDataVolume = new HashMap<ScienceGoal, Map<DataTableColTypes, StorageVolume>>();
    protected Map<ScienceGoal, Boolean> badlyConfiguredScienceGoals = new HashMap<ScienceGoal, Boolean>();
    private Map<TimeTableColTypes, Time> overallTimeMap = new HashMap<TimeTableColTypes, Time>();
    private final Map<ScienceGoal, Time> overallSGTimeMap = new HashMap<ScienceGoal, Time>();

    protected static String formatStorageVolume(@NonNull StorageVolume storageVolume) {
        if (storageVolume == null) {
            throw new NullPointerException("volumeToFormat is marked non-null but is null");
        }
        double d = storageVolume.getContentInDefaultUnits();
        if (storageVolume.isZero() || Double.isNaN(d) || Double.isInfinite(d)) {
            return "-";
        }
        return TextUtils.format(storageVolume.convertToFriendlyUnit(), 2);
    }

    protected static String formatDataRate(@NonNull DataRate dataRate) {
        if (dataRate == null) {
            throw new NullPointerException("dataRateToFormat is marked non-null but is null");
        }
        double d = dataRate.getContentInDefaultUnits();
        if (dataRate.isZero() || Double.isNaN(d) || Double.isInfinite(d)) {
            return "-";
        }
        dataRate.convertToUnit(DataRate.UNIT_MB_S);
        return TextUtils.format(dataRate, 2);
    }

    protected static String formatTime(@NonNull Time time) {
        if (time == null) {
            throw new NullPointerException("timeToFormat is marked non-null but is null");
        }
        if (time.isZero()) {
            return "-";
        }
        return TextUtils.format(time.convertToFriendlyUnit(), 2);
    }

    /*
     * WARNING - void declaration
     */
    protected String build() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        stringBuilder.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        stringBuilder.append("<head>");
        stringBuilder.append("<style>\n");
        stringBuilder.append("@import url('https://fonts.googleapis.com/css?family=Lato');\n");
        stringBuilder.append("table {");
        stringBuilder.append("text-shadow: 0 1px rgba(255,255,255,.8);");
        stringBuilder.append("-moz-border-radius: 5px;-webkit-border-radius: 5px;\tborder-radius: 5px;\t-moz-box-shadow: 10px 0 10px -10px rgba(0, 0, 0, .15), -10px 0 10px -10px rgba(0, 0, 0, .15);");
        stringBuilder.append("-webkit-box-shadow: 10px 0 10px -10px rgba(0, 0, 0, .15), -10px 0 10px -10px rgba(0, 0, 0, .15);");
        stringBuilder.append("box-shadow: 10px 0 10px -10px rgba(0, 0, 0, .15), -10px 0 10px -10px rgba(0, 0, 0, .15);}");
        stringBuilder.append("td {");
        stringBuilder.append("padding: 5px;");
        stringBuilder.append("text-align: left;");
        stringBuilder.append("border-bottom: 1px solid #ddd;");
        stringBuilder.append("}");
        stringBuilder.append("table {");
        stringBuilder.append("width: 100%;");
        stringBuilder.append("}");
        stringBuilder.append("tr:hover {");
        stringBuilder.append("background-color: #EEEEEE;");
        stringBuilder.append("-webkit-box-shadow: 0 6px 6px -6px #EEEEEE;");
        stringBuilder.append("-moz-box-shadow: 0 6px 6px -6px #EEEEEE;");
        stringBuilder.append("box-shadow: 0 6px 6px -6px #EEEEEE;");
        stringBuilder.append("}");
        stringBuilder.append("td.overall {");
        stringBuilder.append("text-align: left;");
        stringBuilder.append("background-color: #DEEAF6;");
        stringBuilder.append("border-bottom: 1px solid #ddd;");
        stringBuilder.append("}");
        stringBuilder.append("td.error {");
        stringBuilder.append("text-align: left;");
        stringBuilder.append("color: ##f0000;");
        stringBuilder.append("border-bottom: 1px solid #ddd;");
        stringBuilder.append("}");
        stringBuilder.append("td.header {");
        stringBuilder.append("text-align: left;");
        stringBuilder.append("background-color: #DEEAF6;");
        stringBuilder.append("border-bottom: 1px solid #ddd;");
        stringBuilder.append("}");
        stringBuilder.append("th {");
        stringBuilder.append("background-color: #BDD6EE;");
        stringBuilder.append("color: #202020;");
        stringBuilder.append("padding: 5px;");
        stringBuilder.append("text-align: left;");
        stringBuilder.append("border-bottom: 1px solid #ddd;");
        stringBuilder.append("}");
        stringBuilder.append("</style>");
        stringBuilder.append("</head>");
        stringBuilder.append("<body>\n");
        stringBuilder.append("<center>\n");
        stringBuilder.append("<h1> Total and Calibration Times</h1>\n");
        stringBuilder.append("<table>\n");
        stringBuilder.append("<tr><th>Science Goal</th><th colspan=\"2\">" + TimeTableColTypes.TWELVEMEXT.getLabel() + "</th><th colspan=\"2\">" + TimeTableColTypes.TWELVEMCOMPACT.getLabel() + "</th><th colspan=\"2\">" + TimeTableColTypes.COMBINEDTWELVEM.getLabel() + "</th><th colspan=\"2\">" + TimeTableColTypes.ACA7M.getLabel() + "</th><th colspan=\"2\">" + TimeTableColTypes.ACATP.getLabel() + "</th><th colspan=\"2\">Overall</th></tr>\n");
        stringBuilder.append("<tr><td  class=\"header\">&nbsp;</td><td class=\"header\">Tot.</td><td class=\"header\"> Cal.</td><td class=\"header\">Tot.</td><td class=\"header\"> Cal.</td><td class=\"header\">Tot.</td><td class=\"header\"> Cal.</td><td class=\"header\">Tot.</td><td class=\"header\"> Cal.</td><td class=\"header\">Tot.</td><td class=\"header\"> Cal.</td><td class=\"header\">Tot.</td><td class=\"header\"> Cal.</td></tr>\n");
        HashMap<TimeTableColTypes, Time> hashMap = new HashMap<TimeTableColTypes, Time>();
        HashMap<TimeTableColTypes, Time> hashMap2 = new HashMap<TimeTableColTypes, Time>();
        for (TimeTableColTypes object2 : TimeTableColTypes.values()) {
            hashMap.put(object2, Time.createTime());
            hashMap2.put(object2, Time.createTime());
        }
        for (ScienceGoal scienceGoal : this.scienceGoalNameMap.keySet()) {
            String string = StringEscapeUtils.escapeHtml4((String)this.scienceGoalNameMap.get(scienceGoal));
            if (this.badlyConfiguredScienceGoals.containsKey(scienceGoal)) {
                stringBuilder.append("<tr color=\"red\"><td class=\"td.error\" >" + string + "</td>");
            } else {
                stringBuilder.append("<tr><td>" + string + "</td>");
            }
            Object var8_14 = null;
            Time time = null;
            Map<TimeTableColTypes, Time> map = this.estimatedTotalTimeData.get(scienceGoal);
            Map<TimeTableColTypes, Time> map2 = this.estimatedCalibrationTimeData.get(scienceGoal);
            for (TimeTableColTypes timeTableColTypes : EnumSet.range(TimeTableColTypes.TWELVEMEXT, TimeTableColTypes.OVERALL)) {
                void var8_19;
                switch (timeTableColTypes) {
                    case TWELVEMCOMPACT: 
                    case TWELVEMEXT: 
                    case ACA7M: 
                    case ACATP: {
                        Time time2 = map.get((Object)timeTableColTypes);
                        time = map2.get((Object)timeTableColTypes);
                        break;
                    }
                    case COMBINEDTWELVEM: {
                        Time time3 = (Time)map.get((Object)TimeTableColTypes.TWELVEMEXT).plus((AbstractDoubleWithUnit)map.get((Object)TimeTableColTypes.TWELVEMCOMPACT));
                        time = (Time)map2.get((Object)TimeTableColTypes.TWELVEMEXT).plus((AbstractDoubleWithUnit)map2.get((Object)TimeTableColTypes.TWELVEMCOMPACT));
                        break;
                    }
                    case OVERALL: {
                        Time time4 = map.get((Object)TimeTableColTypes.ACA7M).isGreaterThan((AbstractDoubleWithUnit)map.get((Object)TimeTableColTypes.ACATP)) ? map.get((Object)TimeTableColTypes.ACA7M) : map.get((Object)TimeTableColTypes.ACATP);
                        Time time5 = map2.get((Object)TimeTableColTypes.ACA7M).isGreaterThan((AbstractDoubleWithUnit)map2.get((Object)TimeTableColTypes.ACATP)) ? map2.get((Object)TimeTableColTypes.ACA7M) : map2.get((Object)TimeTableColTypes.ACATP);
                        Time time6 = (Time)((Time)map.get((Object)TimeTableColTypes.TWELVEMEXT).plus((AbstractDoubleWithUnit)map.get((Object)TimeTableColTypes.TWELVEMCOMPACT))).plus((AbstractDoubleWithUnit)time4);
                        time = (Time)((Time)map2.get((Object)TimeTableColTypes.TWELVEMEXT).plus((AbstractDoubleWithUnit)map2.get((Object)TimeTableColTypes.TWELVEMCOMPACT))).plus((AbstractDoubleWithUnit)time5);
                        Log.logger(ProjectTimeEstimateSummary.class).finest("Total Result: totalTime : " + time6 + " , totalCalibTime :" + time);
                        this.overallSGTimeMap.put(scienceGoal, time6.deepCopy());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown column type specified");
                    }
                }
                hashMap.put(timeTableColTypes, (Time)((Time)hashMap.get((Object)timeTableColTypes)).plus((AbstractDoubleWithUnit)var8_19));
                hashMap2.put(timeTableColTypes, (Time)((Time)hashMap2.get((Object)timeTableColTypes)).plus((AbstractDoubleWithUnit)time));
                stringBuilder.append("<td>" + ProjectTimeEstimateSummary.formatTime((Time)var8_19) + "</td><td>" + ProjectTimeEstimateSummary.formatTime(time) + "</td>");
            }
            stringBuilder.append("</tr>");
        }
        stringBuilder.append("<tr><td  class=\"overall\">Overall</td>");
        for (TimeTableColTypes timeTableColTypes : EnumSet.range(TimeTableColTypes.TWELVEMEXT, TimeTableColTypes.OVERALL)) {
            stringBuilder.append("<td class=\"overall\">" + ProjectTimeEstimateSummary.formatTime((Time)hashMap.get((Object)timeTableColTypes)) + "</td><td class=\"overall\">" + ProjectTimeEstimateSummary.formatTime((Time)hashMap2.get((Object)timeTableColTypes)) + "</td>");
        }
        stringBuilder.append("</tr>\n");
        stringBuilder.append("</table>\n");
        stringBuilder.append("<h1>Data Volumes and Data Rates</h1>\n");
        stringBuilder.append("<table>\n");
        stringBuilder.append("<tr><th>Science Goal</th><th colspan=\"3\"> Data Volume </th> <th colspan=\"3\"> Avg. Data Rate</th></tr>\n");
        stringBuilder.append("<tr><td  class=\"header\">&nbsp;</td><td class=\"header\">" + DataTableColTypes.TWELVEM.getLabel() + "</td><td class=\"header\">" + DataTableColTypes.ACA7M.getLabel() + "</td><td class=\"header\">" + DataTableColTypes.ACATP.getLabel() + "</td><td class=\"header\">" + DataTableColTypes.TWELVEM.getLabel() + "</td><td class=\"header\">" + DataTableColTypes.ACA7M.getLabel() + "</td><td class=\"header\">" + DataTableColTypes.ACATP.getLabel() + "</td></tr>\n");
        HashMap hashMap3 = new HashMap();
        HashMap<DataTableColTypes, StorageVolume> hashMap4 = new HashMap<DataTableColTypes, StorageVolume>();
        for (DataTableColTypes dataTableColTypes : DataTableColTypes.values()) {
            hashMap3.put(dataTableColTypes, DataRate.createDataRate());
            hashMap4.put(dataTableColTypes, StorageVolume.createStorageVolume());
        }
        for (ScienceGoal scienceGoal : this.scienceGoalNameMap.keySet()) {
            String string = StringEscapeUtils.escapeHtml4((String)this.scienceGoalNameMap.get(scienceGoal));
            if (this.badlyConfiguredScienceGoals.containsKey(scienceGoal)) {
                stringBuilder.append("<tr class=\"td.error\" color=\"red\"><td class=\"td.error\" >" + string + "</td>\n");
            } else {
                stringBuilder.append("<tr><td>" + string + "</td>");
            }
            Map<DataTableColTypes, StorageVolume> map = this.estimatedDataVolume.get(scienceGoal);
            Map<DataTableColTypes, DataRate> map3 = this.estimatedDataRates.get(scienceGoal);
            stringBuilder.append("<td>" + ProjectTimeEstimateSummary.formatStorageVolume(map.get((Object)DataTableColTypes.TWELVEM)) + "</td><td>" + ProjectTimeEstimateSummary.formatStorageVolume(map.get((Object)DataTableColTypes.ACA7M)) + "</td><td>" + ProjectTimeEstimateSummary.formatStorageVolume(map.get((Object)DataTableColTypes.ACATP)) + "</td><td>" + ProjectTimeEstimateSummary.formatDataRate((DataRate)((Object)map3.get((Object)DataTableColTypes.TWELVEM))) + "</td><td>" + ProjectTimeEstimateSummary.formatDataRate((DataRate)((Object)map3.get((Object)DataTableColTypes.ACA7M))) + "</td><td>" + ProjectTimeEstimateSummary.formatDataRate((DataRate)((Object)map3.get((Object)DataTableColTypes.ACATP))) + "</td></tr>\n");
            for (DataTableColTypes dataTableColTypes : DataTableColTypes.values()) {
                hashMap3.put(dataTableColTypes, (DataRate)((DataRate)((Object)hashMap3.get((Object)dataTableColTypes))).plus((AbstractDoubleWithUnit)((DataRate)((Object)map3.get((Object)dataTableColTypes)))));
                hashMap4.put(dataTableColTypes, (StorageVolume)((StorageVolume)((Object)hashMap4.get((Object)dataTableColTypes))).plus((AbstractDoubleWithUnit)map.get((Object)dataTableColTypes)));
            }
        }
        stringBuilder.append("<tr><td class=\"header\">Overall</td><td class=\"header\">" + ProjectTimeEstimateSummary.formatStorageVolume((StorageVolume)((Object)hashMap4.get((Object)DataTableColTypes.TWELVEM))) + "</td><td class=\"header\">" + ProjectTimeEstimateSummary.formatStorageVolume((StorageVolume)((Object)hashMap4.get((Object)DataTableColTypes.ACA7M))) + "</td><td class=\"header\">" + ProjectTimeEstimateSummary.formatStorageVolume(((StorageVolume)((Object)hashMap4.get((Object)DataTableColTypes.ACATP))).convertToFriendlyUnit()) + "</td><td class=\"header\"> &nbsp;</td><td class=\"header\"> &nbsp; </td><td class=\"header\"> &nbsp; </td></tr>\n");
        stringBuilder.append("</table></center></body></html>\n");
        this.overallTimeMap = hashMap;
        return stringBuilder.toString();
    }

    public Time getOverallTime() {
        return this.overallTimeMap.get((Object)TimeTableColTypes.OVERALL);
    }

    public Map<ScienceGoal, Map<TimeTableColTypes, Time>> getEstimatedTotalTimeData() {
        return this.estimatedTotalTimeData;
    }

    public Map<TimeTableColTypes, Time> getOverallTimeMap() {
        return this.overallTimeMap;
    }

    public Map<ScienceGoal, Time> getOverallSGTimeMap() {
        return this.overallSGTimeMap;
    }

    protected static enum DataTableColTypes {
        TWELVEM("12-m (1+2)"),
        ACA7M("ACA 7-m"),
        ACATP("ACA TP");

        private final String label;

        private DataTableColTypes(String string2) {
            this.label = string2;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum TimeTableColTypes {
        TWELVEMEXT("12-m (1)"),
        TWELVEMCOMPACT("12-m (2)"),
        COMBINEDTWELVEM("12-m (1+2)"),
        ACA7M("ACA 7-m"),
        ACATP("ACA TP"),
        OVERALL("Overall");

        private final String label;

        private TimeTableColTypes(String string2) {
            this.label = string2;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

