/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.editors.sciencegoals.TimeEstimateFactory;
import alma.obsprep.ot.editors.sciencegoals.TimeEstimateInterface;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.DeclinationData;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import lombok.NonNull;

public class EstimatedTimeInfoBuilder {
    private final ScienceGoal sg;

    public EstimatedTimeInfoBuilder(PerformanceParameters performanceParameters) {
        this.sg = performanceParameters.getScienceGoal();
        if (this.sg == null) {
            throw new IllegalArgumentException("Can not find the parent ScienceGoal from this PerformanceParameters");
        }
    }

    public JDialog buildTimeEstimateDialogWindow(TimeEstimateModel timeEstimateModel) {
        JDialog jDialog = new JDialog();
        jDialog.setTitle("Time Estimate");
        jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        jDialog.setSize(timeEstimateModel.getDialogWindowDimensions());
        jDialog.setDefaultCloseOperation(2);
        Container container = jDialog.getContentPane();
        JLabel jLabel = this.createHeader(timeEstimateModel.getHeader());
        Border border = BorderFactory.createEmptyBorder(10, 60, 10, 10);
        jLabel.setBorder(border);
        container.add((Component)jLabel, "First");
        JTabbedPane jTabbedPane = this.createClusterSpecificTimeEstimateTabbedPane(timeEstimateModel);
        container.add((Component)jTabbedPane, "Center");
        JButton jButton = new JButton("Close");
        jButton.addActionListener(actionEvent -> {
            jDialog.setVisible(false);
            jDialog.dispose();
        });
        container.add((Component)jButton, "Last");
        JFrame jFrame = GuiFactory.getFactory().getParentWindow();
        jDialog.setLocationRelativeTo(jFrame);
        return jDialog;
    }

    private JTabbedPane createClusterSpecificTimeEstimateTabbedPane(@NonNull TimeEstimateModel timeEstimateModel) {
        if (timeEstimateModel == null) {
            throw new NullPointerException("timeEstimate is marked non-null but is null");
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        List<ClusterTimeInfo> list = timeEstimateModel.getSbSpecificInformationBlock();
        assert (!list.isEmpty());
        int n = 1;
        for (ClusterTimeInfo clusterTimeInfo : list) {
            JPanel jPanel = new JPanel();
            JScrollPane jScrollPane = null;
            Border border = BorderFactory.createEmptyBorder(5, 3, 5, 3);
            try {
                jScrollPane = this.createTargetListPanel(clusterTimeInfo);
                jScrollPane.setBorder(border);
            }
            catch (InvalidCoordException | OutOfRangeException exception) {
                // empty catch block
            }
            JScrollPane jScrollPane2 = null;
            try {
                jScrollPane2 = this.createConfigurationListPanel(clusterTimeInfo);
                jScrollPane2.setBorder(border);
            }
            catch (InvalidCoordException | OutOfRangeException exception) {
                // empty catch block
            }
            assert (jScrollPane2 != null && jScrollPane != null) : "Unable to create configuration/target list panel";
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append("<head><style> table { border-collapse: collapse; }table</style></head>");
            stringBuilder.append("<body>");
            stringBuilder.append("<table cellpadding=1>");
            for (List<String> list2 : clusterTimeInfo.getKeyValuePairs()) {
                assert (list2.size() == 2);
                stringBuilder.append("<tr><td>");
                stringBuilder.append(list2.get(0));
                stringBuilder.append("</td><td>");
                stringBuilder.append(list2.get(1));
                stringBuilder.append("</td></tr>");
            }
            stringBuilder.append("</table>");
            stringBuilder.append("</body></html>");
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            Border border2 = BorderFactory.createEmptyBorder(10, 0, 10, 0);
            jPanel.add(jScrollPane);
            JLabel object2 = new JLabel("<html><center><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Possible Configuration Combinations</b></center></html>");
            jPanel.add(object2);
            jPanel.add(jScrollPane2);
            JLabel jLabel = new JLabel();
            jLabel.setText(stringBuilder.toString());
            jLabel.setBorder(border2);
            jPanel.add(jLabel);
            jPanel.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, 100), new Dimension(0, 100)));
            JScrollPane jScrollPane3 = new JScrollPane(jPanel);
            jScrollPane3.setBorder(BorderFactory.createLoweredBevelBorder());
            jTabbedPane.addTab(String.format("Cluster %d", n++), jScrollPane3);
        }
        return jTabbedPane;
    }

    private JScrollPane createTargetListPanel(ClusterTimeInfo clusterTimeInfo) throws OutOfRangeException, InvalidCoordException {
        EventListener eventListener;
        Object[] objectArray = new String[]{"Source Name", "RA", "Dec", "Velocity"};
        TargetParameters[] targetParametersArray = clusterTimeInfo.getClusterSpecificScienceGoal().getTargetParameters();
        Object[][] objectArray2 = new Object[targetParametersArray.length][objectArray.length];
        for (int i = 0; i < targetParametersArray.length; ++i) {
            eventListener = targetParametersArray[i].deepCopy();
            if (eventListener.getSourceCoordinates().isGalactic()) {
                eventListener.getSourceCoordinates().convertToICRS();
            }
            eventListener.getSourceVelocityInDefaultReferenceFrame(Optional.of(clusterTimeInfo.getClusterSpecificScienceGoal()));
            objectArray2[i][0] = eventListener.getSourceName();
            objectArray2[i][1] = eventListener.getSourceCoordinates().getLongitude().toHHMMSS();
            objectArray2[i][2] = eventListener.getSourceCoordinates().getLatitude().toDDMMSS();
            objectArray2[i][3] = TextUtils.format(eventListener.getSourceVelocity().getCenterVelocity(), 3);
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray2, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        eventListener = new JTable(defaultTableModel);
        ((JTable)eventListener).getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)eventListener));
        ((JTable)eventListener).setFillsViewportHeight(true);
        jScrollPane.setVisible(true);
        ((JTable)eventListener).setPreferredScrollableViewportSize(new Dimension(100, 63));
        ((JComponent)((Object)eventListener)).setBorder(BorderFactory.createLoweredBevelBorder());
        return jScrollPane;
    }

    private JScrollPane createConfigurationListPanel(ClusterTimeInfo clusterTimeInfo) throws OutOfRangeException, InvalidCoordException {
        Object object;
        Object object2;
        Object[] objectArray = new String[]{"12-m (1)", "12-m (2)", "7-m", "TP", "Nominal Beam(\")", "<html><center>Max expected<br>axial ratio<center></html>"};
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = clusterTimeInfo.getScienceGoalConfigurations();
        Collections.sort(scienceGoalConfigurations);
        Object[][] objectArray2 = new Object[scienceGoalConfigurations.size()][6];
        for (int i = 0; i < scienceGoalConfigurations.size(); ++i) {
            object2 = (ConfigurationSet)scienceGoalConfigurations.get(i);
            objectArray2[i][0] = ((ConfigurationSet)object2).getTM1Configuration().orElse(Configuration.NO_CONFIG).getName();
            objectArray2[i][1] = ((ConfigurationSet)object2).getTM2Configuration().orElse(Configuration.NO_CONFIG).getName();
            objectArray2[i][2] = ((ConfigurationSet)object2).isACA7mRequired() ? "Yes" : "No";
            objectArray2[i][3] = ((ConfigurationSet)object2).isTPRequired() ? "Yes" : "No";
            boolean bl = clusterTimeInfo.clusterSpecificScienceGoal.isStandAloneACA();
            int n = i;
            if (bl) {
                objectArray2[n][4] = "N/A";
                objectArray2[n][5] = "N/A";
                continue;
            }
            object = Configuration.determineAverageDeclination(clusterTimeInfo.clusterSpecificScienceGoal.getTargetParameters());
            ((ConfigurationSet)object2).getTM1Configuration().ifPresent(arg_0 -> EstimatedTimeInfoBuilder.lambda$createConfigurationListPanel$1((Angle)((Object)object), clusterTimeInfo, objectArray2, n, arg_0));
            objectArray2[n][5] = String.format("%3.2g", SchedulingConstraints.calculateMaxExpectedAxialRatio(((Angle)((Object)object)).getDegs()));
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray2, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        object2 = new JTable(defaultTableModel);
        JTableHeader jTableHeader = ((JTable)object2).getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setPreferredSize(new Dimension(100, 40));
        TableColumnModel tableColumnModel = ((JTable)object2).getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(30);
        tableColumnModel.getColumn(1).setPreferredWidth(30);
        tableColumnModel.getColumn(2).setPreferredWidth(30);
        tableColumnModel.getColumn(3).setPreferredWidth(30);
        tableColumnModel.getColumn(4).setPreferredWidth(100);
        object = new JScrollPane((Component)object2);
        ((JTable)object2).setFillsViewportHeight(true);
        ((JComponent)object).setVisible(true);
        ((JTable)object2).setPreferredScrollableViewportSize(new Dimension(200, 92));
        ((JComponent)object2).setBorder(BorderFactory.createLoweredBevelBorder());
        return object;
    }

    private JLabel createHeader(List<List<String>> list) {
        JLabel jLabel = new JLabel();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<head><style> table { border-collapse: collapse; }table</style></head>");
        stringBuilder.append("<body>");
        stringBuilder.append("<table cellpadding=1>");
        for (List<String> list2 : list) {
            assert (list2.size() == 2);
            stringBuilder.append("<tr><td>");
            stringBuilder.append(list2.get(0));
            stringBuilder.append("</td><td>");
            stringBuilder.append(list2.get(1));
            stringBuilder.append("</td></tr>");
        }
        stringBuilder.append("</table>");
        stringBuilder.append("</body></html>");
        jLabel.setText(stringBuilder.toString());
        return jLabel;
    }

    public TimeEstimateModel buildTimeEstimateModel() throws TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        TimeEstimateInterface timeEstimateInterface;
        SpectralSetupParameters spectralSetupParameters = this.sg.getSpectralSetupParameters();
        if (spectralSetupParameters.isFullPolarisation() && !this.sg.isStandAloneACA() && this.sg.getPerformanceParameters().getUseACA() && !Telescope.isOTConfiguredAs(Telescope.CSVALMA)) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("The ACA cannot be selected when full polarization is requested.");
        }
        try {
            timeEstimateInterface = this.sg.isSolarScienceGoal() ? TimeEstimateFactory.getTimeEstimateModelGenerator(TimeEstimateFactory.TimeEstimate.SOLAR) : (this.sg.getObsProposal().isVLBIorPhasedArray() ? TimeEstimateFactory.getTimeEstimateModelGenerator(TimeEstimateFactory.TimeEstimate.VLBI) : TimeEstimateFactory.getTimeEstimateModelGenerator(TimeEstimateFactory.TimeEstimate.STANDARD));
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to determine if the science goal is solar : " + unknownEntityException.getMessage());
        }
        assert (timeEstimateInterface != null);
        return timeEstimateInterface.generateTimeEstimateModel(this.sg);
    }

    private static /* synthetic */ void lambda$createConfigurationListPanel$1(Angle angle, ClusterTimeInfo clusterTimeInfo, Object[][] objectArray, int n, Configuration configuration) {
        try {
            DeclinationData declinationData = Configuration.getConfigurationPerformanceDataForDeclination(RequestedArray.TWELVE_M, configuration, angle);
            Frequency frequency = clusterTimeInfo.clusterSpecificScienceGoal.getSpectralSetupParameters().getRepresentativeFrequencyWithSkyOffset();
            double d = declinationData.getScaledMinorAxis(frequency).getArcsec();
            double d2 = declinationData.getScaledMajorAxis(frequency).getArcsec();
            DecimalFormat decimalFormat = new DecimalFormat("#.###");
            decimalFormat.setRoundingMode(RoundingMode.CEILING);
            objectArray[n][4] = decimalFormat.format(d) + " x " + decimalFormat.format(d2);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            // empty catch block
        }
    }

    public static class TimeEstimateModel {
        private Dimension dialogWindowDimensions = null;
        private ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = new ScienceGoalConfigurations();
        private ScienceGoal clusterSpecificScienceGoal = null;
        private final List<List<String>> header = new ArrayList<List<String>>();
        private final List<ClusterTimeInfo> sbSpecificInformationBlock = new ArrayList<ClusterTimeInfo>();
        private List<List<String>> keyValuePairBuffer = new ArrayList<List<String>>();
        private final List<List<String>> footer = new ArrayList<List<String>>();

        public List<ClusterTimeInfo> getSbSpecificInformationBlock() {
            return Collections.unmodifiableList(this.sbSpecificInformationBlock);
        }

        public void commitClusterSpecificData() {
            ClusterTimeInfo clusterTimeInfo = new ClusterTimeInfo();
            clusterTimeInfo.setKeyValuePairs(this.keyValuePairBuffer);
            assert (this.clusterSpecificScienceGoal != null);
            clusterTimeInfo.setClusterSpecificScienceGoal(this.clusterSpecificScienceGoal);
            clusterTimeInfo.setScienceGoalConfigurations(this.scienceGoalConfigurations);
            this.scienceGoalConfigurations = new ScienceGoalConfigurations();
            this.sbSpecificInformationBlock.add(clusterTimeInfo);
            this.keyValuePairBuffer = new ArrayList<List<String>>();
            this.clusterSpecificScienceGoal = null;
        }

        public void addClusterSpecificKeyValuePair(@NonNull String string, String string2) {
            if (string == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.keyValuePairBuffer.add(Arrays.asList(string, string2));
        }

        public void addToHeader(@NonNull String string, String string2) {
            if (string == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.header.add(Arrays.asList(string, string2));
        }

        public void addToFooter(@NonNull String string, String string2) {
            if (string == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.footer.add(Arrays.asList(string, string2));
        }

        public Dimension getDialogWindowDimensions() {
            return this.dialogWindowDimensions;
        }

        public void setDialogWindowDimensions(Dimension dimension) {
            this.dialogWindowDimensions = dimension;
        }

        public void setScienceGoalConfigurations(ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations) {
            this.scienceGoalConfigurations = scienceGoalConfigurations;
        }

        public void setClusterSpecificScienceGoal(ScienceGoal scienceGoal) {
            this.clusterSpecificScienceGoal = scienceGoal;
        }

        public List<List<String>> getHeader() {
            return this.header;
        }

        public List<List<String>> getFooter() {
            return this.footer;
        }
    }

    public static class ClusterTimeInfo {
        private List<List<String>> keyValuePairs = new ArrayList<List<String>>();
        private ScienceGoal clusterSpecificScienceGoal = null;
        private ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = new ScienceGoalConfigurations();

        public List<List<String>> getKeyValuePairs() {
            return this.keyValuePairs;
        }

        public ScienceGoal getClusterSpecificScienceGoal() {
            return this.clusterSpecificScienceGoal;
        }

        public ScienceGoalConfigurations<ConfigurationSet> getScienceGoalConfigurations() {
            return this.scienceGoalConfigurations;
        }

        public void setKeyValuePairs(List<List<String>> list) {
            this.keyValuePairs = list;
        }

        public void setClusterSpecificScienceGoal(ScienceGoal scienceGoal) {
            this.clusterSpecificScienceGoal = scienceGoal;
        }

        public void setScienceGoalConfigurations(ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations) {
            this.scienceGoalConfigurations = scienceGoalConfigurations;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ClusterTimeInfo)) {
                return false;
            }
            ClusterTimeInfo clusterTimeInfo = (ClusterTimeInfo)object;
            if (!clusterTimeInfo.canEqual(this)) {
                return false;
            }
            List<List<String>> list = this.getKeyValuePairs();
            List<List<String>> list2 = clusterTimeInfo.getKeyValuePairs();
            if (list == null ? list2 != null : !((Object)list).equals(list2)) {
                return false;
            }
            ScienceGoal scienceGoal = this.getClusterSpecificScienceGoal();
            ScienceGoal scienceGoal2 = clusterTimeInfo.getClusterSpecificScienceGoal();
            if (scienceGoal == null ? scienceGoal2 != null : !scienceGoal.equals(scienceGoal2)) {
                return false;
            }
            ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = this.getScienceGoalConfigurations();
            ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations2 = clusterTimeInfo.getScienceGoalConfigurations();
            return !(scienceGoalConfigurations == null ? scienceGoalConfigurations2 != null : !((Object)scienceGoalConfigurations).equals(scienceGoalConfigurations2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof ClusterTimeInfo;
        }

        public int hashCode() {
            int n = 1;
            List<List<String>> list = this.getKeyValuePairs();
            n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
            ScienceGoal scienceGoal = this.getClusterSpecificScienceGoal();
            n = n * 59 + (scienceGoal == null ? 43 : scienceGoal.hashCode());
            ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = this.getScienceGoalConfigurations();
            n = n * 59 + (scienceGoalConfigurations == null ? 43 : ((Object)scienceGoalConfigurations).hashCode());
            return n;
        }

        public String toString() {
            return "EstimatedTimeInfoBuilder.ClusterTimeInfo(keyValuePairs=" + this.getKeyValuePairs() + ", clusterSpecificScienceGoal=" + this.getClusterSpecificScienceGoal() + ", scienceGoalConfigurations=" + this.getScienceGoalConfigurations() + ")";
        }
    }
}

