/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.schedblock.TargetModel;
import alma.obsprep.ot.models.schedblock.UsedByTargetModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class UsedByTargetPanel
extends Editor {
    private JButton editOnlyThisButton;

    public UsedByTargetPanel(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    protected void build() {
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel();
        this.initEvents(jLabel, ((UsedByTargetModel)this.getModel()).FID_WARNING_LABEL);
        this.add((Component)jLabel, "West");
        this.editOnlyThisButton = new JButton("Edit Only This");
        this.editOnlyThisButton.setToolTipText("<html>Editing this parameter set affects all the targets use it.<br>If you want to change only this target, click this button.</html>");
        this.initEvents(this.editOnlyThisButton, ((UsedByTargetModel)this.getModel()).FID_ONLYTHIS_BUTTON);
        this.add((Component)this.editOnlyThisButton, "East");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        ObservingToolGui observingToolGui;
        UsedByTargetModel usedByTargetModel = (UsedByTargetModel)this.getModel();
        if (fieldID == usedByTargetModel.FID_WARNING_LABEL) {
            Object object2;
            int n = (Integer)object;
            boolean bl = false;
            Icon icon = null;
            switch (n) {
                case 0: {
                    object2 = "no targets";
                    break;
                }
                case 1: {
                    object2 = "1 target";
                    break;
                }
                default: {
                    object2 = n + " targets";
                    icon = UIManager.getIcon("OptionPane.warningIcon");
                    bl = true;
                }
            }
            String string = ((BusinessObject)usedByTargetModel.getDocument()).getClass().getSimpleName();
            String string2 = "<html>This " + string + " is used by <em>" + (String)object2 + "</em>.<br></html>";
            JLabel jLabel = (JLabel)this.retrieve(fieldID);
            jLabel.setText(string2);
            jLabel.setIcon(icon);
            this.updateOnlyThisButton(bl);
            return;
        }
        if (fieldID == usedByTargetModel.FID_ONLYTHIS_BUTTON && (observingToolGui = ObservingToolController.getMyInstance().getGui()) != null) {
            TargetModel targetModel = (TargetModel)observingToolGui.getEditors().modelFor(Target.class);
            Target target = (Target)targetModel.getDocument();
            observingToolGui.jumpToBO((BusinessObject)target);
        }
    }

    private void updateOnlyThisButton(boolean bl) {
        boolean bl2 = ((UsedByTargetModel)this.getModel()).isTargetContext();
        this.editOnlyThisButton.setVisible(bl & bl2);
    }

    public void addOnlyThisButtonListener(ActionListener actionListener) {
        ActionListener[] actionListenerArray = this.editOnlyThisButton.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            if (actionListenerArray[i] != actionListener) continue;
            return;
        }
        this.editOnlyThisButton.addActionListener(actionListener);
    }
}

