/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.ot.editors.schedblock.ComboBoxPair;
import alma.valuetypes.Frequency;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;

public abstract class SpectralWindowComboBoxPair
extends ComboBoxPair {
    static Map<ComboBoxPair, Editor> allInstances = new HashMap<ComboBoxPair, Editor>();
    private final JComboBox nominalBandwidthCombo;
    private final JComboBox nominalChannelsCombo;

    public SpectralWindowComboBoxPair(Editor editor, JComboBox jComboBox, JComboBox jComboBox2) {
        super(editor, jComboBox, jComboBox2);
        allInstances.put(this, editor);
        this.nominalBandwidthCombo = jComboBox;
        this.nominalChannelsCombo = jComboBox2;
    }

    public abstract SpectralWindowI getSpectralWindow();

    @Override
    public void reset() {
        SpectralWindowI spectralWindowI = this.getSpectralWindow();
        if (spectralWindowI == null) {
            return;
        }
        Frequency frequency = spectralWindowI.getNominalBandwidth();
        int n = spectralWindowI.getNominalNumberOfChannels();
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        int n2 = oTConfigModeDecoder.getNominalBandwidthLabelIndex(frequency);
        this.nominalBandwidthCombo.setSelectedIndex(n2);
        n2 = oTConfigModeDecoder.getNominalChannelLabelIndex(n);
        this.nominalChannelsCombo.setSelectedIndex(n2);
        super.reset();
    }

    @Override
    public String[] getPlainTextLabels(JComboBox jComboBox, JComboBox jComboBox2) {
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        String[] stringArray = jComboBox == this.nominalBandwidthCombo ? oTConfigModeDecoder.getKnownNominalChannelLabels() : oTConfigModeDecoder.getKnownNominalBandwidthLabels();
        return stringArray;
    }

    @Override
    protected void suspendEvents(JComboBox jComboBox) {
        super.suspendEvents(jComboBox);
    }

    @Override
    protected void resumeEvents(JComboBox jComboBox) {
        super.resumeEvents(jComboBox);
    }
}

