/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.annotations.PointingPatternI;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.guiutil.mvc.widgets.OTComboBox;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.misc.OTTextCellEditor;
import alma.obsprep.ot.editors.schedblock.PointingPatternCoordsTypeEnum;
import alma.obsprep.ot.editors.schedblock.PointingPatternEditorTestMain;
import alma.obsprep.ot.editors.sciencegoals.AbstractTargetEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.ot.models.schedblock.PointingPatternTableModel;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.UserAngle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import lombok.NonNull;

public class PointingPatternEditor
extends EditorWithGridBagLayout
implements ListSelectionListener {
    public static final FieldID POINTING_PATTERN_TABLE_FID = new FieldID("PointingPatternTable");
    public static final FieldID OFFSET_COORD_TYPE_SELECTOR = new FieldID("CoordTypeSelector");
    public static final FieldID CUSTOM_MOSAIC_CHECKBOX_FID = new FieldID("CustomMosaicCheckBox");
    public static final FieldID OFFSET_UNIT_COMBO_FID = new FieldID("OffsetUnit");
    public static final FieldID NPOINTINGS_FID = new FieldID("PointingPatternEditor.Npointings");
    private static final DialogId DIALOG_OVERWRITE_FILE = new DialogId("PointingPatternEditor.OverwriteFile");
    public static final FieldID IMPORTPOINTINGS_FID = new FieldID("PointingPatternEditor.importPointings");
    public static final FieldID EXPORTPOINTINGS_FID = new FieldID("PointingPatternEditor.exportPointings");
    public static final FieldID USER_REQUESTED_RESET_PP_FID = new FieldID("PointingPatternEditor.pointingPatternResetBtn");
    private final FieldID addPPFID = new FieldID("PointingPatternEditor.addBtn");
    private final FieldID delPPFID = new FieldID("PointingPatternEditor.delBtn");
    private JButton ppImportButton = null;
    private JButton ppExportButton = null;
    private JButton ppAddButton = null;
    private JButton ppDelButton = null;
    private JTable pointingPatternTable = null;
    private EditorWithGridBagLayout.ComponentCollection customMosaicChkComp = null;
    private EditorWithGridBagLayout.ComponentCollection offsetTypeButtons = null;
    private JScrollPane pointingsScroller;
    private JButton ppResetButton;

    public PointingPatternEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        PointingPatternModel pointingPatternModel = (PointingPatternModel)this.getModel();
        this.ppAddButton = new JButton("Add");
        this.ppAddButton.setToolTipText("Add a Pointing");
        this.initEvents(this.ppAddButton, this.addPPFID);
        this.ppDelButton = new JButton("Delete");
        this.ppDelButton.setToolTipText("Delete a Pointing");
        this.initEvents(this.ppDelButton, this.delPPFID);
        this.ppResetButton = new JButton("Reset");
        this.ppResetButton.setToolTipText("Reset pointing pattern");
        this.ppResetButton.addActionListener(actionEvent -> this.resetPointingPattern());
        this.ppImportButton = new JButton("Import");
        this.ppImportButton.setToolTipText("Import pointings from a file");
        this.initEvents(this.ppImportButton, IMPORTPOINTINGS_FID);
        this.ppImportButton.addActionListener(actionEvent -> this.importPointingsFromFile());
        this.ppExportButton = new JButton("Export");
        this.ppExportButton.setToolTipText("Export current pointings to a file");
        this.initEvents(this.ppExportButton, EXPORTPOINTINGS_FID);
        this.ppExportButton.addActionListener(actionEvent -> this.exportPointingsToFile());
        this.pointingPatternTable = new Table(pointingPatternModel.getPointingPatternTableModel()){
            private static final long serialVersionUID = 5882214124972330395L;

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int[] nArray = this.getSelectedRows();
                super.tableChanged(tableModelEvent);
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] >= this.getRowCount() || nArray[i] < 0) continue;
                    if (i == 0) {
                        this.setRowSelectionInterval(nArray[i], nArray[i]);
                        continue;
                    }
                    this.addRowSelectionInterval(nArray[i], nArray[i]);
                }
            }
        };
        int n = this.ppDelButton.getPreferredSize().height;
        Dimension dimension = new Dimension(this.pointingPatternTable.getPreferredSize());
        dimension.height = n * 3;
        dimension.width *= 4;
        this.pointingPatternTable.setPreferredScrollableViewportSize(dimension);
        this.pointingPatternTable.getTableHeader().setReorderingAllowed(false);
        this.pointingPatternTable.setSelectionMode(2);
        this.pointingPatternTable.setColumnSelectionAllowed(false);
        this.pointingPatternTable.getSelectionModel().addListSelectionListener(this);
        this.pointingsScroller = new ScrollWhenFocusedPane(this.pointingPatternTable);
        this.pointingPatternTable.setToolTipText("Coordinates/offsets of each pointing");
        this.pointingPatternTable.setDefaultEditor(String.class, new OTTextCellEditor());
        this.pointingPatternTable.setSelectionForeground(Color.BLACK);
        this.initEvents(this.pointingPatternTable, POINTING_PATTERN_TABLE_FID);
        this.ppAddButton.setPreferredSize(this.ppDelButton.getPreferredSize());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.ppAddButton);
        jPanel2.add(this.ppDelButton);
        jPanel2.add(this.ppResetButton);
        jPanel2.add(this.ppImportButton);
        jPanel2.add(this.ppExportButton);
        this.customMosaicChkComp = new EditorWithGridBagLayout.ComponentCollection(this);
        this.customMosaicChkComp.remember(this.makeCheckBox(CUSTOM_MOSAIC_CHECKBOX_FID, null, pointingPatternModel.isMosaic(), "<html>Switch between treating the pattern as a single shape to be mosaiced for 12m and 7m arrays.<br/>and treating it as one or more individual antenna pointings</html>"));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, this.customMosaicChkComp);
        this.retrieve(CUSTOM_MOSAIC_CHECKBOX_FID).setVisible(false);
        this.offsetTypeButtons = new EditorWithGridBagLayout.ComponentCollection(this);
        this.offsetTypeButtons.remember(this.makeLabel("Coord Type"));
        OTButtonGroup oTButtonGroup = this.makeOTButtonGroup(OFFSET_COORD_TYPE_SELECTOR, PointingPatternCoordsTypeEnum.values(), new String[]{"Relative coordinate type", "Absolute coordinate type"});
        this.set(oTButtonGroup, PointingPatternCoordsTypeEnum.Relative.getUILabel());
        this.offsetTypeButtons.remember(oTButtonGroup);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, this.offsetTypeButtons);
        OTComboBox oTComboBox = this.addOTComboBox(jPanel, gridBagLayout, gridBagConstraints, OFFSET_UNIT_COMBO_FID, "Offset Unit", "Unit of offset pointings", UserAngle.getOrderedKnownModelUnits());
        this.set2(oTComboBox, (Object)PointingPatternI.DEFAULT_OFFSETANGLE_UNIT);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "#Pointings", (JComponent)this.makeTextField(NPOINTINGS_FID, false, "Number of pointings in this field"));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.pointingsScroller);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel2);
        this.addComponent(this, this.layout, this.constraints, jPanel);
    }

    private void resetPointingPattern() {
        Model model;
        if (GUIUtilities.confirm(null, "Are you sure you want to reset the pointing pattern?") && (model = this.getModel()) != null) {
            PointingPatternModel pointingPatternModel = (PointingPatternModel)model;
            pointingPatternModel.performCoordinateResetOfAllPointings();
        }
    }

    @Override
    public void build() {
        super.build("PointingPatternEditor");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        PointingPatternModel pointingPatternModel = (PointingPatternModel)this.getModel();
        if (fieldID.equals(this.addPPFID)) {
            int n = this.pointingPatternTable.getSelectedRow();
            OTButtonGroup oTButtonGroup = (OTButtonGroup)this.retrieve(OFFSET_COORD_TYPE_SELECTOR);
            boolean bl = Boolean.valueOf(PointingPatternCoordsTypeEnum.valueOf(oTButtonGroup.getSelectedItem()).getBOMapping());
            pointingPatternModel.addPointing(n + 1, bl);
            this.pointingPatternTable.setRowSelectionInterval(n + 1, n + 1);
            this.setButtons(pointingPatternModel);
            return;
        }
        if (fieldID.equals(this.delPPFID)) {
            int[] nArray = this.pointingPatternTable.getSelectedRows();
            if (nArray.length == pointingPatternModel.getPointingCount()) {
                GUIUtilities.info(null, "Deleting all of the pointings is not permitted.");
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                pointingPatternModel.deletePointing(nArray[i] - i);
            }
            if (pointingPatternModel.getPointingCount() == 0) {
                this.pointingPatternTable.clearSelection();
            } else {
                this.pointingPatternTable.setRowSelectionInterval(0, 0);
            }
            this.setButtons(pointingPatternModel);
            return;
        }
        if (fieldID.equals(POINTING_PATTERN_TABLE_FID)) {
            ((PointingPatternTableModel)this.pointingPatternTable.getModel()).fireTableDataChanged();
            OTComboBox oTComboBox = (OTComboBox)this.retrieve(OFFSET_UNIT_COMBO_FID);
            if (oTComboBox != null) {
                String string = ((PointingPatternModel)this.getModel()).getDisplayedOffsetUnit();
                this.set2(oTComboBox, (Object)string);
            }
            return;
        }
        if (fieldID.equals(OFFSET_COORD_TYPE_SELECTOR)) {
            super.update(fieldID, object);
            boolean bl = object instanceof String ? Boolean.valueOf((String)object).booleanValue() : Boolean.valueOf((Boolean)object).booleanValue();
            OTComboBox oTComboBox = (OTComboBox)this.retrieve(OFFSET_UNIT_COMBO_FID);
            if (oTComboBox != null) {
                oTComboBox.setEnabled(bl);
                if (bl) {
                    String string = (String)oTComboBox.getSelectedItem();
                    ((PointingPatternModel)this.getModel()).setOffsetUnit(string);
                    ((PointingPatternTableModel)this.pointingPatternTable.getModel()).fireTableStructureChanged();
                }
            }
            return;
        }
        if (fieldID.equals(NPOINTINGS_FID)) {
            super.update(fieldID, object);
            JCheckBox jCheckBox = (JCheckBox)this.retrieve(CUSTOM_MOSAIC_CHECKBOX_FID);
            if ((Integer)object > 1) {
                this.setCollectionComponentEnabled(this.customMosaicChkComp, true);
                jCheckBox.setSelected(true);
                ((PointingPatternModel)this.getModel()).setIsMosaic(true);
            } else {
                jCheckBox.setSelected(false);
                ((PointingPatternModel)this.getModel()).setIsMosaic(false);
                this.setCollectionComponentEnabled(this.customMosaicChkComp, false);
            }
            return;
        }
        if (fieldID == AbstractTargetEditor.FID_NONSIDEREALMOTION) {
            boolean bl = (Boolean)object;
            OTButtonGroup oTButtonGroup = (OTButtonGroup)this.getComponent(OFFSET_COORD_TYPE_SELECTOR);
            if (bl) {
                oTButtonGroup.setSelectedItem(PointingPatternCoordsTypeEnum.Relative.name());
                oTButtonGroup.setEnabled(false);
            } else {
                oTButtonGroup.setEnabled(true);
            }
        } else {
            super.update(fieldID, object);
            return;
        }
    }

    private void importPointingsFromFile() {
        JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser("ImportPointings");
        jFileChooser.setDialogTitle("Import Pointings");
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            PointingPatternModel pointingPatternModel = (PointingPatternModel)this.getModel();
            assert (file != null);
            assert (pointingPatternModel != null);
            if (file.exists()) {
                pointingPatternModel.importPointingsFromFile(file, false);
            } else {
                GUIUtilities.error(null, "File" + file + " does not exist.");
            }
        }
    }

    private void setButtons(PointingPatternModel pointingPatternModel) {
        int n = pointingPatternModel.getPointingCount();
        this.setEnabled(this.ppAddButton, this.pointingPatternTable.getSelectedRowCount() < 2);
        this.setEnabled(this.ppDelButton, n > 0 && this.pointingPatternTable.getSelectedRow() != -1);
    }

    private void setCollectionComponentEnabled(EditorWithGridBagLayout.ComponentCollection componentCollection, boolean bl) {
        for (Component component : componentCollection.getComponents()) {
            component.setEnabled(bl);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons((PointingPatternModel)this.getModel());
    }

    public JTable getPointingPatternTable() {
        return this.pointingPatternTable;
    }

    public static void main(String[] stringArray) {
        PointingPatternEditorTestMain.main(stringArray);
    }

    private void exportPointingsToFile() {
        PointingPatternModel pointingPatternModel = (PointingPatternModel)this.getModel();
        assert (pointingPatternModel != null);
        JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser("ExportPointings");
        IndividualPointingsExportOptions individualPointingsExportOptions = new IndividualPointingsExportOptions();
        jFileChooser.setAccessory(individualPointingsExportOptions);
        jFileChooser.setDialogTitle("Export Pointings");
        jFileChooser.setDialogType(1);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (file.exists()) {
                String string = "";
                try {
                    string = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                String string2 = "File " + string + " already exists.\nDo you want to replace it?";
                boolean bl = GUIUtilities.confirm(DIALOG_OVERWRITE_FILE, string2);
                if (!bl) {
                    return;
                }
            }
            if (individualPointingsExportOptions.isAbsoluteCoords()) {
                pointingPatternModel.exportAbsoluteCoordsToFile(file, individualPointingsExportOptions.getAbsCoordsType());
            } else {
                pointingPatternModel.exportOffsetCoordsToFile(file, individualPointingsExportOptions.getOffsetCoordsType());
            }
        }
    }

    @Override
    public List<JComponent> getUserRestrictedEditableComponents() {
        return Arrays.asList(this.pointingsScroller, this.pointingPatternTable);
    }

    static class IndividualPointingsExportOptions
    extends JPanel {
        private static final String ABSCOORDS_BTN_NAME = "ExportOptionsDialog.expAbsCoordsBtn";
        private static final String OFFSETCOORDS_BTN_NAME = "ExportOptionsDialog.expOffsetCoordsBtn";
        private final ButtonGroup exportGroup = new ButtonGroup();
        private final JRadioButton absoluteCoordsBtn;
        private final JRadioButton offsetCoordsBtn;
        private final AbsoluteCoordsOptions absCoordsOptions;
        private final OffsetCoordsOptions offsetCoordsOptions;

        public IndividualPointingsExportOptions() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.absoluteCoordsBtn = new JRadioButton("Export using absolute coordinates");
            this.absoluteCoordsBtn.setName(ABSCOORDS_BTN_NAME);
            this.absoluteCoordsBtn.setToolTipText("Export pointings using absolute coordinates");
            this.exportGroup.add(this.absoluteCoordsBtn);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.absoluteCoordsBtn, gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.add((Component)new JLabel("     "), gridBagConstraints);
            this.absCoordsOptions = new AbsoluteCoordsOptions();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.absCoordsOptions, gridBagConstraints);
            this.offsetCoordsBtn = new JRadioButton("Export using offset coordinates");
            this.offsetCoordsBtn.setName(OFFSETCOORDS_BTN_NAME);
            this.offsetCoordsBtn.setToolTipText("Export pointings using offset coordinates.");
            this.exportGroup.add(this.offsetCoordsBtn);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            this.add((Component)this.offsetCoordsBtn, gridBagConstraints);
            this.offsetCoordsOptions = new OffsetCoordsOptions();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 4;
            this.add((Component)this.offsetCoordsOptions, gridBagConstraints);
            ActionListener actionListener = actionEvent -> {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                if (abstractButton.getName().equals(ABSCOORDS_BTN_NAME)) {
                    this.setAbsCoordsEnabled(true);
                    this.setOffsetCoordsEnabled(false);
                } else if (abstractButton.getName().equals(OFFSETCOORDS_BTN_NAME)) {
                    this.setAbsCoordsEnabled(false);
                    this.setOffsetCoordsEnabled(true);
                }
            };
            this.offsetCoordsBtn.setSelected(true);
            this.setOffsetCoordsEnabled(true);
            this.setAbsCoordsEnabled(false);
            this.absoluteCoordsBtn.addActionListener(actionListener);
            this.offsetCoordsBtn.addActionListener(actionListener);
        }

        public boolean isAbsoluteCoords() {
            return this.absoluteCoordsBtn.isSelected();
        }

        public boolean isOffsetCoords() {
            return this.offsetCoordsBtn.isSelected();
        }

        public PointingStorageFormat getExportFormat() {
            if (this.absoluteCoordsBtn.isSelected()) {
                return PointingStorageFormat.ABSOLUTECOORDS;
            }
            if (this.offsetCoordsBtn.isSelected()) {
                return PointingStorageFormat.OFFSETCOORDS;
            }
            throw new IllegalArgumentException("Unable to determine the coordinate type to export");
        }

        public AbsoluteCoordsFormat getAbsCoordsType() {
            return this.absCoordsOptions.getCoordsType();
        }

        public void setAbsCoordsEnabled(boolean bl) {
            this.absCoordsOptions.setEnabled(bl);
        }

        public OffsetCoordsFormat getOffsetCoordsType() {
            return this.offsetCoordsOptions.getCoordsType();
        }

        public void setOffsetCoordsEnabled(boolean bl) {
            this.offsetCoordsOptions.setEnabled(bl);
        }

        class OffsetCoordsOptions
        extends JPanel {
            private final ButtonGroup coordsGroup = new ButtonGroup();
            private final JRadioButton arcsecBtn;
            private final JRadioButton arcminBtn;
            private final JRadioButton degreesBtn;

            public OffsetCoordsOptions() {
                this.setLayout(new BoxLayout(this, 0));
                this.arcsecBtn = new JRadioButton("Arcsec");
                this.arcsecBtn.setName("ExportOptionsDialog.Arcsec");
                this.coordsGroup.add(this.arcsecBtn);
                this.arcminBtn = new JRadioButton("Arcmin");
                this.arcminBtn.setName("ExportOptionsDialog.Arcmins");
                this.coordsGroup.add(this.arcminBtn);
                this.degreesBtn = new JRadioButton("Degrees");
                this.degreesBtn.setName("ExportOptionsDialog.Degrees");
                this.coordsGroup.add(this.degreesBtn);
                this.add(this.arcsecBtn);
                this.add(this.arcminBtn);
                this.add(this.degreesBtn);
                this.arcsecBtn.setSelected(true);
            }

            public boolean isArcSec() {
                return this.arcsecBtn.isSelected();
            }

            public boolean isArcMin() {
                return this.arcminBtn.isSelected();
            }

            public boolean isDegrees() {
                return this.degreesBtn.isSelected();
            }

            public OffsetCoordsFormat getCoordsType() {
                if (this.arcsecBtn.isSelected()) {
                    return OffsetCoordsFormat.ARCSECS;
                }
                if (this.arcminBtn.isSelected()) {
                    return OffsetCoordsFormat.ARCMINS;
                }
                if (this.degreesBtn.isSelected()) {
                    return OffsetCoordsFormat.DEGREES;
                }
                return null;
            }

            @Override
            public void setEnabled(boolean bl) {
                this.arcsecBtn.setEnabled(bl);
                this.arcminBtn.setEnabled(bl);
                this.degreesBtn.setEnabled(bl);
            }
        }

        class AbsoluteCoordsOptions
        extends JPanel {
            private final ButtonGroup coordsGroup = new ButtonGroup();
            private final JRadioButton sexagBtn;
            private final JRadioButton degreesBtn;
            private final JRadioButton radiansBtn;

            public AbsoluteCoordsOptions() {
                this.setLayout(new BoxLayout(this, 0));
                this.sexagBtn = new JRadioButton("Sexagesimal");
                this.sexagBtn.setName("ExportOptionsDialog.CoordsSexagesimal");
                this.coordsGroup.add(this.sexagBtn);
                this.degreesBtn = new JRadioButton("Degrees");
                this.degreesBtn.setName("ExportOptionsDialog.CoordsDegrees");
                this.coordsGroup.add(this.degreesBtn);
                this.radiansBtn = new JRadioButton("Radians");
                this.radiansBtn.setName("ExportOptionsDialog.CoordsRadians");
                this.coordsGroup.add(this.radiansBtn);
                this.add(this.sexagBtn);
                this.add(this.degreesBtn);
                this.add(this.radiansBtn);
                this.sexagBtn.setSelected(true);
            }

            public boolean isSexagesimal() {
                return this.sexagBtn.isSelected();
            }

            public boolean isDegrees() {
                return this.degreesBtn.isSelected();
            }

            public boolean isRadians() {
                return this.radiansBtn.isSelected();
            }

            public AbsoluteCoordsFormat getCoordsType() {
                if (this.sexagBtn.isSelected()) {
                    return AbsoluteCoordsFormat.SEXAGESIMAL;
                }
                if (this.degreesBtn.isSelected()) {
                    return AbsoluteCoordsFormat.DEGREES;
                }
                if (this.radiansBtn.isSelected()) {
                    return AbsoluteCoordsFormat.RADIANS;
                }
                throw new IllegalArgumentException("Unhandled coordinate system selected");
            }

            @Override
            public void setEnabled(boolean bl) {
                this.sexagBtn.setEnabled(bl);
                this.degreesBtn.setEnabled(bl);
                this.radiansBtn.setEnabled(bl);
            }
        }
    }

    public static enum OffsetCoordsFormat {
        ARCSECS,
        ARCMINS,
        DEGREES;

    }

    public static enum AbsoluteCoordsFormat {
        SEXAGESIMAL,
        DEGREES,
        RADIANS;

    }

    public static enum PointingStorageFormat {
        ABSOLUTECOORDS("Absolute"),
        OFFSETCOORDS("Offset");

        private String label;

        public static PointingStorageFormat getExportFormat(@NonNull String string) {
            if (string == null) {
                throw new NullPointerException("label is marked non-null but is null");
            }
            for (PointingStorageFormat pointingStorageFormat : PointingStorageFormat.values()) {
                if (!string.trim().equalsIgnoreCase(pointingStorageFormat.getLabel())) continue;
                return pointingStorageFormat;
            }
            return null;
        }

        private PointingStorageFormat(String string2) {
            this.label = string2;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

