/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.schedblock.LOSetupPreferenceModel;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LOSetupPreferenceEditor
extends EditorWithGridBagLayout {
    public static final FieldID SBBB1_FID = new FieldID("LOSetupPreferenceEditor.SideBandPrefs.BB1");
    public static final FieldID SBBB2_FID = new FieldID("LOSetupPreferenceEditor.SideBandPrefs.BB2");
    public static final FieldID SBBB3_FID = new FieldID("LOSetupPreferenceEditor.SideBandPrefs.BB3");
    public static final FieldID SBBB4_FID = new FieldID("LOSetupPreferenceEditor.SideBandPrefs.BB4");
    public static final FieldID BB1_FID = new FieldID("LOSetupPreferenceEditor.BB1");
    public static final FieldID BB2_FID = new FieldID("LOSetupPreferenceEditor.BB2");
    public static final FieldID BB3_FID = new FieldID("LOSetupPreferenceEditor.BB3");
    public static final FieldID BB4_FID = new FieldID("LOSetupPreferenceEditor.BB4");
    public static final FieldID[] sbchoiceFIDs = new FieldID[]{SBBB1_FID, SBBB2_FID, SBBB3_FID, SBBB4_FID};
    public static final FieldID[] weightFIDs = new FieldID[]{BB1_FID, BB2_FID, BB3_FID, BB4_FID};
    public static final FieldID DOPPLER_FID = new FieldID("LOSetupPreferenceEditor.Doppler");
    public static final FieldID CALC_FID = new FieldID("LOSetupPreferenceEditor.Calc");
    public static final FieldID VELOCITY_FID = new FieldID("LOSetupPreferenceEditor.Velocity");
    private JButton calcLOButton;
    private final List<ActionListener> calcLOListeners = new ArrayList<ActionListener>();

    public LOSetupPreferenceEditor(LOSetupPreferenceModel lOSetupPreferenceModel) {
        this.setModel(lOSetupPreferenceModel);
        this.build();
        lOSetupPreferenceModel.publish();
    }

    @Override
    public LOSetupPreferenceModel getModel() {
        return (LOSetupPreferenceModel)super.getModel();
    }

    @Override
    public void build() {
        super.build("LO Setup Preference");
    }

    @Override
    public void addComponents(String string) {
        JPanel jPanel = this.createPanel();
        this.constraints.weightx = 1.0;
        this.addGroup(jPanel, string);
    }

    private JPanel createPanel() {
        int n;
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        String string = "Prioritise the selected sideband when selecting local oscillator frequencies";
        JPanel jPanel2 = this.createLineContainer();
        String[] stringArray = BaseBandSpecification.getKnownSideBandPreferenceList();
        for (n = 0; n < SpectralSpec.maxBaseBandCount(); ++n) {
            jPanel2.add(this.makeLabel(String.format("BB_%1d", n + 1)));
            JComboBox jComboBox = this.makeComboBox(sbchoiceFIDs[n], stringArray, string);
            jPanel2.add(jComboBox);
        }
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Sideband(s) to prioritise", (JComponent)jPanel2);
        string = "Weightings for the basebands, to be used in determining the LO setup.";
        jPanel2 = this.createLineContainer();
        for (n = 0; n < SpectralSpec.maxBaseBandCount(); ++n) {
            jPanel2.add(this.makeLabel(String.format("BB_%1d", n + 1)));
            JTextField jTextField = this.makeTextFieldWithDoubleVerifier(weightFIDs[n], string, 0.0, 100.0);
            jTextField.setColumns(4);
            jPanel2.add(jTextField);
        }
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Base band config(s) to prioritise ", (JComponent)jPanel2);
        Box box = Box.createHorizontalBox();
        box.add(this.makeComboBox(DOPPLER_FID, FrequencySetup.getKnownDopplerReferenceList(), "Either ignore (topo) or use (rest) the source velocity in the tuning solution"));
        box.add(Box.createHorizontalGlue());
        this.calcLOButton = new JButton("Calculate LOs 1 and 2");
        this.register(this.calcLOButton, CALC_FID);
        this.calcLOButton.setToolTipText("Attempt a tuning solution");
        this.calcLOButton.addActionListener(actionEvent -> this.calculateLOs(actionEvent));
        box.add(this.calcLOButton);
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Doppler Reference", (JComponent)box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.makeLabel(VELOCITY_FID, "Long Long Long Test Label", ""));
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "", (JComponent)box);
        return jPanel;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(BB1_FID) || fieldID.equals(BB2_FID) || fieldID.equals(BB3_FID) || fieldID.equals(BB4_FID)) {
            if (object == null) {
                super.update(fieldID, "");
                this.retrieve(fieldID).setEnabled(false);
            } else {
                this.retrieve(fieldID).setEnabled(true);
                if (object instanceof String) {
                    super.update(fieldID, object);
                } else {
                    super.update(fieldID, String.format("%.1f", (Double)object));
                }
            }
            this.setButtons();
            return;
        }
        if (fieldID.equals(SBBB1_FID) || fieldID.equals(SBBB2_FID) || fieldID.equals(SBBB3_FID) || fieldID.equals(SBBB4_FID)) {
            if (object == null) {
                super.update(fieldID, "");
                this.retrieve(fieldID).setEnabled(false);
            } else {
                this.retrieve(fieldID).setEnabled(true);
                super.update(fieldID, object);
            }
            this.setButtons();
            return;
        }
        if (fieldID.equals(VELOCITY_FID)) {
            String string;
            FieldSource fieldSource = (FieldSource)object;
            if (fieldSource == null) {
                string = "using velocity 0.0km/s";
            } else {
                Velocity velocity = fieldSource.getSourceVelocity();
                String string2 = Speed.UNIT_KM_S;
                string = String.format("using velocity from %s (%.0f %s)", fieldSource.getSourceName(), velocity.getCenterVelocity().getContentInUnits(string2), string2);
            }
            super.update(fieldID, string);
            return;
        }
        if (fieldID.equals(DOPPLER_FID)) {
            boolean bl = false;
            if (((String)object).equals("rest")) {
                bl = true;
            }
            this.retrieve(VELOCITY_FID).setVisible(bl);
        }
        super.update(fieldID, object);
    }

    protected void calculateLOs(ActionEvent actionEvent) {
        this.getModel().calculateLOs(0, true);
        for (ActionListener actionListener : this.calcLOListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    protected void setButtons() {
        if (!this.isEnabled()) {
            return;
        }
        FrequencySetup frequencySetup = this.getModel().getFrequencySetup();
        if (frequencySetup == null) {
            return;
        }
        this.setEnabled(this.calcLOButton, frequencySetup.getBaseBandSpecificationCount() > 0);
    }

    public void addCalculateLOListener(ActionListener actionListener) {
        this.calcLOListeners.add(actionListener);
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        LOSetupPreferenceModel lOSetupPreferenceModel = new LOSetupPreferenceModel(null);
        LOSetupPreferenceEditor lOSetupPreferenceEditor = new LOSetupPreferenceEditor(lOSetupPreferenceModel);
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpecWithBLCorrelatorConfiguration(Optional.empty());
        spectralSpec.addNewBaseBand();
        BaseBand baseBand = spectralSpec.addNewBaseBand();
        baseBand.getBaseBandSpecification().setBaseBandName("BB_4");
        FrequencySetup frequencySetup = spectralSpec.getFrequencySetup();
        String[] stringArray2 = new String[]{BaseBandSpecification.SIDEBANDPREFERENCE_LSB, null, null, BaseBandSpecification.SIDEBANDPREFERENCE_NONE};
        frequencySetup.setSideBandPreferences(stringArray2);
        lOSetupPreferenceModel.setDocument(frequencySetup);
        LOSetupPreferenceEditor.runTestApp(lOSetupPreferenceEditor);
    }
}

