/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.common.sourcecatalog.Measurement;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ObservatoryGoalTargetParameters;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.TimeVerifier;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetParametersDialog;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetParametersTableModel;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetQuerySourceDialog;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetSelectorDialog;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.obsproject.ObservatoryGoalModel;
import alma.obsprep.ot.models.obsproject.ObservatoryGoalTargetParametersModel;
import alma.obsprep.ot.models.obsproject.ObservatoryGoalTargetsModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.util.UnitMapConfigurator;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ObservatoryGoalTargetsEditor
extends EditorWithGridBagLayout
implements ListSelectionListener {
    public static final FieldID MANUAL_TARGET_LIST_QUERY = new FieldID("ObservingGoalTargetsPanel manual target list query FID");
    public static final FieldID AUTO_TARGET_LIST_QUERY = new FieldID("ObservingGoalTargetsPanel automatic target list query FID");
    public static final FieldID EDIT_TARGET_LIST_QUERY = new FieldID("ObservingGoalTargetsPanel edit target list query FID");
    public static final FieldID TARGET_LIST_ADD_CALIBRATOR = new FieldID("ObservingGoalTargetsPanel add calibrator FID");
    public static final FieldID TARGET_LIST_ADD_TARGET = new FieldID("ObservingGoalTargetsPanel add target FID");
    public static final FieldID TARGET_LIST_REMOVE = new FieldID("ObservingGoalTargetsPanel remove from target list FID");
    public static final FieldID TARGET_LIST_UP = new FieldID("ObservingGoalTargetsPanel move target up FID");
    public static final FieldID TARGET_LIST_DOWN = new FieldID("ObservingGoalTargetsPanel move target down FID");
    public static final FieldID TARGET_LIST_LOAD = new FieldID("ObservingGoalTargetsPanel load from file FID");
    public static final FieldID TARGET_LIST_REMOVE_ALL = new FieldID("ObservingGoalTargetsPanel clear target list FID");
    public static final FieldID INTEGRATION_TIME_VALUE_FID = new FieldID("ObservingGoalTargetsPanel integration time value FID");
    public static final FieldID INTEGRATION_TIME_UNITS_FID = new FieldID("ObservingGoalTargetsPanel integration time units FID");
    public static final FieldID OBSERVATORY_GOAL_PURPOSE_FID = new FieldID("ObservingGoalTargetsPanel observatory goal purpose");
    private JLabel hardCodedLabel;
    private JButton addCalibratorButton;
    private JButton addTargetButton;
    private JButton loadFileButton;
    private JPanel buttonPanel;
    private JButton downButton;
    private JButton removeAllButton;
    private JButton editQueryButton;
    private JLabel helpLabel;
    private JLabel integrationTimeLabel;
    private JPanel integrationTimePanel;
    private JButton removeButton;
    private JScrollPane scrollPane;
    private JTable table;
    private ButtonGroup targetListButtonGroup;
    private JPanel targetsPanel;
    private JButton upButton;
    private JRadioButton useQueryButton;
    private JRadioButton useTargetListButton;
    private ValueUnitPairEditor integrationTime;
    private final ObservatoryGoalTargetParametersTableModel tableModel = new ObservatoryGoalTargetParametersTableModel();
    private final ObservatoryGoalTargetsModel targetsModel;
    private final ValueUnitPairModel integrationTimeModel;

    public ObservatoryGoalTargetsEditor(Model model) {
        this.setName("ObservatoryGoalTargets");
        if (!(model instanceof ObservatoryGoalModel)) {
            throw new AssertionError((Object)("Wrong model passed to ObservatoryGoalTargetsEditor: " + model.getClass().getSimpleName()));
        }
        this.setModel(model);
        ObservatoryGoalModel observatoryGoalModel = (ObservatoryGoalModel)model;
        this.targetsModel = observatoryGoalModel.getTargetModel();
        this.targetsModel.subscribe(this);
        this.integrationTimeModel = observatoryGoalModel.getIntegrationTimeModel();
        this.initTargetsPanel();
        this.initIntegrationTimePanel();
        this.build();
        model.publish();
    }

    @Override
    protected void addComponents(String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.targetsPanel.setBorder(new TitledBorder("Survey Targets"));
        this.add((Component)this.targetsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.integrationTimePanel.setBorder(new TitledBorder("Integration Time"));
        this.add((Component)this.integrationTimePanel, gridBagConstraints);
    }

    @Override
    protected void build() {
        super.build("ObservatoryGoalTargetsEditor");
        this.table.getSelectionModel().addListSelectionListener(this);
        this.useQueryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObservatoryGoalTargetsEditor.this.useQueryButtonActionPerformed(actionEvent);
            }
        });
        this.useTargetListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObservatoryGoalTargetsEditor.this.useTargetListButtonActionPerformed(actionEvent);
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons();
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (fieldID.equals(TARGET_LIST_REMOVE)) {
            ArrayList<ObservatoryGoalTargetParameters> arrayList = new ArrayList<ObservatoryGoalTargetParameters>();
            for (int n : this.table.getSelectedRows()) {
                arrayList.add(this.tableModel.get(n));
            }
            return arrayList;
        }
        if (fieldID.equals(TARGET_LIST_UP) || fieldID.equals(TARGET_LIST_DOWN)) {
            int[] nArray = this.table.getSelectedRows();
            if (nArray.length == 1) {
                ObservatoryGoalTargetParameters observatoryGoalTargetParameters = this.tableModel.get(nArray[0]);
                return observatoryGoalTargetParameters;
            }
        } else {
            if (fieldID.equals(TARGET_LIST_ADD_CALIBRATOR)) {
                QuerySource querySource = QuerySource.createQuerySource();
                QuerySourceAdapter querySourceAdapter = new QuerySourceAdapter(querySource);
                CalibratorExpertModel calibratorExpertModel = this.targetsModel.getCalibratorExpertModel();
                calibratorExpertModel.setDocument(querySourceAdapter);
                ObservatoryGoalTargetSelectorDialog observatoryGoalTargetSelectorDialog = new ObservatoryGoalTargetSelectorDialog(calibratorExpertModel, true);
                ObservatoryGoalTargetsEditor.resizeDialog(observatoryGoalTargetSelectorDialog);
                observatoryGoalTargetSelectorDialog.setVisible(true);
                List<Measurement> list = observatoryGoalTargetSelectorDialog.getSelected();
                return list;
            }
            if (fieldID.equals(TARGET_LIST_ADD_TARGET)) {
                ObservatoryGoalTargetParameters observatoryGoalTargetParameters = ObservatoryGoalTargetParameters.createObservatoryGoalTargetParameters();
                ObservatoryGoalTargetParametersModel observatoryGoalTargetParametersModel = this.targetsModel.getObservatoryGoalTargetParametersModel();
                observatoryGoalTargetParametersModel.setDocument(observatoryGoalTargetParameters);
                ObservatoryGoalTargetParametersDialog observatoryGoalTargetParametersDialog = new ObservatoryGoalTargetParametersDialog(observatoryGoalTargetParametersModel, true);
                ObservatoryGoalTargetsEditor.centreDialog(observatoryGoalTargetParametersDialog);
                observatoryGoalTargetParametersDialog.setVisible(true);
                if (observatoryGoalTargetParametersDialog.isCancelled()) {
                    return null;
                }
                return observatoryGoalTargetParameters;
            }
            if (fieldID.equals(TARGET_LIST_LOAD)) {
                JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser(this);
                jFileChooser.setDialogTitle("Load Target List");
                File file = null;
                int n = jFileChooser.showOpenDialog(this);
                if (n == 0) {
                    file = jFileChooser.getSelectedFile();
                }
                return file;
            }
        }
        return object;
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (fieldID.equals(ObservatoryGoalTargetsModel.CALIBRATOR_SURVEY_TARGET_CALIBRATORS_FID)) {
            int n = this.table.getSelectedRow();
            if (object instanceof ObservatoryGoalTargetParameters[]) {
                ObservatoryGoalTargetParameters[] observatoryGoalTargetParametersArray = (ObservatoryGoalTargetParameters[])object;
                this.tableModel.setTargets(Arrays.asList(observatoryGoalTargetParametersArray));
            }
            if (n != -1) {
                int n2 = n < this.tableModel.getRowCount() ? n : this.tableModel.getRowCount() - 1;
                this.table.getSelectionModel().setSelectionInterval(n2, n2);
            }
            this.setButtons();
        } else if (fieldID.equals(TARGET_LIST_UP) || fieldID.equals(TARGET_LIST_DOWN)) {
            ObservatoryGoalTargetParameters observatoryGoalTargetParameters;
            int n;
            if (object != null && object instanceof ObservatoryGoalTargetParameters && (n = this.tableModel.indexOf(observatoryGoalTargetParameters = (ObservatoryGoalTargetParameters)object)) != -1 && n < this.tableModel.getRowCount()) {
                int n3 = n == 0 ? 0 : n;
                this.table.getSelectionModel().setSelectionInterval(n3, n);
            }
        } else if (fieldID.equals(EDIT_TARGET_LIST_QUERY)) {
            CalibratorExpertModel calibratorExpertModel = this.targetsModel.getCalibratorExpertModel();
            ObservatoryGoalTargetQuerySourceDialog observatoryGoalTargetQuerySourceDialog = new ObservatoryGoalTargetQuerySourceDialog(calibratorExpertModel, true);
            observatoryGoalTargetQuerySourceDialog.setTitle("Source List Query Editor");
            ObservatoryGoalTargetsEditor.resizeDialog(observatoryGoalTargetQuerySourceDialog);
            observatoryGoalTargetQuerySourceDialog.setVisible(true);
        } else if (fieldID.equals(AUTO_TARGET_LIST_QUERY)) {
            this.useQueryButton.setSelected(true);
            this.useQueryButtonActionPerformed(null);
        } else if (fieldID.equals(MANUAL_TARGET_LIST_QUERY)) {
            this.useTargetListButton.setSelected(true);
            this.useTargetListButtonActionPerformed(null);
            this.setButtons();
        }
        super.modelChanged(model, fieldID, object);
    }

    private void setButtons() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else if (nArray.length == 1) {
            this.removeButton.setEnabled(true);
            int n = nArray[0];
            int n2 = this.tableModel.getRowCount();
            if (n2 > 1) {
                if (n < n2 - 1) {
                    this.downButton.setEnabled(true);
                } else {
                    this.downButton.setEnabled(false);
                }
                if (n == 0) {
                    this.upButton.setEnabled(false);
                } else {
                    this.upButton.setEnabled(true);
                }
            }
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
        if (this.tableModel.getRowCount() > 0) {
            this.removeAllButton.setEnabled(true);
        } else {
            this.removeAllButton.setEnabled(false);
        }
    }

    private void initIntegrationTimePanel() {
        this.integrationTimePanel = new JPanel();
        this.integrationTimePanel.setLayout(new GridBagLayout());
        this.integrationTimeLabel = this.makeLabel("Integration time per source");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.integrationTimePanel.add((Component)this.integrationTimeLabel, gridBagConstraints);
        this.integrationTime = this.makeValueUnitPairEditor(this.integrationTimeModel, "Integration time per target");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 11, 12, 12);
        this.integrationTimePanel.add((Component)this.integrationTime, gridBagConstraints);
        this.setVerifier(this.integrationTime, "FOCUSLOST_VERIFIER", new TimeVerifier(this.integrationTime));
        this.integrationTime.setName("ObservatoryGoalTargetsEditor.integrationTime");
        this.integrationTimeLabel.setName("ObservatoryGoalTargetsEditor.integrationTimeLabel");
        this.integrationTimePanel.setName("ObservatoryGoalTargetsEditor.integrationTimePanel");
    }

    private void initTargetsPanel() {
        this.targetListButtonGroup = new ButtonGroup();
        this.targetsPanel = new JPanel();
        this.scrollPane = new ScrollWhenFocusedPane();
        this.table = new JTable();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.buttonPanel = new JPanel();
        this.upButton = this.makeButton(TARGET_LIST_UP, "Move Up", "Move selected source up the source list");
        this.downButton = this.makeButton(TARGET_LIST_DOWN, "Move Down", "Move selected source down the source list");
        this.loadFileButton = this.makeButton(TARGET_LIST_LOAD, "Load from File", "Load source list from a file");
        this.addCalibratorButton = this.makeButton(TARGET_LIST_ADD_CALIBRATOR, "Add from Catalog", "Add a source catalog entry to the source list");
        this.addTargetButton = this.makeButton(TARGET_LIST_ADD_TARGET, "Add", "Add a source to the source list");
        this.removeButton = this.makeButton(TARGET_LIST_REMOVE, "Remove", "Remove the selected calibrators from the source list");
        this.helpLabel = new JLabel();
        this.useQueryButton = new JRadioButton();
        this.useTargetListButton = new JRadioButton();
        this.editQueryButton = this.makeButton(EDIT_TARGET_LIST_QUERY, "Edit Selection Criteria", "Edit the selection criteria used to generate the source list");
        this.removeAllButton = this.makeButton(TARGET_LIST_REMOVE_ALL, "Remove All", "Remove all sources from the source list");
        this.initEvents(this.useQueryButton, AUTO_TARGET_LIST_QUERY);
        this.initEvents(this.useTargetListButton, MANUAL_TARGET_LIST_QUERY);
        this.targetsPanel.setLayout(new GridBagLayout());
        this.table.setModel(this.tableModel);
        this.scrollPane.setViewportView(this.table);
        this.targetListButtonGroup.add(this.useQueryButton);
        this.useQueryButton.setText("Generate source list at execution time");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.targetsPanel.add((Component)this.useQueryButton, gridBagConstraints);
        this.helpLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() & 0xFFFFFFFE));
        this.helpLabel.setText("<html><ul><li>Edit the selection criteria for a target list created at project execution time with the <i>Edit Selection Criteria</i> button</li></ul></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.targetsPanel.add((Component)this.helpLabel, gridBagConstraints);
        this.editQueryButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.targetsPanel.add((Component)this.editQueryButton, gridBagConstraints);
        this.targetListButtonGroup.add(this.useTargetListButton);
        this.useTargetListButton.setSelected(true);
        this.useTargetListButton.setText("User-selected source list");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.targetsPanel.add((Component)this.useTargetListButton, gridBagConstraints);
        this.hardCodedLabel = new JLabel();
        this.hardCodedLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() & 0xFFFFFFFE));
        this.hardCodedLabel.setText("<html><ul><li>Use the <i>Add</i> and <i>Load</i> buttons to create a target list now, at proposal creation time.</li></ul></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.targetsPanel.add((Component)this.hardCodedLabel, gridBagConstraints);
        GroupLayout groupLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.addTargetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addCalibratorButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadFileButton).addGap(18, 18, 18).addComponent(this.removeAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addTargetButton).addComponent(this.addCalibratorButton).addComponent(this.loadFileButton).addComponent(this.removeAllButton).addComponent(this.removeButton)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 12, 12, 12);
        this.targetsPanel.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.targetsPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.addCalibratorButton.setName("ObservatoryGoalTargetsEditor.addCalibratorButton");
        this.addTargetButton.setName("ObservatoryGoalTargetsEditor.addTargetButton");
        this.buttonPanel.setName("ObservatoryGoalTargetsEditor.buttonPanel");
        this.downButton.setName("ObservatoryGoalTargetsEditor.downButton");
        this.editQueryButton.setName("ObservatoryGoalTargetsEditor.editQueryButton");
        this.hardCodedLabel.setName("ObservatoryGoalTargetsEditor.hardCodedLabel");
        this.helpLabel.setName("ObservatoryGoalTargetsEditor.helpLabel");
        this.loadFileButton.setName("ObservatoryGoalTargetsEditor.loadFileButton");
        this.removeAllButton.setName("ObservatoryGoalTargetsEditor.removeAllButton");
        this.removeButton.setName("ObservatoryGoalTargetsEditor.removeButton");
        this.scrollPane.setName("ObservatoryGoalTargetsEditor.scrollPane");
        this.table.setName("ObservatoryGoalTargetsEditor.table");
        this.targetsPanel.setName("ObservatoryGoalTargetsEditor.targetsPanel");
        this.upButton.setName("ObservatoryGoalTargetsEditor.upButton");
        this.useQueryButton.setName("ObservatoryGoalTargetsEditor.useQueryButton");
        this.useTargetListButton.setName("ObservatoryGoalTargetsEditor.useTargetListButton");
    }

    private void useQueryButtonActionPerformed(ActionEvent actionEvent) {
        this.editQueryButton.setEnabled(true);
        this.table.setEnabled(false);
        this.addCalibratorButton.setEnabled(false);
        this.addTargetButton.setEnabled(false);
        this.loadFileButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.removeAllButton.setEnabled(false);
    }

    private void useTargetListButtonActionPerformed(ActionEvent actionEvent) {
        this.editQueryButton.setEnabled(false);
        this.addCalibratorButton.setEnabled(true);
        this.addTargetButton.setEnabled(true);
        this.loadFileButton.setEnabled(true);
        this.table.setEnabled(true);
        this.removeAllButton.setEnabled(true);
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        final ObservatoryGoalModel observatoryGoalModel = new ObservatoryGoalModel(null);
        final ObservatoryGoal observatoryGoal = ObservatoryGoal.createCalibratorSurveyGoal();
        observatoryGoal.setUseQuery(false);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
                }
                ObservatoryGoalTargetsEditor observatoryGoalTargetsEditor = new ObservatoryGoalTargetsEditor(observatoryGoalModel);
                observatoryGoalModel.setDocument(observatoryGoal);
                JFrame jFrame = new JFrame("ObservatoryGoalTargetsEditor");
                jFrame.setDefaultCloseOperation(3);
                jFrame.getContentPane().add(observatoryGoalTargetsEditor);
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
    }
}

