/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetQuerySourceEditor;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.util.UnitMapConfigurator;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class ObservatoryGoalTargetQuerySourceDialog
extends GuiFactory.Dialog {
    private final ObservatoryGoalTargetQuerySourceEditor editor;

    public ObservatoryGoalTargetQuerySourceDialog(Model model, boolean bl) {
        this.setModal(bl);
        this.editor = new ObservatoryGoalTargetQuerySourceEditor(model);
        this.editor.getCloseButton().addActionListener(actionEvent -> this.closeButtonActionPerformed());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ObservatoryGoalTargetQuerySourceDialog.this.closeButtonActionPerformed();
            }
        });
        this.initComponents();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.rescaleToMonitor(0.8);
        }
        super.setVisible(bl);
    }

    private void closeButtonActionPerformed() {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Calibrator Query Editor");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.editor, gridBagConstraints);
        this.pack();
        this.getRootPane().setDefaultButton(this.editor.getSubmitButton());
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_AMPLITUDE);
        QuerySourceAdapter querySourceAdapter = new QuerySourceAdapter(querySource);
        CalibratorExpertModel calibratorExpertModel = new CalibratorExpertModel(querySourceAdapter);
        calibratorExpertModel.subscribe(new CalibratorExpertController());
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, exception);
            }
            ObservatoryGoalTargetQuerySourceDialog observatoryGoalTargetQuerySourceDialog = new ObservatoryGoalTargetQuerySourceDialog(calibratorExpertModel, true);
            observatoryGoalTargetQuerySourceDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            observatoryGoalTargetQuerySourceDialog.setVisible(true);
        });
    }
}

