/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.util.UnitMapConfigurator;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.DataRate;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeReference;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Latitude;
import alma.valuetypes.Length;
import alma.valuetypes.Longitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Speed;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Temperature;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ValueUnitPairParser {
    protected static Map<Class, ValueUnitPair> map = new HashMap<Class, ValueUnitPair>();
    protected ValueUnitPair vup;
    protected double value;
    protected String unit;

    public ValueUnitPair parse(String string, Class clazz) {
        this.vup = this.getDefault(clazz);
        if (this.vup == null) {
            throw new IllegalArgumentException("Class " + clazz + " is not supported.");
        }
        Set set = this.vup.unitMap().keySet();
        if (this.parseString(string, set)) {
            this.vup.setContent(this.value);
            if (this.unit == null) {
                this.vup.setUnitToDefault();
            } else {
                this.vup.setUnit(this.unit);
            }
            return this.vup;
        }
        return null;
    }

    protected boolean parseString(String string, Set<String> set) {
        String string22;
        String string3 = ValueUnitPairParser.deleteBlank(string);
        string3 = string3.toLowerCase();
        this.unit = null;
        int n = string3.length();
        for (String string22 : set) {
            int n2 = string3.indexOf(string22.toLowerCase());
            if (n2 == -1 || string3.length() != n2 + string22.length()) continue;
            if (n2 < n) {
                n = n2;
                this.unit = string22;
                continue;
            }
            if (n2 != n || this.unit.length() >= string22.length()) continue;
            this.unit = string22;
        }
        string22 = string3.substring(0, n);
        try {
            this.value = string22.equals("infinity") ? Double.POSITIVE_INFINITY : (string22.equals("-infinity") ? Double.NEGATIVE_INFINITY : (string22.equals("NaN") ? Double.NaN : Double.parseDouble(string22)));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public ValueUnitPair getDefault(Class clazz) {
        ValueUnitPair valueUnitPair = map.get(clazz);
        return valueUnitPair == null ? null : (ValueUnitPair)valueUnitPair.deepCopy();
    }

    public static String deleteBlank(String string) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer(string);
        for (String string2 : stringArray = new String[]{" ", "\t"}) {
            int n;
            while ((n = stringBuffer.indexOf(string2)) >= 0) {
                stringBuffer.deleteCharAt(n);
            }
        }
        return stringBuffer.toString();
    }

    static {
        UnitMapConfigurator.configureUnitMaps();
        map.put(Angle.class, (ValueUnitPair)Angle.createAngle());
        map.put(UserAngle.class, UserAngle.createUserAngle());
        map.put(AngularVelocity.class, (ValueUnitPair)AngularVelocity.createAngularVelocity());
        map.put(DataRate.class, (ValueUnitPair)DataRate.createDataRate());
        map.put(Flux.class, (ValueUnitPair)Flux.createFlux());
        map.put(Frequency.class, (ValueUnitPair)Frequency.createFrequency());
        map.put(UserFrequency.class, (ValueUnitPair)UserFrequency.createFrequency());
        map.put(IntTimeReference.class, (ValueUnitPair)IntTimeReference.createIntTimeReference());
        map.put(IntTimeSource.class, (ValueUnitPair)IntTimeSource.createIntTimeSource());
        map.put(Latitude.class, (ValueUnitPair)Latitude.createLatitude());
        map.put(Length.class, (ValueUnitPair)Length.createLength());
        map.put(Longitude.class, (ValueUnitPair)Longitude.createLongitude());
        map.put(Sensitivity.class, (ValueUnitPair)Sensitivity.createSensitivity());
        map.put(UserSensitivity.class, UserSensitivity.createUserSensitivity());
        map.put(Speed.class, (ValueUnitPair)Speed.createSpeed());
        map.put(StorageVolume.class, (ValueUnitPair)StorageVolume.createStorageVolume());
        map.put(Temperature.class, (ValueUnitPair)Temperature.createTemperature());
        map.put(Time.class, (ValueUnitPair)Time.createTime());
    }
}

