/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.ot.editors.misc.OTTextCellEditor;
import alma.obsprep.ot.gui.resources.Colors;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.JTextField;

public abstract class ValueCellEditor
extends OTTextCellEditor {
    protected JTextField textField;
    protected Object value;

    public ValueCellEditor() {
        super(new JTextField());
        this.textField = (JTextField)this.editorComponent;
        this.textField.setHorizontalAlignment(4);
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValueCellEditor.this.stopCellEditing();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.setValue(object);
        return this.textField;
    }

    public void setValue(Object object) {
        this.value = object;
        this.textField.setText(object.toString());
    }

    public abstract boolean verify(String var1);

    @Override
    public boolean stopCellEditing() {
        this.textField.setForeground(Color.BLACK);
        if (!this.verify(this.textField.getText())) {
            this.textField.setForeground(Colors.OT_RED);
            return false;
        }
        return super.stopCellEditing();
    }

    public static class Natural
    extends ValueCellEditor {
        @Override
        public Object getCellEditorValue() {
            String string = this.textField.getText();
            try {
                this.value = java.lang.Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.value;
        }

        @Override
        public boolean verify(String string) {
            try {
                int n = java.lang.Integer.parseInt(string);
                return n > 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static class Integer
    extends ValueCellEditor {
        @Override
        public Object getCellEditorValue() {
            String string = this.textField.getText();
            try {
                this.value = java.lang.Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.value;
        }

        @Override
        public boolean verify(String string) {
            try {
                java.lang.Integer.parseInt(string);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static class Double
    extends ValueCellEditor {
        @Override
        public Object getCellEditorValue() {
            String string = this.textField.getText();
            try {
                this.value = java.lang.Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.value;
        }

        @Override
        public boolean verify(String string) {
            try {
                java.lang.Double.parseDouble(string);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

