/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.bo.obsproject.OpticalPointingTargetParameters;
import alma.obsprep.ot.editors.misc.TableRowsLoader;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.util.Convert;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

class TargetListTableLoader
extends TableRowsLoader {
    static final int FIELD_RA = 1;
    static final int FIELD_DEC = 2;
    static final int FIELD_MAGNITUDE = 3;
    static final int FIELD_PMRA = 4;
    static final int FIELD_PMDEC = 5;
    static final int FIELD_PARALLAX = 6;
    protected ArrayList list = new ArrayList();

    TargetListTableLoader() {
    }

    public void add(Object object) {
        this.list.add(object);
    }

    @Override
    public void init() {
        this.list.clear();
    }

    @Override
    public void parse(String[] stringArray, StringBuilder stringBuilder) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(stringArray[0]);
        int n = 1;
        try {
            try {
                vector.add(Double.parseDouble(stringArray[n]));
            }
            catch (NumberFormatException numberFormatException) {
                vector.add(Convert.HHMMSSToDeg(stringArray[n]));
            }
        }
        catch (Exception exception) {
            stringBuilder.append("column " + n + ": " + exception + "\n");
            vector.add(0.0);
        }
        ++n;
        try {
            try {
                vector.add(Double.parseDouble(stringArray[n]));
            }
            catch (NumberFormatException numberFormatException) {
                vector.add(Convert.DDMMSSToDeg(stringArray[n]));
            }
        }
        catch (Exception exception) {
            stringBuilder.append("column " + n + ": " + exception + "\n");
            vector.add(0.0);
        }
        ++n;
        while (n < stringArray.length) {
            try {
                vector.add(Double.parseDouble(stringArray[n]));
            }
            catch (Exception exception) {
                stringBuilder.append("column " + n + ": " + exception + "\n");
                vector.add(0.0);
            }
            ++n;
        }
        if (stringBuilder.length() == 0) {
            this.load(vector);
        }
    }

    public void load(Vector vector) {
        OpticalPointingTargetParameters opticalPointingTargetParameters = OpticalPointingTargetParameters.createOpticalPointingTargetParameters();
        opticalPointingTargetParameters.setSourceName((String)vector.get(0));
        SkyCoordinates skyCoordinates = opticalPointingTargetParameters.getSourceCoordinates();
        skyCoordinates.getLongitude().setContent((Double)vector.get(1));
        skyCoordinates.getLongitude().setUnit(Longitude.UNIT_DEG);
        skyCoordinates.getLatitude().setContent((Double)vector.get(2));
        skyCoordinates.getLatitude().setUnit(Latitude.UNIT_DEG);
        opticalPointingTargetParameters.getPmRA().setContent((Double)vector.get(4));
        opticalPointingTargetParameters.getPmRA().setUnit(AngularVelocity.UNIT_MAS_YR);
        opticalPointingTargetParameters.getPmDec().setContent((Double)vector.get(5));
        opticalPointingTargetParameters.getPmDec().setUnit(AngularVelocity.UNIT_MAS_YR);
        opticalPointingTargetParameters.setVisibleMagnitude((Double)vector.get(3));
        try {
            opticalPointingTargetParameters.getParallax().setContent((Double)vector.get(6));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            opticalPointingTargetParameters.getParallax().setContent(0.0);
        }
        opticalPointingTargetParameters.getParallax().setUnit(Angle.UNIT_MAS);
        this.add((Object)opticalPointingTargetParameters);
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        TargetListTableLoader targetListTableLoader = new TargetListTableLoader();
        try {
            targetListTableLoader.loadList(new File("test/alma/obsprep/services/optical/refdata/trcOP.scat.txt"), "\t");
            System.out.println("#records = " + targetListTableLoader.getList().size());
            for (int i = 0; i < 5; ++i) {
                OpticalPointingTargetParameters opticalPointingTargetParameters = (OpticalPointingTargetParameters)((Object)targetListTableLoader.getList().get(i));
                String string = opticalPointingTargetParameters.getSourceName() + ", " + opticalPointingTargetParameters.getSourceCoordinates().getLongitude() + ", " + opticalPointingTargetParameters.getSourceCoordinates().getLatitude() + ", " + opticalPointingTargetParameters.getPmRA() + ", " + opticalPointingTargetParameters.getPmDec() + ", " + opticalPointingTargetParameters.getVisibleMagnitude() + ", " + opticalPointingTargetParameters.getParallax();
                System.out.println(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public ArrayList getList() {
        return this.list;
    }
}

