/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.hla.runtime.obsprep.util.Log;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import lombok.NonNull;

public abstract class TableRowsLoader {
    public static final String LINESEPARATOR = "--";

    public abstract void parse(String[] var1, StringBuilder var2) throws UnableToParseLineException;

    public abstract void init();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadList(File file, String string) throws IOException {
        boolean bl = true;
        this.init();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        try (LineNumberReader lineNumberReader = null;){
            lineNumberReader = this.preparedReader(file);
            do {
                if ((string2 = lineNumberReader.readLine()) == null) {
                    break;
                }
                if ((string2 = string2.trim()).equals("") || string2.startsWith("#")) continue;
                stringBuilder.setLength(0);
                this.parseValues(string2, string, stringBuilder);
                if (stringBuilder.length() <= 0) continue;
                Log.logger((Object)this).warning("Errors while reading line " + lineNumberReader.getLineNumber() + " of list file:\n" + stringBuilder.toString());
                bl = false;
            } while (string2 != null);
        }
        return bl;
    }

    protected LineNumberReader preparedReader(@NonNull File file) throws IOException {
        String string;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        while ((string = lineNumberReader.readLine()) != null) {
            if (string.startsWith(LINESEPARATOR)) {
                return lineNumberReader;
            }
            if (string != null) continue;
        }
        lineNumberReader.close();
        lineNumberReader = new LineNumberReader(new FileReader(file));
        return lineNumberReader;
    }

    protected void parseValues(String string, String string2, StringBuilder stringBuilder) throws UnableToParseLineException {
        String[] stringArray = null;
        try {
            stringArray = string.split(string2);
        }
        catch (Exception exception) {
            stringBuilder.append(exception + "\n");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        this.parse(stringArray, stringBuilder);
    }

    public class UnableToParseLineException
    extends Exception {
        UnableToParseLineException(String string) {
            super(string);
        }
    }
}

