/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.models.misc.TabbedEditorModel;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class TabbedEditor
extends Editor {
    public static final FieldID FID_TABSELECTION = new FieldID("TabbedEditor.tabSelection");
    public static final FieldID FID_MULTIDOCUMENT = new FieldID("TabbedEditor.tabbedPane");
    public static final FieldID FID_SUBDOCUMENT = new FieldID("TabbedEditor.subDocument");
    protected final FieldID FID_ADD_BUTTON = new FieldID("TabbedEditor.addButton");
    protected final FieldID FID_DELETE_BUTTON = new FieldID("TabbedEditor.delButton");
    protected JTabbedPane tabbedPane;
    protected ArrayList<ChangeListener> listeners = new ArrayList();
    protected int maxNumberOfSubBO = -1;
    protected int minNumberOfSubBO = 0;
    protected Editor subEditor;
    private boolean pending = false;

    public TabbedEditor() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(0);
        this.initEvents(this.tabbedPane, FID_TABSELECTION);
    }

    public TabbedEditor(TabbedEditorModel tabbedEditorModel, Editor editor) {
        this();
        this.subEditor = editor;
        this.registerSubView(this.subEditor);
        this.setModel(tabbedEditorModel);
        this.build();
        tabbedEditorModel.publish();
    }

    @Override
    public TabbedEditorModel getModel() {
        return (TabbedEditorModel)super.getModel();
    }

    @Override
    protected void build() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(this.tabbedPane);
        if (this.showsButtonBox()) {
            this.add(this.createButtons());
        }
    }

    protected boolean showsButtonBox() {
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.tabbedPane.addChangeListener(changeListener);
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.tabbedPane.removeChangeListener(changeListener);
        this.listeners.remove(changeListener);
    }

    protected void fireStateChanged() {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    protected Component createButtons() {
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton("Add");
        this.initEvents(jButton, this.FID_ADD_BUTTON);
        box.add(jButton);
        jButton = new JButton("Delete");
        this.initEvents(jButton, this.FID_DELETE_BUTTON);
        box.add(jButton);
        return box;
    }

    public int getSelectedIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public void setSelectedIndex(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    protected void updateButtons() {
        if (this.showsButtonBox()) {
            this.updateDefaultButtons();
        }
    }

    protected void updateDefaultButtons() {
        JButton jButton = (JButton)this.retrieve(this.FID_ADD_BUTTON);
        JButton jButton2 = (JButton)this.retrieve(this.FID_DELETE_BUTTON);
        jButton.setEnabled(true);
        jButton2.setEnabled(true);
        int n = this.getBOCount();
        if (n <= this.minNumberOfSubBO) {
            jButton2.setEnabled(false);
        }
        if (this.maxNumberOfSubBO > 0 && n >= this.maxNumberOfSubBO) {
            jButton.setEnabled(false);
        }
    }

    public void setMaxNumberOfSubBO(int n) {
        this.maxNumberOfSubBO = n;
        this.updateButtons();
    }

    public void setMinNumberOfSubBO(int n) {
        this.minNumberOfSubBO = n;
        this.updateButtons();
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == FID_TABSELECTION) {
            if (!this.isPending()) {
                this.setSubEditorAtTab((Integer)object);
            }
            return;
        }
        if (fieldID == FID_MULTIDOCUMENT) {
            this.resetTabEditor();
            this.setSubEditorAtSelectedTab();
            this.updateButtons();
            this.setTabTitles();
            this.fireStateChanged();
            return;
        }
        if (fieldID == FID_SUBDOCUMENT) {
            TabbedEditorModel tabbedEditorModel = this.getModel();
            for (int i = 0; i < tabbedEditorModel.getBOCount(); ++i) {
                if (tabbedEditorModel.getBO(i) != object) continue;
                if (this.tabbedPane.getTabCount() > i) {
                    this.tabbedPane.setSelectedIndex(i);
                }
                return;
            }
        } else {
            if (fieldID == this.FID_ADD_BUTTON) {
                this.add();
                return;
            }
            if (fieldID == this.FID_DELETE_BUTTON) {
                this.delete();
                return;
            }
        }
        super.update(fieldID, object);
    }

    private JLabel getDummyLabel() {
        JLabel jLabel = new JLabel();
        return jLabel;
    }

    public void add() {
        Object object = this.getModel().newBO();
        Component component = this.tabbedPane.add(this.getDummyLabel());
        this.tabbedPane.setSelectedComponent(component);
        this.tabbedPane.setComponentAt(this.tabbedPane.getSelectedIndex(), this.subEditor);
        this.setSubEditorAtSelectedTab();
        this.updateButtons();
        this.setTabTitles();
    }

    public void delete() {
        Editor editor = (Editor)this.tabbedPane.getSelectedComponent();
        BusinessObject businessObject = (BusinessObject)editor.getModel().getDocument();
        this.getModel().deleteBO(businessObject);
        int n = this.tabbedPane.getSelectedIndex();
        this.tabbedPane.remove(n);
        if (n >= this.getBOCount()) {
            this.tabbedPane.setSelectedIndex(n - 1);
        }
        this.setSubEditorAtSelectedTab();
        this.updateButtons();
        this.setTabTitles();
    }

    protected int getBOCount() {
        return this.getModel().getBOCount();
    }

    protected void setSubEditorAtTab(int n) {
        if (n == -1) {
            return;
        }
        int n2 = this.tabbedPane.indexOfComponent(this.subEditor);
        if (n >= this.tabbedPane.getTabCount()) {
            this.resetTabEditor();
        }
        Object object = this.subEditor.getModel().getDocument();
        if (n >= this.getModel().getBOCount()) {
            return;
        }
        Object object2 = this.getModel().getBO(n);
        if (object != object2) {
            this.getModel().setSubDocument(object2);
        }
        this.setTabTitles();
        if (n2 == n) {
            return;
        }
        if (n2 != -1) {
            this.tabbedPane.setComponentAt(n2, this.getDummyLabel());
        }
        SwingUtilities.updateComponentTreeUI(this.subEditor);
        this.tabbedPane.setComponentAt(n, this.subEditor);
        this.tabbedPane.setSelectedComponent(this.subEditor);
        this.setTitle(n);
        this.getModel().publish(FID_SUBDOCUMENT, object2);
        this.getModel().getSubModel().publish();
    }

    protected void setSubEditorAtSelectedTab() {
        int n = this.tabbedPane.getSelectedIndex();
        this.setSubEditorAtTab(n);
    }

    private void setPending(boolean bl) {
        this.pending = bl;
    }

    private boolean isPending() {
        return this.pending;
    }

    protected void setTabTitles() {
        for (int i = 0; i < this.getModel().getBOCount(); ++i) {
            this.setTitle(i);
        }
    }

    protected void setTitle(int n) {
        String string = this.tabTitle(n);
        if (string == null || string.length() == 0) {
            try {
                Object object = this.getModel().getBO(n);
                if (object != null) {
                    string = ((BusinessObject)object).getName();
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.tabbedPane.setTitleAt(n, string);
    }

    protected String tabTitle(int n) {
        return null;
    }

    public void resetTabEditor() {
        int n;
        ChangeListener[] changeListenerArray;
        this.setPending(true);
        for (ChangeListener changeListener : changeListenerArray = this.tabbedPane.getChangeListeners()) {
            this.tabbedPane.removeChangeListener(changeListener);
        }
        int n2 = this.getBOCount();
        int n3 = this.tabbedPane.getTabCount();
        if (n2 == 0) {
            this.tabbedPane.removeAll();
        } else if (n2 > n3) {
            for (n = n3; n < n2; ++n) {
                this.tabbedPane.addTab("", this.getDummyLabel());
            }
        } else if (n2 < n3) {
            n = 0;
            for (int i = n3; i > n2; --i) {
                if (this.tabbedPane.getComponentAt(i - 1) == this.subEditor) {
                    n = 1;
                    continue;
                }
                this.tabbedPane.remove(i - 1);
            }
            if (n != 0) {
                this.tabbedPane.remove(0);
            }
        }
        for (ChangeListener changeListener : changeListenerArray) {
            this.tabbedPane.addChangeListener(changeListener);
        }
        this.setPending(false);
    }
}

