/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.editors.misc.ReceiverBandLabelConverter;
import alma.obsprep.ot.editors.misc.ValueUnitPairParser;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.obsprep.services.experts.spectralline.gui.UnitFormat;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserSensitivity;

public class ScienceGoalSummaryTableColumns
implements SummaryTableColumns {
    protected static final int COL_GOALNAME = 0;
    protected static final int COL_NUMSOURCES = 1;
    protected static final int COL_BAND = 2;
    protected static final int COL_SPECTRALTYPE = 3;
    protected static final int COL_NUMWINDOWS = 4;
    protected static final int COL_POLARISATION = 5;
    protected static final int COL_CALIBRATIONS = 6;
    protected static final int COL_ANGULARESOL = 7;
    protected static final int COL_LARGESTSCALE = 8;
    protected static final int COL_REPFREQ = 9;
    protected static final int COL_SENSITIVITY = 10;
    protected static final int NUM_COLUMNS = 11;
    public static Object[] longValues = new Object[]{"B3 spectral sweep CO (9-8)", "5", "10", "full", "4", "double", "system", "3.0 arcsec", "0.0 arcsec", "85.125 GHz", "1.4E-4 Jy"};
    private ScienceGoal scienceGoal;

    public ScienceGoalSummaryTableColumns(ScienceGoal scienceGoal) {
        this.scienceGoal = scienceGoal;
    }

    @Override
    public SummaryTableRow getSummaryTableRow() {
        return this.scienceGoal;
    }

    @Override
    public Class<?> getSummaryColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Integer.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return UserAngle.class;
            }
            case 8: {
                return Angle.class;
            }
            case 9: {
                return String.class;
            }
            case 10: {
                return String.class;
            }
        }
        throw new RuntimeException(String.format("Invalid column number (%d)", n));
    }

    @Override
    public int getSummaryColumnCount() {
        return 11;
    }

    @Override
    public String getSummaryColumnName(int n) {
        switch (n) {
            case 0: {
                return "Science Goal";
            }
            case 1: {
                return "No. Sources";
            }
            case 2: {
                return "Band";
            }
            case 3: {
                return "Spec. Type";
            }
            case 4: {
                return "No. Spec. Win.";
            }
            case 5: {
                return "Pol.";
            }
            case 6: {
                return "Calibration Setup";
            }
            case 7: {
                return "Ang. Res.";
            }
            case 8: {
                return "Largest Scale";
            }
            case 9: {
                return "Rep. Freq.";
            }
            case 10: {
                return "Sens.";
            }
        }
        throw new RuntimeException(String.format("Invalid column number (%d)", n));
    }

    public String humanReadableSpectralType(String string) {
        if (string.equals("full")) {
            return "Spectral line";
        }
        if (string.equals("continuum")) {
            return "Continuum";
        }
        if (string.equals("scan")) {
            return "Scan";
        }
        return string;
    }

    public int humanReadableNumberOfSpectralWindows(String string, int n) {
        if (string.equals("full")) {
            return n;
        }
        if (string.equals("continuum")) {
            return 4;
        }
        if (string.equals("scan")) {
            return n;
        }
        return n;
    }

    public String humanReadablePolarisation(CorrPolarization corrPolarization) {
        String string = corrPolarization.toString();
        if (string.equals("SINGLE_X")) {
            return "XX";
        }
        if (string.equals("SINGLE_Y")) {
            return "YY";
        }
        if (string.equals("DOUBLE")) {
            return "Dual";
        }
        if (string.equals("FULL")) {
            return "Full";
        }
        return string;
    }

    public String humanReadableCalibration(String string) {
        if (string.equals(CalibrationSetupParameters.SELECTION_SYSTEM)) {
            return "System";
        }
        if (string.equals(CalibrationSetupParameters.SELECTION_USER)) {
            return "User";
        }
        if (string.equals(CalibrationSetupParameters.SELECTION_SYSTEMALTERNATE)) {
            return "System (with amp)";
        }
        return string;
    }

    @Override
    public Object getSummaryValueAt(int n) {
        switch (n) {
            case 0: {
                return this.scienceGoal.getName();
            }
            case 1: {
                return this.scienceGoal.getTargetParametersCount();
            }
            case 2: {
                try {
                    ReceiverBand receiverBand = this.scienceGoal.getReceiverBand();
                    if (receiverBand == null) {
                        return "undefined";
                    }
                    return ReceiverBandLabelConverter.convert(receiverBand.getName());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return "undefined";
                }
            }
            case 3: {
                return this.humanReadableSpectralType(this.scienceGoal.getSpectralSetupParameters().getType());
            }
            case 4: {
                SpectralScan spectralScan;
                if (this.scienceGoal.getSpectralSetupParameters().getType().equals(SpectralSetupParameters.TYPE_SCAN) && (spectralScan = this.scienceGoal.getSpectralSetupParameters().getSpectralScan()) != null) {
                    try {
                        SpectralScan.SpectralScanTunings spectralScanTunings = spectralScan.getTunings();
                        Integer n2 = spectralScanTunings.getNumberOfSPWs() * spectralScanTunings.getNumberOfTunings();
                        return this.humanReadableNumberOfSpectralWindows(this.scienceGoal.getSpectralSetupParameters().getType(), n2);
                    }
                    catch (UnableToFindSolutionException unableToFindSolutionException) {
                        return this.humanReadableNumberOfSpectralWindows(this.scienceGoal.getSpectralSetupParameters().getType(), 0);
                    }
                    catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
                        return this.humanReadableNumberOfSpectralWindows(this.scienceGoal.getSpectralSetupParameters().getType(), 0);
                    }
                }
                return this.humanReadableNumberOfSpectralWindows(this.scienceGoal.getSpectralSetupParameters().getType(), this.scienceGoal.getSpectralSetupParameters().getScienceSpectralWindowCount());
            }
            case 5: {
                return this.humanReadablePolarisation(this.scienceGoal.getSpectralSetupParameters().getCorrPolarization());
            }
            case 6: {
                return this.humanReadableCalibration(this.scienceGoal.getCalibrationSetupParameters().getSelection());
            }
            case 7: {
                String string = this.scienceGoal.getPerformanceParameters().getDesiredAngularResolution().getUserUnit();
                if (string.equals(UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM)) {
                    double d = this.scienceGoal.getPerformanceParameters().getDesiredAngularResolution().getContentInUnits(UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM);
                    return String.format("%.4f fomb", d);
                }
                return this.scienceGoal.getPerformanceParameters().getDesiredAngularResolution();
            }
            case 8: {
                if (this.scienceGoal.getPerformanceParameters().getDesiredLargestScale().isLessThan((AbstractDoubleWithUnit)Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC))) {
                    return "Undefined";
                }
                return this.scienceGoal.getPerformanceParameters().getDesiredLargestScale();
            }
            case 9: {
                return this.getFrequencyFormattedValue(this.scienceGoal.getRepresentativeFrequency());
            }
            case 10: {
                UserSensitivity userSensitivity = this.scienceGoal.getPerformanceParameters().getDesiredSensitivity();
                return this.getSensitivityFormattedValue(userSensitivity);
            }
        }
        return null;
    }

    public String getSensitivityFormattedValue(UserSensitivity userSensitivity) {
        double d;
        UnitFormat unitFormat;
        if (userSensitivity.inTemperatureUnit()) {
            unitFormat = UnitFormat.temperature();
            d = userSensitivity.getContentInUnits(UserSensitivity.USERUNIT_K);
        } else {
            unitFormat = UnitFormat.fluxDensity();
            d = userSensitivity.getContentInUnits(UserSensitivity.USERUNIT_JY);
        }
        if (d == 0.0) {
            return "Undefined";
        }
        return unitFormat.format(d);
    }

    public String getFrequencyFormattedValue(Frequency frequency) {
        UnitFormat unitFormat = UnitFormat.frequency();
        double d = frequency.getContentInUnits(Frequency.UNIT_HZ);
        if (d == 0.0) {
            return "Undefined";
        }
        return unitFormat.format(d);
    }

    @Override
    public boolean isSummaryCellEditable(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return false;
            }
        }
        throw new RuntimeException(String.format("Invalid column number (%d)", n));
    }

    @Override
    public boolean isSummaryCellEnable(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        throw new RuntimeException(String.format("Invalid column number (%d)", n));
    }

    @Override
    public void setSummaryValueAt(Object object, int n) {
        switch (n) {
            case 0: {
                this.scienceGoal.setName((String)object);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.scienceGoal.getSpectralSetupParameters().setSpectralType(SpectralSetupParameters.SpectralSetupTypeChoice.getTypeChoice((String)object));
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.scienceGoal.getSpectralSetupParameters().setPolarisation((String)object);
                break;
            }
            case 6: {
                this.scienceGoal.getCalibrationSetupParameters().setSelection((String)object);
                break;
            }
            case 7: {
                UserAngle userAngle = (UserAngle)object;
                this.scienceGoal.getPerformanceParameters().setDesiredAngularResolution(userAngle);
                break;
            }
            case 8: {
                Angle angle = (Angle)((Object)object);
                this.scienceGoal.getPerformanceParameters().setDesiredLargestScale(angle);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                UserSensitivity userSensitivity = (UserSensitivity)object;
                this.scienceGoal.getPerformanceParameters().setDesiredSensitivity(userSensitivity);
                break;
            }
            default: {
                return;
            }
        }
    }

    public Object parseSummaryValueAt(String string, int n) {
        ValueUnitPairParser valueUnitPairParser = new ValueUnitPairParser();
        switch (n) {
            case 0: {
                return string;
            }
            case 1: {
                return Integer.parseInt(string);
            }
            case 2: {
                return TextUtils.getChoice(string, ReceiverBandLabelConverter.getKnownFieldTypeLabelList(), false);
            }
            case 3: {
                return string;
            }
            case 4: {
                return Integer.parseInt(string);
            }
            case 5: {
                return string;
            }
            case 6: {
                return string;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                Class<?> clazz = this.getSummaryColumnClass(n);
                ValueUnitPair valueUnitPair = valueUnitPairParser.parse(string, clazz);
                return valueUnitPair == null ? valueUnitPairParser.getDefault(clazz) : valueUnitPair;
            }
        }
        throw new RuntimeException(String.format("Invalid column number (%d)", n));
    }

    @Override
    public Object[] getSummaryColumnKnownItemList(int n) {
        switch (n) {
            case 2: {
                return ReceiverBandLabelConverter.getKnownFieldTypeLabelList();
            }
        }
        return null;
    }

    @Override
    public Object[] getLongValues() {
        return longValues;
    }

    @Override
    public String getHeaderText() {
        return this.getLineText(true);
    }

    @Override
    public String getLineText() {
        return this.getLineText(false);
    }

    protected String getLineText(boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.getSummaryColumnCount(); ++n) {
            String string = bl ? this.getSummaryColumnName(n) : this.getValueString(n);
            stringBuffer.append(string);
            stringBuffer.append(",").append(" ");
        }
        n = stringBuffer.lastIndexOf(",");
        if (n >= 0) {
            stringBuffer.delete(n, stringBuffer.length());
        }
        return stringBuffer.toString();
    }

    protected String getValueString(int n) {
        Object object = this.getSummaryValueAt(n);
        String string = object == null ? "" : object.toString();
        Class<?> clazz = this.getSummaryColumnClass(n);
        if (clazz == Longitude.class) {
            try {
                Longitude longitude = (Longitude)((Object)this.getSummaryValueAt(n));
                string = longitude.toHHMMSS();
            }
            catch (Exception exception) {}
        } else if (clazz == Latitude.class) {
            try {
                Latitude latitude = (Latitude)((Object)this.getSummaryValueAt(n));
                string = latitude.toDDMMSS();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public void load(String[] stringArray) {
        Object object;
        System.out.println("ScienceGoalSummaryTableColumns::load()");
        if (stringArray.length != this.getSummaryColumnCount()) {
            return;
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < this.getSummaryColumnCount(); ++i) {
            object = stringArray[i];
            objectArray[i] = this.parseSummaryValueAt((String)object, i);
        }
        TargetParameters targetParameters = TargetParameters.createTargetParameters();
        this.scienceGoal.addTargetParameters(targetParameters);
        object = SpectralSetupParameters.createSpectralSetupParameters();
        ((SpectralSetupParameters)((Object)object)).clearAbstractScienceSpectralWindow();
        object.addAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)ScienceSpectralWindow.createScienceSpectralWindow()));
        this.scienceGoal.setSpectralSetupParameters((SpectralSetupParameters)((Object)object));
        for (int i = 0; i < this.getSummaryColumnCount(); ++i) {
            this.setSummaryValueAt(objectArray[i], i);
        }
    }
}

