/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.ot.editors.misc.SummaryTableRowsLoader;
import alma.obsprep.ot.editors.schedblock.PointingPatternEditor;
import alma.obsprep.util.Convert;
import alma.obsprep.util.Convert4dp;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;

public class IndividualPointingsTableLoader
extends SummaryTableRowsLoader {
    private PointingPatternEditor.PointingStorageFormat predominantCoordinateType = null;
    protected static final int EXPECTED_COLS = ColumnIndexEnumeration.values().length;

    @Override
    public void parse(String[] stringArray, StringBuilder stringBuilder) {
        if (stringArray.length < EXPECTED_COLS) {
            GUIUtilities.error(null, "<html>Input file format is invalid.<br><br>Please ensure each line in your file contains comma-separated values with column order:<ol><li>RA</li><li>Dec</li><li>Coordinate type (Absolute|Offset)</li><li>Coordinate units (Degrees|Arcmins|Arcsecs|SEXAGESIMAL|Radians)</li></ol><br><i>e.g.</i> 10.0, 20.0, Offset, Arcsecs</html>");
            throw new IllegalArgumentException();
        }
        PointingPatternEditor.PointingStorageFormat pointingStorageFormat = PointingPatternEditor.PointingStorageFormat.getExportFormat(stringArray[ColumnIndexEnumeration.COL_COORDTYPE.getColumnIndex()]);
        if (pointingStorageFormat == null) {
            GUIUtilities.warning(null, "Unable to determine coordinate type: " + stringArray[ColumnIndexEnumeration.COL_COORDTYPE.getColumnIndex()]);
            throw new IllegalArgumentException();
        }
        if (this.predominantCoordinateType == null) {
            this.predominantCoordinateType = pointingStorageFormat;
        } else if (!this.predominantCoordinateType.equals((Object)pointingStorageFormat)) {
            GUIUtilities.warning(null, "A mix of absolute and offset coordinates in the same source file is not allowed.");
            throw new IllegalArgumentException();
        }
        SkyCoordinates skyCoordinates = null;
        Latitude latitude = Latitude.createLatitude();
        Longitude longitude = Longitude.createLongitude();
        String string = stringArray[ColumnIndexEnumeration.COL_DEC.getColumnIndex()];
        String string2 = stringArray[ColumnIndexEnumeration.COL_RA.getColumnIndex()];
        block9 : switch (pointingStorageFormat) {
            case ABSOLUTECOORDS: {
                PointingPatternEditor.AbsoluteCoordsFormat absoluteCoordsFormat;
                try {
                    absoluteCoordsFormat = PointingPatternEditor.AbsoluteCoordsFormat.valueOf(stringArray[ColumnIndexEnumeration.COL_COORDUNIT.getColumnIndex()].trim().toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    GUIUtilities.error(null, "Unable to determine coordinate unit: " + stringArray[ColumnIndexEnumeration.COL_COORDUNIT.getColumnIndex()]);
                    throw new IllegalArgumentException(illegalArgumentException);
                }
                skyCoordinates = SkyCoordinates.createSkyCoordinates(SkyCoordinates.TYPE_ABSOLUTE);
                switch (absoluteCoordsFormat) {
                    case DEGREES: 
                    case RADIANS: {
                        Double d;
                        Double d2 = null;
                        try {
                            d = Double.parseDouble(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            GUIUtilities.warning(null, "Error parsing RA, set to 0.0");
                            d = 0.0;
                        }
                        try {
                            d2 = Double.parseDouble(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            GUIUtilities.warning(null, "Error parsing Dec, set to 0.0");
                            d2 = 0.0;
                        }
                        assert (d != null && d2 != null);
                        String string3 = null;
                        String string4 = null;
                        try {
                            if (absoluteCoordsFormat.equals((Object)PointingPatternEditor.AbsoluteCoordsFormat.DEGREES)) {
                                string3 = Latitude.UNIT_DEG;
                                string4 = Longitude.UNIT_DEG;
                            } else if (absoluteCoordsFormat.equals((Object)PointingPatternEditor.AbsoluteCoordsFormat.RADIANS)) {
                                string3 = Latitude.UNIT_RAD;
                                string4 = Longitude.UNIT_RAD;
                            } else {
                                throw new IllegalArgumentException("Unknown absolute coordinate unit : " + absoluteCoordsFormat);
                            }
                            assert (string3 != null || string4 != null);
                            latitude = Latitude.createLatitude((double)d2, (String)string3);
                            longitude = Longitude.createLongitude((double)d, (String)string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            GUIUtilities.warning(null, "Unable to parse RA and Dec " + string2 + " " + string + " - setting to 0.0");
                            longitude.setContentAndUnit(0.0, string4);
                            latitude.setContentAndUnit(0.0, string3);
                        }
                        break block9;
                    }
                    case SEXAGESIMAL: {
                        try {
                            longitude.setContentInDeg(Convert4dp.HHMMSSToDeg(string2));
                        }
                        catch (InvalidCoordException | NumberFormatException exception) {
                            GUIUtilities.warning(null, "Error parsing RA, set to 0.0");
                            longitude.setContentInDeg(0.0);
                        }
                        try {
                            latitude.setContentInDeg(Convert.DDMMSSToDeg(string));
                        }
                        catch (InvalidCoordException | NumberFormatException exception) {
                            GUIUtilities.warning(null, "Error parsing Dec, set to 0.0: " + string);
                            latitude.setContentInDeg(0.0);
                        }
                        break block9;
                    }
                }
                throw new IllegalArgumentException("Unknown absolute coordinate unit specified: " + absoluteCoordsFormat);
            }
            case OFFSETCOORDS: {
                Double d;
                PointingPatternEditor.OffsetCoordsFormat offsetCoordsFormat;
                try {
                    offsetCoordsFormat = PointingPatternEditor.OffsetCoordsFormat.valueOf(stringArray[ColumnIndexEnumeration.COL_COORDUNIT.getColumnIndex()].trim().toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    GUIUtilities.error(null, "Unable to determine coordinate unit: " + stringArray[ColumnIndexEnumeration.COL_COORDUNIT.getColumnIndex()]);
                    throw new IllegalArgumentException(illegalArgumentException);
                }
                skyCoordinates = SkyCoordinates.createSkyCoordinates(SkyCoordinates.TYPE_RELATIVE);
                Double d3 = null;
                try {
                    d = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    GUIUtilities.warning(null, "Error parsing RA, set to 0.0");
                    d = 0.0;
                }
                try {
                    d3 = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    GUIUtilities.warning(null, "Error parsing Dec, set to 0.0");
                    d3 = 0.0;
                }
                switch (offsetCoordsFormat) {
                    case ARCMINS: {
                        latitude = Latitude.createLatitude((double)d3, (String)Latitude.UNIT_ARCMIN);
                        longitude = Longitude.createLongitude((double)d, (String)Latitude.UNIT_ARCMIN);
                        break block9;
                    }
                    case ARCSECS: {
                        latitude = Latitude.createLatitude((double)d3, (String)Latitude.UNIT_ARCSEC);
                        longitude = Longitude.createLongitude((double)d, (String)Latitude.UNIT_ARCSEC);
                        break block9;
                    }
                    case DEGREES: {
                        latitude = Latitude.createLatitude((double)d3, (String)Latitude.UNIT_DEG);
                        longitude = Longitude.createLongitude((double)d, (String)Latitude.UNIT_DEG);
                        break block9;
                    }
                }
                throw new RuntimeException("Unknown offset coord specified : " + offsetCoordsFormat);
            }
            default: {
                throw new IllegalArgumentException("Unknown coordType: " + pointingStorageFormat);
            }
        }
        assert (skyCoordinates != null);
        assert (latitude != null && longitude != null);
        skyCoordinates.setLatitude(latitude);
        skyCoordinates.setLongitude(longitude);
        if (pointingStorageFormat == PointingPatternEditor.PointingStorageFormat.ABSOLUTECOORDS && !skyCoordinates.verifySkyCoordinates()) {
            GUIUtilities.warning(null, "Absolute coordinates out of range: " + longitude + " " + latitude);
            skyCoordinates.setLatitude(Latitude.createLatitude());
            skyCoordinates.setLongitude(Longitude.createLongitude());
        }
        this.add(skyCoordinates);
    }

    public static enum ColumnIndexEnumeration {
        COL_RA(0),
        COL_DEC(1),
        COL_COORDTYPE(2),
        COL_COORDUNIT(3);

        private final int columnIndex;

        public static ColumnIndexEnumeration findColumnIndex(int n) {
            for (ColumnIndexEnumeration columnIndexEnumeration : ColumnIndexEnumeration.values()) {
                if (n != columnIndexEnumeration.getColumnIndex()) continue;
                return columnIndexEnumeration;
            }
            throw new IllegalArgumentException("Unable to find index in the enumeration: " + n);
        }

        private ColumnIndexEnumeration(int n2) {
            this.columnIndex = n2;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }
    }
}

