/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;

public class FieldSourceSummaryTableColumns
implements SummaryTableColumns {
    protected static final int COL_PARAMNAME = 0;
    protected static final int COL_SOURCENAME = 1;
    protected static final int COL_RA = 2;
    protected static final int COL_DEC = 3;
    protected static final int COL_PATTERNTYPE = 4;
    protected static final int NUM_COLUMNS = 5;
    public static Object[] longValues = new Object[]{"FieldSource Name", "Source Name", " 00:00:00.000", "+00:00:00.000", "Rectangle"};
    private FieldSource fs;

    public FieldSourceSummaryTableColumns(FieldSource fieldSource) {
        this.fs = fieldSource;
    }

    @Override
    public int getSummaryColumnCount() {
        return 5;
    }

    @Override
    public String getSummaryColumnName(int n) {
        switch (n) {
            case 0: {
                return "FieldSource Name";
            }
            case 1: {
                return "SourceName";
            }
            case 2: {
                return "RA";
            }
            case 3: {
                return "Dec";
            }
            case 4: {
                return "PatternType";
            }
        }
        return "";
    }

    @Override
    public Object getSummaryValueAt(int n) {
        FieldPattern fieldPattern = this.fs.getFieldPattern();
        switch (n) {
            case 0: {
                return this.fs.getName();
            }
            case 1: {
                return this.fs.getSourceName();
            }
            case 2: {
                return this.fs.getSourceCoordinates().getJ2000SkyCoordinates().getLongitude();
            }
            case 3: {
                return this.fs.getSourceCoordinates().getJ2000SkyCoordinates().getLatitude();
            }
            case 4: {
                return this.fs.getFieldPatternType();
            }
        }
        return null;
    }

    @Override
    public void setSummaryValueAt(Object object, int n) {
    }

    @Override
    public String getHeaderText() {
        return null;
    }

    @Override
    public String getLineText() {
        return null;
    }

    @Override
    public Object[] getLongValues() {
        return longValues;
    }

    @Override
    public Class<?> getSummaryColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Longitude.class;
            }
            case 3: {
                return Latitude.class;
            }
            case 4: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object[] getSummaryColumnKnownItemList(int n) {
        return null;
    }

    @Override
    public SummaryTableRow getSummaryTableRow() {
        return this.fs;
    }

    @Override
    public boolean isSummaryCellEditable(int n) {
        return false;
    }

    @Override
    public boolean isSummaryCellEnable(int n) {
        return true;
    }
}

