/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.investigator.verifiers;

import alma.obsprep.ot.editors.investigator.verifiers.TextFieldVerifier;
import alma.obsprep.ot.gui.resources.Colors;
import java.awt.Color;
import javax.swing.JTextField;

public class MinLengthVerifier
extends TextFieldVerifier {
    private final JTextField textField;
    private final int minLength;

    public MinLengthVerifier(JTextField jTextField, int n) {
        this.textField = jTextField;
        this.minLength = n;
    }

    @Override
    public boolean isValid() {
        if (this.textField != null && this.textField.getText().length() >= this.minLength) {
            String[] stringArray;
            for (String string : stringArray = this.textField.getText().split(",")) {
                if (string.length() >= this.minLength) continue;
                this.textField.setForeground(Colors.OT_RED);
                return false;
            }
            if (this.textField.getForeground() == Colors.OT_RED) {
                this.textField.setForeground(Color.BLACK);
            }
            return true;
        }
        if (this.textField != null) {
            this.textField.setForeground(Colors.OT_RED);
        }
        return false;
    }

    @Override
    public String getInvalidTooltip() {
        return "At least " + this.minLength + " characters required for search";
    }
}

