/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.boEditors;

import alma.obsprep.bo.TestUtilities;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.guiutil.mvc.verifiers.IntegerVerifier;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.guiutil.mvc.widgets.OTComboBox;
import alma.obsprep.guiutil.mvc.widgets.OTFileArea;
import alma.obsprep.guiutil.mvc.widgets.OTTextArea;
import alma.obsprep.ot.editors.misc.IsoDatePicker;
import alma.obsprep.ot.editors.valuetypes.SkyCoordsEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.editors.valuetypes.VelocityEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.EditorDisablerController;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.VelocityModel;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Stream;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import lombok.NonNull;

public abstract class EditorWithGridBagLayout
extends Editor {
    private static final long serialVersionUID = -304618038986054415L;
    public static final int FILL_LINE = 0;
    public static final int IN_SAME_COLUMN = 4;
    public static final int IN_SAME_ROW = 5;
    protected static final int DEFAULT_TEXTFIELDWIDTH = 15;
    protected int textFieldWidth = 15;
    protected GridBagLayout layout;
    protected GridBagConstraints constraints;
    private ArrayList<JButton> expandButtons = new ArrayList();
    private ArrayList<JButton> collapseButtons = new ArrayList();

    protected abstract void addComponents(String var1);

    protected void build(String string) {
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        this.constraints.anchor = 17;
        this.constraints.fill = 2;
        this.constraints.gridy = 0;
        this.addComponents(string);
        this.addGlobalButtons();
    }

    protected boolean wantGlobalButtons() {
        return true;
    }

    protected void addGlobalButtons() {
        if (this.expandButtons.size() > 1 && this.wantGlobalButtons()) {
            JButton jButton = new JButton("Show All");
            JButton jButton2 = new JButton("Hide All");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jButton.setToolTipText("Show all the information.");
            jButton2.setToolTipText("Hide all the information.");
            this.addComponent(jPanel);
            jButton.addActionListener(new GlobalActionListener(true));
            jButton2.addActionListener(new GlobalActionListener(false));
        }
    }

    protected GridBagLayout createNewLayout(JPanel jPanel) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        return gridBagLayout;
    }

    protected GridBagConstraints createNewConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        return gridBagConstraints;
    }

    protected JPanel createCollapsingGroup(JComponent jComponent, String string, boolean bl) {
        JPanel jPanel = this.createNewGroup();
        JButton jButton = new JButton(Icons.question);
        jButton.setPreferredSize(new Dimension(Icons.question.getIconWidth(), Icons.question.getIconHeight()));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        JButton jButton2 = new JButton(Icons.plus);
        jButton2.setPreferredSize(new Dimension(Icons.plus.getIconWidth(), Icons.plus.getIconHeight()));
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton2.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        JButton jButton3 = new JButton(Icons.minus);
        jButton3.setPreferredSize(new Dimension(Icons.minus.getIconWidth(), Icons.minus.getIconHeight()));
        jButton3.setMargin(new Insets(0, 0, 0, 0));
        jButton3.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel2.add(new Box.Filler(new Dimension(4, 0), new Dimension(4, 0), new Dimension(4, 0)));
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jButton.setToolTipText("Display help from reference manual");
        jButton2.setToolTipText("Show the " + string + " information");
        jButton3.setToolTipText("Hide the " + string + " information");
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(jPanel2.getWidth(), 1)));
        jPanel.add(jComponent);
        jPanel.add(Box.createRigidArea(new Dimension(jComponent.getWidth(), 1)));
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        ObservingToolController observingToolController = ObservingToolController.getMyInstance();
        if (observingToolController != null) {
            jButton.addActionListener((ActionListener)new CSH.DisplayHelpFromFocus(observingToolController.getReferenceManualHS(), "javax.help.MainWindow", null));
        }
        this.expandButtons.add(jButton2);
        this.collapseButtons.add(jButton3);
        jButton2.addActionListener(new GroupActionListener(jButton2, jButton3, jComponent, true));
        jButton3.addActionListener(new GroupActionListener(jButton2, jButton3, jComponent, false));
        if (bl) {
            jButton3.doClick();
        }
        return jPanel;
    }

    protected JPanel createNonCollapsingGroup(JComponent jComponent, String string) {
        JPanel jPanel = this.createNewGroup();
        JButton jButton = new JButton(Icons.question);
        jButton.setPreferredSize(new Dimension(Icons.question.getIconWidth(), Icons.question.getIconHeight()));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText("Display help from reference manual");
        jButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(jPanel2.getWidth(), 1)));
        jPanel.add(jComponent);
        jPanel.add(Box.createRigidArea(new Dimension(jComponent.getWidth(), 1)));
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        ObservingToolController observingToolController = ObservingToolController.getMyInstance();
        if (observingToolController != null) {
            jButton.addActionListener((ActionListener)new CSH.DisplayHelpFromFocus(observingToolController.getReferenceManualHS(), "javax.help.MainWindow", null));
        }
        return jPanel;
    }

    protected JPanel createNonCollapsingGroupNoHelp(JComponent jComponent, String string) {
        JPanel jPanel = this.createNewGroup();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jComponent);
        jPanel.add(Box.createRigidArea(new Dimension(jComponent.getWidth(), 1)));
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        return jPanel;
    }

    protected JPanel addGroup(int n, JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JComponent jComponent2, String string, boolean bl) {
        JPanel jPanel = this.createCollapsingGroup(jComponent2, string, bl);
        this.addComponent(n, jComponent, gridBagLayout, gridBagConstraints, jPanel);
        return jPanel;
    }

    protected JPanel addGroup(JComponent jComponent, String string) {
        return this.addGroup(0, this, this.layout, this.constraints, jComponent, string, false);
    }

    protected JPanel addGroup(JComponent jComponent, String string, boolean bl) {
        return this.addGroup(0, this, this.layout, this.constraints, jComponent, string, bl);
    }

    protected JPanel addGroup(int n, JComponent jComponent, String string) {
        return this.addGroup(n, this, this.layout, this.constraints, jComponent, string, false);
    }

    protected JPanel addGroup(int n, JComponent jComponent, String string, boolean bl) {
        return this.addGroup(n, this, this.layout, this.constraints, jComponent, string, bl);
    }

    protected JComponent addNonCollapsingGroup(int n, JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JComponent jComponent2, String string) {
        JPanel jPanel = this.createNonCollapsingGroup(jComponent2, string);
        this.addComponent(n, jComponent, gridBagLayout, gridBagConstraints, jPanel);
        return jPanel;
    }

    protected JComponent addNonCollapsingGroupNoHelp(int n, JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JComponent jComponent2, String string) {
        JPanel jPanel = this.createNonCollapsingGroupNoHelp(jComponent2, string);
        this.addComponent(n, jComponent, gridBagLayout, gridBagConstraints, jPanel);
        return jPanel;
    }

    protected JComponent addNonCollapsingGroup(JComponent jComponent, String string) {
        return this.addNonCollapsingGroup(0, this, this.layout, this.constraints, jComponent, string);
    }

    protected JComponent addNonCollapsingGroupNoHelp(JComponent jComponent, String string) {
        return this.addNonCollapsingGroupNoHelp(0, this, this.layout, this.constraints, jComponent, string);
    }

    protected JComponent addNonCollapsingGroup(int n, JComponent jComponent, String string) {
        return this.addNonCollapsingGroup(n, this, this.layout, this.constraints, jComponent, string);
    }

    protected void addComponent(int n, JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JComponent jComponent2) {
        if (n == 4) {
            ++gridBagConstraints.gridy;
        } else if (n == 5) {
            ++gridBagConstraints.gridx;
        } else {
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 0;
        }
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jComponent.add(jComponent2);
        if (jComponent2 instanceof Editor) {
            this.registerSubView((Editor)jComponent2);
        }
        if (n == 4 && gridBagConstraints.gridheight > 1) {
            gridBagConstraints.gridy += gridBagConstraints.gridheight - 1;
        }
        if (n != 4) {
            gridBagConstraints.gridheight = 1;
        }
        gridBagConstraints.gridwidth = 1;
    }

    protected void addComponent(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JComponent jComponent2) {
        this.addComponent(0, jComponent, gridBagLayout, gridBagConstraints, jComponent2);
    }

    protected void addComponent(JComponent jComponent) {
        this.addComponent(0, this, this.layout, this.constraints, jComponent);
    }

    protected void addComponentArray(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, ComponentCollection componentCollection) {
        this.addComponentArray(jComponent, gridBagLayout, gridBagConstraints, componentCollection, true);
    }

    protected void addComponentArray(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, ComponentCollection componentCollection, Boolean bl) {
        int n = componentCollection.components.size();
        if (n != componentCollection.widths.size()) {
            throw new IllegalArgumentException("Argument components and cols must have the same length.");
        }
        int n2 = gridBagConstraints.anchor;
        int n3 = gridBagConstraints.fill;
        if (bl.booleanValue()) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        JComponent[] jComponentArray = componentCollection.components.toArray(new JComponent[n]);
        Integer[] integerArray = componentCollection.widths.toArray(new Integer[n]);
        for (int i = 0; i < n; ++i) {
            gridBagConstraints.gridwidth = integerArray[i];
            int n4 = gridBagConstraints.insets.right;
            int n5 = gridBagConstraints.insets.left;
            if (jComponentArray[i] instanceof JLabel) {
                gridBagConstraints.insets.right = 5;
            } else if (jComponentArray[i] instanceof ValueUnitPairEditor) {
                gridBagConstraints.insets.left = -5;
            }
            gridBagLayout.setConstraints(jComponentArray[i], gridBagConstraints);
            jComponent.add(jComponentArray[i]);
            gridBagConstraints.gridx += integerArray[i].intValue();
            if (jComponentArray[i] instanceof JLabel) {
                gridBagConstraints.insets.right = n4;
                continue;
            }
            if (!(jComponentArray[i] instanceof ValueUnitPairEditor)) continue;
            gridBagConstraints.insets.left = n5;
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = n2;
        gridBagConstraints.fill = n3;
    }

    @Deprecated
    protected void addComponentArray(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JComponent[] jComponentArray, int[] nArray, FieldID[] fieldIDArray, String[] stringArray) {
        if (jComponentArray.length != nArray.length || nArray.length != fieldIDArray.length || fieldIDArray.length != stringArray.length) {
            throw new IllegalArgumentException("Argument arrays cols, fids, names and tooltips must have the same length.");
        }
        for (int i = 0; i < jComponentArray.length; ++i) {
            if (stringArray[i] != null) {
                jComponentArray[i].setToolTipText(stringArray[i]);
            }
            if (fieldIDArray[i] == null || !(jComponentArray[i] instanceof JCheckBox)) continue;
            this.initEvents((JCheckBox)jComponentArray[i], fieldIDArray[i]);
        }
        this.addComponentArray(jComponent, gridBagLayout, gridBagConstraints, jComponentArray, nArray);
    }

    protected void addComponentArray(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JComponent[] jComponentArray, int[] nArray) {
        if (jComponentArray.length != nArray.length) {
            throw new IllegalArgumentException("Argument arrays cols, fids, names and tooltips must have the same length.");
        }
        ComponentCollection componentCollection = new ComponentCollection();
        for (int i = 0; i < jComponentArray.length; ++i) {
            componentCollection.remember(jComponentArray[i], nArray[i]);
        }
        this.addComponentArray(jComponent, gridBagLayout, gridBagConstraints, componentCollection);
    }

    protected void addComponentArray(ComponentCollection componentCollection) {
        this.addComponentArray(this, this.layout, this.constraints, componentCollection);
    }

    protected JLabel addLabeledComponent(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string, JComponent jComponent2) {
        JLabel jLabel = this.makeLabel(string);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, jLabel, jComponent2);
        return jLabel;
    }

    protected JLabel addLabeledComponent(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string, JComponent jComponent2, @NonNull FieldID fieldID) {
        if (fieldID == null) {
            throw new NullPointerException("FID is marked non-null but is null");
        }
        JLabel jLabel = this.makeLabel(string);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, jLabel, jComponent2);
        this.register(jLabel, fieldID);
        return jLabel;
    }

    protected void addLabeledComponent(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JLabel jLabel, JComponent jComponent2) {
        int n = gridBagConstraints.insets.right;
        int n2 = gridBagConstraints.anchor;
        if (jComponent2 instanceof JTextField) {
            gridBagConstraints.insets.right = 5;
        } else if (jComponent2 instanceof SkyCoordsEditor) {
            gridBagConstraints.anchor = 18;
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jComponent.add(jLabel);
        gridBagConstraints.anchor = n2;
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 0;
        int n3 = gridBagConstraints.insets.left;
        if (jComponent2 instanceof ValueUnitPairEditor || jComponent2 instanceof VelocityEditor) {
            gridBagConstraints.insets.left = -5;
        }
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jComponent.add(jComponent2);
        gridBagConstraints.insets.right = n;
        gridBagConstraints.insets.left = n3;
        gridBagConstraints.gridwidth = 1;
    }

    protected JButton addButton(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string, String string2) {
        JButton jButton = this.makeButton(fieldID, string, string2);
        this.addComponent(jComponent, gridBagLayout, gridBagConstraints, jButton);
        return jButton;
    }

    protected JLabel addLabel(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string) {
        JLabel jLabel = this.makeLabel(string);
        this.addComponent(0, jComponent, gridBagLayout, gridBagConstraints, jLabel);
        return jLabel;
    }

    protected JLabel addLabel(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string) {
        JLabel jLabel = this.makeLabel(string);
        this.initEvents(jLabel, fieldID);
        this.addComponent(jComponent, gridBagLayout, gridBagConstraints, jLabel);
        return jLabel;
    }

    protected JLabel addLabel(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string, String string2) {
        JLabel jLabel = this.makeLabel(string);
        this.initEvents(jLabel, fieldID);
        jLabel.setToolTipText(string2);
        this.addComponent(jComponent, gridBagLayout, gridBagConstraints, jLabel);
        return jLabel;
    }

    protected void addVerticalSpace(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        this.addVerticalSpace(jComponent, gridBagLayout, gridBagConstraints, 5);
    }

    protected void addVerticalSpace(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n) {
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(n));
        this.addComponent(jComponent, gridBagLayout, gridBagConstraints, box);
    }

    protected void addHorizontalSpace(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(n));
        this.addComponent(jComponent, gridBagLayout, gridBagConstraints, box);
    }

    public JCheckBox addBooleanComponent(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string, String string2) {
        JCheckBox jCheckBox = this.makeCheckBox(fieldID, string2);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)jCheckBox);
        return jCheckBox;
    }

    protected JTabbedPane addTabbedComponent(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string) {
        JTabbedPane jTabbedPane = this.makeTabbedPane(fieldID, string);
        this.addComponent(jComponent, gridBagLayout, gridBagConstraints, jTabbedPane);
        return jTabbedPane;
    }

    protected JTextField addTextComponent(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string, String string2) {
        JTextField jTextField = this.makeTextField(fieldID, string2);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)jTextField);
        return jTextField;
    }

    protected ValueUnitPairEditor addValueUnitPair(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, ValueUnitPairModel valueUnitPairModel, String string, String string2) {
        ValueUnitPairEditor valueUnitPairEditor = this.makeValueUnitPairEditor(valueUnitPairModel, string2);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)valueUnitPairEditor);
        return valueUnitPairEditor;
    }

    protected ValueUnitPairEditor addValueUnitPair(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, ValueUnitPairModel valueUnitPairModel, JLabel jLabel, String string) {
        ValueUnitPairEditor valueUnitPairEditor = this.makeValueUnitPairEditor(valueUnitPairModel, string);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, jLabel, (JComponent)valueUnitPairEditor);
        return valueUnitPairEditor;
    }

    protected VelocityEditor addVelocity(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, VelocityModel velocityModel, String string, String string2) {
        VelocityEditor velocityEditor = this.makeVelocityEditor(velocityModel, string2);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)velocityEditor);
        return velocityEditor;
    }

    protected JComboBox addComboBox(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, JLabel jLabel, String string, String[] stringArray) {
        JComboBox jComboBox = this.makeComboBox(fieldID, stringArray, string);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, jLabel, (JComponent)jComboBox);
        return jComboBox;
    }

    protected JComboBox addComboBox(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string, String string2, String[] stringArray) {
        JComboBox jComboBox = this.makeComboBox(fieldID, stringArray, string2);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)jComboBox);
        return jComboBox;
    }

    protected JComboBox addComboBox(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string, String string2, String[] stringArray, Map<String, String> map) {
        JComboBox jComboBox = this.makeComboBox(fieldID, stringArray, string2, map);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)jComboBox);
        return jComboBox;
    }

    protected OTComboBox addOTComboBox(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string, String string2, String[] stringArray) {
        OTComboBox oTComboBox = this.makeOTComboBox(fieldID, stringArray, string2);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)oTComboBox);
        return oTComboBox;
    }

    protected JList<String> addJList(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string, String string2, String[] stringArray) {
        JList<String> jList = this.makeJList(fieldID, stringArray, string2);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(jList);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)scrollWhenFocusedPane);
        return jList;
    }

    protected Table addTable(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string, String string2, boolean bl, String[] stringArray) {
        Table table = this.makeTable(fieldID, string2, bl, stringArray);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(table);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)scrollWhenFocusedPane);
        return table;
    }

    protected JTextArea addJustificationTextArea(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, int n, int n2, String string, String string2) {
        JTextArea jTextArea = this.makeTextArea(fieldID, string2);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(jTextArea);
        scrollWhenFocusedPane.setPreferredSize(new Dimension(n, n2));
        scrollWhenFocusedPane.setVerticalScrollBarPolicy(20);
        scrollWhenFocusedPane.setHorizontalScrollBarPolicy(31);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)scrollWhenFocusedPane);
        return jTextArea;
    }

    protected JTextArea addJustificationTextArea(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, int n, int n2, String string, String string2) {
        JTextArea jTextArea = this.makeTextArea(fieldID, string2);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(jTextArea);
        scrollWhenFocusedPane.setPreferredSize(new Dimension(n, n2));
        scrollWhenFocusedPane.setVerticalScrollBarPolicy(20);
        scrollWhenFocusedPane.setHorizontalScrollBarPolicy(31);
        this.addLabel(jPanel, gridBagLayout, gridBagConstraints, string);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        return jTextArea;
    }

    protected JTextArea addJTextArea(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, int n, int n2, String string, String string2) {
        JTextArea jTextArea = this.makeTextArea(fieldID, string2);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(jTextArea);
        scrollWhenFocusedPane.setPreferredSize(new Dimension(n, n2));
        scrollWhenFocusedPane.setVerticalScrollBarPolicy(20);
        scrollWhenFocusedPane.setHorizontalScrollBarPolicy(31);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)scrollWhenFocusedPane);
        return jTextArea;
    }

    protected OTTextArea addOTTextArea(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, int n, int n2, String string, boolean bl) {
        OTTextArea oTTextArea = this.makeOTTextArea(fieldID, string, n, n2, bl);
        this.addComponent(jComponent, gridBagLayout, gridBagConstraints, oTTextArea);
        return oTTextArea;
    }

    protected OTTextArea addOTTextArea(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, int n, int n2, String string, String string2, boolean bl) {
        OTTextArea oTTextArea = this.makeOTTextArea(fieldID, string2, n, n2, bl);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)oTTextArea);
        return oTTextArea;
    }

    protected OTFileArea addOTFileArea(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, int n, int n2, String string, String string2) {
        OTFileArea oTFileArea = this.makeOTFileArea(fieldID, string2, n, n2);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)oTFileArea);
        return oTFileArea;
    }

    protected OTButtonGroup addOTButtonGroup(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string, String string2, String[] stringArray) {
        OTButtonGroup oTButtonGroup = this.makeOTButtonGroup(fieldID, stringArray, string2);
        this.initEvents(oTButtonGroup, fieldID);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)oTButtonGroup);
        return oTButtonGroup;
    }

    protected OTButtonGroup addOTButtonGroup(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string, String[] stringArray, String[] stringArray2) {
        OTButtonGroup oTButtonGroup = this.makeOTButtonGroup(fieldID, stringArray2, stringArray);
        this.initEvents(oTButtonGroup, fieldID);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)oTButtonGroup);
        return oTButtonGroup;
    }

    protected OTButtonGroup addOTButtonGroup(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string, String string2, String[] stringArray, int n, int n2) {
        OTButtonGroup oTButtonGroup = this.makeOTButtonGroup(fieldID, stringArray, string2, n, n2);
        this.initEvents(oTButtonGroup, fieldID);
        oTButtonGroup.setBorder(BorderFactory.createTitledBorder(string));
        this.addComponent(0, jComponent, gridBagLayout, gridBagConstraints, oTButtonGroup);
        return oTButtonGroup;
    }

    protected SkyCoordsEditor addSkyCoordinates(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, SkyCoordsModel skyCoordsModel, String string, String string2) {
        SkyCoordsEditor skyCoordsEditor = this.makeSkyCoordsEditor(skyCoordsModel, string2);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)skyCoordsEditor);
        return skyCoordsEditor;
    }

    protected JPanel addIsoDateTime(Editor editor, JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, FieldID fieldID, String string, String string2) {
        IsoDatePicker isoDatePicker = this.makeIsoDateTimePanel(editor, fieldID, string2);
        this.addLabeledComponent(jComponent, gridBagLayout, gridBagConstraints, string, (JComponent)isoDatePicker);
        return isoDatePicker;
    }

    public static void resizeDialog(Dialog dialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width * 2 / 3;
        int n2 = dialog.getPreferredSize().height;
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        dialog.setSize(n, n2);
        dialog.setLocation(n3, n4);
    }

    public static void centreDialog(Dialog dialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dialog.getSize().width;
        int n2 = dialog.getSize().height;
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        dialog.setLocation(n3, n4);
    }

    protected static void runTestApp(Editor editor, int n, int n2) {
        TestUtilities.runTestApp(editor, n, n2);
    }

    protected static void runTestApp(Editor editor) {
        EditorWithGridBagLayout.runTestApp(editor, -1, -1);
    }

    protected JPanel createNewGroup() {
        return new GroupPanel();
    }

    protected JTextField makeTextField(FieldID fieldID, boolean bl, String string) {
        return this.makeTextField(fieldID, this.textFieldWidth, bl, string);
    }

    protected JTextField makeTextField(FieldID fieldID, String string) {
        return this.makeTextField(fieldID, this.textFieldWidth, true, string);
    }

    protected JTextField makeTextFieldWithDoubleVerifier(FieldID fieldID, String string, double d, double d2) {
        JTextField jTextField = this.makeTextField(fieldID, string);
        DoubleVerifier doubleVerifier = new DoubleVerifier((Editor)this, jTextField, d, d2);
        this.setVerifier(jTextField, "FOCUSLOST_VERIFIER", doubleVerifier);
        return jTextField;
    }

    protected JTextField makeTextFieldWithIntegerVerifier(FieldID fieldID, String string, int n, int n2) {
        JTextField jTextField = this.makeTextField(fieldID, string);
        IntegerVerifier integerVerifier = new IntegerVerifier(this, jTextField, n, n2);
        this.setVerifier(jTextField, "FOCUSLOST_VERIFIER", integerVerifier);
        return jTextField;
    }

    public static class GroupPanel
    extends JPanel {
        private static final long serialVersionUID = 78067162410073808L;
    }

    private final class GlobalActionListener
    implements ActionListener {
        private boolean m_expander;

        public GlobalActionListener(boolean bl) {
            this.m_expander = bl;
        }

        private void doit() {
            ArrayList<JButton> arrayList = this.m_expander ? EditorWithGridBagLayout.this.expandButtons : EditorWithGridBagLayout.this.collapseButtons;
            for (JButton jButton : arrayList) {
                jButton.doClick(0);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.doit();
        }
    }

    private final class GroupActionListener
    implements ActionListener {
        private JButton m_expand;
        private JButton m_collapse;
        private boolean m_expander;
        private JComponent m_group;

        public GroupActionListener(JButton jButton, JButton jButton2, JComponent jComponent, boolean bl) {
            this.m_expand = jButton;
            this.m_collapse = jButton2;
            this.m_group = jComponent;
            this.m_expander = bl;
            if (bl) {
                this.doit();
            }
        }

        private void doit() {
            this.m_collapse.setVisible(this.m_expander);
            this.m_collapse.setEnabled(this.m_expander);
            this.m_expand.setVisible(!this.m_expander);
            this.m_expand.setEnabled(!this.m_expander);
            this.m_group.setVisible(this.m_expander);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.m_expander && (actionEvent.getModifiers() & 1) != 0) {
                for (JButton jButton : EditorWithGridBagLayout.this.collapseButtons) {
                    jButton.doClick(0);
                }
            }
            this.doit();
        }
    }

    public final class ComponentCollection {
        private final Collection<JComponent> components = new Vector<JComponent>();
        private final Collection<Integer> widths = new Vector<Integer>();

        public Stream<JComponent> stream() {
            return this.components.stream();
        }

        public void remember(JComponent ... jComponentArray) {
            for (JComponent jComponent : jComponentArray) {
                this.remember(jComponent, 1);
            }
        }

        public void remember(JComponent jComponent, int n) {
            this.components.add(jComponent);
            this.widths.add(n);
        }

        public void spaces(int n) {
            this.remember((JComponent)new JLabel(), n);
        }

        public void space() {
            this.spaces(1);
        }

        public Collection<JComponent> getComponents() {
            return this.components;
        }

        public Collection<Integer> getWidths() {
            return this.widths;
        }

        public int size() {
            return this.components.size();
        }
    }
}

