/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.data.ObsProgramData;
import alma.obsprep.bo.obsproject.data.ObsProjectData;
import alma.obsprep.bo.obsproject.data.ObsUnitSetData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsproposal.data.ObsProposalData;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.NewProject;
import alma.obsprep.ot.actions.NewProjectInteractor;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.util.MiscUtils;

public class NewProjectPerformer
extends Performer {
    public NewProjectPerformer(NewProjectInteractor newProjectInteractor) {
        super(newProjectInteractor);
    }

    @Override
    public void perform() {
        NewProjectInteractor newProjectInteractor = (NewProjectInteractor)this.getGui();
        if (newProjectInteractor.confirmOverwrite()) {
            MiscUtils.resetJCSCache();
            ObsProject obsProject = ObsProjectData.createObsProject();
            obsProject.setStatus(ObsProjectData.STATUS_NEWPHASE2);
            ObsProgram obsProgram = ObsProgramData.createObsProgram();
            ObsProposal obsProposal = ObsProposalData.createObsProposal();
            AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
            boolean bl = newProjectInteractor.getProjectMode().equals((Object)NewProject.ProjectMode.ACASUPPLEMENTALCALL);
            obsProposal.setCycle(bl ? almaPolicies.getSupplementalCallCycleNumber() : almaPolicies.getCycleNumber());
            obsProject.setObsProgram(obsProgram);
            obsProject.setObsProposal(obsProposal);
            obsProject.setIsCommissioning(true);
            this.setProjectMode(obsProject, newProjectInteractor.getProjectMode());
            obsProposal.setObsProject(obsProject);
            this.setUpProposalType(newProjectInteractor.getProjectMode(), obsProposal);
            ObsUnitSet obsUnitSet = ObsUnitSetData.createObsUnitSet();
            obsUnitSet.setName("Observing Program");
            obsProgram.setObsPlan(obsUnitSet);
            obsUnitSet.setObsProject(obsProject);
            newProjectInteractor.display(obsProject);
            ActionLog.performed("New project", obsProject);
            UserEditRestrictionController.getInstance().projectDocumentReset(obsProject, new ImpexFactory.WorkingPersistenceData());
        }
    }

    private void setUpProposalType(NewProject.ProjectMode projectMode, ObsProposal obsProposal) {
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        assert (almaPolicies != null);
        switch (projectMode) {
            case CALIBRATION: 
            case COMMISSIONING: 
            case LARGEPROGRAM: 
            case MANUAL: 
            case SIMULATION: 
            case STANDARD: 
            case ACASUPPLEMENTALCALL: {
                String string = almaPolicies.getProposalTypeForCode("S");
                obsProposal.setProposalTypeCode("S");
                obsProposal.setProposalTypeString(string);
                if (!projectMode.equals((Object)NewProject.ProjectMode.ACASUPPLEMENTALCALL)) break;
                obsProposal.setCycle(almaPolicies.getSupplementalCallCycleNumber());
                break;
            }
            case VLBI: {
                String string = almaPolicies.getProposalTypeForCode("V");
                obsProposal.setProposalTypeCode("V");
                obsProposal.setProposalTypeString(string);
                break;
            }
            default: {
                throw new RuntimeException("Unknown project mode specified " + projectMode);
            }
        }
    }

    private void setProjectMode(ObsProject obsProject, NewProject.ProjectMode projectMode) {
        if (projectMode == NewProject.ProjectMode.STANDARD || projectMode == NewProject.ProjectMode.VLBI || projectMode == NewProject.ProjectMode.ACASUPPLEMENTALCALL) {
            obsProject.setManualMode(false);
            obsProject.setSimulationMode(false);
            obsProject.setIsCalibration(false);
            obsProject.setIsCommissioning(false);
        } else if (projectMode == NewProject.ProjectMode.MANUAL) {
            obsProject.setManualMode(true);
        } else if (projectMode == NewProject.ProjectMode.SIMULATION) {
            obsProject.setSimulationMode(true);
        } else if (projectMode == NewProject.ProjectMode.CALIBRATION) {
            obsProject.setIsCalibration(true);
        } else if (projectMode == NewProject.ProjectMode.COMMISSIONING) {
            obsProject.setIsCommissioning(true);
        }
    }
}

