/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.perspectives;

import alma.obsprep.guiutil.perspectives.Perspective;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class PerspectiveRepository {
    protected String storedPerspectivePrefix = "StoredPerspective_";
    protected String storedPerspectiveSuffix = ".ser";
    protected Perspective repositoryListener;
    protected HashMap name2perspective = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveToDirectory(String string) {
        File file = new File(string);
        for (Map.Entry entry : this.name2perspective.entrySet()) {
            String string2 = (String)entry.getKey();
            Perspective.PerspectiveDesc perspectiveDesc = (Perspective.PerspectiveDesc)entry.getValue();
            String string3 = this.storedPerspectivePrefix + string2 + this.storedPerspectiveSuffix;
            OutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(new File(file, string3));
                ((FileOutputStream)outputStream).write(perspectiveDesc.stream.toByteArray());
            }
            catch (IOException iOException) {
                Perspective.debug("could not store perspective " + string3 + ": " + iOException);
            }
            finally {
                try {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadFromDirectory(String string) {
        Vector<Object> vector = new Vector<Object>();
        File file = new File(string);
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                boolean bl = string.startsWith(PerspectiveRepository.this.storedPerspectivePrefix);
                boolean bl2 = string.endsWith(PerspectiveRepository.this.storedPerspectiveSuffix);
                return bl & bl2;
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            Perspective.PerspectiveDesc perspectiveDesc = null;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                int n = (int)file2.length();
                perspectiveDesc = new Perspective.PerspectiveDesc(n);
                Object object = perspectiveDesc.stream;
                synchronized (object) {
                    fileInputStream.read(perspectiveDesc.stream.getBuffer());
                    perspectiveDesc.stream.setCount(n);
                }
                object = file2.getName().substring(this.storedPerspectivePrefix.length(), file2.getName().length() - this.storedPerspectiveSuffix.length());
                perspectiveDesc.isDefined = true;
                this.name2perspective.put(object, perspectiveDesc);
                vector.add(object);
                continue;
            }
            catch (Exception exception) {
                if (!(exception instanceof IOException)) continue;
                Perspective.debug("could not read stored perspective " + file2.getName() + ": " + exception);
                continue;
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        this.fireRepositoryChangedEvent(vector);
    }

    protected synchronized String[] getPerspectiveNames() {
        Set set = this.name2perspective.keySet();
        return set.toArray(new String[set.size()]);
    }

    synchronized Perspective.PerspectiveDesc givePerspective(String string) {
        Perspective.PerspectiveDesc perspectiveDesc = (Perspective.PerspectiveDesc)this.name2perspective.get(string);
        if (perspectiveDesc == null) {
            perspectiveDesc = new Perspective.PerspectiveDesc();
            this.name2perspective.put(string, perspectiveDesc);
        }
        return perspectiveDesc;
    }

    synchronized void removePerspective(String string) {
        this.name2perspective.remove(string);
    }

    protected synchronized void setRepositoryListener(Perspective perspective) {
        this.repositoryListener = perspective;
    }

    protected void fireRepositoryChangedEvent(Vector vector) {
        if (this.repositoryListener != null && vector.size() > 0) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            this.repositoryListener.perspectiveRepositoryChanged((String[])objectArray);
        }
    }
}

