/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.verifiers;

import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.verifiers.Verifier;
import alma.obsprep.util.Convert;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.JTextField;

public class ISODateVerifier
extends Verifier {
    protected Calendar min = null;
    protected Calendar max = null;
    protected boolean incMin = true;
    protected boolean incMax = true;
    private JTextField minTF = null;
    private JTextField maxTF = null;
    private boolean afterToday = false;

    public ISODateVerifier(Editor editor, JTextField jTextField) {
        super(editor, jTextField);
    }

    public ISODateVerifier(Editor editor, JTextField jTextField, String string, String string2) {
        this(editor, jTextField, string, string2, true, true);
    }

    public ISODateVerifier(Editor editor, JTextField jTextField, JTextField jTextField2, JTextField jTextField3, boolean bl) {
        this(editor, jTextField, jTextField2, jTextField3, true, true, bl);
    }

    public ISODateVerifier(Editor editor, JTextField jTextField, JTextField jTextField2, JTextField jTextField3, boolean bl, boolean bl2, boolean bl3) {
        this(editor, jTextField);
        Calendar calendar = null;
        Calendar calendar2 = null;
        if (jTextField2 != null) {
            calendar = Convert.convertToCalendar(jTextField2.getText());
        }
        if (jTextField3 != null) {
            calendar2 = Convert.convertToCalendar(jTextField3.getText());
        }
        ISODateVerifier.checkMinMax(calendar, calendar2);
        this.min = calendar;
        this.max = calendar2;
        this.incMin = bl;
        this.incMax = bl2;
        this.afterToday = bl3;
        this.minTF = jTextField2;
        this.maxTF = jTextField3;
    }

    public ISODateVerifier(Editor editor, JTextField jTextField, String string, String string2, boolean bl, boolean bl2) {
        this(editor, jTextField);
        Calendar calendar = null;
        Calendar calendar2 = null;
        if (string != null) {
            calendar = Convert.convertToCalendar(string);
        }
        if (string2 != null) {
            calendar2 = Convert.convertToCalendar(string2);
        }
        ISODateVerifier.checkMinMax(calendar, calendar2);
        this.min = calendar;
        this.max = calendar2;
        this.incMin = bl;
        this.incMax = bl2;
    }

    @Override
    public Object validate(JTextField jTextField) throws OutOfRangeException, NumberFormatException {
        Calendar calendar = null;
        Calendar calendar2 = null;
        Calendar calendar3 = ISODateVerifier.parseIsoDate(jTextField.getText());
        if (this.minTF != null || this.maxTF != null) {
            if (this.minTF != null) {
                calendar = Convert.convertToCalendar(this.minTF.getText());
            }
            if (this.maxTF != null) {
                calendar2 = Convert.convertToCalendar(this.maxTF.getText());
            }
            if (this.afterToday) {
                Calendar calendar4 = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                try {
                    ISODateVerifier.checkMinMax(calendar4, calendar3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Date can not be in the past");
                }
            }
            ISODateVerifier.checkMinMax(calendar, calendar2);
            this.min = calendar;
            this.max = calendar2;
        }
        if (this.min != null || this.max != null) {
            ISODateVerifier.checkRange(calendar3, this.min, this.max, this.incMin, this.incMax);
        }
        return String.format("%tFT%tT.%tLZ", calendar3, calendar3, calendar3);
    }

    public static Calendar parseIsoDate(Object object, TimeZone timeZone) throws NumberFormatException, IllegalArgumentException {
        String string = object.toString();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        float f = 0.0f;
        int n7 = 0;
        String[] stringArray = string.split("[TZ :-]");
        n = new Integer(stringArray[0]);
        n2 = new Integer(stringArray[1]);
        n3 = new Integer(stringArray[2]);
        switch (n2) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 4;
                break;
            }
            case 6: {
                n2 = 5;
                break;
            }
            case 7: {
                n2 = 6;
                break;
            }
            case 8: {
                n2 = 7;
                break;
            }
            case 9: {
                n2 = 8;
                break;
            }
            case 10: {
                n2 = 9;
                break;
            }
            case 11: {
                n2 = 10;
                break;
            }
            case 12: {
                n2 = 11;
                break;
            }
        }
        switch (6 - stringArray.length) {
            default: {
                f = new Float(stringArray[5]).floatValue();
                n6 = (int)f;
                n7 = Math.round(1000.0f * (f - (float)n6));
            }
            case 1: {
                n5 = new Integer(stringArray[4]);
            }
            case 2: {
                n4 = new Integer(stringArray[3]);
            }
            case 3: 
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setLenient(false);
        calendar.set(n, n2, n3, n4, n5, n6);
        calendar.set(14, n7);
        try {
            for (int i = 0; i < 17; ++i) {
                calendar.get(i);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid field (" + illegalArgumentException.getMessage() + "). Required format is YYYY-MM-DD [hh:mm:ss.mmm]");
        }
        return calendar;
    }

    public static Calendar parseIsoDate(Object object) throws NumberFormatException, IllegalArgumentException {
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        return ISODateVerifier.parseIsoDate(object, timeZone);
    }

    protected static void checkMinMax(Calendar calendar, Calendar calendar2) {
        if (calendar != null && calendar2 != null && calendar2.compareTo(calendar) <= 0) {
            throw new IllegalArgumentException("Invalid range, max=" + calendar2 + " smaller than min=" + calendar);
        }
    }

    public static void checkRange(Calendar calendar, Calendar calendar2, Calendar calendar3, boolean bl, boolean bl2) throws OutOfRangeException {
        boolean bl3 = false;
        int n = -1;
        int n2 = -1;
        if (calendar2 == null) {
            n2 = calendar3.compareTo(calendar);
            bl3 = bl2 ? n2 >= 0 : n2 > 0;
        } else if (calendar3 == null) {
            n = calendar.compareTo(calendar2);
            bl3 = bl ? n >= 0 : n > 0;
        } else {
            n = calendar.compareTo(calendar2);
            n2 = calendar3.compareTo(calendar);
            if (bl && bl2) {
                bl3 = n >= 0 && n2 >= 0;
            } else if (bl && !bl2) {
                bl3 = n >= 0 && n2 > 0;
            } else if (!bl && bl2) {
                bl3 = n > 0 && n2 >= 0;
            } else {
                boolean bl4 = bl3 = n > 0 && n2 > 0;
            }
        }
        if (!bl3) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Value must be ");
            if (calendar2 != null && calendar3 != null) {
                stringBuffer.append("between ").append(String.format("%tF %tT.%tL", calendar2, calendar2, calendar2)).append(bl ? " (" : " (not ").append("included) and ").append(String.format("%tF %tT.%tL", calendar3, calendar3, calendar3)).append(bl2 ? " (" : " (not ").append("included)");
            } else if (calendar2 == null) {
                stringBuffer.append("before ").append(String.format("%tF %tT.%tL", calendar3, calendar3, calendar3)).append(bl2 ? " (" : " (not ").append("included)");
            } else if (calendar3 == null) {
                stringBuffer.append("after ").append(String.format("%tF %tT.%tL", calendar2, calendar2, calendar2)).append(bl ? " (" : " (not ").append("included)");
            }
            throw new OutOfRangeException(stringBuffer.toString());
        }
    }
}

