/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.examples;

import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.examples.RedShift;
import alma.obsprep.guiutil.mvc.examples.RedShiftModel;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.editors.valuetypes.VelocityEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class RedShiftEditor
extends Editor {
    public static final FieldID NAME_FID = new FieldID("Redshift.name");
    public static final FieldID REDSHIFT_FID = new FieldID("Redshift.redshift");
    private static final int COLUMN_WIDTH = 10;

    public RedShiftEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public RedShiftModel getModel() {
        return (RedShiftModel)super.getModel();
    }

    @Override
    protected void build() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel("Name");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        ++gridBagConstraints.gridx;
        JTextField jTextField = new JTextField();
        jTextField.setColumns(10);
        this.initEvents(jTextField, NAME_FID);
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        this.add(jTextField);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel("Frequency");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        ++gridBagConstraints.gridx;
        ValueUnitPairEditor valueUnitPairEditor = new ValueUnitPairEditor(this.getModel().getFrequencyModel());
        this.registerSubView(valueUnitPairEditor);
        gridBagLayout.setConstraints(valueUnitPairEditor, gridBagConstraints);
        this.add(valueUnitPairEditor);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel("Velocity");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        ++gridBagConstraints.gridx;
        VelocityEditor velocityEditor = new VelocityEditor(this.getModel().getVelocityModel());
        this.registerSubView(velocityEditor);
        gridBagLayout.setConstraints(velocityEditor, gridBagConstraints);
        this.add(velocityEditor);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel("RedShift");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        ++gridBagConstraints.gridx;
        jTextField = new JTextField();
        jTextField.setColumns(10);
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        this.initEvents(jTextField, REDSHIFT_FID);
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        this.add(jTextField);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 2;
        JButton jButton = new JButton("Print");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(RedShiftEditor.this.getModel().getRedShift());
            }
        });
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(REDSHIFT_FID)) {
            Frequency frequency = (Frequency)((Object)object);
            String string = TextUtils.format(frequency, 3, 5);
            super.update(fieldID, string);
            return;
        }
        super.update(fieldID, object);
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        RedShiftModel redShiftModel = new RedShiftModel(null);
        RedShiftEditor redShiftEditor = new RedShiftEditor(redShiftModel);
        RedShift redShift = new RedShift();
        redShift.setName("param1");
        redShift.setFrequency(Frequency.createFrequencyGHZ(230.0));
        Velocity velocity = Velocity.createVelocity();
        velocity.getCenterVelocity().setContentAndUnit(1000.0, Speed.UNIT_KM_S);
        redShift.setVelocity(velocity);
        ((Model)redShiftModel).setDocument(redShift);
        JFrame jFrame = new JFrame("RedShiftEditor");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(redShiftEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

