/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.jsky.catalog.astrocat;

import alma.obsprep.guiutil.jsky.catalog.astrocat.AlmaAstroCatXML;
import alma.obsprep.util.MiscUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import jsky.catalog.AbstractCatalogDirectory;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.CatalogFactory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.HTMLQueryResultHandler;
import jsky.catalog.astrocat.AstroCatConfig;
import jsky.catalog.astrocat.AstroCatXML;
import jsky.catalog.astrocat.AstroCatalog;
import jsky.catalog.skycat.SkycatConfigFile;
import jsky.util.FileUtil;
import jsky.util.gui.DialogUtil;

public class AlmaAstroCatConfig
extends AbstractCatalogDirectory {
    public static final String ALMA_IMAGESERVER_CONFIG_DIR = "config/imageServer";
    private static AlmaAstroCatConfig _configFile;
    private static URL _defaultURL;

    public AlmaAstroCatConfig(String string, URL uRL) {
        super(string);
        this.setURL(uRL);
        this._load();
    }

    public AlmaAstroCatConfig(String string, String string2) {
        this(string, FileUtil.makeURL(null, (String)string2));
    }

    public AlmaAstroCatConfig(String string) {
        this(string, FileUtil.makeURL(null, (String)string));
    }

    public AlmaAstroCatConfig(URL uRL, HTMLQueryResultHandler hTMLQueryResultHandler) {
        super(new File(uRL.toString()).getPath());
        this.setURL(uRL);
        this.setHTMLQueryResultHandler(hTMLQueryResultHandler);
        this._load();
    }

    private void _load() {
        URL uRL = this.getURL();
        if (uRL == null) {
            return;
        }
        AlmaAstroCatXML almaAstroCatXML = new AlmaAstroCatXML();
        almaAstroCatXML.parse(uRL);
        this.setCatalogs(almaAstroCatXML.getCatalogs());
    }

    public static CatalogDirectory getDirectory() {
        return AlmaAstroCatConfig.getConfigFile();
    }

    public static AlmaAstroCatConfig getConfigFile() {
        if (_configFile != null) {
            return _configFile;
        }
        String[] stringArray = new String[4];
        int n = 0;
        if (_defaultURL == null) {
            _defaultURL = MiscUtils.findResource("config/imageServer/AstroCat.xml");
        }
        if (_defaultURL == null) {
            throw new RuntimeException("Can't find the default catalog config file resource (AstroCat.xml).");
        }
        stringArray[n++] = _defaultURL.toString();
        _configFile = new AlmaAstroCatConfig(stringArray[0]);
        for (int i = 1; i < n; ++i) {
            if (stringArray[i] == null) continue;
            _configFile.addCatalogDirectory(stringArray[i]);
        }
        return _configFile;
    }

    public CatalogDirectory reload() {
        _configFile = null;
        AlmaAstroCatConfig.getConfigFile();
        return _configFile;
    }

    public CatalogDirectory loadSubDir(URL uRL) {
        String string = uRL.getFile();
        if (string.endsWith(".xml")) {
            AstroCatConfig astroCatConfig = new AstroCatConfig(uRL, this.getHTMLQueryResultHandler());
            return astroCatConfig;
        }
        if (string.endsWith(".cfg")) {
            SkycatConfigFile skycatConfigFile = new SkycatConfigFile(uRL, this.getHTMLQueryResultHandler());
            return skycatConfigFile;
        }
        throw new RuntimeException("Expected an AstroCat XML file, or a Skycat style .cfg file");
    }

    public static void setConfigFile(URL uRL) {
        _defaultURL = uRL;
    }

    public void addCatalogDirectory(String string) {
        if (this.getCatalog(string) != null) {
            return;
        }
        try {
            URL uRL = new URL(string);
            AstroCatConfig astroCatConfig = new AstroCatConfig(string, uRL);
            this.addCatalog((Catalog)astroCatConfig);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public List<Catalog> getNameServers() {
        List list = super.getNameServers();
        if (list.size() != 0) {
            return list;
        }
        this._addDefaultNameServers();
        return CatalogFactory.getCatalogsByType((String)"namesvr");
    }

    private void _addDefaultNameServers() {
        AstroCatalog astroCatalog = new AstroCatalog();
        astroCatalog.setId("simbad_ns@eso");
        astroCatalog.setName("SIMBAD Names");
        astroCatalog.setType("namesvr");
        astroCatalog.setHost("archive.eso.org");
        astroCatalog.setURLPath("/skycat/servers/sim-server");
        FieldDescAdapter[] fieldDescAdapterArray = new FieldDescAdapter[]{new FieldDescAdapter()};
        FieldDescAdapter fieldDescAdapter = fieldDescAdapterArray[0];
        fieldDescAdapter.setName("Object Name");
        fieldDescAdapter.setId("o");
        fieldDescAdapter.setDescription("Enter the name of the object (star, galaxy)");
        astroCatalog.setParams((FieldDesc[])fieldDescAdapterArray);
        CatalogFactory.registerCatalog((Catalog)astroCatalog, (boolean)false);
    }

    public void save() {
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("file.separator");
        String string3 = string + string2 + ".jsky" + string2 + "AstroCat.xml";
        try {
            this.save(string3);
        }
        catch (Exception exception) {
            DialogUtil.error((Exception)exception);
        }
    }

    public void save(String string) {
        File file = new File(string + ".tmp");
        File file2 = file.getParentFile();
        if (!file2.isDirectory()) {
            file2.mkdirs();
        }
        try {
            AstroCatXML.save((File)file, (List)this.getCatalogs());
        }
        catch (Exception exception) {
            file.delete();
            throw new RuntimeException(exception);
        }
        File file3 = new File(string);
        file3.delete();
        if (!file.renameTo(file3)) {
            DialogUtil.error((String)("Rename " + file + " to " + string + " failed"));
        }
    }

    public static void main(String[] stringArray) {
        String string;
        AlmaAstroCatConfig almaAstroCatConfig = AlmaAstroCatConfig.getConfigFile();
        Catalog catalog = almaAstroCatConfig.getCatalog(string = "CO via SkyView @ NASA/GSFC");
        if (catalog == null) {
            System.out.println("Can't find entry for catalog: " + string);
            System.exit(1);
        } else {
            System.out.println("Test passed");
        }
    }

    static {
        _defaultURL = null;
    }
}

