/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.jsky;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.util.astro.Resolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.astrocat.AstroCatConfig;
import jsky.catalog.skycat.SkycatCatalog;
import jsky.catalog.skycat.SkycatTable;
import jsky.coords.WorldCoords;

public class SkycatNameResolver
extends Resolver {
    public static final String SIMBAD_VIA_ESO = "SIMBAD Names via ESO";
    public static final String NED_ESO = "NED Names ESO";
    private String nameServer = "SIMBAD Names via ESO";

    public SkycatNameResolver() {
        this.setResolverService(Resolver.ResolverService.SIMBAD);
        this.setNameServer(SIMBAD_VIA_ESO);
    }

    public SkycatNameResolver(String string) {
        this.setNameServer(string);
    }

    @Override
    public String getNameServer() {
        return this.nameServer;
    }

    @Override
    public void setNameServer(String string) {
        this.nameServer = string;
    }

    @Override
    public void query(String string) throws IOException, MalformedURLException {
        String string2;
        Catalog catalog2;
        String string3;
        this.setName(string);
        String string4 = this.getNameServerUrl(this.nameServer);
        if (string4 == null) {
            throw new MalformedURLException();
        }
        String string5 = string.replaceAll(" ", "%20");
        try {
            string3 = string4.replaceAll("%id", string5);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.logger((Object)this).fine(this.getClass().getSimpleName() + ": IllegalArgumentException[" + illegalArgumentException.getMessage() + "]");
            throw new MalformedURLException(illegalArgumentException.getMessage());
        }
        URL uRL = new URL(string3);
        InputStream inputStream = uRL.openStream();
        AstroCatConfig astroCatConfig = AstroCatConfig.getConfigFile();
        SkycatCatalog skycatCatalog = null;
        for (Catalog catalog2 : astroCatConfig.getCatalogs()) {
            if (!(catalog2 instanceof SkycatCatalog)) continue;
            skycatCatalog = (SkycatCatalog)catalog2;
        }
        if (skycatCatalog == null) {
            Log.logger((Object)this).warning("Could not configure NameResolver");
            return;
        }
        BasicQueryArgs basicQueryArgs = new BasicQueryArgs(skycatCatalog);
        this.results.clear();
        try {
            catalog2 = new SkycatTable(skycatCatalog, inputStream, (QueryArgs)basicQueryArgs);
        }
        catch (RuntimeException runtimeException) {
            String string6 = runtimeException.getMessage();
            if (string6.indexOf("identifier is not present") >= 0 || string6.indexOf("The catalogue name is unknown") >= 0 || string6.indexOf("Identifier error:") >= 0 || string6.indexOf("This identifier is not correctly written:") >= 0 || string6.indexOf("no object found") >= 0 || string6.indexOf("object name not recognized by") >= 0) {
                this.fail();
                return;
            }
            throw runtimeException;
        }
        Integer n = null;
        int n2 = 0;
        for (Object object : catalog2.getFields()) {
            string2 = object.getName();
            if (string2 == null) continue;
            if ("id".equals(string2.toLowerCase())) {
                n = n2;
                break;
            }
            ++n2;
        }
        for (int i = 0; i < catalog2.getRowCount(); ++i) {
            try {
                List list;
                Object object;
                WorldCoords worldCoords = (WorldCoords)catalog2.getCoordinates(i);
                SkycatNameResolver skycatNameResolver = new SkycatNameResolver(this.nameServer);
                skycatNameResolver.setRa(worldCoords.getRaDeg());
                skycatNameResolver.setDec(worldCoords.getDecDeg());
                if (n != null && (object = (list = catalog2.getRowData(i)).get(n)) instanceof String) {
                    string2 = (String)object;
                    skycatNameResolver.setName(string2);
                }
                this.results.add(skycatNameResolver);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.fail();
                return;
            }
        }
    }

    public List<Catalog> getNameServerList() {
        AstroCatConfig astroCatConfig = AstroCatConfig.getConfigFile();
        List list = astroCatConfig.getNameServers();
        return list;
    }

    private String getNameServerUrl(String string) {
        String string2 = null;
        for (SkycatCatalog skycatCatalog : this.getNameServerList()) {
            String string3 = skycatCatalog.getName();
            if (!string3.equals(string)) continue;
            string2 = skycatCatalog.getConfigEntry().getURL(0);
            break;
        }
        return string2;
    }
}

