/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.defaulters.examples;

import alma.obsprep.defaulters.examples.Car;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;

public class CarModel
extends Model {
    public static final FieldID FID_MAKER = new FieldID(CarModel.class, "maker");
    public static final FieldID FID_MODEL = new FieldID(CarModel.class, "model");
    public static final FieldID FID_ENGINE = new FieldID(CarModel.class, "engine");
    public static final FieldID FID_PRICE = new FieldID(CarModel.class, "price");

    public CarModel(Car car) {
        super(car);
    }

    private Car getCar() {
        return (Car)this.getDocument();
    }

    @Override
    public void publish() {
        Car car = this.getCar();
        this.publish(FID_MAKER, car.getMaker());
        this.publish(FID_MODEL, car.getModel());
        this.publish(FID_ENGINE, car.getEngine());
        this.publish(FID_PRICE, new Integer(car.getPrice()));
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        Car car = this.getCar();
        if (fieldID == FID_MAKER) {
            car.setMaker((String)object);
        } else if (fieldID == FID_MODEL) {
            car.setModel((String)object);
        } else if (fieldID == FID_ENGINE) {
            car.setEngine((String)object);
        } else if (fieldID == FID_PRICE) {
            car.setPrice(Integer.parseInt((String)object));
        }
        return object;
    }

    @Override
    public Object get(FieldID fieldID) {
        Car car = this.getCar();
        if (fieldID == FID_MAKER) {
            return car.getMaker();
        }
        if (fieldID == FID_MODEL) {
            return car.getModel();
        }
        if (fieldID == FID_ENGINE) {
            return car.getEngine();
        }
        if (fieldID == FID_PRICE) {
            return new Integer(car.getPrice());
        }
        throw new RuntimeException("Unknown FieldID: " + fieldID);
    }
}

