/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.SchedulingConstraintsT;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.data.SchedulingConstraintsData;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;

public class SchedulingConstraints
extends SchedulingConstraintsData {
    public SchedulingConstraints(SchedulingConstraintsT schedulingConstraintsT) {
        super(schedulingConstraintsT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.getMinAcceptableAngResolution().setUnit(Angle.UNIT_ARCSEC);
        this.getMaxAcceptableAngResolution().setUnit(Angle.UNIT_ARCSEC);
        this.setIsSimultaneous(false);
    }

    public Frequency getRepresentativeFrequencyInRest() {
        Object object;
        Velocity velocity = Velocity.createVelocity();
        Target target = this.getRepresentativeTarget();
        if (target != null && (object = target.getFieldSource()) != null) {
            velocity = ((FieldSource)object).getSourceVelocityInReferenceFrame();
        }
        object = this.getRepresentativeFrequency().deepCopy();
        return ((Frequency)((Object)object)).inverseDopplerShifted(velocity);
    }

    public static double calculateMaxExpectedAxialRatio(double d) {
        double d2 = -70.0 < d && d < 20.0 ? 1.5 : 2.5;
        return d2;
    }
}

