/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.common.horizonsparser.HorizonParser;
import alma.entity.xmlbinding.schedblock.FieldSourceT;
import alma.entity.xmlbinding.schedblock.SchedBlockRefT;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.AddableToSubSBCollection;
import alma.obsprep.bo.annotations.AttachableToTarget;
import alma.obsprep.bo.annotations.BOWithSpecificName;
import alma.obsprep.bo.annotations.FieldTargetPart;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.annotations.SpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpectralSpecDocument;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SourceProperty;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.data.FieldSourceData;
import alma.obsprep.ot.editors.misc.FieldSourceSummaryTableColumns;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualParameters;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.obsprep.ot.models.sciencegoals.AbstractTargetModel;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.OTHorizonParser;
import alma.obsprep.util.OTLoggerAdapter;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.Magnitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.lang3.StringUtils;

public class FieldSource
extends FieldSourceData
implements AddableToSubSBCollection,
AttachableToTarget,
FieldTargetPart,
SpatialDocument,
SpatialPartOfSpectralSpecDocument,
SpatialPartOfSpatialDocument,
BOWithSpecificName,
SummaryTableRow {
    private QuerySource previousQuerySource = null;
    private static CacheAccess<String, OTHorizonParser> horizonsCache = JCS.getInstance((String)"horizonsCache");
    private TargetParameters targetParameters = null;
    private Reference[] referenceMem = null;
    private FieldPattern oldFieldPattern = null;
    private final SpatialVisualParameters spatialVisualParameters = new SpatialVisualParameters(this);
    private final SummaryTableColumns summaryTableColumns = new FieldSourceSummaryTableColumns(this);
    private String previousNonQuerySourceName = "";

    public String toString() {
        return "FieldSource [targetParameters=" + this.targetParameters + ", referenceMem=" + Arrays.toString(this.referenceMem) + ", oldFieldPattern=" + this.oldFieldPattern + ", spatialVisualParameters=" + this.spatialVisualParameters + ", summaryTableColumns=" + this.summaryTableColumns + ", previousNonQuerySourceName=" + this.previousNonQuerySourceName + "]";
    }

    public FieldSource(FieldSourceT fieldSourceT) {
        super(fieldSourceT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.getSourceCoordinates();
        this.getSourceVelocity().getCenterVelocity().setUnit(Speed.UNIT_KM_S);
        this.getPMRA().setUnit(AngularVelocity.UNIT_MAS_YR);
        this.getPMDec().setUnit(AngularVelocity.UNIT_MAS_YR);
        this.getParallax().setUnit(Angle.UNIT_MAS);
        this.setSourceName("");
        this.setNonSiderealMotion(false);
        this.getSourceEphemeris();
    }

    private SourceProperty getVisibleSourcePropertyOrNull() {
        SourceProperty sourceProperty = null;
        double d = Flux.visibleCentreFrequency().getContentInDefaultUnits();
        for (int i = 0; i < this.getSourcePropertyCount(); ++i) {
            sourceProperty = this.getSourceProperty(i);
            double d2 = sourceProperty.getSourceFrequency().getContentInDefaultUnits();
            if (!(Math.abs(d - d2) < 1.0E-4)) continue;
            return sourceProperty;
        }
        return null;
    }

    public SourceProperty getVisibleSourceProperty() {
        SourceProperty sourceProperty = this.getVisibleSourcePropertyOrNull();
        if (sourceProperty == null) {
            sourceProperty = SourceProperty.createSourceProperty();
            sourceProperty.setSourceFrequency(Flux.visibleCentreFrequency());
            this.addSourceProperty(sourceProperty);
        }
        return sourceProperty;
    }

    public Magnitude getVisibleMagnitudeOrNull() {
        SourceProperty sourceProperty = this.getVisibleSourcePropertyOrNull();
        Magnitude magnitude = null;
        if (sourceProperty != null) {
            magnitude = sourceProperty.getVisibleMagnitude();
        }
        return magnitude;
    }

    public void setVisibleMagnitude(double d) {
        this.getVisibleSourceProperty().setVisibleMagnitude(d);
    }

    public void setVisibleMagnitude(Magnitude magnitude) {
        this.setVisibleMagnitude(magnitude.getValue());
    }

    public Velocity getSourceVelocityInReferenceFrame() {
        Velocity velocity = this.getSourceVelocity();
        SchedBlock schedBlock = (SchedBlock)this.getParent();
        ScienceGoal scienceGoal = null;
        if (schedBlock.getSbGenerationContext() != null) {
            scienceGoal = schedBlock.getSbGenerationContext().getGoal();
        } else {
            try {
                scienceGoal = (ScienceGoal)((Object)schedBlock.getParentScienceGoal());
            }
            catch (SchedBlock.UnableToFindParentScienceGoalException unableToFindParentScienceGoalException) {
                Log.logger(FieldSource.class).warning("Unable to determine the science goal associated with the SB");
            }
        }
        return velocity.getVelocityInDefaultReferenceFrame(this.getSourceCoordinates(), Optional.of(scienceGoal));
    }

    public String toTreeString(int n, boolean bl, boolean bl2) {
        String string = this.getNameOrDefault();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(" ");
        stringBuilder.append(this.briefDescription());
        return stringBuilder.toString();
    }

    public String briefDescription() {
        return this.getSourceName();
    }

    public String getFieldPatternType() {
        FieldPattern fieldPattern = this.getFieldPattern();
        if (fieldPattern == null) {
            return null;
        }
        return fieldPattern.getType();
    }

    public FieldPattern setDefaultFieldPattern() {
        FieldPattern fieldPattern = FieldPattern.createFieldPattern(FieldPattern.FieldPatternType.POINT);
        this.setFieldPattern(fieldPattern);
        return fieldPattern;
    }

    public void saveReferences() {
        if (this.referenceMem == null) {
            this.referenceMem = this.getReference();
        }
    }

    public void restoreReferences() {
        if (this.referenceMem != null) {
            this.setReference(this.referenceMem);
            this.referenceMem = null;
        }
    }

    public void setFieldPattern(FieldPattern fieldPattern) {
        if (fieldPattern != null) {
            this.oldFieldPattern = this.gettrueFieldPattern();
        }
        super.setFieldPattern(fieldPattern);
    }

    public SchedBlockRefT getEntityPartReference() {
        SchedBlockRefT schedBlockRefT = super.getEntityPartReference();
        schedBlockRefT.setDocumentVersion("1");
        return schedBlockRefT;
    }

    @Override
    public void attachTo(Target target) {
        target.setFieldSource(this);
    }

    @Override
    public void detachFrom(Target target) {
        if (target.getFieldSource() == this) {
            target.setFieldSource(null);
        }
    }

    @Override
    public Target[] getTargetList() {
        SchedBlock schedBlock = (SchedBlock)this.getParent();
        if (schedBlock == null) {
            return null;
        }
        ArrayList<Target> arrayList = new ArrayList<Target>();
        for (Target target : schedBlock.getTarget()) {
            if (target.getFieldSource() != this) continue;
            arrayList.add(target);
        }
        return arrayList.toArray(new Target[arrayList.size()]);
    }

    @Override
    public int getUsedCount() {
        Target[] targetArray = this.getTargetList();
        if (targetArray == null) {
            return 0;
        }
        return targetArray.length;
    }

    @Override
    public ObsUnitSet getContainingObsUnitSet() {
        ObsUnitSetComponent obsUnitSetComponent = (ObsUnitSetComponent)this.getParent();
        return obsUnitSetComponent.getContainingObsUnitSet();
    }

    @Override
    public SpatialPartOfSpatialDocument getSpatialPartOfSpatialDocument() {
        return this;
    }

    @Override
    public Frequency getSingleFrequency() {
        SchedBlock schedBlock = (SchedBlock)this.getParent();
        if (schedBlock == null) {
            return null;
        }
        return schedBlock.getSchedulingConstraints().getRepresentativeFrequency();
    }

    @Override
    public String getSingleFrequencySource() {
        SchedBlock schedBlock = (SchedBlock)this.getParent();
        if (schedBlock == null) {
            return null;
        }
        return schedBlock.getNameOrDefault() + ":representativeFrequency";
    }

    public Time getSingleSubscanDuration() {
        ScienceParameters scienceParameters = null;
        Target[] targetArray = this.getTargetList();
        if (targetArray == null) {
            return null;
        }
        for (Target target : targetArray) {
            ScienceParameters[] scienceParametersArray = target.getScienceParametersList();
            if (scienceParametersArray == null || scienceParametersArray.length <= 0) continue;
            if (scienceParametersArray.length == 1) {
                scienceParameters = scienceParametersArray[0];
                continue;
            }
            return null;
        }
        if (scienceParameters == null) {
            return null;
        }
        return scienceParameters.getSubScanDuration();
    }

    @Override
    public int getNumberOfPointings() {
        FieldPattern fieldPattern = this.getFieldPattern();
        return fieldPattern == null ? 0 : fieldPattern.getNumberOfPointings();
    }

    public SkyCoordinates getTargetCenter() {
        return this.getSourceCoordinates();
    }

    public FieldSource deepCopy() {
        FieldSource fieldSource = super.deepCopy();
        fieldSource.setTargetParameters(this.getTargetParameters());
        return fieldSource;
    }

    public void initialiseFieldSourceAttributesWithEphemerisData(Optional<String> optional) {
        Log.Logger logger = Log.logger((Object)this);
        String string = this.getSourceEphemeris();
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        try {
            OTHorizonParser oTHorizonParser = (OTHorizonParser)((Object)horizonsCache.get((Object)string));
            if (oTHorizonParser == null) {
                oTHorizonParser = new OTHorizonParser(new OTLoggerAdapter(logger, this.getClass().getName(), null), string);
                horizonsCache.put((Object)string, (Object)oTHorizonParser);
            }
            assert (oTHorizonParser != null);
            if (optional.isPresent()) {
                this.setSourceName(MiscUtils.getSanitizedSourceName(optional.get()));
            } else if (this.getSourceName().isEmpty()) {
                this.setSourceName(MiscUtils.getSanitizedSourceName(oTHorizonParser.getSourceName(string)));
            }
            List list = oTHorizonParser.parseEphemeris();
            if (list.isEmpty()) {
                Log.logger(AbstractTargetModel.class).warning("No ephemeris entries found in ephemeris data.");
                throw new WizardSBGenerationException("No ephemeris entries found in ephemeris data.");
            }
            HorizonParser.ParsedEphemerisLine parsedEphemerisLine = (HorizonParser.ParsedEphemerisLine)list.get(0);
            SkyCoordinates skyCoordinates = this.getSourceCoordinates();
            skyCoordinates.setLatitude(Latitude.createLatitude((double)parsedEphemerisLine.declination, (String)Latitude.UNIT_RAD));
            skyCoordinates.setLongitude(Longitude.createLongitude((double)parsedEphemerisLine.rightAscension, (String)Longitude.UNIT_RAD));
            skyCoordinates.setSystem(SkyCoordinates.SYSTEM_ICRS);
            skyCoordinates.setType(SkyCoordinates.TYPE_ABSOLUTE);
        }
        catch (HorizonParser.UnableToParseEphemerisDataException | IOException | NullPointerException throwable) {
            logger.info("Logic error: the ephemeris data should be in JPL HORIZONS format : " + throwable.getMessage());
        }
    }

    public boolean isEphemerisSource() {
        String string = this.getSolarSystemObject();
        return this.getNonSiderealMotion() && string != null && (string.equals(SOLARSYSTEMOBJECT_EPHEMERIS) || string.equals(SOLARSYSTEMOBJECT_SUN));
    }

    public QuerySource getPreviousQuerySource() {
        return this.previousQuerySource;
    }

    public void setPreviousQuerySource(QuerySource querySource) {
        this.previousQuerySource = querySource;
    }

    public TargetParameters getTargetParameters() {
        return this.targetParameters;
    }

    public void setTargetParameters(TargetParameters targetParameters) {
        this.targetParameters = targetParameters;
    }

    public FieldPattern getOldFieldPattern() {
        return this.oldFieldPattern;
    }

    @Override
    public SpatialVisualParameters getSpatialVisualParameters() {
        return this.spatialVisualParameters;
    }

    @Override
    public SummaryTableColumns getSummaryTableColumns() {
        return this.summaryTableColumns;
    }

    public String getPreviousNonQuerySourceName() {
        return this.previousNonQuerySourceName;
    }

    public void setPreviousNonQuerySourceName(String string) {
        this.previousNonQuerySourceName = string;
    }
}

