/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.BLSpectralWindowT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.annotations.BLSpectralWindowI;
import alma.obsprep.bo.enumerations.CorrBits;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.enumerations.SpectralAverage;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.ChannelAverageRegion;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.bo.schedblock.SpectralLine;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.UnknownScalingFactorException;
import alma.obsprep.bo.schedblock.data.BLSpectralWindowData;
import alma.valuetypes.Frequency;
import java.util.Arrays;
import java.util.List;

public class BLSpectralWindow
extends BLSpectralWindowData
implements BLSpectralWindowI {
    public static final double CHANNEL_WIDTH_KHZ = 30.517578125;

    public BLSpectralWindow(BLSpectralWindowT bLSpectralWindowT) {
        super(bLSpectralWindowT);
    }

    @Override
    public void clearSpectralLines(SpectralSpec.SideBand sideBand) {
        super.clearSpectralLine();
    }

    @Override
    public void addSpectralLine(SpectralSpec.SideBand sideBand, SpectralLine spectralLine) {
        super.addSpectralLine(spectralLine);
    }

    public void initAsNew() {
        super.initAsNew();
        this.setCorrelationBits(this.getCorrConfigMode().getBits().correlationBits);
        this.setCorrelationNyquistOversampling(this.getCorrConfigMode().isOversampling());
        ChannelAverageRegion channelAverageRegion = ChannelAverageRegion.createChannelAverageRegion(0, this.getEffectiveNumberOfChannels());
        this.addChannelAverageRegion(channelAverageRegion);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(",BL[");
        stringBuffer.append("filter=" + this.getFilterMode() + ",");
        stringBuffer.append("mode=" + this.getCorrConfigMode().getMode() + ",");
        stringBuffer.append("bits=" + this.getCorrelationBits() + ",");
        stringBuffer.append("ovrs=" + this.getCorrelationNyquistOversampling() + ",");
        stringBuffer.append("qntc=" + this.getQuantizationCorrection());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public CorrelatorType getCorrelatorType() {
        return CorrelatorType.BL;
    }

    @Override
    public void publishCorrConfigMode() {
        if (!this.corrConfigMode.isValid()) {
            return;
        }
        String string = this.getCorrConfigMode().getPolarization().polnProducts;
        this.setPolnProducts(string);
        String string2 = this.getCorrConfigMode().getBits().correlationBits;
        this.setCorrelationBits(string2);
        boolean bl = this.getCorrConfigMode().isOversampling();
        this.setCorrelationNyquistOversampling(bl);
        super.publishCorrConfigMode();
    }

    @Override
    public void updateCorrConfigMode() {
        if (this.getNominalBandwidth() == null || this.getNominalNumberOfChannels() == 0 || this.getCorrelationBits() == null || this.getPolnProducts() == null) {
            return;
        }
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        CorrConfigMode corrConfigMode = oTConfigModeDecoder.findMode(this.getNominalBandwidth(), this.getNominalNumberOfChannels(), this.getCorrelationBits(), this.getCorrelationNyquistOversampling(), this.getPolnProducts());
        this.setCorrConfigMode(corrConfigMode);
        if (!(this.corrConfigMode.isValid() && corrConfigMode.isValid() && this.corrConfigMode.equals(corrConfigMode))) {
            super.resetSpectralAverageRegions();
        }
    }

    public void updateApplicableModeSet() {
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        this.applicableModeSet = oTConfigModeDecoder.findMode(CorrBits.getCorrBits(this.getCorrelationBits()), this.getCorrelationNyquistOversampling(), CorrPolarization.getCorrPolarization(this.getPolnProducts()));
    }

    @Override
    public void setCorrelationBits(String string) {
        super.setCorrelationBits(string);
        this.updateApplicableModeSet();
    }

    @Override
    public void setCorrelationNyquistOversampling(boolean bl) {
        super.setCorrelationNyquistOversampling(bl);
        this.updateApplicableModeSet();
    }

    @Override
    public void setPolnProducts(String string) {
        super.setPolnProducts(string);
        this.updateApplicableModeSet();
    }

    @Override
    public void adjustCenterFrequency() {
        Frequency frequency = this.getEffectiveBandwidth();
        if (frequency.isEqual((AbstractDoubleWithUnit)BaseBandSpecification.basebandWidth)) {
            this.getCenterFrequency().setContentAndUnit(3.0, Frequency.UNIT_GHZ);
            return;
        }
        CorrFilter corrFilter = this.getCorrConfigMode().getFilter();
        if (corrFilter.equals((Object)CorrFilter.TFB)) {
            double d;
            Frequency frequency2 = this.getCenterFrequency();
            double d2 = frequency2.getContentInUnits(Frequency.UNIT_KHZ);
            long l = Math.round(d2 / 30.517578125);
            if ((d2 = (double)l * 30.517578125) - (d = frequency.getContentInUnits(Frequency.UNIT_KHZ) / 2.0) < 2000000.0) {
                d2 = 2000000.0 + d;
            } else if (d2 + d > 4000000.0) {
                d2 = 4000000.0 - d;
            }
            Frequency frequency3 = Frequency.createFrequency((double)d2, (String)Frequency.UNIT_KHZ);
            frequency2.setContent(frequency3.getContentInUnits(frequency2.getUnit()));
        }
    }

    @Override
    public Frequency getEffectiveResolution() throws UnknownScalingFactorException {
        return this.getEffectiveResolution(this.getWindowFunction());
    }

    public Frequency getEffectiveResolution(String string) throws UnknownScalingFactorException {
        Frequency frequency = this.getResolution().deepCopy();
        int n = this.getSpectralAveragingFactor();
        SpectralAverage spectralAverage = SpectralAverage.getValue(n);
        if (null == spectralAverage) {
            throw new UnknownScalingFactorException("This windowing function is currently unsupported");
        }
        double d = 0.0;
        try {
            d = spectralAverage.getResolutionScalingFactor(string);
        }
        catch (SpectralAverage.UnknownWindowingFunctionException unknownWindowingFunctionException) {
            throw new UnknownScalingFactorException("This windowing function is currently unsupported");
        }
        double d2 = frequency.getContent() * d;
        frequency.setContent(d2);
        return frequency;
    }

    @Override
    public List<SpectralLine> getSpectralLines() {
        return Arrays.asList(super.getSpectralLine());
    }
}

