/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.AbstractInstrumentSpecT;
import alma.obsprep.bo.annotations.AddableToSubSBCollection;
import alma.obsprep.bo.annotations.AttachableToTarget;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.data.AbstractInstrumentSpecData;
import alma.obsprep.ot.editors.misc.InstrumentSpecSummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import java.util.ArrayList;

public abstract class AbstractInstrumentSpec
extends AbstractInstrumentSpecData
implements AddableToSubSBCollection,
AttachableToTarget,
SummaryTableRow {
    protected SummaryTableColumns summaryTableColumns = new InstrumentSpecSummaryTableColumns(this);

    public AbstractInstrumentSpec(AbstractInstrumentSpecT abstractInstrumentSpecT) {
        super(abstractInstrumentSpecT);
    }

    public boolean isSpectralSpec() {
        return this instanceof SpectralSpec;
    }

    public boolean isOpticalCameraSpec() {
        return this instanceof OpticalCameraSpec;
    }

    @Override
    public void attachTo(Target target) {
        target.setAbstractInstrumentSpec(this);
    }

    @Override
    public void detachFrom(Target target) {
        if (target.getAbstractInstrumentSpec() == this) {
            target.setAbstractInstrumentSpec(null);
        }
    }

    @Override
    public Target[] getTargetList() {
        SchedBlock schedBlock = (SchedBlock)this.getParent();
        if (schedBlock == null) {
            return null;
        }
        ArrayList<Target> arrayList = new ArrayList<Target>();
        for (Target target : schedBlock.getTarget()) {
            if (target.getAbstractInstrumentSpec() != this) continue;
            arrayList.add(target);
        }
        return arrayList.toArray(new Target[arrayList.size()]);
    }

    @Override
    public int getUsedCount() {
        Target[] targetArray = this.getTargetList();
        if (targetArray == null) {
            return 0;
        }
        return targetArray.length;
    }

    @Override
    public SummaryTableColumns getSummaryTableColumns() {
        return this.summaryTableColumns;
    }
}

