/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.VisitConstraintT;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.data.VisitConstraintData;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import lombok.NonNull;

public class VisitConstraint
extends VisitConstraintData {
    private static DateTimeFormatter almaDateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public VisitConstraint(VisitConstraintT visitConstraintT) {
        super(visitConstraintT);
    }

    public ZonedDateTime gettrueStartTimeInDate() {
        String string = this.gettrueStartTime();
        if (null == string || "" == string) {
            return null;
        }
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(string, almaDateFormat);
            return localDateTime.atZone(ZoneOffset.UTC);
        }
        catch (DateTimeParseException dateTimeParseException) {
            String string2 = "Unexpected start time format : " + dateTimeParseException.getMessage();
            Log.logger((Object)((Object)this)).warning(string2);
            return null;
        }
    }

    public void setStartTimeInDate(@NonNull ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            throw new NullPointerException("newDate is marked non-null but is null");
        }
        String string = zonedDateTime.format(almaDateFormat);
        this.setStartTime(string);
    }

    public static ZonedDateTime nowInUTC() {
        return ZonedDateTime.now(ZoneOffset.UTC).withNano(0);
    }

    public ZonedDateTime getStartTimeInDate() {
        ZonedDateTime zonedDateTime = this.gettrueStartTimeInDate();
        if (null == zonedDateTime) {
            this.setStartTimeInDate(VisitConstraint.nowInUTC());
        }
        return zonedDateTime;
    }
}

