/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.TargetParametersT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.annotations.FieldPatternI;
import alma.obsprep.bo.annotations.FieldTargetDocument;
import alma.obsprep.bo.annotations.FieldTargetPart;
import alma.obsprep.bo.annotations.SpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpectralSpecDocument;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.ExpectedProperties;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.FieldTypeInfo;
import alma.obsprep.bo.obsproject.PointingPatternAdapter;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyChangeEvent;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyListener;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.data.TargetParametersData;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.ot.editors.misc.TargetParametersSummaryTableColumns;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualParameters;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.util.astro.PointingCoordsConverter;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import alma.valuetypes.data.LatitudeData;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import lombok.NonNull;

public class TargetParameters
extends TargetParametersData
implements SpatialDocument,
SpatialPartOfSpatialDocument,
SpatialPartOfSpectralSpecDocument,
FieldTargetDocument,
SummaryTableRow,
RepresentativeFrequencyListener,
TargetWithIntent {
    private ScienceGoal parentScienceGoal;
    private final SummaryTableColumns summaryTableColumns;
    private final PointingPatternAdapter pointingPattern;
    private final SpatialVisualParameters spatialVisualParameters = new SpatialVisualParameters(this);
    private final PropertyChangeListener sourceVelocityChangedListener = propertyChangeEvent -> {
        if (propertyChangeEvent == null) {
            return;
        }
        Object object = propertyChangeEvent.getSource();
        if (object instanceof Velocity) {
            ScienceGoal scienceGoal;
            SpectralSetupParameters spectralSetupParameters;
            Velocity velocity = (Velocity)((Object)((Object)object));
            BusinessObject businessObject = this.getParent();
            if (businessObject instanceof ScienceGoal && (spectralSetupParameters = (scienceGoal = (ScienceGoal)businessObject).getSpectralSetupParameters()) != null) {
                Object object2;
                Frequency frequency = null;
                if (spectralSetupParameters.isSingleContinuumSkyFrequency() || spectralSetupParameters.isSpectralScan()) {
                    frequency = spectralSetupParameters.getRepresentativeFrequency();
                } else {
                    object2 = spectralSetupParameters.getRepresentativeFrequency();
                    frequency = velocity.dopplerShift((Frequency)((Object)((Object)object2)));
                }
                object2 = this.getExpectedProperties();
                object2.getReferenceFrequency().setContentAndUnit((ValueUnitPair)frequency);
                for (Rectangle rectangle : this.getFieldRectangle()) {
                    rectangle.getReferenceFrequency().setContentAndUnit((ValueUnitPair)frequency);
                }
                if (scienceGoal.getSoleTargetParameters() == this) {
                    RepresentativeFrequencyChangeEvent representativeFrequencyChangeEvent = new RepresentativeFrequencyChangeEvent((Object)spectralSetupParameters.getRepresentativeFrequency());
                    scienceGoal.getPerformanceParameters().representativeFrequencyUpdated(representativeFrequencyChangeEvent);
                }
            }
        }
    };
    private final PropertyChangeListener sourceVelocitySpeedChangedListener = propertyChangeEvent -> {
        if (propertyChangeEvent == null) {
            return;
        }
        Object object = propertyChangeEvent.getSource();
        if (object instanceof Speed) {
            ScienceGoal scienceGoal;
            SpectralSetupParameters spectralSetupParameters;
            Velocity velocity = this.getSourceVelocity();
            BusinessObject businessObject = this.getParent();
            if (businessObject instanceof ScienceGoal && (spectralSetupParameters = (scienceGoal = (ScienceGoal)businessObject).getSpectralSetupParameters()) != null) {
                Object object2;
                Frequency frequency = null;
                if (spectralSetupParameters.isSingleContinuumSkyFrequency() || spectralSetupParameters.isSpectralScan()) {
                    frequency = spectralSetupParameters.getRepresentativeFrequency();
                } else {
                    object2 = spectralSetupParameters.getRepresentativeFrequency();
                    frequency = velocity.dopplerShift((Frequency)((Object)((Object)object2)));
                }
                object2 = this.getExpectedProperties();
                object2.getReferenceFrequency().setContentAndUnit((ValueUnitPair)frequency);
                for (Rectangle rectangle : this.getFieldRectangle()) {
                    rectangle.getReferenceFrequency().setContentAndUnit((ValueUnitPair)frequency);
                }
                if (scienceGoal.getSoleTargetParameters() == this) {
                    RepresentativeFrequencyChangeEvent representativeFrequencyChangeEvent = new RepresentativeFrequencyChangeEvent((Object)spectralSetupParameters.getRepresentativeFrequency());
                    scienceGoal.getPerformanceParameters().representativeFrequencyUpdated(representativeFrequencyChangeEvent);
                }
            }
        }
    };

    public TargetParameters(TargetParametersT targetParametersT) {
        super(targetParametersT);
        this.summaryTableColumns = new TargetParametersSummaryTableColumns(this);
        this.pointingPattern = new PointingPatternAdapter(this);
    }

    protected static void attachSourceVelocityListeners(TargetParameters targetParameters) {
        Velocity velocity = targetParameters.getSourceVelocity();
        velocity.addPropertyChangeListener(targetParameters.sourceVelocityChangedListener);
        velocity.getCenterVelocity().addPropertyChangeListener(targetParameters.sourceVelocitySpeedChangedListener);
    }

    public boolean isSolar() {
        boolean bl = false;
        if (this.getNonSiderealMotion() && this.getSolarSystemObject() == SOLARSYSTEMOBJECT_SUN) {
            bl = true;
        }
        return bl;
    }

    public synchronized TargetParameters deepCopy() {
        TargetParameters targetParameters = super.deepCopy();
        TargetParameters.attachSourceVelocityListeners(targetParameters);
        targetParameters.setParentScienceGoal(this.getScienceGoal());
        return targetParameters;
    }

    protected void initAsNew() {
        super.initAsNew();
        this.getExpectedProperties();
        SinglePoint singlePoint = SinglePoint.createSinglePoint();
        singlePoint.getCentre().setType(SkyCoordinates.TYPE_RELATIVE);
        this.addField((Field)((Object)singlePoint));
        this.setType(TYPE_F_MULTIPLEPOINTS);
        this.setIsMosaic(false);
        TargetParameters.attachSourceVelocityListeners(this);
    }

    public ScienceGoal getScienceGoal() {
        ScienceGoal scienceGoal = (ScienceGoal)this.getParent();
        if (scienceGoal == null && this.parentScienceGoal != null) {
            scienceGoal = this.parentScienceGoal;
        }
        return scienceGoal;
    }

    public BusinessObject getSpatial() {
        return this;
    }

    @Override
    public SpatialPartOfSpatialDocument getSpatialPartOfSpatialDocument() {
        return this;
    }

    @Override
    public Frequency getSingleFrequency() {
        ScienceGoal scienceGoal = this.getScienceGoal();
        return scienceGoal.getSingleFrequency();
    }

    @Override
    public String getSingleFrequencySource() {
        ScienceGoal scienceGoal = this.getScienceGoal();
        return scienceGoal.getSingleFrequencySource();
    }

    public FieldPatternI getFieldPattern() {
        return this;
    }

    public SkyCoordinates getTargetCenter() {
        return this.getSourceCoordinates();
    }

    public boolean isPointingPattern() {
        return this.getType().equals(TYPE_F_MULTIPLEPOINTS);
    }

    public boolean isRectanglePattern() {
        return this.getType().equals(TYPE_F_SINGLERECTANGLE);
    }

    public boolean isFillPattern() {
        return false;
    }

    public boolean isMosaic() {
        return this.getIsMosaic();
    }

    public boolean isOffsetPointingPattern() {
        return true;
    }

    public FieldPattern.FieldPatternType getFieldPatternType() {
        if (this.isPointingPattern()) {
            return FieldPattern.FieldPatternType.POINT;
        }
        if (this.isRectanglePattern()) {
            return FieldPattern.FieldPatternType.RECTANGLE;
        }
        return null;
    }

    @Override
    public FieldTargetPart getFieldTargetPart() {
        return this;
    }

    public Rectangle getSingleRectangle() {
        if (!this.isRectanglePattern()) {
            return null;
        }
        int n = this.getFieldRectangleCount();
        switch (n) {
            case 0: {
                Rectangle rectangle = Rectangle.createRectangle();
                this.addField((Field)((Object)rectangle));
                return rectangle;
            }
            case 1: {
                return this.getFieldRectangle()[0];
            }
        }
        Log.logger((Object)this).warning("Multiple rectangle is not allowed. Only the first one is used.");
        return this.getFieldRectangle()[0];
    }

    @Override
    public int getNumberOfPointings() {
        if (this.isPointingPattern()) {
            return this.getFieldSinglePointCount();
        }
        if (this.isRectanglePattern()) {
            Rectangle rectangle = this.getSingleRectangle();
            return rectangle.getNumberOfPointings();
        }
        return 0;
    }

    public int getNumberOfPointings(Array array) {
        if (this.isPointingPattern()) {
            return this.getFieldSinglePointCount();
        }
        if (this.isRectanglePattern()) {
            Rectangle rectangle = this.getSingleRectangle();
            return rectangle.getNumberOfPointings(array);
        }
        return 0;
    }

    public String getType() {
        int n;
        String string = super.getType();
        if (string == null && (n = this.getFieldCount()) > 0) {
            Field field = this.getField(0);
            string = field.isRectanglePattern() ? TYPE_F_SINGLERECTANGLE : TYPE_F_MULTIPLEPOINTS;
            this.setType(string);
        }
        return string;
    }

    public static String[] getKnownLabelList() {
        String[] stringArray = TargetParameters.getKnownTypeList();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            FieldTypeInfo fieldTypeInfo = FieldTypeInfo.valueOf(string);
            stringArray2[i] = fieldTypeInfo.getLabel();
            stringArray2[i] = FieldTypeInfo.valueOf(stringArray[i]).getLabel();
        }
        return stringArray2;
    }

    public String getTypeLabel() {
        return FieldTypeInfo.valueOf(this.getType()).getLabel();
    }

    public String getTypeTooltip() {
        return FieldTypeInfo.valueOf(this.getType()).getTooltip();
    }

    @Override
    public SummaryTableColumns getSummaryTableColumns() {
        return this.summaryTableColumns;
    }

    @Override
    public void representativeFrequencyUpdated(RepresentativeFrequencyChangeEvent representativeFrequencyChangeEvent) {
        for (Field field : this.getField()) {
            if (!(field instanceof RepresentativeFrequencyListener)) continue;
            ((RepresentativeFrequencyListener)((Object)field)).representativeFrequencyUpdated(representativeFrequencyChangeEvent);
        }
        this.getExpectedProperties().representativeFrequencyUpdated(representativeFrequencyChangeEvent);
    }

    public void addField(int n, Field field) {
        super.addField(n, field);
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (scienceGoal != null && field instanceof RepresentativeFrequencyListener) {
            RepresentativeFrequencyListener representativeFrequencyListener = (RepresentativeFrequencyListener)((Object)field);
            representativeFrequencyListener.representativeFrequencyUpdated(new RepresentativeFrequencyChangeEvent(this));
        }
    }

    public void addField(Field field) {
        super.addField(field);
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (scienceGoal != null && field instanceof RepresentativeFrequencyListener) {
            RepresentativeFrequencyListener representativeFrequencyListener = (RepresentativeFrequencyListener)((Object)field);
            representativeFrequencyListener.representativeFrequencyUpdated(new RepresentativeFrequencyChangeEvent(this));
        }
    }

    public boolean isMaxElevationNeverVisible() {
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        Angle angle = almaCapabilities.getElLimit();
        double d = angle.getContentInUnits(Angle.UNIT_DEG);
        SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
        Latitude latitude = siteCharacteristics.getObsLatitude();
        double d2 = 90.0 - d;
        SkyCoordinates skyCoordinates = this.getSourceCoordinates().getJ2000SkyCoordinates();
        double d3 = Math.abs(skyCoordinates.getLatitude().getContentInUnits(LatitudeData.UNIT_DEG) - latitude.getContentInUnits(LatitudeData.UNIT_DEG));
        return d3 > d2;
    }

    public boolean isMaxElevationTooLow() {
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        Angle angle = almaCapabilities.getElLoWarn();
        double d = angle.getContentInUnits(Angle.UNIT_DEG);
        SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
        Latitude latitude = siteCharacteristics.getObsLatitude();
        double d2 = 90.0 - d;
        SkyCoordinates skyCoordinates = this.getSourceCoordinates().getJ2000SkyCoordinates();
        double d3 = Math.abs(skyCoordinates.getLatitude().getContentInUnits(LatitudeData.UNIT_DEG) - latitude.getContentInUnits(LatitudeData.UNIT_DEG));
        return d3 > d2;
    }

    public boolean isMaxElevationNeedingJustification() {
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        Angle angle = almaCapabilities.getElLoWarnThreshold();
        double d = angle.getContentInUnits(Angle.UNIT_DEG);
        SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
        Latitude latitude = siteCharacteristics.getObsLatitude();
        double d2 = 90.0 - d;
        SkyCoordinates skyCoordinates = this.getSourceCoordinates().getJ2000SkyCoordinates();
        double d3 = Math.abs(skyCoordinates.getLatitude().getContentInUnits(LatitudeData.UNIT_DEG) - latitude.getContentInUnits(LatitudeData.UNIT_DEG));
        return d3 > d2 && !this.isMaxElevationTooLow();
    }

    public boolean isMaxElevationTooHigh() {
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        Angle angle = almaCapabilities.getElHiWarn();
        double d = angle.getContentInUnits(Angle.UNIT_DEG);
        SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
        Latitude latitude = siteCharacteristics.getObsLatitude();
        double d2 = 90.0 - d;
        SkyCoordinates skyCoordinates = this.getSourceCoordinates().getJ2000SkyCoordinates();
        double d3 = Math.abs(skyCoordinates.getLatitude().getContentInUnits(LatitudeData.UNIT_DEG) - latitude.getContentInUnits(LatitudeData.UNIT_DEG));
        return d3 < d2;
    }

    public void setSourceVelocity(Velocity velocity) {
        Velocity velocity2 = this.gettrueSourceVelocity();
        if (velocity2 == null) {
            velocity2 = Velocity.createVelocity();
        } else {
            velocity2.removePropertyChangeListener(this.sourceVelocityChangedListener);
            velocity2.getCenterVelocity().removePropertyChangeListener(this.sourceVelocitySpeedChangedListener);
        }
        super.setSourceVelocity(velocity);
        if (velocity != null) {
            ExpectedProperties expectedProperties = this.getExpectedProperties();
            Frequency frequency = expectedProperties.getReferenceFrequency();
            Frequency frequency2 = velocity2.reverseShift(frequency);
            Frequency frequency3 = velocity.dopplerShift(frequency2);
            expectedProperties.getReferenceFrequency().setContentAndUnit((ValueUnitPair)frequency3);
            for (Rectangle rectangle : this.getFieldRectangle()) {
                frequency = rectangle.getReferenceFrequency();
                frequency2 = velocity2.reverseShift(frequency);
                frequency3 = velocity.dopplerShift(frequency2);
                rectangle.getReferenceFrequency().setContentAndUnit((ValueUnitPair)frequency3);
            }
            velocity.addPropertyChangeListener(this.sourceVelocityChangedListener);
            velocity.getCenterVelocity().addPropertyChangeListener(this.sourceVelocitySpeedChangedListener);
        }
    }

    @Override
    public ObsType getObsType() {
        return ObsType.SCIENCE;
    }

    public boolean matches(@NonNull TargetParameters targetParameters) {
        if (targetParameters == null) {
            throw new NullPointerException("targetToMatch is marked non-null but is null");
        }
        if (!this.getSourceName().equals(targetParameters.getSourceName())) {
            return false;
        }
        if (!this.getSourceVelocity().getCenterVelocity().isEqual((AbstractDoubleWithUnit)targetParameters.getSourceVelocity().getCenterVelocity())) {
            return false;
        }
        if (!this.getSourceCoordinates().getLatitude().isEqual((AbstractDoubleWithUnit)targetParameters.getSourceCoordinates().getLatitude())) {
            return false;
        }
        return this.getSourceCoordinates().getLongitude().isEqual((AbstractDoubleWithUnit)targetParameters.getSourceCoordinates().getLongitude());
    }

    public static TargetParameters getPointingSourceInICRS(@NonNull TargetParameters targetParameters) {
        if (targetParameters == null) {
            throw new NullPointerException("targetParametersToConvert is marked non-null but is null");
        }
        TargetParameters targetParameters2 = targetParameters.deepCopy();
        SkyCoordinates skyCoordinates2 = targetParameters.getSourceCoordinates();
        if (skyCoordinates2.isGalactic()) {
            targetParameters2.setSourceCoordinates(skyCoordinates2.getICRSSkyCoordinates());
            PointingCoordsConverter pointingCoordsConverter = new PointingCoordsConverter(targetParameters2.getSourceCoordinates());
            boolean bl = targetParameters.isOffsetPointingPattern();
            SkyCoordinates[] skyCoordinatesArray = (SkyCoordinates[])Arrays.asList(targetParameters2.getPointingPattern().getPhaseCenterCoordinates()).stream().map(skyCoordinates -> {
                if (bl) {
                    pointingCoordsConverter.matchSystemToOrigin((SkyCoordinates)skyCoordinates);
                } else {
                    skyCoordinates.convertToSystem(SkyCoordinates.SYSTEM_ICRS);
                }
                return skyCoordinates;
            }).toArray(SkyCoordinates[]::new);
            if (targetParameters2.getPointingPattern().isPointingPattern()) {
                targetParameters2.getPointingPattern().setPhaseCenterCoordinates(skyCoordinatesArray);
            }
        }
        return targetParameters2;
    }

    public String toString() {
        return "TargetParameters [getName()=" + this.getSourceName() + ", getFieldPatternType()=" + this.getFieldPatternType() + ", getSourceCoordinates()=" + this.getSourceCoordinates() + "]";
    }

    public void setParentScienceGoal(ScienceGoal scienceGoal) {
        this.parentScienceGoal = scienceGoal;
    }

    public boolean isEphemerisSource() {
        String string = this.getSolarSystemObject();
        return this.getNonSiderealMotion() && string != null && (string.equals(SOLARSYSTEMOBJECT_EPHEMERIS) || string.equals(SOLARSYSTEMOBJECT_SUN));
    }

    public PointingPatternAdapter getPointingPattern() {
        return this.pointingPattern;
    }

    @Override
    public SpatialVisualParameters getSpatialVisualParameters() {
        return this.spatialVisualParameters;
    }
}

