/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.obsprep.bo.obsproject.NonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.List;

class SpectralScanNonOverlappingBandwidthCalculator
extends NonOverlappingBandwidthCalculator {
    SpectralScanNonOverlappingBandwidthCalculator(SpectralSetupParameters spectralSetupParameters, Velocity velocity) {
        super(spectralSetupParameters, velocity);
    }

    @Override
    public Frequency calculatePerPoln() {
        SpectralScan spectralScan = this.ssp.getSpectralScan();
        Frequency frequency = spectralScan.getEffectiveBandwidth();
        ArrayList<VupRange> arrayList = new ArrayList<VupRange>();
        try {
            SpectralScan.SpectralScanTunings spectralScanTunings = spectralScan.getTunings();
            for (List object2 : spectralScanTunings.getTunings()) {
                for (Frequency frequency2 : object2) {
                    arrayList.add(FrequencyRange.centredOn(frequency2, frequency));
                }
            }
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
            return null;
        }
        List<VupRange> list = VupRange.aggregate(arrayList);
        if (list.size() != 1) {
            return null;
        }
        Frequency frequency3 = (Frequency)((Object)((VupRange)list.get(0)).range());
        return this.ssp.isWalshSwitching() ? (Frequency)frequency3.multiply(2.0) : frequency3;
    }
}

